/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.google.services.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Locale;
import org.chenillekit.google.services.GoogleGeoCoder;
import org.chenillekit.google.services.impl.AbstractGoogleService;
import org.chenillekit.google.utils.GeoCodeLocation;
import org.chenillekit.google.utils.JSONException;
import org.chenillekit.google.utils.JSONObject;
import org.chenillekit.google.utils.geocode.GeoCodeResult;
import org.slf4j.Logger;

public class GoogleGeoCoderImpl
extends AbstractGoogleService
implements GoogleGeoCoder {
    private final Logger logger;

    public GoogleGeoCoderImpl(Logger logger, String googleKey, int timeout, String referer, String proxy) {
        super(logger, googleKey, timeout, referer, proxy);
        this.logger = logger;
    }

    public GeoCodeResult getGeoCode(GeoCodeLocation geoCodeLocation) {
        return this.getGeoCode(geoCodeLocation.getStreet(), geoCodeLocation.getCountry(), geoCodeLocation.getState(), geoCodeLocation.getZipCode(), geoCodeLocation.getCity());
    }

    public GeoCodeResult getGeoCode(String street, String country, String state, String zipCode, String city) {
        return this.getGeoCode(null, street, country, state, zipCode, city);
    }

    public GeoCodeResult getGeoCode(Locale locale, String street, String country, String state, String zipCode, String city) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            GeoCodeResult geoCodeResult;
            String line;
            String queryString = String.format("%shttp://maps.google.com/maps/geo?q=%s,%s,%s,%s,%s&key=%s&gl=%s&output=json", this.getProxy(), this.getEncodedString(street), this.getEncodedString(country), this.getEncodedString(state), this.getEncodedString(zipCode), this.getEncodedString(city), this.getKey(), locale.getLanguage());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("send query '%s' to google maps", queryString));
            }
            URL url = new URL(queryString);
            List<Proxy> proxies = this.getProxySelector().select(url.toURI());
            URLConnection connection = url.openConnection(proxies.get(0));
            connection.setConnectTimeout(this.getTimeout());
            connection.setUseCaches(false);
            connection.addRequestProperty("Referer", this.getReferer());
            StringBuilder builder = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            JSONObject jsonObject = new JSONObject(builder.toString());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("JSON result: {}", (Object)jsonObject.toString(1));
            }
            if ((geoCodeResult = new GeoCodeResult(jsonObject)).getStatus().getCode() != 200 && this.logger.isWarnEnabled()) {
                this.logger.warn("GoogleMapService receives an error code '{}'", (Object)geoCodeResult.getStatus().getCode());
            }
            return geoCodeResult;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }
}

