/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.22.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openapitools.client.model.HistoricProcessInstanceQueryDto;
import org.openapitools.client.model.JobQueryDto;
import org.openapitools.client.model.ProcessInstanceQueryDto;
import org.openapitools.client.model.SetJobRetriesByProcessDtoAllOf;
import org.openapitools.client.model.SetJobRetriesDto;

/**
 * SetJobRetriesByProcessDto
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-09-30T07:31:15.229408535Z[Etc/UTC]")
public class SetJobRetriesByProcessDto {
  public static final String SERIALIZED_NAME_PROCESS_INSTANCES = "processInstances";
  @SerializedName(SERIALIZED_NAME_PROCESS_INSTANCES)
  private List<String> processInstances = null;

  public static final String SERIALIZED_NAME_PROCESS_INSTANCE_QUERY = "processInstanceQuery";
  @SerializedName(SERIALIZED_NAME_PROCESS_INSTANCE_QUERY)
  private ProcessInstanceQueryDto processInstanceQuery;

  public static final String SERIALIZED_NAME_HISTORIC_PROCESS_INSTANCE_QUERY = "historicProcessInstanceQuery";
  @SerializedName(SERIALIZED_NAME_HISTORIC_PROCESS_INSTANCE_QUERY)
  private HistoricProcessInstanceQueryDto historicProcessInstanceQuery;

  public static final String SERIALIZED_NAME_JOB_IDS = "jobIds";
  @SerializedName(SERIALIZED_NAME_JOB_IDS)
  private List<String> jobIds = null;

  public static final String SERIALIZED_NAME_JOB_QUERY = "jobQuery";
  @SerializedName(SERIALIZED_NAME_JOB_QUERY)
  private JobQueryDto jobQuery;

  public static final String SERIALIZED_NAME_DUE_DATE = "dueDate";
  @SerializedName(SERIALIZED_NAME_DUE_DATE)
  private Date dueDate;

  public static final String SERIALIZED_NAME_RETRIES = "retries";
  @SerializedName(SERIALIZED_NAME_RETRIES)
  private Integer retries;


  public SetJobRetriesByProcessDto processInstances(List<String> processInstances) {
    
    this.processInstances = processInstances;
    return this;
  }

  public SetJobRetriesByProcessDto addProcessInstancesItem(String processInstancesItem) {
    if (this.processInstances == null) {
      this.processInstances = new ArrayList<String>();
    }
    this.processInstances.add(processInstancesItem);
    return this;
  }

   /**
   * A list of process instance ids to fetch jobs, for which retries will be set.
   * @return processInstances
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A list of process instance ids to fetch jobs, for which retries will be set.")

  public List<String> getProcessInstances() {
    return processInstances;
  }


  public void setProcessInstances(List<String> processInstances) {
    this.processInstances = processInstances;
  }


  public SetJobRetriesByProcessDto processInstanceQuery(ProcessInstanceQueryDto processInstanceQuery) {
    
    this.processInstanceQuery = processInstanceQuery;
    return this;
  }

   /**
   * Get processInstanceQuery
   * @return processInstanceQuery
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public ProcessInstanceQueryDto getProcessInstanceQuery() {
    return processInstanceQuery;
  }


  public void setProcessInstanceQuery(ProcessInstanceQueryDto processInstanceQuery) {
    this.processInstanceQuery = processInstanceQuery;
  }


  public SetJobRetriesByProcessDto historicProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
    
    this.historicProcessInstanceQuery = historicProcessInstanceQuery;
    return this;
  }

   /**
   * Get historicProcessInstanceQuery
   * @return historicProcessInstanceQuery
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public HistoricProcessInstanceQueryDto getHistoricProcessInstanceQuery() {
    return historicProcessInstanceQuery;
  }


  public void setHistoricProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
    this.historicProcessInstanceQuery = historicProcessInstanceQuery;
  }


  public SetJobRetriesByProcessDto jobIds(List<String> jobIds) {
    
    this.jobIds = jobIds;
    return this;
  }

  public SetJobRetriesByProcessDto addJobIdsItem(String jobIdsItem) {
    if (this.jobIds == null) {
      this.jobIds = new ArrayList<String>();
    }
    this.jobIds.add(jobIdsItem);
    return this;
  }

   /**
   * A list of job ids to set retries for.
   * @return jobIds
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A list of job ids to set retries for.")

  public List<String> getJobIds() {
    return jobIds;
  }


  public void setJobIds(List<String> jobIds) {
    this.jobIds = jobIds;
  }


  public SetJobRetriesByProcessDto jobQuery(JobQueryDto jobQuery) {
    
    this.jobQuery = jobQuery;
    return this;
  }

   /**
   * Get jobQuery
   * @return jobQuery
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public JobQueryDto getJobQuery() {
    return jobQuery;
  }


  public void setJobQuery(JobQueryDto jobQuery) {
    this.jobQuery = jobQuery;
  }


  public SetJobRetriesByProcessDto dueDate(Date dueDate) {
    
    this.dueDate = dueDate;
    return this;
  }

   /**
   * The due date to set for the job. A due date indicates when this job is ready for execution. Jobs with due dates in the past will be scheduled for execution.
   * @return dueDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The due date to set for the job. A due date indicates when this job is ready for execution. Jobs with due dates in the past will be scheduled for execution.")

  public Date getDueDate() {
    return dueDate;
  }


  public void setDueDate(Date dueDate) {
    this.dueDate = dueDate;
  }


  public SetJobRetriesByProcessDto retries(Integer retries) {
    
    this.retries = retries;
    return this;
  }

   /**
   * The number of retries to set for the resource.  Must be &gt;&#x3D; 0. If this is 0, an incident is created and the task, or job, cannot be fetched, or acquired anymore unless the retries are increased again. Can not be null.
   * @return retries
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The number of retries to set for the resource.  Must be >= 0. If this is 0, an incident is created and the task, or job, cannot be fetched, or acquired anymore unless the retries are increased again. Can not be null.")

  public Integer getRetries() {
    return retries;
  }


  public void setRetries(Integer retries) {
    this.retries = retries;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SetJobRetriesByProcessDto setJobRetriesByProcessDto = (SetJobRetriesByProcessDto) o;
    return Objects.equals(this.processInstances, setJobRetriesByProcessDto.processInstances) &&
        Objects.equals(this.processInstanceQuery, setJobRetriesByProcessDto.processInstanceQuery) &&
        Objects.equals(this.historicProcessInstanceQuery, setJobRetriesByProcessDto.historicProcessInstanceQuery) &&
        Objects.equals(this.jobIds, setJobRetriesByProcessDto.jobIds) &&
        Objects.equals(this.jobQuery, setJobRetriesByProcessDto.jobQuery) &&
        Objects.equals(this.dueDate, setJobRetriesByProcessDto.dueDate) &&
        Objects.equals(this.retries, setJobRetriesByProcessDto.retries);
  }

  @Override
  public int hashCode() {
    return Objects.hash(processInstances, processInstanceQuery, historicProcessInstanceQuery, jobIds, jobQuery, dueDate, retries);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SetJobRetriesByProcessDto {\n");
    sb.append("    processInstances: ").append(toIndentedString(processInstances)).append("\n");
    sb.append("    processInstanceQuery: ").append(toIndentedString(processInstanceQuery)).append("\n");
    sb.append("    historicProcessInstanceQuery: ").append(toIndentedString(historicProcessInstanceQuery)).append("\n");
    sb.append("    jobIds: ").append(toIndentedString(jobIds)).append("\n");
    sb.append("    jobQuery: ").append(toIndentedString(jobQuery)).append("\n");
    sb.append("    dueDate: ").append(toIndentedString(dueDate)).append("\n");
    sb.append("    retries: ").append(toIndentedString(retries)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

