/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.22.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openapitools.client.model.MigrationInstructionDto;
import org.openapitools.client.model.VariableValueDto;

/**
 * MigrationPlanDto
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-09-30T07:31:15.229408535Z[Etc/UTC]")
public class MigrationPlanDto {
  public static final String SERIALIZED_NAME_SOURCE_PROCESS_DEFINITION_ID = "sourceProcessDefinitionId";
  @SerializedName(SERIALIZED_NAME_SOURCE_PROCESS_DEFINITION_ID)
  private String sourceProcessDefinitionId;

  public static final String SERIALIZED_NAME_TARGET_PROCESS_DEFINITION_ID = "targetProcessDefinitionId";
  @SerializedName(SERIALIZED_NAME_TARGET_PROCESS_DEFINITION_ID)
  private String targetProcessDefinitionId;

  public static final String SERIALIZED_NAME_INSTRUCTIONS = "instructions";
  @SerializedName(SERIALIZED_NAME_INSTRUCTIONS)
  private List<MigrationInstructionDto> instructions = null;

  public static final String SERIALIZED_NAME_VARIABLES = "variables";
  @SerializedName(SERIALIZED_NAME_VARIABLES)
  private Map<String, VariableValueDto> variables = null;


  public MigrationPlanDto sourceProcessDefinitionId(String sourceProcessDefinitionId) {
    
    this.sourceProcessDefinitionId = sourceProcessDefinitionId;
    return this;
  }

   /**
   * The id of the source process definition for the migration.
   * @return sourceProcessDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the source process definition for the migration.")

  public String getSourceProcessDefinitionId() {
    return sourceProcessDefinitionId;
  }


  public void setSourceProcessDefinitionId(String sourceProcessDefinitionId) {
    this.sourceProcessDefinitionId = sourceProcessDefinitionId;
  }


  public MigrationPlanDto targetProcessDefinitionId(String targetProcessDefinitionId) {
    
    this.targetProcessDefinitionId = targetProcessDefinitionId;
    return this;
  }

   /**
   * The id of the target process definition for the migration.
   * @return targetProcessDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the target process definition for the migration.")

  public String getTargetProcessDefinitionId() {
    return targetProcessDefinitionId;
  }


  public void setTargetProcessDefinitionId(String targetProcessDefinitionId) {
    this.targetProcessDefinitionId = targetProcessDefinitionId;
  }


  public MigrationPlanDto instructions(List<MigrationInstructionDto> instructions) {
    
    this.instructions = instructions;
    return this;
  }

  public MigrationPlanDto addInstructionsItem(MigrationInstructionDto instructionsItem) {
    if (this.instructions == null) {
      this.instructions = new ArrayList<MigrationInstructionDto>();
    }
    this.instructions.add(instructionsItem);
    return this;
  }

   /**
   * A list of migration instructions which map equal activities. Each migration instruction is a JSON object with the following properties:
   * @return instructions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A list of migration instructions which map equal activities. Each migration instruction is a JSON object with the following properties:")

  public List<MigrationInstructionDto> getInstructions() {
    return instructions;
  }


  public void setInstructions(List<MigrationInstructionDto> instructions) {
    this.instructions = instructions;
  }


  public MigrationPlanDto variables(Map<String, VariableValueDto> variables) {
    
    this.variables = variables;
    return this;
  }

  public MigrationPlanDto putVariablesItem(String key, VariableValueDto variablesItem) {
    if (this.variables == null) {
      this.variables = new HashMap<String, VariableValueDto>();
    }
    this.variables.put(key, variablesItem);
    return this;
  }

   /**
   * A map of variables which will be set into the process instances&#39; scope. Each key is a variable name and each value a JSON variable value object.
   * @return variables
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A map of variables which will be set into the process instances' scope. Each key is a variable name and each value a JSON variable value object.")

  public Map<String, VariableValueDto> getVariables() {
    return variables;
  }


  public void setVariables(Map<String, VariableValueDto> variables) {
    this.variables = variables;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MigrationPlanDto migrationPlanDto = (MigrationPlanDto) o;
    return Objects.equals(this.sourceProcessDefinitionId, migrationPlanDto.sourceProcessDefinitionId) &&
        Objects.equals(this.targetProcessDefinitionId, migrationPlanDto.targetProcessDefinitionId) &&
        Objects.equals(this.instructions, migrationPlanDto.instructions) &&
        Objects.equals(this.variables, migrationPlanDto.variables);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sourceProcessDefinitionId, targetProcessDefinitionId, instructions, variables);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MigrationPlanDto {\n");
    sb.append("    sourceProcessDefinitionId: ").append(toIndentedString(sourceProcessDefinitionId)).append("\n");
    sb.append("    targetProcessDefinitionId: ").append(toIndentedString(targetProcessDefinitionId)).append("\n");
    sb.append("    instructions: ").append(toIndentedString(instructions)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

