/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.22.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openapitools.client.model.VariableValueDto;

/**
 * CorrelationMessageDto
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-09-30T07:31:15.229408535Z[Etc/UTC]")
public class CorrelationMessageDto {
  public static final String SERIALIZED_NAME_MESSAGE_NAME = "messageName";
  @SerializedName(SERIALIZED_NAME_MESSAGE_NAME)
  private String messageName;

  public static final String SERIALIZED_NAME_BUSINESS_KEY = "businessKey";
  @SerializedName(SERIALIZED_NAME_BUSINESS_KEY)
  private String businessKey;

  public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
  @SerializedName(SERIALIZED_NAME_TENANT_ID)
  private String tenantId;

  public static final String SERIALIZED_NAME_WITHOUT_TENANT_ID = "withoutTenantId";
  @SerializedName(SERIALIZED_NAME_WITHOUT_TENANT_ID)
  private Boolean withoutTenantId = false;

  public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
  @SerializedName(SERIALIZED_NAME_PROCESS_INSTANCE_ID)
  private String processInstanceId;

  public static final String SERIALIZED_NAME_CORRELATION_KEYS = "correlationKeys";
  @SerializedName(SERIALIZED_NAME_CORRELATION_KEYS)
  private Map<String, VariableValueDto> correlationKeys = null;

  public static final String SERIALIZED_NAME_LOCAL_CORRELATION_KEYS = "localCorrelationKeys";
  @SerializedName(SERIALIZED_NAME_LOCAL_CORRELATION_KEYS)
  private Map<String, VariableValueDto> localCorrelationKeys = null;

  public static final String SERIALIZED_NAME_PROCESS_VARIABLES = "processVariables";
  @SerializedName(SERIALIZED_NAME_PROCESS_VARIABLES)
  private Map<String, VariableValueDto> processVariables = null;

  public static final String SERIALIZED_NAME_PROCESS_VARIABLES_LOCAL = "processVariablesLocal";
  @SerializedName(SERIALIZED_NAME_PROCESS_VARIABLES_LOCAL)
  private Map<String, VariableValueDto> processVariablesLocal = null;

  public static final String SERIALIZED_NAME_PROCESS_VARIABLES_TO_TRIGGERED_SCOPE = "processVariablesToTriggeredScope";
  @SerializedName(SERIALIZED_NAME_PROCESS_VARIABLES_TO_TRIGGERED_SCOPE)
  private Map<String, VariableValueDto> processVariablesToTriggeredScope = null;

  public static final String SERIALIZED_NAME_ALL = "all";
  @SerializedName(SERIALIZED_NAME_ALL)
  private Boolean all = false;

  public static final String SERIALIZED_NAME_RESULT_ENABLED = "resultEnabled";
  @SerializedName(SERIALIZED_NAME_RESULT_ENABLED)
  private Boolean resultEnabled = false;

  public static final String SERIALIZED_NAME_VARIABLES_IN_RESULT_ENABLED = "variablesInResultEnabled";
  @SerializedName(SERIALIZED_NAME_VARIABLES_IN_RESULT_ENABLED)
  private Boolean variablesInResultEnabled = false;


  public CorrelationMessageDto messageName(String messageName) {
    
    this.messageName = messageName;
    return this;
  }

   /**
   * The name of the message to deliver.
   * @return messageName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The name of the message to deliver.")

  public String getMessageName() {
    return messageName;
  }


  public void setMessageName(String messageName) {
    this.messageName = messageName;
  }


  public CorrelationMessageDto businessKey(String businessKey) {
    
    this.businessKey = businessKey;
    return this;
  }

   /**
   * Used for correlation of process instances that wait for incoming messages. Will only correlate to executions that belong to a process instance with the provided business key.
   * @return businessKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Used for correlation of process instances that wait for incoming messages. Will only correlate to executions that belong to a process instance with the provided business key.")

  public String getBusinessKey() {
    return businessKey;
  }


  public void setBusinessKey(String businessKey) {
    this.businessKey = businessKey;
  }


  public CorrelationMessageDto tenantId(String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

   /**
   * Used to correlate the message for a tenant with the given id. Will only correlate to executions and process definitions which belong to the tenant. Must not be supplied in conjunction with a &#x60;withoutTenantId&#x60;.
   * @return tenantId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Used to correlate the message for a tenant with the given id. Will only correlate to executions and process definitions which belong to the tenant. Must not be supplied in conjunction with a `withoutTenantId`.")

  public String getTenantId() {
    return tenantId;
  }


  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }


  public CorrelationMessageDto withoutTenantId(Boolean withoutTenantId) {
    
    this.withoutTenantId = withoutTenantId;
    return this;
  }

   /**
   * A Boolean value that indicates whether the message should only be correlated to executions and process definitions which belong to no tenant or not. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. Must not be supplied in conjunction with a &#x60;tenantId&#x60;.
   * @return withoutTenantId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A Boolean value that indicates whether the message should only be correlated to executions and process definitions which belong to no tenant or not. Value may only be `true`, as `false` is the default behavior. Must not be supplied in conjunction with a `tenantId`.")

  public Boolean getWithoutTenantId() {
    return withoutTenantId;
  }


  public void setWithoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = withoutTenantId;
  }


  public CorrelationMessageDto processInstanceId(String processInstanceId) {
    
    this.processInstanceId = processInstanceId;
    return this;
  }

   /**
   * Used to correlate the message to the process instance with the given id.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Used to correlate the message to the process instance with the given id.")

  public String getProcessInstanceId() {
    return processInstanceId;
  }


  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = processInstanceId;
  }


  public CorrelationMessageDto correlationKeys(Map<String, VariableValueDto> correlationKeys) {
    
    this.correlationKeys = correlationKeys;
    return this;
  }

  public CorrelationMessageDto putCorrelationKeysItem(String key, VariableValueDto correlationKeysItem) {
    if (this.correlationKeys == null) {
      this.correlationKeys = new HashMap<String, VariableValueDto>();
    }
    this.correlationKeys.put(key, correlationKeysItem);
    return this;
  }

   /**
   * Used for correlation of process instances that wait for incoming messages. Has to be a JSON object containing key-value pairs that are matched against process instance variables during correlation. Each key is a variable name and each value a JSON variable value object with the following properties.
   * @return correlationKeys
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Used for correlation of process instances that wait for incoming messages. Has to be a JSON object containing key-value pairs that are matched against process instance variables during correlation. Each key is a variable name and each value a JSON variable value object with the following properties.")

  public Map<String, VariableValueDto> getCorrelationKeys() {
    return correlationKeys;
  }


  public void setCorrelationKeys(Map<String, VariableValueDto> correlationKeys) {
    this.correlationKeys = correlationKeys;
  }


  public CorrelationMessageDto localCorrelationKeys(Map<String, VariableValueDto> localCorrelationKeys) {
    
    this.localCorrelationKeys = localCorrelationKeys;
    return this;
  }

  public CorrelationMessageDto putLocalCorrelationKeysItem(String key, VariableValueDto localCorrelationKeysItem) {
    if (this.localCorrelationKeys == null) {
      this.localCorrelationKeys = new HashMap<String, VariableValueDto>();
    }
    this.localCorrelationKeys.put(key, localCorrelationKeysItem);
    return this;
  }

   /**
   * Local variables used for correlation of executions (process instances) that wait for incoming messages. Has to be a JSON object containing key-value pairs that are matched against local variables during correlation. Each key is a variable name and each value a JSON variable value object with the following properties.
   * @return localCorrelationKeys
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Local variables used for correlation of executions (process instances) that wait for incoming messages. Has to be a JSON object containing key-value pairs that are matched against local variables during correlation. Each key is a variable name and each value a JSON variable value object with the following properties.")

  public Map<String, VariableValueDto> getLocalCorrelationKeys() {
    return localCorrelationKeys;
  }


  public void setLocalCorrelationKeys(Map<String, VariableValueDto> localCorrelationKeys) {
    this.localCorrelationKeys = localCorrelationKeys;
  }


  public CorrelationMessageDto processVariables(Map<String, VariableValueDto> processVariables) {
    
    this.processVariables = processVariables;
    return this;
  }

  public CorrelationMessageDto putProcessVariablesItem(String key, VariableValueDto processVariablesItem) {
    if (this.processVariables == null) {
      this.processVariables = new HashMap<String, VariableValueDto>();
    }
    this.processVariables.put(key, processVariablesItem);
    return this;
  }

   /**
   * A map of variables that is injected into the triggered execution or process instance after the message has been delivered. Each key is a variable name and each value a JSON variable value object with the following properties.
   * @return processVariables
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A map of variables that is injected into the triggered execution or process instance after the message has been delivered. Each key is a variable name and each value a JSON variable value object with the following properties.")

  public Map<String, VariableValueDto> getProcessVariables() {
    return processVariables;
  }


  public void setProcessVariables(Map<String, VariableValueDto> processVariables) {
    this.processVariables = processVariables;
  }


  public CorrelationMessageDto processVariablesLocal(Map<String, VariableValueDto> processVariablesLocal) {
    
    this.processVariablesLocal = processVariablesLocal;
    return this;
  }

  public CorrelationMessageDto putProcessVariablesLocalItem(String key, VariableValueDto processVariablesLocalItem) {
    if (this.processVariablesLocal == null) {
      this.processVariablesLocal = new HashMap<String, VariableValueDto>();
    }
    this.processVariablesLocal.put(key, processVariablesLocalItem);
    return this;
  }

   /**
   * A map of local variables that is injected into the execution waiting on the message. Each key is a variable name and each value a JSON variable value object with the following properties.
   * @return processVariablesLocal
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A map of local variables that is injected into the execution waiting on the message. Each key is a variable name and each value a JSON variable value object with the following properties.")

  public Map<String, VariableValueDto> getProcessVariablesLocal() {
    return processVariablesLocal;
  }


  public void setProcessVariablesLocal(Map<String, VariableValueDto> processVariablesLocal) {
    this.processVariablesLocal = processVariablesLocal;
  }


  public CorrelationMessageDto processVariablesToTriggeredScope(Map<String, VariableValueDto> processVariablesToTriggeredScope) {
    
    this.processVariablesToTriggeredScope = processVariablesToTriggeredScope;
    return this;
  }

  public CorrelationMessageDto putProcessVariablesToTriggeredScopeItem(String key, VariableValueDto processVariablesToTriggeredScopeItem) {
    if (this.processVariablesToTriggeredScope == null) {
      this.processVariablesToTriggeredScope = new HashMap<String, VariableValueDto>();
    }
    this.processVariablesToTriggeredScope.put(key, processVariablesToTriggeredScopeItem);
    return this;
  }

   /**
   * A map of variables that is injected into the new scope triggered by message correlation. Each key is a variable name and each value a JSON variable value object with the following properties.
   * @return processVariablesToTriggeredScope
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A map of variables that is injected into the new scope triggered by message correlation. Each key is a variable name and each value a JSON variable value object with the following properties.")

  public Map<String, VariableValueDto> getProcessVariablesToTriggeredScope() {
    return processVariablesToTriggeredScope;
  }


  public void setProcessVariablesToTriggeredScope(Map<String, VariableValueDto> processVariablesToTriggeredScope) {
    this.processVariablesToTriggeredScope = processVariablesToTriggeredScope;
  }


  public CorrelationMessageDto all(Boolean all) {
    
    this.all = all;
    return this;
  }

   /**
   * A Boolean value that indicates whether the message should be correlated to exactly one entity or multiple entities. If the value is set to &#x60;false&#x60;, the message will be correlated to exactly one entity (execution or process definition). If the value is set to &#x60;true&#x60;, the message will be correlated to multiple executions and a process definition that can be instantiated by this message in one go.
   * @return all
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A Boolean value that indicates whether the message should be correlated to exactly one entity or multiple entities. If the value is set to `false`, the message will be correlated to exactly one entity (execution or process definition). If the value is set to `true`, the message will be correlated to multiple executions and a process definition that can be instantiated by this message in one go.")

  public Boolean getAll() {
    return all;
  }


  public void setAll(Boolean all) {
    this.all = all;
  }


  public CorrelationMessageDto resultEnabled(Boolean resultEnabled) {
    
    this.resultEnabled = resultEnabled;
    return this;
  }

   /**
   * A Boolean value that indicates whether the result of the correlation should be returned or not. If this property is set to &#x60;true&#x60;, there will be returned a list of message correlation result objects. Depending on the all property, there will be either one ore more returned results in the list.  The default value is &#x60;false&#x60;, which means no result will be returned.
   * @return resultEnabled
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A Boolean value that indicates whether the result of the correlation should be returned or not. If this property is set to `true`, there will be returned a list of message correlation result objects. Depending on the all property, there will be either one ore more returned results in the list.  The default value is `false`, which means no result will be returned.")

  public Boolean getResultEnabled() {
    return resultEnabled;
  }


  public void setResultEnabled(Boolean resultEnabled) {
    this.resultEnabled = resultEnabled;
  }


  public CorrelationMessageDto variablesInResultEnabled(Boolean variablesInResultEnabled) {
    
    this.variablesInResultEnabled = variablesInResultEnabled;
    return this;
  }

   /**
   * A Boolean value that indicates whether the result of the correlation should contain process variables or not. The parameter resultEnabled should be set to &#x60;true&#x60; in order to use this it.  The default value is &#x60;false&#x60;, which means the variables will not be returned.
   * @return variablesInResultEnabled
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A Boolean value that indicates whether the result of the correlation should contain process variables or not. The parameter resultEnabled should be set to `true` in order to use this it.  The default value is `false`, which means the variables will not be returned.")

  public Boolean getVariablesInResultEnabled() {
    return variablesInResultEnabled;
  }


  public void setVariablesInResultEnabled(Boolean variablesInResultEnabled) {
    this.variablesInResultEnabled = variablesInResultEnabled;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CorrelationMessageDto correlationMessageDto = (CorrelationMessageDto) o;
    return Objects.equals(this.messageName, correlationMessageDto.messageName) &&
        Objects.equals(this.businessKey, correlationMessageDto.businessKey) &&
        Objects.equals(this.tenantId, correlationMessageDto.tenantId) &&
        Objects.equals(this.withoutTenantId, correlationMessageDto.withoutTenantId) &&
        Objects.equals(this.processInstanceId, correlationMessageDto.processInstanceId) &&
        Objects.equals(this.correlationKeys, correlationMessageDto.correlationKeys) &&
        Objects.equals(this.localCorrelationKeys, correlationMessageDto.localCorrelationKeys) &&
        Objects.equals(this.processVariables, correlationMessageDto.processVariables) &&
        Objects.equals(this.processVariablesLocal, correlationMessageDto.processVariablesLocal) &&
        Objects.equals(this.processVariablesToTriggeredScope, correlationMessageDto.processVariablesToTriggeredScope) &&
        Objects.equals(this.all, correlationMessageDto.all) &&
        Objects.equals(this.resultEnabled, correlationMessageDto.resultEnabled) &&
        Objects.equals(this.variablesInResultEnabled, correlationMessageDto.variablesInResultEnabled);
  }

  @Override
  public int hashCode() {
    return Objects.hash(messageName, businessKey, tenantId, withoutTenantId, processInstanceId, correlationKeys, localCorrelationKeys, processVariables, processVariablesLocal, processVariablesToTriggeredScope, all, resultEnabled, variablesInResultEnabled);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CorrelationMessageDto {\n");
    sb.append("    messageName: ").append(toIndentedString(messageName)).append("\n");
    sb.append("    businessKey: ").append(toIndentedString(businessKey)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    withoutTenantId: ").append(toIndentedString(withoutTenantId)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    correlationKeys: ").append(toIndentedString(correlationKeys)).append("\n");
    sb.append("    localCorrelationKeys: ").append(toIndentedString(localCorrelationKeys)).append("\n");
    sb.append("    processVariables: ").append(toIndentedString(processVariables)).append("\n");
    sb.append("    processVariablesLocal: ").append(toIndentedString(processVariablesLocal)).append("\n");
    sb.append("    processVariablesToTriggeredScope: ").append(toIndentedString(processVariablesToTriggeredScope)).append("\n");
    sb.append("    all: ").append(toIndentedString(all)).append("\n");
    sb.append("    resultEnabled: ").append(toIndentedString(resultEnabled)).append("\n");
    sb.append("    variablesInResultEnabled: ").append(toIndentedString(variablesInResultEnabled)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

