/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.22.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.client.api;

import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.ProgressRequestBody;
import org.openapitools.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.openapitools.client.model.CountResultDto;
import java.util.Date;
import org.openapitools.client.model.ExceptionDto;
import org.openapitools.client.model.HistoricIncidentDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HistoricIncidentApi {
    private ApiClient localVarApiClient;

    public HistoricIncidentApi() {
        this(Configuration.getDefaultApiClient());
    }

    public HistoricIncidentApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getHistoricIncidents
     * @param incidentId Restricts to incidents that have the given id. (optional)
     * @param incidentType Restricts to incidents that belong to the given incident type. See the [User Guide](/manual/develop/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Restricts to incidents that have the given incident message. (optional)
     * @param incidentMessageLike Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character &#39;%&#39; to express like-strategy: starts with (string%), ends with (%string) or contains (%string%).  (optional)
     * @param processDefinitionId Restricts to incidents that belong to a process definition with the given id. (optional)
     * @param processDefinitionKey Restricts to incidents that have the given processDefinitionKey. (optional)
     * @param processDefinitionKeyIn Restricts to incidents that have one of the given process definition keys. (optional)
     * @param processInstanceId Restricts to incidents that belong to a process instance with the given id. (optional)
     * @param executionId Restricts to incidents that belong to an execution with the given id. (optional)
     * @param createTimeBefore Restricts to incidents that have a createTime date before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param createTimeAfter Restricts to incidents that have a createTime date after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param endTimeBefore Restricts to incidents that have an endTimeBefore date before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param endTimeAfter Restricts to incidents that have an endTimeAfter date after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param activityId Restricts to incidents that belong to an activity with the given id. (optional)
     * @param failedActivityId Restricts to incidents that were created due to the failure of an activity with the given id. (optional)
     * @param causeIncidentId Restricts to incidents that have the given incident id as cause incident. (optional)
     * @param rootCauseIncidentId Restricts to incidents that have the given incident id as root cause incident. (optional)
     * @param _configuration Restricts to incidents that have the given parameter set as configuration. (optional)
     * @param historyConfiguration Restricts to incidents that have the given parameter set as history configuration. (optional)
     * @param open Restricts to incidents that are open. (optional)
     * @param resolved Restricts to incidents that are resolved. (optional)
     * @param deleted Restricts to incidents that are deleted. (optional)
     * @param tenantIdIn Restricts to incidents that have one of the given comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include historic incidents that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param jobDefinitionIdIn Restricts to incidents that have one of the given comma-separated job definition ids. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricIncidentsCall(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processInstanceId, String executionId, Date createTimeBefore, Date createTimeAfter, Date endTimeBefore, Date endTimeAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String historyConfiguration, Boolean open, Boolean resolved, Boolean deleted, String tenantIdIn, Boolean withoutTenantId, String jobDefinitionIdIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/incident";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (incidentId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentId", incidentId));
        }

        if (incidentType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentType", incidentType));
        }

        if (incidentMessage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentMessage", incidentMessage));
        }

        if (incidentMessageLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
        }

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }

        if (processDefinitionKeyIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
        }

        if (processInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }

        if (executionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executionId", executionId));
        }

        if (createTimeBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("createTimeBefore", createTimeBefore));
        }

        if (createTimeAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("createTimeAfter", createTimeAfter));
        }

        if (endTimeBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("endTimeBefore", endTimeBefore));
        }

        if (endTimeAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("endTimeAfter", endTimeAfter));
        }

        if (activityId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityId", activityId));
        }

        if (failedActivityId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("failedActivityId", failedActivityId));
        }

        if (causeIncidentId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("causeIncidentId", causeIncidentId));
        }

        if (rootCauseIncidentId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("rootCauseIncidentId", rootCauseIncidentId));
        }

        if (_configuration != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("configuration", _configuration));
        }

        if (historyConfiguration != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("historyConfiguration", historyConfiguration));
        }

        if (open != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("open", open));
        }

        if (resolved != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("resolved", resolved));
        }

        if (deleted != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deleted", deleted));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (jobDefinitionIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobDefinitionIdIn", jobDefinitionIdIn));
        }

        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortBy", sortBy));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricIncidentsValidateBeforeCall(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processInstanceId, String executionId, Date createTimeBefore, Date createTimeAfter, Date endTimeBefore, Date endTimeAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String historyConfiguration, Boolean open, Boolean resolved, Boolean deleted, String tenantIdIn, Boolean withoutTenantId, String jobDefinitionIdIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getHistoricIncidentsCall(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processInstanceId, executionId, createTimeBefore, createTimeAfter, endTimeBefore, endTimeAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, historyConfiguration, open, resolved, deleted, tenantIdIn, withoutTenantId, jobDefinitionIdIn, sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;

    }

    /**
     * Get Incidents
     * Queries for historic incidents that fulfill given parameters. The size of the result set can be retrieved by using the [Get Incident Count](https://docs.camunda.org/manual/7.22/reference/rest/history/incident/get-incident-query-count/) method.
     * @param incidentId Restricts to incidents that have the given id. (optional)
     * @param incidentType Restricts to incidents that belong to the given incident type. See the [User Guide](/manual/develop/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Restricts to incidents that have the given incident message. (optional)
     * @param incidentMessageLike Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character &#39;%&#39; to express like-strategy: starts with (string%), ends with (%string) or contains (%string%).  (optional)
     * @param processDefinitionId Restricts to incidents that belong to a process definition with the given id. (optional)
     * @param processDefinitionKey Restricts to incidents that have the given processDefinitionKey. (optional)
     * @param processDefinitionKeyIn Restricts to incidents that have one of the given process definition keys. (optional)
     * @param processInstanceId Restricts to incidents that belong to a process instance with the given id. (optional)
     * @param executionId Restricts to incidents that belong to an execution with the given id. (optional)
     * @param createTimeBefore Restricts to incidents that have a createTime date before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param createTimeAfter Restricts to incidents that have a createTime date after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param endTimeBefore Restricts to incidents that have an endTimeBefore date before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param endTimeAfter Restricts to incidents that have an endTimeAfter date after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param activityId Restricts to incidents that belong to an activity with the given id. (optional)
     * @param failedActivityId Restricts to incidents that were created due to the failure of an activity with the given id. (optional)
     * @param causeIncidentId Restricts to incidents that have the given incident id as cause incident. (optional)
     * @param rootCauseIncidentId Restricts to incidents that have the given incident id as root cause incident. (optional)
     * @param _configuration Restricts to incidents that have the given parameter set as configuration. (optional)
     * @param historyConfiguration Restricts to incidents that have the given parameter set as history configuration. (optional)
     * @param open Restricts to incidents that are open. (optional)
     * @param resolved Restricts to incidents that are resolved. (optional)
     * @param deleted Restricts to incidents that are deleted. (optional)
     * @param tenantIdIn Restricts to incidents that have one of the given comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include historic incidents that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param jobDefinitionIdIn Restricts to incidents that have one of the given comma-separated job definition ids. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return List&lt;HistoricIncidentDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<HistoricIncidentDto> getHistoricIncidents(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processInstanceId, String executionId, Date createTimeBefore, Date createTimeAfter, Date endTimeBefore, Date endTimeAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String historyConfiguration, Boolean open, Boolean resolved, Boolean deleted, String tenantIdIn, Boolean withoutTenantId, String jobDefinitionIdIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<HistoricIncidentDto>> localVarResp = getHistoricIncidentsWithHttpInfo(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processInstanceId, executionId, createTimeBefore, createTimeAfter, endTimeBefore, endTimeAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, historyConfiguration, open, resolved, deleted, tenantIdIn, withoutTenantId, jobDefinitionIdIn, sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    /**
     * Get Incidents
     * Queries for historic incidents that fulfill given parameters. The size of the result set can be retrieved by using the [Get Incident Count](https://docs.camunda.org/manual/7.22/reference/rest/history/incident/get-incident-query-count/) method.
     * @param incidentId Restricts to incidents that have the given id. (optional)
     * @param incidentType Restricts to incidents that belong to the given incident type. See the [User Guide](/manual/develop/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Restricts to incidents that have the given incident message. (optional)
     * @param incidentMessageLike Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character &#39;%&#39; to express like-strategy: starts with (string%), ends with (%string) or contains (%string%).  (optional)
     * @param processDefinitionId Restricts to incidents that belong to a process definition with the given id. (optional)
     * @param processDefinitionKey Restricts to incidents that have the given processDefinitionKey. (optional)
     * @param processDefinitionKeyIn Restricts to incidents that have one of the given process definition keys. (optional)
     * @param processInstanceId Restricts to incidents that belong to a process instance with the given id. (optional)
     * @param executionId Restricts to incidents that belong to an execution with the given id. (optional)
     * @param createTimeBefore Restricts to incidents that have a createTime date before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param createTimeAfter Restricts to incidents that have a createTime date after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param endTimeBefore Restricts to incidents that have an endTimeBefore date before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param endTimeAfter Restricts to incidents that have an endTimeAfter date after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param activityId Restricts to incidents that belong to an activity with the given id. (optional)
     * @param failedActivityId Restricts to incidents that were created due to the failure of an activity with the given id. (optional)
     * @param causeIncidentId Restricts to incidents that have the given incident id as cause incident. (optional)
     * @param rootCauseIncidentId Restricts to incidents that have the given incident id as root cause incident. (optional)
     * @param _configuration Restricts to incidents that have the given parameter set as configuration. (optional)
     * @param historyConfiguration Restricts to incidents that have the given parameter set as history configuration. (optional)
     * @param open Restricts to incidents that are open. (optional)
     * @param resolved Restricts to incidents that are resolved. (optional)
     * @param deleted Restricts to incidents that are deleted. (optional)
     * @param tenantIdIn Restricts to incidents that have one of the given comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include historic incidents that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param jobDefinitionIdIn Restricts to incidents that have one of the given comma-separated job definition ids. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return ApiResponse&lt;List&lt;HistoricIncidentDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<HistoricIncidentDto>> getHistoricIncidentsWithHttpInfo(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processInstanceId, String executionId, Date createTimeBefore, Date createTimeAfter, Date endTimeBefore, Date endTimeAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String historyConfiguration, Boolean open, Boolean resolved, Boolean deleted, String tenantIdIn, Boolean withoutTenantId, String jobDefinitionIdIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        okhttp3.Call localVarCall = getHistoricIncidentsValidateBeforeCall(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processInstanceId, executionId, createTimeBefore, createTimeAfter, endTimeBefore, endTimeAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, historyConfiguration, open, resolved, deleted, tenantIdIn, withoutTenantId, jobDefinitionIdIn, sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<HistoricIncidentDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Incidents (asynchronously)
     * Queries for historic incidents that fulfill given parameters. The size of the result set can be retrieved by using the [Get Incident Count](https://docs.camunda.org/manual/7.22/reference/rest/history/incident/get-incident-query-count/) method.
     * @param incidentId Restricts to incidents that have the given id. (optional)
     * @param incidentType Restricts to incidents that belong to the given incident type. See the [User Guide](/manual/develop/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Restricts to incidents that have the given incident message. (optional)
     * @param incidentMessageLike Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character &#39;%&#39; to express like-strategy: starts with (string%), ends with (%string) or contains (%string%).  (optional)
     * @param processDefinitionId Restricts to incidents that belong to a process definition with the given id. (optional)
     * @param processDefinitionKey Restricts to incidents that have the given processDefinitionKey. (optional)
     * @param processDefinitionKeyIn Restricts to incidents that have one of the given process definition keys. (optional)
     * @param processInstanceId Restricts to incidents that belong to a process instance with the given id. (optional)
     * @param executionId Restricts to incidents that belong to an execution with the given id. (optional)
     * @param createTimeBefore Restricts to incidents that have a createTime date before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param createTimeAfter Restricts to incidents that have a createTime date after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param endTimeBefore Restricts to incidents that have an endTimeBefore date before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param endTimeAfter Restricts to incidents that have an endTimeAfter date after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param activityId Restricts to incidents that belong to an activity with the given id. (optional)
     * @param failedActivityId Restricts to incidents that were created due to the failure of an activity with the given id. (optional)
     * @param causeIncidentId Restricts to incidents that have the given incident id as cause incident. (optional)
     * @param rootCauseIncidentId Restricts to incidents that have the given incident id as root cause incident. (optional)
     * @param _configuration Restricts to incidents that have the given parameter set as configuration. (optional)
     * @param historyConfiguration Restricts to incidents that have the given parameter set as history configuration. (optional)
     * @param open Restricts to incidents that are open. (optional)
     * @param resolved Restricts to incidents that are resolved. (optional)
     * @param deleted Restricts to incidents that are deleted. (optional)
     * @param tenantIdIn Restricts to incidents that have one of the given comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include historic incidents that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param jobDefinitionIdIn Restricts to incidents that have one of the given comma-separated job definition ids. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricIncidentsAsync(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processInstanceId, String executionId, Date createTimeBefore, Date createTimeAfter, Date endTimeBefore, Date endTimeAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String historyConfiguration, Boolean open, Boolean resolved, Boolean deleted, String tenantIdIn, Boolean withoutTenantId, String jobDefinitionIdIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback<List<HistoricIncidentDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricIncidentsValidateBeforeCall(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processInstanceId, executionId, createTimeBefore, createTimeAfter, endTimeBefore, endTimeAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, historyConfiguration, open, resolved, deleted, tenantIdIn, withoutTenantId, jobDefinitionIdIn, sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<HistoricIncidentDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getHistoricIncidentsCount
     * @param incidentId Restricts to incidents that have the given id. (optional)
     * @param incidentType Restricts to incidents that belong to the given incident type. See the [User Guide](/manual/develop/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Restricts to incidents that have the given incident message. (optional)
     * @param incidentMessageLike Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character &#39;%&#39; to express like-strategy: starts with (string%), ends with (%string) or contains (%string%).  (optional)
     * @param processDefinitionId Restricts to incidents that belong to a process definition with the given id. (optional)
     * @param processDefinitionKey Restricts to incidents that have the given processDefinitionKey. (optional)
     * @param processDefinitionKeyIn Restricts to incidents that have one of the given process definition keys. (optional)
     * @param processInstanceId Restricts to incidents that belong to a process instance with the given id. (optional)
     * @param executionId Restricts to incidents that belong to an execution with the given id. (optional)
     * @param createTimeBefore Restricts to incidents that have a createTime date before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param createTimeAfter Restricts to incidents that have a createTime date after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param endTimeBefore Restricts to incidents that have an endTimeBefore date before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param endTimeAfter Restricts to incidents that have an endTimeAfter date after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param activityId Restricts to incidents that belong to an activity with the given id. (optional)
     * @param failedActivityId Restricts to incidents that were created due to the failure of an activity with the given id. (optional)
     * @param causeIncidentId Restricts to incidents that have the given incident id as cause incident. (optional)
     * @param rootCauseIncidentId Restricts to incidents that have the given incident id as root cause incident. (optional)
     * @param _configuration Restricts to incidents that have the given parameter set as configuration. (optional)
     * @param historyConfiguration Restricts to incidents that have the given parameter set as history configuration. (optional)
     * @param open Restricts to incidents that are open. (optional)
     * @param resolved Restricts to incidents that are resolved. (optional)
     * @param deleted Restricts to incidents that are deleted. (optional)
     * @param tenantIdIn Restricts to incidents that have one of the given comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include historic incidents that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param jobDefinitionIdIn Restricts to incidents that have one of the given comma-separated job definition ids. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricIncidentsCountCall(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processInstanceId, String executionId, Date createTimeBefore, Date createTimeAfter, Date endTimeBefore, Date endTimeAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String historyConfiguration, Boolean open, Boolean resolved, Boolean deleted, String tenantIdIn, Boolean withoutTenantId, String jobDefinitionIdIn, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/incident/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (incidentId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentId", incidentId));
        }

        if (incidentType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentType", incidentType));
        }

        if (incidentMessage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentMessage", incidentMessage));
        }

        if (incidentMessageLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
        }

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }

        if (processDefinitionKeyIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
        }

        if (processInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }

        if (executionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executionId", executionId));
        }

        if (createTimeBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("createTimeBefore", createTimeBefore));
        }

        if (createTimeAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("createTimeAfter", createTimeAfter));
        }

        if (endTimeBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("endTimeBefore", endTimeBefore));
        }

        if (endTimeAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("endTimeAfter", endTimeAfter));
        }

        if (activityId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityId", activityId));
        }

        if (failedActivityId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("failedActivityId", failedActivityId));
        }

        if (causeIncidentId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("causeIncidentId", causeIncidentId));
        }

        if (rootCauseIncidentId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("rootCauseIncidentId", rootCauseIncidentId));
        }

        if (_configuration != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("configuration", _configuration));
        }

        if (historyConfiguration != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("historyConfiguration", historyConfiguration));
        }

        if (open != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("open", open));
        }

        if (resolved != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("resolved", resolved));
        }

        if (deleted != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deleted", deleted));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (jobDefinitionIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobDefinitionIdIn", jobDefinitionIdIn));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricIncidentsCountValidateBeforeCall(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processInstanceId, String executionId, Date createTimeBefore, Date createTimeAfter, Date endTimeBefore, Date endTimeAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String historyConfiguration, Boolean open, Boolean resolved, Boolean deleted, String tenantIdIn, Boolean withoutTenantId, String jobDefinitionIdIn, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getHistoricIncidentsCountCall(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processInstanceId, executionId, createTimeBefore, createTimeAfter, endTimeBefore, endTimeAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, historyConfiguration, open, resolved, deleted, tenantIdIn, withoutTenantId, jobDefinitionIdIn, _callback);
        return localVarCall;

    }

    /**
     * Get Incident Count
     * Queries for the number of historic incidents that fulfill the given parameters. Takes the same parameters as the [Get Incidents](https://docs.camunda.org/manual/7.22/reference/rest/history/incident/get-incident-query/) method.
     * @param incidentId Restricts to incidents that have the given id. (optional)
     * @param incidentType Restricts to incidents that belong to the given incident type. See the [User Guide](/manual/develop/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Restricts to incidents that have the given incident message. (optional)
     * @param incidentMessageLike Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character &#39;%&#39; to express like-strategy: starts with (string%), ends with (%string) or contains (%string%).  (optional)
     * @param processDefinitionId Restricts to incidents that belong to a process definition with the given id. (optional)
     * @param processDefinitionKey Restricts to incidents that have the given processDefinitionKey. (optional)
     * @param processDefinitionKeyIn Restricts to incidents that have one of the given process definition keys. (optional)
     * @param processInstanceId Restricts to incidents that belong to a process instance with the given id. (optional)
     * @param executionId Restricts to incidents that belong to an execution with the given id. (optional)
     * @param createTimeBefore Restricts to incidents that have a createTime date before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param createTimeAfter Restricts to incidents that have a createTime date after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param endTimeBefore Restricts to incidents that have an endTimeBefore date before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param endTimeAfter Restricts to incidents that have an endTimeAfter date after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param activityId Restricts to incidents that belong to an activity with the given id. (optional)
     * @param failedActivityId Restricts to incidents that were created due to the failure of an activity with the given id. (optional)
     * @param causeIncidentId Restricts to incidents that have the given incident id as cause incident. (optional)
     * @param rootCauseIncidentId Restricts to incidents that have the given incident id as root cause incident. (optional)
     * @param _configuration Restricts to incidents that have the given parameter set as configuration. (optional)
     * @param historyConfiguration Restricts to incidents that have the given parameter set as history configuration. (optional)
     * @param open Restricts to incidents that are open. (optional)
     * @param resolved Restricts to incidents that are resolved. (optional)
     * @param deleted Restricts to incidents that are deleted. (optional)
     * @param tenantIdIn Restricts to incidents that have one of the given comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include historic incidents that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param jobDefinitionIdIn Restricts to incidents that have one of the given comma-separated job definition ids. (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto getHistoricIncidentsCount(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processInstanceId, String executionId, Date createTimeBefore, Date createTimeAfter, Date endTimeBefore, Date endTimeAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String historyConfiguration, Boolean open, Boolean resolved, Boolean deleted, String tenantIdIn, Boolean withoutTenantId, String jobDefinitionIdIn) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = getHistoricIncidentsCountWithHttpInfo(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processInstanceId, executionId, createTimeBefore, createTimeAfter, endTimeBefore, endTimeAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, historyConfiguration, open, resolved, deleted, tenantIdIn, withoutTenantId, jobDefinitionIdIn);
        return localVarResp.getData();
    }

    /**
     * Get Incident Count
     * Queries for the number of historic incidents that fulfill the given parameters. Takes the same parameters as the [Get Incidents](https://docs.camunda.org/manual/7.22/reference/rest/history/incident/get-incident-query/) method.
     * @param incidentId Restricts to incidents that have the given id. (optional)
     * @param incidentType Restricts to incidents that belong to the given incident type. See the [User Guide](/manual/develop/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Restricts to incidents that have the given incident message. (optional)
     * @param incidentMessageLike Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character &#39;%&#39; to express like-strategy: starts with (string%), ends with (%string) or contains (%string%).  (optional)
     * @param processDefinitionId Restricts to incidents that belong to a process definition with the given id. (optional)
     * @param processDefinitionKey Restricts to incidents that have the given processDefinitionKey. (optional)
     * @param processDefinitionKeyIn Restricts to incidents that have one of the given process definition keys. (optional)
     * @param processInstanceId Restricts to incidents that belong to a process instance with the given id. (optional)
     * @param executionId Restricts to incidents that belong to an execution with the given id. (optional)
     * @param createTimeBefore Restricts to incidents that have a createTime date before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param createTimeAfter Restricts to incidents that have a createTime date after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param endTimeBefore Restricts to incidents that have an endTimeBefore date before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param endTimeAfter Restricts to incidents that have an endTimeAfter date after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param activityId Restricts to incidents that belong to an activity with the given id. (optional)
     * @param failedActivityId Restricts to incidents that were created due to the failure of an activity with the given id. (optional)
     * @param causeIncidentId Restricts to incidents that have the given incident id as cause incident. (optional)
     * @param rootCauseIncidentId Restricts to incidents that have the given incident id as root cause incident. (optional)
     * @param _configuration Restricts to incidents that have the given parameter set as configuration. (optional)
     * @param historyConfiguration Restricts to incidents that have the given parameter set as history configuration. (optional)
     * @param open Restricts to incidents that are open. (optional)
     * @param resolved Restricts to incidents that are resolved. (optional)
     * @param deleted Restricts to incidents that are deleted. (optional)
     * @param tenantIdIn Restricts to incidents that have one of the given comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include historic incidents that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param jobDefinitionIdIn Restricts to incidents that have one of the given comma-separated job definition ids. (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> getHistoricIncidentsCountWithHttpInfo(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processInstanceId, String executionId, Date createTimeBefore, Date createTimeAfter, Date endTimeBefore, Date endTimeAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String historyConfiguration, Boolean open, Boolean resolved, Boolean deleted, String tenantIdIn, Boolean withoutTenantId, String jobDefinitionIdIn) throws ApiException {
        okhttp3.Call localVarCall = getHistoricIncidentsCountValidateBeforeCall(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processInstanceId, executionId, createTimeBefore, createTimeAfter, endTimeBefore, endTimeAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, historyConfiguration, open, resolved, deleted, tenantIdIn, withoutTenantId, jobDefinitionIdIn, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Incident Count (asynchronously)
     * Queries for the number of historic incidents that fulfill the given parameters. Takes the same parameters as the [Get Incidents](https://docs.camunda.org/manual/7.22/reference/rest/history/incident/get-incident-query/) method.
     * @param incidentId Restricts to incidents that have the given id. (optional)
     * @param incidentType Restricts to incidents that belong to the given incident type. See the [User Guide](/manual/develop/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Restricts to incidents that have the given incident message. (optional)
     * @param incidentMessageLike Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character &#39;%&#39; to express like-strategy: starts with (string%), ends with (%string) or contains (%string%).  (optional)
     * @param processDefinitionId Restricts to incidents that belong to a process definition with the given id. (optional)
     * @param processDefinitionKey Restricts to incidents that have the given processDefinitionKey. (optional)
     * @param processDefinitionKeyIn Restricts to incidents that have one of the given process definition keys. (optional)
     * @param processInstanceId Restricts to incidents that belong to a process instance with the given id. (optional)
     * @param executionId Restricts to incidents that belong to an execution with the given id. (optional)
     * @param createTimeBefore Restricts to incidents that have a createTime date before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param createTimeAfter Restricts to incidents that have a createTime date after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param endTimeBefore Restricts to incidents that have an endTimeBefore date before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param endTimeAfter Restricts to incidents that have an endTimeAfter date after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param activityId Restricts to incidents that belong to an activity with the given id. (optional)
     * @param failedActivityId Restricts to incidents that were created due to the failure of an activity with the given id. (optional)
     * @param causeIncidentId Restricts to incidents that have the given incident id as cause incident. (optional)
     * @param rootCauseIncidentId Restricts to incidents that have the given incident id as root cause incident. (optional)
     * @param _configuration Restricts to incidents that have the given parameter set as configuration. (optional)
     * @param historyConfiguration Restricts to incidents that have the given parameter set as history configuration. (optional)
     * @param open Restricts to incidents that are open. (optional)
     * @param resolved Restricts to incidents that are resolved. (optional)
     * @param deleted Restricts to incidents that are deleted. (optional)
     * @param tenantIdIn Restricts to incidents that have one of the given comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include historic incidents that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param jobDefinitionIdIn Restricts to incidents that have one of the given comma-separated job definition ids. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricIncidentsCountAsync(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processInstanceId, String executionId, Date createTimeBefore, Date createTimeAfter, Date endTimeBefore, Date endTimeAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String historyConfiguration, Boolean open, Boolean resolved, Boolean deleted, String tenantIdIn, Boolean withoutTenantId, String jobDefinitionIdIn, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricIncidentsCountValidateBeforeCall(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processInstanceId, executionId, createTimeBefore, createTimeAfter, endTimeBefore, endTimeAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, historyConfiguration, open, resolved, deleted, tenantIdIn, withoutTenantId, jobDefinitionIdIn, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
