/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.rest;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.net.ssl.SSLContext;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.rest.AbstractRESTConfluenceService;
import org.bsc.confluence.rest.model.Attachment;
import org.bsc.confluence.rest.model.Blogpost;
import org.bsc.confluence.rest.model.Page;
import org.bsc.ssl.SSLCertificateInfo;

public class RESTConfluenceService
extends AbstractRESTConfluenceService
implements ConfluenceService {
    final ConfluenceService.Credentials credentials;
    final URL endpoint;

    public RESTConfluenceService(String url, ConfluenceService.Credentials credentials, SSLCertificateInfo sslInfo) {
        if (credentials == null) {
            throw new IllegalArgumentException("credentials argument is null!");
        }
        if (url == null) {
            throw new IllegalArgumentException("url argument is null!");
        }
        if (sslInfo == null) {
            throw new IllegalArgumentException("sslInfo argument is null!");
        }
        try {
            this.endpoint = new URL(url);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("url argument is not valid!", ex);
        }
        this.credentials = credentials;
        HttpClient.Builder clientBuilder = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(ConfluenceService.getConnectTimeout((TimeUnit)TimeUnit.SECONDS)));
        if (!sslInfo.isIgnore() && "https".equals(this.endpoint.getProtocol())) {
            try {
                SSLContext sslContext = SSLContext.getInstance("TLSv1.3");
                sslContext.init(null, null, null);
                clientBuilder.sslContext(sslContext);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new Error(e);
            }
        }
        this.client = clientBuilder.build();
    }

    private HttpRequest.Builder processHeaderBeforeRequest(HttpRequest.Builder reqBuilder) {
        if (this.credentials.username != null) {
            String credential = "Basic " + Base64.getEncoder().encodeToString((this.credentials.username + ":" + this.credentials.password).getBytes());
            reqBuilder.header("Authorization", credential);
        }
        if (!this.credentials.httpHeaders.isEmpty()) {
            this.credentials.httpHeaders.forEach(reqBuilder::header);
        }
        return reqBuilder;
    }

    @Override
    protected void fromRequest(HttpRequest.Builder reqBuilder, String description, Consumer<HttpResponse<String>> consumer) {
        this.processHeaderBeforeRequest(reqBuilder);
        super.fromRequest(reqBuilder, description, consumer);
    }

    @Override
    public CompletableFuture<HttpResponse<String>> fromRequestAsync(HttpRequest.Builder reqBuilder) {
        return super.fromRequestAsync(this.processHeaderBeforeRequest(reqBuilder));
    }

    private <T extends S, S> CompletableFuture<T> cast(CompletableFuture<S> s) {
        return s;
    }

    public final JsonObjectBuilder jsonForCreatingContent(ContentType type, String spaceKey, String title, ConfluenceService.Storage content) {
        return Json.createObjectBuilder().add("type", type.name()).add("title", title).add("space", Json.createObjectBuilder().add("key", spaceKey)).add("body", Json.createObjectBuilder().add("storage", Json.createObjectBuilder().add("representation", content.rapresentation.toString()).add("value", content.value)));
    }

    public final JsonObjectBuilder jsonForCreatingContent(ContentType type, String spaceKey, long parentPageId, String title, ConfluenceService.Storage content) {
        return this.jsonForCreatingContent(type, spaceKey, title, content).add("ancestors", Json.createArrayBuilder().add(Json.createObjectBuilder().add("id", parentPageId)));
    }

    public final JsonObjectBuilder jsonAddBody(JsonObjectBuilder builder, ConfluenceService.Storage storage) {
        return builder.add("body", Json.createObjectBuilder().add("storage", Json.createObjectBuilder().add("representation", storage.rapresentation.toString()).add("value", storage.value)));
    }

    public final CompletableFuture<ConfluenceService.Model.Page> createPageByTitle(String spaceKey, String title, ConfluenceService.Storage content) {
        JsonObjectBuilder input = this.jsonForCreatingContent(ContentType.page, spaceKey, title, content);
        return this.createPage(input.build()).thenApply(data -> data.map(Page::new).get());
    }

    @Override
    protected URI urlBuilder() throws URISyntaxException {
        int port = this.endpoint.getPort();
        port = port > -1 ? port : this.endpoint.getDefaultPort();
        String path = this.endpoint.getPath();
        return new URI(this.endpoint.getProtocol(), null, this.endpoint.getHost(), port, path, null, null);
    }

    @Override
    public ConfluenceService.Credentials getCredentials() {
        return this.credentials;
    }

    public ConfluenceService.Model.Page newPage(ConfluenceService.Model.ID id, String space, String title, int version) {
        return new Page(Json.createObjectBuilder().add("version", (JsonValue)Json.createObjectBuilder().add("number", version).build()).add("id", id.toString()).add("title", title).add("space", Json.createObjectBuilder().add("key", space)).build());
    }

    public CompletableFuture<Optional<? extends ConfluenceService.Model.PageSummary>> getPageByTitle(ConfluenceService.Model.ID parentPageId, String title) {
        return this.childrenPages(String.valueOf(parentPageId)).thenApply(children -> children.stream().map(Page::new).filter(page -> page.getTitle().equals(title)).findFirst());
    }

    public CompletableFuture<Optional<ConfluenceService.Model.Page>> getPage(ConfluenceService.Model.ID pageId) {
        return this.findPageById(pageId.toString()).thenApply(page -> page.map(Page::new));
    }

    public CompletableFuture<Optional<ConfluenceService.Model.Page>> getPage(String spaceKey, String pageTitle) {
        return this.findPage(spaceKey, pageTitle).thenApply(page -> page.map(Page::new));
    }

    public CompletableFuture<List<ConfluenceService.Model.PageSummary>> getDescendents(ConfluenceService.Model.ID pageId) {
        return this.descendantPages(pageId.getValue()).thenApply(descendant -> descendant.stream().map(page -> new Page((JsonObject)page)).collect(Collectors.toList()));
    }

    public CompletableFuture<ConfluenceService.Model.Page> createPage(ConfluenceService.Model.Page parentPage, String title, ConfluenceService.Storage content) {
        String spaceKey = parentPage.getSpace();
        JsonObjectBuilder input = this.jsonForCreatingContent(ContentType.page, spaceKey, parentPage.getId().getValue(), title, content);
        return this.createPage(input.build()).thenApply(page -> page.map(Page::new).get());
    }

    public CompletableFuture<ConfluenceService.Model.Page> storePage(ConfluenceService.Model.Page page, ConfluenceService.Storage content) {
        int previousVersion = page.getVersion();
        JsonObjectBuilder builder = Json.createObjectBuilder().add("version", Json.createObjectBuilder().add("number", ++previousVersion)).add("id", page.getId().getValue()).add("type", "page").add("title", page.getTitle()).add("space", Json.createObjectBuilder().add("key", page.getSpace())).add("body", Json.createObjectBuilder().add("storage", Json.createObjectBuilder().add("representation", content.rapresentation.toString()).add("value", content.value)));
        JsonObject input = builder.build();
        CompletionStage updatePage = this.updatePage(page.getId().toString(), input).thenApply(p -> p.map(Page::new).get());
        return CompletableFuture.supplyAsync(() -> RESTConfluenceService.lambda$storePage$9((CompletableFuture)updatePage));
    }

    public CompletableFuture<ConfluenceService.Model.Page> storePage(ConfluenceService.Model.Page page) {
        return CompletableFuture.completedFuture(page);
    }

    public CompletableFuture<Boolean> removePage(ConfluenceService.Model.Page parentPage, String title) {
        return this.childrenPages(parentPage.getId().toString()).thenCompose(children -> children.stream().map(page -> new Page((JsonObject)page)).filter(page -> page.getTitle().equals(title)).map(page -> this.deletePageById(page.getId().toString())).findFirst().orElse(CompletableFuture.completedFuture(false)));
    }

    public CompletableFuture<Boolean> removePage(ConfluenceService.Model.ID pageId) {
        return this.deletePageById(pageId.toString());
    }

    public CompletableFuture<Void> addLabelsByName(ConfluenceService.Model.ID id, String[] labels) {
        return CompletableFuture.runAsync(() -> this.addLabels(id.toString(), labels));
    }

    private Attachment cast(ConfluenceService.Model.Attachment attachment) {
        if (attachment == null) {
            throw new IllegalArgumentException("attachment argument is null!");
        }
        if (!(attachment instanceof Attachment)) {
            throw new IllegalArgumentException("page argument is not right type!");
        }
        return (Attachment)attachment;
    }

    public ConfluenceService.Model.Attachment newAttachment() {
        return new Attachment();
    }

    public CompletableFuture<Optional<ConfluenceService.Model.Attachment>> getAttachment(ConfluenceService.Model.ID pageId, String name, String version) {
        return this.getAttachment(pageId.toString(), name).thenApply(attachments -> attachments.stream().findFirst().map(result -> new Attachment((JsonObject)result)));
    }

    public CompletableFuture<ConfluenceService.Model.Attachment> addAttachment(ConfluenceService.Model.Page page, ConfluenceService.Model.Attachment attachment, InputStream source) {
        CompletionStage addAttchment = this.addAttachment(page.getId().toString(), this.cast(attachment), source).thenApply(attachments -> attachments.stream().findFirst().map(result -> new Attachment((JsonObject)result)).get());
        return CompletableFuture.supplyAsync(() -> RESTConfluenceService.lambda$addAttachment$19((CompletableFuture)addAttchment));
    }

    public ConfluenceService.Model.Blogpost createBlogpost(String space, String title, ConfluenceService.Storage content, int version) {
        Blogpost result = new Blogpost();
        result.setSpace(space);
        result.setTitle(title);
        result.setContent(content);
        result.setVersion(version);
        return result;
    }

    public CompletableFuture<ConfluenceService.Model.Blogpost> addBlogpost(ConfluenceService.Model.Blogpost blogpost) {
        Blogpost restBlogpost = (Blogpost)Blogpost.class.cast(blogpost);
        JsonObjectBuilder builder = this.jsonForCreatingContent(ContentType.blogpost, restBlogpost.getSpace(), restBlogpost.getTitle(), restBlogpost.getContent());
        return this.cast((CompletableFuture)this.createPage(builder.build()).thenApply(page -> page.map(Blogpost::new).orElse(null)));
    }

    public void close() throws IOException {
    }

    private static /* synthetic */ ConfluenceService.Model.Attachment lambda$addAttachment$19(CompletableFuture addAttchment) {
        return (ConfluenceService.Model.Attachment)addAttchment.join();
    }

    private static /* synthetic */ ConfluenceService.Model.Page lambda$storePage$9(CompletableFuture updatePage) {
        return (ConfluenceService.Model.Page)updatePage.join();
    }

    public static enum ContentType {
        page,
        blogpost;

    }
}

