/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WebDotXmlReader {
    private static final Logger logger = LoggerFactory.getLogger(WebDotXmlReader.class);
    private final ArrayList<String> mappings = new ArrayList();

    public WebDotXmlReader(InputStream stream) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            this.parse(factory.newDocumentBuilder().parse(stream));
        }
        catch (SAXException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void parse(Document document) {
        Element element = document.getDocumentElement();
        NodeList servlets = element.getElementsByTagName("servlet");
        String atmosphereServletName = null;
        block0: for (int i = 0; i < servlets.getLength(); ++i) {
            Node m = servlets.item(i);
            NodeList list = m.getChildNodes();
            for (int j = 0; j < list.getLength(); ++j) {
                Node n = list.item(j);
                if (n.getNodeName().equals("servlet-name")) {
                    atmosphereServletName = n.getFirstChild().getNodeValue();
                }
                if (n.getNodeName().equals("servlet-class") && n.getFirstChild().getNodeValue().equals("org.atmosphere.cpr.AtmosphereServlet")) continue block0;
            }
        }
        NodeList servletMappings = element.getElementsByTagName("servlet-mapping");
        for (int i = 0; i < servletMappings.getLength(); ++i) {
            Node m = servletMappings.item(i);
            NodeList list = m.getChildNodes();
            String urlMapping = null;
            String servletName = null;
            for (int j = 0; j < list.getLength(); ++j) {
                Node n = list.item(j);
                if (n.getNodeName().equals("servlet-name") && !(servletName = n.getFirstChild().getNodeValue()).equals(atmosphereServletName)) {
                    servletName = null;
                }
                if (n.getNodeName().equals("url-pattern")) {
                    urlMapping = n.getFirstChild().getNodeValue();
                }
                if (servletName == null || urlMapping == null) continue;
                this.mappings.add(urlMapping);
                servletName = null;
                urlMapping = null;
            }
        }
    }

    public ArrayList<String> getMappings() {
        return this.mappings;
    }
}

