/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.channel;

import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.proxy.ProxyType;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.HttpUtils;

public interface ChannelPoolPartitioning {
    public Object getPartitionKey(Uri var1, String var2, ProxyServer var3);

    public static class CompositePartitionKey {
        private final String targetHostBaseUrl;
        private final String virtualHost;
        private final String proxyHost;
        private final int proxyPort;
        private final ProxyType proxyType;

        CompositePartitionKey(String targetHostBaseUrl, String virtualHost, String proxyHost, int proxyPort, ProxyType proxyType) {
            this.targetHostBaseUrl = targetHostBaseUrl;
            this.virtualHost = virtualHost;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.proxyType = proxyType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompositePartitionKey that = (CompositePartitionKey)o;
            if (this.proxyPort != that.proxyPort) {
                return false;
            }
            if (this.targetHostBaseUrl != null ? !this.targetHostBaseUrl.equals(that.targetHostBaseUrl) : that.targetHostBaseUrl != null) {
                return false;
            }
            if (this.virtualHost != null ? !this.virtualHost.equals(that.virtualHost) : that.virtualHost != null) {
                return false;
            }
            if (this.proxyHost != null ? !this.proxyHost.equals(that.proxyHost) : that.proxyHost != null) {
                return false;
            }
            return this.proxyType == that.proxyType;
        }

        public int hashCode() {
            int result = this.targetHostBaseUrl != null ? this.targetHostBaseUrl.hashCode() : 0;
            result = 31 * result + (this.virtualHost != null ? this.virtualHost.hashCode() : 0);
            result = 31 * result + (this.proxyHost != null ? this.proxyHost.hashCode() : 0);
            result = 31 * result + this.proxyPort;
            result = 31 * result + (this.proxyType != null ? this.proxyType.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "CompositePartitionKey(targetHostBaseUrl=" + this.targetHostBaseUrl + ", virtualHost=" + this.virtualHost + ", proxyHost=" + this.proxyHost + ", proxyPort=" + this.proxyPort + ", proxyType=" + (Object)((Object)this.proxyType);
        }
    }

    public static enum PerHostChannelPoolPartitioning implements ChannelPoolPartitioning
    {
        INSTANCE;


        @Override
        public Object getPartitionKey(Uri uri, String virtualHost, ProxyServer proxyServer) {
            String targetHostBaseUrl = HttpUtils.getBaseUrl(uri);
            if (proxyServer == null) {
                if (virtualHost == null) {
                    return targetHostBaseUrl;
                }
                return new CompositePartitionKey(targetHostBaseUrl, virtualHost, null, 0, null);
            }
            return new CompositePartitionKey(targetHostBaseUrl, virtualHost, proxyServer.getHost(), uri.isSecured() && proxyServer.getProxyType() == ProxyType.HTTP ? proxyServer.getSecuredPort() : proxyServer.getPort(), proxyServer.getProxyType());
        }
    }
}

