/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.recovery;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.launcher.InterpreterClient;

public abstract class RecoveryStorage {
    protected ZeppelinConfiguration zConf;
    protected Map<String, InterpreterClient> restoredClients;

    public RecoveryStorage(ZeppelinConfiguration zConf) {
        this.zConf = zConf;
    }

    public abstract void onInterpreterClientStart(InterpreterClient var1) throws IOException;

    public abstract void onInterpreterClientStop(InterpreterClient var1) throws IOException;

    public abstract Map<String, InterpreterClient> restore() throws IOException;

    public void init() throws IOException {
        Map<String, InterpreterClient> restoredClientsInStorage = this.restore();
        this.restoredClients = new HashMap<String, InterpreterClient>();
        for (Map.Entry<String, InterpreterClient> entry : restoredClientsInStorage.entrySet()) {
            if (entry.getValue().recover()) {
                this.restoredClients.put(entry.getKey(), entry.getValue());
                continue;
            }
            this.onInterpreterClientStop(entry.getValue());
        }
    }

    public InterpreterClient getInterpreterClient(String interpreterGroupId) {
        if (this.restoredClients.containsKey(interpreterGroupId)) {
            return this.restoredClients.get(interpreterGroupId);
        }
        return null;
    }

    public void removeInterpreterClient(String interpreterGroupId) {
        this.restoredClients.remove(interpreterGroupId);
    }
}

