/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.lang.reflect.Field;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.zeppelin.annotation.Experimental;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.interpreter.DefaultInterpreterProperty;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterHookRegistry;
import org.apache.zeppelin.interpreter.InterpreterOption;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterRunner;
import org.apache.zeppelin.interpreter.InvalidHookException;
import org.apache.zeppelin.interpreter.LazyOpenInterpreter;
import org.apache.zeppelin.interpreter.WrappedInterpreter;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.resource.Resource;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Interpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(Interpreter.class);
    private InterpreterGroup interpreterGroup;
    private URL[] classloaderUrls;
    protected Properties properties;
    protected String userName;

    @ZeppelinApi
    public abstract void open() throws InterpreterException;

    @ZeppelinApi
    public abstract void close() throws InterpreterException;

    @ZeppelinApi
    public InterpreterResult executePrecode(InterpreterContext interpreterContext) throws InterpreterException {
        String simpleName = this.getClass().getSimpleName();
        String precode = this.getProperty(String.format("zeppelin.%s.precode", simpleName));
        if (StringUtils.isNotBlank((CharSequence)precode)) {
            return this.interpret(precode, interpreterContext);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String interpolate(String cmd, ResourcePool resourcePool) {
        Matcher m;
        Pattern zVariablePattern = Pattern.compile("([^{}]*)([{]+[^{}]*[}]+)(.*)", 32);
        StringBuilder sb = new StringBuilder();
        String st = cmd;
        while ((m = zVariablePattern.matcher(st)).matches()) {
            sb.append(m.group(1));
            String varPat = m.group(2);
            if (varPat.matches("[{][^{}]+[}]")) {
                Object variableValue;
                Resource resource = resourcePool.get(varPat.substring(1, varPat.length() - 1));
                Object object = variableValue = resource == null ? null : resource.get();
                if (variableValue == null) return cmd;
                sb.append(variableValue);
            } else {
                if (!varPat.matches("[{]{2}[^{}]+[}]{2}")) return cmd;
                sb.append("{").append(varPat.substring(2, varPat.length() - 2)).append("}");
            }
            st = m.group(3);
        }
        sb.append(st);
        return sb.toString();
    }

    @ZeppelinApi
    public abstract InterpreterResult interpret(String var1, InterpreterContext var2) throws InterpreterException;

    @ZeppelinApi
    public abstract void cancel(InterpreterContext var1) throws InterpreterException;

    @ZeppelinApi
    public abstract FormType getFormType() throws InterpreterException;

    @ZeppelinApi
    public abstract int getProgress(InterpreterContext var1) throws InterpreterException;

    @ZeppelinApi
    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) throws InterpreterException {
        return Collections.emptyList();
    }

    @ZeppelinApi
    public Scheduler getScheduler() {
        return SchedulerFactory.singleton().createOrGetFIFOScheduler("interpreter_" + this.hashCode());
    }

    @ZeppelinApi
    public Interpreter(Properties properties) {
        this.properties = properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @ZeppelinApi
    public Properties getProperties() {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this.properties);
        this.replaceContextParameters(p);
        return p;
    }

    @ZeppelinApi
    public String getProperty(String key) {
        LOGGER.debug("key: {}, value: {}", (Object)key, (Object)this.getProperties().getProperty(key));
        return this.getProperties().getProperty(key);
    }

    @ZeppelinApi
    public String getProperty(String key, String defaultValue) {
        LOGGER.debug("key: {}, value: {}", (Object)key, (Object)this.getProperties().getProperty(key, defaultValue));
        return this.getProperties().getProperty(key, defaultValue);
    }

    @ZeppelinApi
    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setInterpreterGroup(InterpreterGroup interpreterGroup) {
        this.interpreterGroup = interpreterGroup;
    }

    @ZeppelinApi
    public InterpreterGroup getInterpreterGroup() {
        return this.interpreterGroup;
    }

    public URL[] getClassloaderUrls() {
        return this.classloaderUrls;
    }

    public void setClassloaderUrls(URL[] classloaderUrls) {
        this.classloaderUrls = classloaderUrls;
    }

    @Experimental
    public void registerHook(String noteId, String event, String cmd) throws InvalidHookException {
        InterpreterHookRegistry hooks = this.interpreterGroup.getInterpreterHookRegistry();
        String className = this.getClassName();
        hooks.register(noteId, className, event, cmd);
    }

    @Experimental
    public void registerHook(String event, String cmd) throws InvalidHookException {
        this.registerHook(null, event, cmd);
    }

    @Experimental
    public String getHook(String noteId, String event) {
        InterpreterHookRegistry hooks = this.interpreterGroup.getInterpreterHookRegistry();
        String className = this.getClassName();
        return hooks.get(noteId, className, event);
    }

    @Experimental
    public String getHook(String event) {
        return this.getHook(null, event);
    }

    @Experimental
    public void unregisterHook(String noteId, String event) {
        InterpreterHookRegistry hooks = this.interpreterGroup.getInterpreterHookRegistry();
        String className = this.getClassName();
        hooks.unregister(noteId, className, event);
    }

    @Experimental
    public void unregisterHook(String event) {
        this.unregisterHook(null, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ZeppelinApi
    public <T> T getInterpreterInTheSameSessionByClassName(Class<T> interpreterClass, boolean open2) throws InterpreterException {
        InterpreterGroup interpreterGroup = this.interpreterGroup;
        synchronized (interpreterGroup) {
            for (List<Interpreter> interpreters : this.interpreterGroup.values()) {
                boolean belongsToSameNoteGroup = false;
                Interpreter interpreterFound = null;
                for (Interpreter intp : interpreters) {
                    if (intp.getClassName().equals(interpreterClass.getName())) {
                        interpreterFound = intp;
                    }
                    Interpreter p = intp;
                    while (p instanceof WrappedInterpreter) {
                        p = ((WrappedInterpreter)((Object)p)).getInnerInterpreter();
                    }
                    if (this != p) continue;
                    belongsToSameNoteGroup = true;
                }
                if (!belongsToSameNoteGroup || interpreterFound == null) continue;
                LazyOpenInterpreter lazy = null;
                Interpreter innerInterpreter = null;
                while (interpreterFound instanceof WrappedInterpreter) {
                    if (interpreterFound instanceof LazyOpenInterpreter) {
                        lazy = (LazyOpenInterpreter)interpreterFound;
                    }
                    interpreterFound = ((WrappedInterpreter)((Object)interpreterFound)).getInnerInterpreter();
                }
                innerInterpreter = interpreterFound;
                if (lazy != null && open2) {
                    lazy.open();
                }
                return (T)innerInterpreter;
            }
        }
        return null;
    }

    public <T> T getInterpreterInTheSameSessionByClassName(Class<T> interpreterClass) throws InterpreterException {
        return this.getInterpreterInTheSameSessionByClassName(interpreterClass, true);
    }

    private void replaceContextParameters(Properties properties) {
        InterpreterContext interpreterContext = InterpreterContext.get();
        if (interpreterContext != null) {
            String markerTemplate = "#\\{%s\\}";
            List<String> skipFields = Arrays.asList("paragraphTitle", "paragraphId", "paragraphText");
            List<Class> typesToProcess = Arrays.asList(String.class, Double.class, Float.class, Short.class, Byte.class, Character.class, Boolean.class, Integer.class, Long.class);
            for (String key : properties.stringPropertyNames()) {
                String p = properties.getProperty(key);
                if (!StringUtils.isNotEmpty((CharSequence)p)) continue;
                for (Field field : InterpreterContext.class.getDeclaredFields()) {
                    Class<?> clazz = field.getType();
                    if (skipFields.contains(field.getName()) || !typesToProcess.contains(clazz) && !clazz.isPrimitive()) continue;
                    Object value = null;
                    try {
                        value = FieldUtils.readField((Field)field, (Object)interpreterContext, (boolean)true);
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot read value of field {}", (Object)field.getName());
                    }
                    p = p.replaceAll(String.format(markerTemplate, field.getName()), value != null ? value.toString() : "");
                }
                p = p.replaceAll(String.format(markerTemplate, "user"), StringUtils.defaultString((String)this.userName, (String)""));
                properties.setProperty(key, p);
            }
        }
    }

    public static enum SchedulingMode {
        FIFO,
        PARALLEL;

    }

    public static class RegisteredInterpreter {
        private String group;
        private String name;
        private String className;
        private boolean defaultInterpreter;
        private Map<String, DefaultInterpreterProperty> properties;
        private Map<String, Object> editor;
        private Map<String, Object> config;
        private String path;
        private InterpreterOption option;
        private InterpreterRunner runner;

        public RegisteredInterpreter(String name, String group, String className, Map<String, DefaultInterpreterProperty> properties) {
            this(name, group, className, false, properties);
        }

        public RegisteredInterpreter(String name, String group, String className, boolean defaultInterpreter, Map<String, DefaultInterpreterProperty> properties) {
            this.name = name;
            this.group = group;
            this.className = className;
            this.defaultInterpreter = defaultInterpreter;
            this.properties = properties;
            this.editor = new HashMap<String, Object>();
        }

        public String getName() {
            return this.name;
        }

        public String getGroup() {
            return this.group;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean isDefaultInterpreter() {
            return this.defaultInterpreter;
        }

        public void setDefaultInterpreter(boolean defaultInterpreter) {
            this.defaultInterpreter = defaultInterpreter;
        }

        public Map<String, DefaultInterpreterProperty> getProperties() {
            return this.properties;
        }

        public Map<String, Object> getEditor() {
            return this.editor;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public String getInterpreterKey() {
            return this.getGroup() + "." + this.getName();
        }

        public InterpreterOption getOption() {
            return this.option;
        }

        public InterpreterRunner getRunner() {
            return this.runner;
        }

        public Map<String, Object> getConfig() {
            return this.config;
        }

        public void setConfig(Map<String, Object> config) {
            this.config = config;
        }
    }

    public static enum FormType {
        NATIVE,
        SIMPLE,
        NONE;

    }
}

