/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.render.Renderer;

public abstract class AbstractRendererConfigurator {
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$fop$render$AbstractRendererConfigurator == null ? (class$org$apache$fop$render$AbstractRendererConfigurator = AbstractRendererConfigurator.class$("org.apache.fop.render.AbstractRendererConfigurator")) : class$org$apache$fop$render$AbstractRendererConfigurator));
    protected FOUserAgent userAgent = null;
    static /* synthetic */ Class class$org$apache$fop$render$AbstractRendererConfigurator;

    public AbstractRendererConfigurator(FOUserAgent userAgent) {
        this.userAgent = userAgent;
    }

    protected Configuration getRendererConfig(Renderer renderer) {
        Configuration cfg = this.userAgent.getFactory().getUserConfig();
        if (cfg == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"userconfig is null");
            }
            return null;
        }
        String mimeType = renderer.getMimeType();
        if (mimeType == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"renderer mimeType is null");
            }
            return null;
        }
        Configuration userRendererConfig = null;
        Configuration[] cfgs = cfg.getChild("renderers").getChildren("renderer");
        for (int i = 0; i < cfgs.length; ++i) {
            Configuration child = cfgs[i];
            try {
                if (!child.getAttribute("mime").equals(mimeType)) continue;
                userRendererConfig = child;
                break;
            }
            catch (ConfigurationException e) {
                // empty catch block
            }
        }
        log.debug((Object)((userRendererConfig == null ? "No u" : "U") + "ser configuration found for MIME type " + mimeType));
        return userRendererConfig;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

