/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.locator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axiom.locator.Feature;
import org.apache.axiom.locator.Implementation;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMMetaFactoryLocator;

class PriorityBasedOMMetaFactoryLocator
implements OMMetaFactoryLocator {
    private final Map factories = new HashMap();

    PriorityBasedOMMetaFactoryLocator() {
    }

    void loadImplementations(List implementations) {
        HashMap<String, Integer> priorityMap = new HashMap<String, Integer>();
        this.factories.clear();
        for (Implementation implementation : implementations) {
            Feature[] features = implementation.getFeatures();
            for (int i = 0; i < features.length; ++i) {
                Feature feature = features[i];
                String name = feature.getName();
                int priority = feature.getPriority();
                Integer highestPriority = (Integer)priorityMap.get(name);
                if (highestPriority != null && priority <= highestPriority) continue;
                priorityMap.put(name, priority);
                this.factories.put(name, implementation.getMetaFactory());
            }
        }
    }

    public OMMetaFactory getOMMetaFactory(String feature) {
        return (OMMetaFactory)this.factories.get(feature);
    }
}

