/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.models;

import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.model.AbstractPropertyModel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IWrapModel;
import org.apache.wicket.security.WaspApplication;
import org.apache.wicket.security.WaspSession;
import org.apache.wicket.security.actions.ActionFactory;
import org.apache.wicket.security.actions.WaspAction;
import org.apache.wicket.security.models.ISecureModel;
import org.apache.wicket.security.strategies.WaspAuthorizationStrategy;

public class SecureCompoundPropertyModel
extends CompoundPropertyModel
implements ISecureModel {
    private static final long serialVersionUID = 1L;

    public SecureCompoundPropertyModel(Object object) {
        super(object);
    }

    protected final WaspAuthorizationStrategy getStrategy() {
        return (WaspAuthorizationStrategy)((WaspSession)Session.get()).getAuthorizationStrategy();
    }

    protected final ActionFactory getActionFactory() {
        return ((WaspApplication)Application.get()).getActionFactory();
    }

    public IWrapModel wrapOnInheritance(Component component) {
        return new AttachedSecureCompoundPropertyModel(component);
    }

    public boolean isAuthenticated(Component component) {
        return this.getStrategy().isModelAuthenticated(this, component);
    }

    public boolean isAuthorized(Component component, WaspAction action) {
        return this.getStrategy().isModelAuthorized(this, component, action);
    }

    public String toString() {
        return this.getClass().getName();
    }

    protected class AttachedSecureCompoundPropertyModel
    extends AbstractPropertyModel
    implements IWrapModel,
    ISecureModel {
        private static final long serialVersionUID = 1L;
        private final Component owner;

        public AttachedSecureCompoundPropertyModel(Component owner) {
            super((Object)SecureCompoundPropertyModel.this);
            this.owner = owner;
        }

        protected final Component getOwner() {
            return this.owner;
        }

        protected String propertyExpression() {
            return SecureCompoundPropertyModel.this.propertyExpression(this.owner);
        }

        public IModel getWrappedModel() {
            return SecureCompoundPropertyModel.this;
        }

        public void detach() {
            super.detach();
            SecureCompoundPropertyModel.this.detach();
        }

        public boolean isAuthenticated(Component component) {
            return SecureCompoundPropertyModel.this.isAuthenticated(component != null ? component : this.owner);
        }

        public boolean isAuthorized(Component component, WaspAction action) {
            return SecureCompoundPropertyModel.this.isAuthorized(component != null ? component : this.owner, action);
        }

        public String toString() {
            return SecureCompoundPropertyModel.this.toString() + ":" + (this.getOwner() != null ? this.getOwner().getId() : "null");
        }
    }
}

