/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.checks;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.security.actions.WaspAction;
import org.apache.wicket.security.checks.ComponentSecurityCheck;
import org.apache.wicket.security.components.SecureComponentHelper;
import org.apache.wicket.security.models.ISecureModel;

public class ContainerSecurityCheck
extends ComponentSecurityCheck {
    private static final long serialVersionUID = 1L;
    private final boolean enableAuthentication;

    public ContainerSecurityCheck(MarkupContainer component) {
        super((Component)component);
        this.enableAuthentication = false;
    }

    public ContainerSecurityCheck(MarkupContainer component, boolean checkSecureModelIfExists) {
        this(component, checkSecureModelIfExists, false);
    }

    public ContainerSecurityCheck(MarkupContainer component, boolean checkSecureModelIfExists, boolean enableAuthenticationCheck) {
        super((Component)component, checkSecureModelIfExists);
        this.enableAuthentication = enableAuthenticationCheck;
    }

    public boolean isActionAuthorized(WaspAction action) {
        if (this.enableAuthentication && !this.isAuthenticated()) {
            throw new RestartResponseAtInterceptPageException(this.getLoginPage());
        }
        boolean result = this.getStrategy().isClassAuthorized(this.getComponent().getClass(), action);
        if (result && this.checkSecureModel() && SecureComponentHelper.hasSecureModel(this.getComponent())) {
            return ((ISecureModel)this.getComponent().getModel()).isAuthorized(this.getComponent(), action);
        }
        return result;
    }
}

