/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.PDF;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.pdf.PDFParserConfig;
import org.apache.tika.parser.pdf.updates.StartXRefOffset;
import org.apache.tika.parser.pdf.updates.StartXRefScanner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PDFIncrementalUpdatesTest
extends TikaTest {
    @Test
    public void testIncrementalUpdateInfoExtracted() throws Exception {
        PDFParserConfig pdfParserConfig = new PDFParserConfig();
        pdfParserConfig.setExtractIncrementalUpdateInfo(true);
        ParseContext parseContext = new ParseContext();
        parseContext.set(PDFParserConfig.class, (Object)pdfParserConfig);
        List metadataList = this.getRecursiveMetadata("testPDF_incrementalUpdates.pdf", parseContext);
        Assertions.assertEquals((int)2, (Integer)((Metadata)metadataList.get(0)).getInt(TikaCoreProperties.VERSION_COUNT));
        Assertions.assertEquals((int)2, (Integer)((Metadata)metadataList.get(0)).getInt(PDF.PDF_INCREMENTAL_UPDATE_COUNT));
        long[] expected = new long[]{16242L, 41226L, 64872L};
        long[] eofs = ((Metadata)metadataList.get(0)).getLongValues(PDF.EOF_OFFSETS);
        Assertions.assertEquals((int)3, (int)eofs.length);
        Assertions.assertArrayEquals((long[])expected, (long[])eofs);
    }

    @Test
    public void testTooLongLong() throws Exception {
        String s = "blah blah startxref 01234567890123456789\n%%EOF blah";
        Assertions.assertEquals((int)0, (int)this.getOffsets(s).size());
    }

    @Test
    public void testMissingEOF() throws Exception {
        String s = "blah blah startxref 123456\nblah";
        Assertions.assertEquals((int)1, (int)this.getOffsets(s).size());
    }

    @Test
    public void testBrokenEOF() throws Exception {
        String s = "blah blah startxref 123456\n%%EO\nstartxref 234567\n%%EOF\nblah";
        Assertions.assertEquals((int)2, (int)this.getOffsets(s).size());
    }

    @Test
    public void testNoSpace1() throws Exception {
        String s = "blah blah startxref123456\n%%EOF\nblah";
        Assertions.assertEquals((int)1, (int)this.getOffsets(s).size());
    }

    @Test
    public void testNoSpace2() throws Exception {
        String s = "blah blah startxref 123456%%EOF\nblah";
        Assertions.assertEquals((int)1, (int)this.getOffsets(s).size());
    }

    @Test
    public void testNoStartXref() throws Exception {
        String s = "blah blah startxref not a startxre";
        Assertions.assertEquals((int)0, (int)this.getOffsets(s).size());
    }

    @Test
    public void testLongAtEOF() throws Exception {
        String s = "blah blah startxref 100";
        Assertions.assertEquals((int)0, (int)this.getOffsets(s).size());
    }

    @Test
    public void testCommentInsteadOfEOF() throws Exception {
        String s = "blah blah startxref 123456\n%%regular comment\n%%EOF";
        Assertions.assertEquals((int)1, (int)this.getOffsets(s).size());
    }

    @Test
    public void testStartxStartXref() throws Exception {
        String s = "blah blah startxstartxref 123456\n%%EOFblah";
        Assertions.assertEquals((int)1, (int)this.getOffsets(s).size());
    }

    private List<StartXRefOffset> getOffsets(String s) throws IOException {
        try (RandomAccessReadBuffer randomAccessRead = new RandomAccessReadBuffer(s.getBytes(StandardCharsets.US_ASCII));){
            StartXRefScanner scanner = new StartXRefScanner((RandomAccessRead)randomAccessRead);
            List list = scanner.scan();
            return list;
        }
    }

    @Test
    public void testIncrementalUpdateParsing() throws Exception {
        PDFParserConfig pdfParserConfig = new PDFParserConfig();
        pdfParserConfig.setParseIncrementalUpdates(true);
        ParseContext parseContext = new ParseContext();
        parseContext.set(PDFParserConfig.class, (Object)pdfParserConfig);
        List metadataList = this.getRecursiveMetadata("testPDF_incrementalUpdates.pdf", parseContext);
        Assertions.assertEquals((int)3, (int)metadataList.size());
        Assertions.assertEquals((int)2, (Integer)((Metadata)metadataList.get(0)).getInt(PDF.PDF_INCREMENTAL_UPDATE_COUNT));
        Assertions.assertEquals((int)2, (Integer)((Metadata)metadataList.get(0)).getInt(TikaCoreProperties.VERSION_COUNT));
        long[] expected = new long[]{16242L, 41226L, 64872L};
        long[] eofs = ((Metadata)metadataList.get(0)).getLongValues(PDF.EOF_OFFSETS);
        Assertions.assertEquals((int)3, (int)eofs.length);
        Assertions.assertArrayEquals((long[])expected, (long[])eofs);
        PDFIncrementalUpdatesTest.assertContains((String)"Testing Incremental", (String)((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_CONTENT));
        PDFIncrementalUpdatesTest.assertNotContained((String)"Testing Incremental", (String)((Metadata)metadataList.get(1)).get(TikaCoreProperties.TIKA_CONTENT));
        PDFIncrementalUpdatesTest.assertContains((String)"Testing Incremental", (String)((Metadata)metadataList.get(2)).get(TikaCoreProperties.TIKA_CONTENT));
        Assertions.assertNull((Object)((Metadata)metadataList.get(0)).get(PDF.INCREMENTAL_UPDATE_NUMBER));
        Assertions.assertNull((Object)((Metadata)metadataList.get(0)).get(PDF.INCREMENTAL_UPDATE_NUMBER));
        Assertions.assertEquals((int)0, (Integer)((Metadata)metadataList.get(1)).getInt(PDF.INCREMENTAL_UPDATE_NUMBER));
        Assertions.assertEquals((int)1, (Integer)((Metadata)metadataList.get(2)).getInt(PDF.INCREMENTAL_UPDATE_NUMBER));
        Assertions.assertEquals((Object)"/version-number-0", (Object)((Metadata)metadataList.get(1)).get(TikaCoreProperties.EMBEDDED_RESOURCE_PATH));
        Assertions.assertEquals((Object)"/version-number-1", (Object)((Metadata)metadataList.get(2)).get(TikaCoreProperties.EMBEDDED_RESOURCE_PATH));
        Assertions.assertNull((Object)((Metadata)metadataList.get(1)).get("resourceName"));
        Assertions.assertNull((Object)((Metadata)metadataList.get(2)).get("resourceName"));
        Assertions.assertEquals((Object)TikaCoreProperties.EmbeddedResourceType.VERSION.toString(), (Object)((Metadata)metadataList.get(1)).get(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE));
        Assertions.assertEquals((Object)TikaCoreProperties.EmbeddedResourceType.VERSION.toString(), (Object)((Metadata)metadataList.get(2)).get(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE));
    }
}

