/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.extractor.microsoft;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.Ole10Native;
import org.apache.poi.poifs.filesystem.Ole10NativeException;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.tika.extractor.EmbeddedStreamTranslator;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSEmbeddedStreamTranslator
implements EmbeddedStreamTranslator {
    private static final Logger LOG = LoggerFactory.getLogger(MSEmbeddedStreamTranslator.class);

    public boolean shouldTranslate(InputStream inputStream, Metadata metadata) throws IOException {
        TikaInputStream tin;
        String contentType = metadata.get("Content-Type");
        if ("application/vnd.openxmlformats-officedocument.oleObject".equals(contentType)) {
            return true;
        }
        return inputStream instanceof TikaInputStream && (tin = (TikaInputStream)inputStream).getOpenContainer() != null && tin.getOpenContainer() instanceof DirectoryEntry;
    }

    public InputStream translate(InputStream inputStream, Metadata metadata) throws IOException {
        TikaInputStream tin;
        String contentType = metadata.get("Content-Type");
        if ("application/vnd.openxmlformats-officedocument.oleObject".equals(contentType)) {
            UnsynchronizedByteArrayOutputStream bos = UnsynchronizedByteArrayOutputStream.builder().get();
            IOUtils.copy((InputStream)inputStream, (OutputStream)bos);
            POIFSFileSystem poifs = new POIFSFileSystem(bos.toInputStream());
            OfficeParser.POIFSDocumentType type = OfficeParser.POIFSDocumentType.detectType(poifs);
            Object name = metadata.get("resourceName");
            byte[] data = bos.toByteArray();
            if (type == OfficeParser.POIFSDocumentType.OLE10_NATIVE) {
                try {
                    Ole10Native ole = Ole10Native.createFromEmbeddedOleObject((POIFSFileSystem)poifs);
                    if (ole.getDataSize() > 0) {
                        name = ole.getLabel();
                        data = ole.getDataBuffer();
                    }
                }
                catch (Ole10NativeException ex) {
                    LOG.warn("Skipping invalid part", (Throwable)ex);
                }
            } else {
                name = (String)name + "." + type.getExtension();
            }
            metadata.set("resourceName", (String)name);
            return UnsynchronizedByteArrayInputStream.builder().setByteArray(data).get();
        }
        if (inputStream instanceof TikaInputStream && (tin = (TikaInputStream)inputStream).getOpenContainer() != null && tin.getOpenContainer() instanceof DirectoryEntry) {
            POIFSFileSystem fs = new POIFSFileSystem();
            this.copy((DirectoryEntry)tin.getOpenContainer(), (DirectoryEntry)fs.getRoot());
            try (UnsynchronizedByteArrayOutputStream bos2 = UnsynchronizedByteArrayOutputStream.builder().get();){
                fs.writeFilesystem((OutputStream)bos2);
                InputStream inputStream2 = bos2.toInputStream();
                return inputStream2;
            }
        }
        return inputStream;
    }

    protected void copy(DirectoryEntry sourceDir, DirectoryEntry destDir) throws IOException {
        for (Entry entry : sourceDir) {
            if (entry instanceof DirectoryEntry) {
                DirectoryEntry newDir = destDir.createDirectory(entry.getName());
                this.copy((DirectoryEntry)entry, newDir);
                continue;
            }
            try (DocumentInputStream contents = new DocumentInputStream((DocumentEntry)entry);){
                destDir.createDocument(entry.getName(), (InputStream)contents);
            }
        }
    }
}

