/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.cli.server.helper;

import java.io.IOException;
import org.apache.sshd.cli.server.helper.ServerEventListenerHelper;
import org.apache.sshd.common.forward.PortForwardingEventListener;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class ServerPortForwardingEventListener
extends ServerEventListenerHelper
implements PortForwardingEventListener {
    public ServerPortForwardingEventListener(Appendable stdout, Appendable stderr) {
        super("PORT-FWD", stdout, stderr);
    }

    public void establishedExplicitTunnel(Session session, SshdSocketAddress local, SshdSocketAddress remote, boolean localForwarding, SshdSocketAddress boundAddress, Throwable reason) throws IOException {
        if (reason == null) {
            this.outputDebugMessage("Estalibshed explicit tunnel for session=%s: local=%s, remote=%s, bound=%s, localForward=%s", session, local, remote, boundAddress, localForwarding);
        } else {
            this.outputErrorMessage("Failed (%s) to establish explicit tunnel for session=%s, local=%s, remote=%s, bound=%s, localForward=%s: %s", reason.getClass().getSimpleName(), session, local, remote, boundAddress, localForwarding, reason.getMessage());
        }
    }

    public void tornDownExplicitTunnel(Session session, SshdSocketAddress address, boolean localForwarding, SshdSocketAddress remoteAddress, Throwable reason) throws IOException {
        if (reason == null) {
            this.outputDebugMessage("Torn down explicit tunnel for session=%s: address=%s, remote=%s, localForward=%s", session, address, remoteAddress, localForwarding);
        } else {
            this.outputErrorMessage("Failed (%s) to tear down explicit tunnel for session=%s, address=%s, remote=%s, localForward=%s: %s", reason.getClass().getSimpleName(), session, address, remoteAddress, localForwarding, reason.getMessage());
        }
    }

    public void establishedDynamicTunnel(Session session, SshdSocketAddress local, SshdSocketAddress boundAddress, Throwable reason) throws IOException {
        if (reason == null) {
            this.outputDebugMessage("Estalibshed dynamic tunnel for session=%s: local=%s,  bound=%s", session, local, boundAddress);
        } else {
            this.outputErrorMessage("Failed (%s) to establish dynamic tunnel for session=%s, bound=%s: %s", reason.getClass().getSimpleName(), session, local, boundAddress, reason.getMessage());
        }
    }

    public void tornDownDynamicTunnel(Session session, SshdSocketAddress address, Throwable reason) throws IOException {
        if (reason == null) {
            this.outputDebugMessage("Tornd down dynamic tunnel for session=%s: address=%s", session);
        } else {
            this.outputErrorMessage("Failed (%s) to tear down dynamic tunnel for session=%s, address=%s: %s", reason.getClass().getSimpleName(), session, address, reason.getMessage());
        }
    }
}

