/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.cli.client;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Level;
import org.apache.sshd.cli.CliSupport;
import org.apache.sshd.cli.client.SshClientCliSupport;
import org.apache.sshd.client.scp.ScpClient;
import org.apache.sshd.client.scp.ScpClientCreator;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.scp.ScpLocation;
import org.apache.sshd.common.scp.ScpTransferEventListener;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.NoCloseInputStream;
import org.apache.sshd.common.util.threads.ThreadUtils;

public class ScpCommandMain
extends SshClientCliSupport {
    public static final String SCP_PORT_OPTION = "-P";

    public static String[] normalizeCommandArguments(PrintStream stdout, PrintStream stderr, String ... args) {
        int numArgs = GenericUtils.length((Object[])args);
        if (numArgs <= 0) {
            return args;
        }
        ArrayList<String> effective = new ArrayList<String>(numArgs);
        boolean error = false;
        for (int index = 0; index < numArgs && !error; ++index) {
            String argName = args[index];
            if (ScpCommandMain.isArgumentedOption(SCP_PORT_OPTION, argName) || "-creator".equals(argName)) {
                if (++index >= numArgs) {
                    error = ScpCommandMain.showError(stderr, "option requires an argument: " + argName);
                    break;
                }
                effective.add(argName);
                effective.add(args[index]);
                continue;
            }
            if ("-r".equals(argName) || "-p".equals(argName) || "-q".equals(argName) || "-C".equals(argName) || "-v".equals(argName) || "-vv".equals(argName) || "-vvv".equals(argName)) {
                effective.add(argName);
                continue;
            }
            if (argName.charAt(0) == '-') {
                error = ScpCommandMain.showError(stderr, "Unknown option: " + argName);
                break;
            }
            if (++index >= numArgs) {
                error = ScpCommandMain.showError(stderr, "Not enough arguments");
                break;
            }
            ScpLocation source = new ScpLocation(argName);
            ScpLocation target = new ScpLocation(args[index]);
            if (index < numArgs - 1) {
                error = ScpCommandMain.showError(stderr, "Unexpected extra arguments");
                break;
            }
            if (source.isLocal() == target.isLocal()) {
                error = ScpCommandMain.showError(stderr, "Both targets are either remote or local");
                break;
            }
            ScpLocation remote = source.isLocal() ? target : source;
            effective.add(remote.resolveUsername() + "@" + remote.getHost());
            effective.add(source.toString());
            effective.add(target.toString());
            break;
        }
        if (error) {
            return null;
        }
        return effective.toArray(new String[effective.size()]);
    }

    public static ScpClientCreator resolveScpClientCreator(PrintStream stderr, String ... args) {
        String className = null;
        int numArgs = GenericUtils.length((Object[])args);
        for (int index = 0; index < numArgs; ++index) {
            String argName = args[index];
            if (!"-creator".equals(argName)) continue;
            if (++index >= numArgs) {
                ScpCommandMain.showError(stderr, "option requires an argument: " + argName);
                return null;
            }
            className = args[index];
        }
        if (GenericUtils.isEmpty(className)) {
            className = System.getProperty(ScpClientCreator.class.getName());
        }
        if (GenericUtils.isEmpty(className)) {
            return ScpClientCreator.instance();
        }
        try {
            ClassLoader cl = ThreadUtils.resolveDefaultClassLoader(ScpClientCreator.class);
            Class<?> clazz = cl.loadClass(className);
            return (ScpClientCreator)ScpClientCreator.class.cast(clazz.newInstance());
        }
        catch (Exception e) {
            stderr.append("WARNING: Failed (").append(e.getClass().getSimpleName()).append(')').append(" to instantiate ").append(className).append(": ").println(e.getMessage());
            stderr.flush();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        final PrintStream stdout = System.out;
        final PrintStream stderr = System.err;
        OutputStream logStream = stdout;
        try (BufferedReader stdin = new BufferedReader(new InputStreamReader((InputStream)new NoCloseInputStream(System.in), Charset.defaultCharset()));){
            ClientSession session;
            args = ScpCommandMain.normalizeCommandArguments(stdout, stderr, args);
            Level level = Level.SEVERE;
            int numArgs = GenericUtils.length((Object[])args);
            if (numArgs >= 2) {
                level = CliSupport.resolveLoggingVerbosity(args, numArgs - 2);
                logStream = ScpCommandMain.resolveLoggingTargetStream(stdout, stderr, args, numArgs - 2);
                if (logStream != null) {
                    ScpCommandMain.setupLogging(level, stdout, stderr, logStream);
                }
            }
            ScpClientCreator creator = ScpCommandMain.resolveScpClientCreator(stderr, args);
            ClientSession clientSession = session = logStream == null || creator == null || GenericUtils.isEmpty((Object[])args) ? null : ScpCommandMain.setupClientSession(SCP_PORT_OPTION, stdin, level, stdout, stderr, args);
            if (session == null) {
                stderr.println("usage: scp [-P port] [-i identity] [-io nio2|mina|netty] [-v[v][v]] [-E logoutput] [-r] [-p] [-q] [-o option=value] [-o creator=class name] [-c cipherlist] [-m maclist] [-w password] [-C] <source> <target>");
                stderr.println();
                stderr.println("Where <source> or <target> are either 'user@host:file' or a local file path");
                stderr.println("NOTE: exactly ONE of the source or target must be remote and the other one local");
                System.exit(-1);
                return;
            }
            try {
                EnumSet<ScpClient.Option> options = EnumSet.noneOf(ScpClient.Option.class);
                boolean quiet = false;
                for (int index = 0; index < numArgs; ++index) {
                    String argName = args[index];
                    if ("-r".equals(argName)) {
                        options.add(ScpClient.Option.Recursive);
                        continue;
                    }
                    if ("-p".equals(argName)) {
                        options.add(ScpClient.Option.PreserveAttributes);
                        continue;
                    }
                    if (!"-q".equals(argName)) continue;
                    quiet = true;
                }
                if (!quiet) {
                    creator.setScpTransferEventListener(new ScpTransferEventListener(){

                        public void startFolderEvent(Session session, ScpTransferEventListener.FileOperation op, Path file, Set<PosixFilePermission> perms) {
                            this.logEvent("startFolderEvent", session, op, file, -1L, perms, null);
                        }

                        public void endFolderEvent(Session session, ScpTransferEventListener.FileOperation op, Path file, Set<PosixFilePermission> perms, Throwable thrown) {
                            this.logEvent("endFolderEvent", session, op, file, -1L, perms, thrown);
                        }

                        public void startFileEvent(Session session, ScpTransferEventListener.FileOperation op, Path file, long length, Set<PosixFilePermission> perms) {
                            this.logEvent("startFileEvent", session, op, file, length, perms, null);
                        }

                        public void endFileEvent(Session session, ScpTransferEventListener.FileOperation op, Path file, long length, Set<PosixFilePermission> perms, Throwable thrown) {
                            this.logEvent("endFileEvent", session, op, file, length, perms, thrown);
                        }

                        private void logEvent(String name, Session session, ScpTransferEventListener.FileOperation op, Path file, long length, Collection<PosixFilePermission> perms, Throwable thrown) {
                            PrintStream ps = thrown == null ? stdout : stderr;
                            ps.append("    ").append(name).append('[').append(session.toString()).append(']').append('[').append(op.name()).append(']').append(' ').append(file.toString());
                            if (length > 0L) {
                                ps.append(' ').append("length=").append(Long.toString(length));
                            }
                            ps.append(' ').append(String.valueOf(perms));
                            if (thrown != null) {
                                ps.append(" - ").append(thrown.getClass().getSimpleName()).append(": ").append(thrown.getMessage());
                            }
                            ps.println();
                        }
                    });
                }
                ScpClient client = creator.createScpClient(session);
                ScpLocation source = new ScpLocation(args[numArgs - 2]);
                ScpLocation target = new ScpLocation(args[numArgs - 1]);
                if (source.isLocal()) {
                    client.upload(source.getPath(), target.getPath(), options);
                } else {
                    client.download(source.getPath(), target.getPath(), options);
                }
            }
            finally {
                session.close();
            }
        }
        finally {
            if (logStream != stdout && logStream != stderr) {
                logStream.close();
            }
        }
    }
}

