/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import breeze.linalg.SparseVector;
import breeze.storage.Zero;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Arrays;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.types.SQLUserDefinedType;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonAssoc$;
import org.json4s.JsonDSL$;
import org.json4s.JsonListAssoc$;
import org.json4s.jackson.JsonMethods$;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@SQLUserDefinedType(udt=VectorUDT.class)
@ScalaSignature(bytes="\u0006\u0005\u0005%h\u0001\u0002\u0010 \u0001)B\u0001\"\u000e\u0001\u0003\u0006\u0004%\tE\u000e\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005o!AQ\t\u0001BC\u0002\u0013\u0005a\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003H\u0011!i\u0005A!b\u0001\n\u0003q\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u000bY\u0003A\u0011A,\t\u000b\u0001\u0004A\u0011I1\t\u000b5\u0004A\u0011\t(\t\u000b=\u0004A\u0011\t9\t\rQ\u0004A\u0011I\u0012v\u0011\u0015a\b\u0001\"\u0011~\u0011\u001d\t\t\u0001\u0001C!\u0003\u0007Aq!!\u0006\u0001\t\u0003\n9\u0002\u0003\u0004\u0002\u001a\u0001!\tE\u000e\u0005\u0007\u0003C\u0001A\u0011\t\u001c\t\u0011\u0005\u0015\u0002\u0001\"\u0011 \u0003OAa!!\f\u0001\t\u00032\u0004\u0002CA\u001b\u0001\u0011\u00051%a\u000e\t\u000f\u0005u\u0002\u0001\"\u0011\u0002@!9\u0011q\t\u0001\u0005B\u0005%\u0003\u0002CA/\u0001\u0011\u00053%a\u0018\t\u0011\u0005e\u0004\u0001\"\u0011$\u0003?:q!!' \u0011\u0003\tYJ\u0002\u0004\u001f?!\u0005\u0011Q\u0014\u0005\u0007-f!\t!a,\t\u000f\u0005E\u0016\u0004\"\u0001\u00024\"9\u00111Z\r\u0005\u0002\u00055\u0007\"CAk3\u0005\u0005I\u0011BAl\u00051\u0019\u0006/\u0019:tKZ+7\r^8s\u0015\t\u0001\u0013%\u0001\u0004mS:\fGn\u001a\u0006\u0003E\r\nQ!\u001c7mS\nT!\u0001J\u0013\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0019:\u0013AB1qC\u000eDWMC\u0001)\u0003\ry'oZ\u0002\u0001'\r\u00011&\r\t\u0003Y=j\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005I\u001aT\"A\u0010\n\u0005Qz\"A\u0002,fGR|'/\u0001\u0003tSj,W#A\u001c\u0011\u00051B\u0014BA\u001d.\u0005\rIe\u000e\u001e\u0015\u0004\u0003m\n\u0005C\u0001\u001f@\u001b\u0005i$B\u0001 $\u0003)\tgN\\8uCRLwN\\\u0005\u0003\u0001v\u0012QaU5oG\u0016\f\u0013AQ\u0001\u0006c9\u0002d\u0006M\u0001\u0006g&TX\r\t\u0015\u0004\u0005m\n\u0015aB5oI&\u001cWm]\u000b\u0002\u000fB\u0019A\u0006S\u001c\n\u0005%k#!B!se\u0006L\bfA\u0002<\u0003\u0006A\u0011N\u001c3jG\u0016\u001c\b\u0005K\u0002\u0005w\u0005\u000baA^1mk\u0016\u001cX#A(\u0011\u00071B\u0005\u000b\u0005\u0002-#&\u0011!+\f\u0002\u0007\t>,(\r\\3)\u0007\u0015Y\u0014)A\u0004wC2,Xm\u001d\u0011)\u0007\u0019Y\u0014)\u0001\u0004=S:LGO\u0010\u000b\u00051f[V\f\u0005\u00023\u0001!)Qg\u0002a\u0001o!\u001a\u0011lO!\t\u000b\u0015;\u0001\u0019A$)\u0007m[\u0014\tC\u0003N\u000f\u0001\u0007q\nK\u0002^w\u0005C3aB\u001eB\u0003!!xn\u0015;sS:<G#\u00012\u0011\u0005\rTgB\u00013i!\t)W&D\u0001g\u0015\t9\u0017&\u0001\u0004=e>|GOP\u0005\u0003S6\na\u0001\u0015:fI\u00164\u0017BA6m\u0005\u0019\u0019FO]5oO*\u0011\u0011.L\u0001\bi>\f%O]1zQ\rI1(Q\u0001\u0005G>\u0004\u00180F\u0001YQ\rQ1H]\u0011\u0002g\u0006)\u0011GL\u0019/a\u0005A\u0011m\u001d\"sK\u0016TX-F\u0001w!\r98\u0010U\u0007\u0002q*\u0011\u0001%\u001f\u0006\u0002u\u00061!M]3fu\u0016L!\u0001\u000e=\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0005As\b\"B@\r\u0001\u00049\u0014!A5\u0002\r\u0015\fX/\u00197t)\u0011\t)!a\u0003\u0011\u00071\n9!C\u0002\u0002\n5\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002\u000e5\u0001\r!a\u0004\u0002\u000b=$\b.\u001a:\u0011\u00071\n\t\"C\u0002\u0002\u00145\u00121!\u00118z\u0003!A\u0017m\u001d5D_\u0012,G#A\u001c\u0002\u00159,X.Q2uSZ,7\u000f\u000b\u0003\u0010w\u0005u\u0011EAA\u0010\u0003\u0015\td\u0006\u000e\u00181\u0003-qW/\u001c(p]j,'o\\:)\tAY\u0014QD\u0001\u0011i>\u001c\u0006/\u0019:tK^KG\u000f[*ju\u0016$2\u0001WA\u0015\u0011\u0019\tY#\u0005a\u0001o\u0005\u0019aN\u001c>\u0002\r\u0005\u0014x-\\1yQ\u0011\u00112(!\r\"\u0005\u0005M\u0012!B\u0019/k9\u0002\u0014!B:mS\u000e,Gc\u0001-\u0002:!1\u00111H\nA\u0002\u001d\u000bqb]3mK\u000e$X\rZ%oI&\u001cWm]\u0001\u0007i>T5o\u001c8\u0016\u0003\tDC\u0001F\u001e\u0002D\u0005\u0012\u0011QI\u0001\u0006c92d\u0006M\u0001\u0005CNlE*\u0006\u0002\u0002LA!\u0011QJA+\u001b\t\tyEC\u0002!\u0003#R1!a\u0015$\u0003\tiG.C\u0002\u001f\u0003\u001fBC!F\u001e\u0002Z\u0005\u0012\u00111L\u0001\u0006e9\u0002d\u0006M\u0001\tSR,'/\u0019;peV\u0011\u0011\u0011\r\t\u0007\u0003G\ni'a\u001d\u000f\t\u0005\u0015\u0014\u0011\u000e\b\u0004K\u0006\u001d\u0014\"\u0001\u0018\n\u0007\u0005-T&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\u0014\u0011\u000f\u0002\t\u0013R,'/\u0019;pe*\u0019\u00111N\u0017\u0011\u000b1\n)h\u000e)\n\u0007\u0005]TF\u0001\u0004UkBdWMM\u0001\u000fC\u000e$\u0018N^3Ji\u0016\u0014\u0018\r^8sQ\u001d\u0001\u0011QPAG\u0003\u001f\u0003B!a \u0002\n6\u0011\u0011\u0011\u0011\u0006\u0005\u0003\u0007\u000b))A\u0003usB,7OC\u0002\u0002\b\u000e\n1a]9m\u0013\u0011\tY)!!\u0003%M\u000bF*V:fe\u0012+g-\u001b8fIRK\b/Z\u0001\u0004k\u0012$8EAAI!\r\u0011\u00141S\u0005\u0004\u0003+{\"!\u0003,fGR|'/\u0016#UQ\r\u00011(Q\u0001\r'B\f'o]3WK\u000e$xN\u001d\t\u0003ee\u0019B!G\u0016\u0002 B!\u0011\u0011UAV\u001b\t\t\u0019K\u0003\u0003\u0002&\u0006\u001d\u0016AA5p\u0015\t\tI+\u0001\u0003kCZ\f\u0017\u0002BAW\u0003G\u0013AbU3sS\u0006d\u0017N_1cY\u0016$\"!a'\u0002\u000fUt\u0017\r\u001d9msR!\u0011QWAa!\u0015a\u0013qWA^\u0013\r\tI,\f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r1\nilN$P\u0013\r\ty,\f\u0002\u0007)V\u0004H.Z\u001a\t\r\u0005\r7\u00041\u0001Y\u0003\t\u0019h\u000f\u000b\u0003\u001cw\u0005\u001d\u0017EAAe\u0003\u0015\tdf\r\u00181\u0003\u00191'o\\7N\u0019R\u0019\u0001,a4\t\u000f\u0005EG\u00041\u0001\u0002L\u0005\ta\u000f\u000b\u0003\u001dw\u0005e\u0013\u0001D<sSR,'+\u001a9mC\u000e,GCAAm!\u0011\tY.!9\u000e\u0005\u0005u'\u0002BAp\u0003O\u000bA\u0001\\1oO&!\u00111]Ao\u0005\u0019y%M[3di\"\"\u0011dOAdQ\u0011A2(a2")
public class SparseVector
implements Vector {
    private final int size;
    private final int[] indices;
    private final double[] values;

    public static SparseVector fromML(org.apache.spark.ml.linalg.SparseVector sparseVector) {
        return SparseVector$.MODULE$.fromML(sparseVector);
    }

    public static Option<Tuple3<Object, int[], double[]>> unapply(SparseVector sparseVector) {
        return SparseVector$.MODULE$.unapply(sparseVector);
    }

    @Override
    public void foreach(Function2<Object, Object, BoxedUnit> f) {
        Vector.foreach$(this, f);
    }

    @Override
    public void foreachActive(Function2<Object, Object, BoxedUnit> f) {
        Vector.foreachActive$(this, f);
    }

    @Override
    public void foreachNonZero(Function2<Object, Object, BoxedUnit> f) {
        Vector.foreachNonZero$(this, f);
    }

    @Override
    public SparseVector toSparse() {
        return Vector.toSparse$(this);
    }

    @Override
    public DenseVector toDense() {
        return Vector.toDense$(this);
    }

    @Override
    public Vector compressed() {
        return Vector.compressed$(this);
    }

    @Override
    public double dot(Vector v) {
        return Vector.dot$(this, v);
    }

    @Override
    public Iterator<Tuple2<Object, Object>> nonZeroIterator() {
        return Vector.nonZeroIterator$(this);
    }

    @Override
    public double sparsity() {
        return Vector.sparsity$(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    public int[] indices() {
        return this.indices;
    }

    public double[] values() {
        return this.values;
    }

    public String toString() {
        return new java.lang.StringBuilder(4).append("(").append(this.size()).append(",").append(Predef$.MODULE$.wrapIntArray(this.indices()).mkString("[", ",", "]")).append(",").append(Predef$.MODULE$.wrapDoubleArray(this.values()).mkString("[", ",", "]")).append(")").toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] toArray() {
        void var1_1;
        double[] data = new double[this.size()];
        int nnz = this.indices().length;
        for (int i = 0; i < nnz; ++i) {
            data[this.indices()[i]] = this.values()[i];
        }
        return var1_1;
    }

    @Override
    public SparseVector copy() {
        return new SparseVector(this.size(), (int[])this.indices().clone(), (double[])this.values().clone());
    }

    @Override
    public breeze.linalg.Vector<Object> asBreeze() {
        return new SparseVector.mcD.sp(this.indices(), this.values(), this.size(), (Zero)Zero.DoubleZero$.MODULE$);
    }

    @Override
    public double apply(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException(new java.lang.StringBuilder(26).append("Index ").append(i).append(" out of bounds [0, ").append(this.size()).append(")").toString());
        }
        int j = Arrays.binarySearch(this.indices(), i);
        return j < 0 ? 0.0 : this.values()[j];
    }

    @Override
    public boolean equals(Object other) {
        return Vector.equals$(this, other);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int result = 31 + this.size();
        int end = this.values().length;
        int nnz = 0;
        for (int k = 0; k < end && nnz < Vectors$.MODULE$.MAX_HASH_NNZ(); ++k) {
            double v = this.values()[k];
            if (v == 0.0) continue;
            int i = this.indices()[k];
            result = 31 * result + i;
            long bits = Double.doubleToLongBits(v);
            result = 31 * result + (int)(bits ^ bits >>> 32);
            ++nnz;
        }
        return (int)var1_1;
    }

    @Override
    public int numActives() {
        return this.values().length;
    }

    @Override
    public int numNonzeros() {
        IntRef nnz = IntRef.create((int)0);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.doubleArrayOps(this.values()), (Function1)(JFunction1.mcVD.sp & Serializable)v -> {
            block0: {
                if (v == 0.0) break block0;
                ++nnz$3.elem;
            }
        });
        return nnz.elem;
    }

    @Override
    public SparseVector toSparseWithSize(int nnz) {
        SparseVector sparseVector;
        if (nnz == this.numActives()) {
            sparseVector = this;
        } else {
            int[] ii = new int[nnz];
            double[] vv = new double[nnz];
            IntRef k = IntRef.create((int)0);
            this.foreachNonZero((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable)(i, v) -> {
                ii$2[k$2.elem] = i;
                vv$2[k$2.elem] = v;
                ++k$2.elem;
            });
            sparseVector = new SparseVector(this.size(), ii, vv);
        }
        return sparseVector;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int argmax() {
        int n;
        if (this.size() == 0) {
            n = -1;
        } else if (this.numActives() == 0) {
            n = 0;
        } else {
            void var1_1;
            int maxIdx = this.indices()[0];
            double maxValue = this.values()[0];
            int maxJ = 0;
            int na = this.numActives();
            for (int j = 1; j < na; ++j) {
                double v = this.values()[j];
                if (!(v > maxValue)) continue;
                maxValue = v;
                maxIdx = this.indices()[j];
                maxJ = j;
            }
            if (maxValue <= 0.0 && na < this.size()) {
                if (maxValue == 0.0) {
                    if (maxJ < maxIdx) {
                        int k;
                        for (k = 0; k < maxJ && this.indices()[k] == k; ++k) {
                        }
                        maxIdx = k;
                    }
                } else {
                    int k;
                    for (k = 0; k < na && this.indices()[k] == k; ++k) {
                    }
                    maxIdx = k;
                }
            }
            n = var1_1;
        }
        return n;
    }

    public SparseVector slice(int[] selectedIndices) {
        IntRef currentIdx = IntRef.create((int)0);
        Tuple2 tuple2 = ArrayOps$.MODULE$.unzip$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.intArrayOps(selectedIndices), (Function1 & Serializable)origIdx -> SparseVector.$anonfun$slice$1(this, currentIdx, BoxesRunTime.unboxToInt((Object)origIdx)), ClassTag$.MODULE$.apply(Tuple2.class))), Predef$.MODULE$.$conforms(), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Double());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int[] sliceInds = (int[])tuple2._1();
        double[] sliceVals = (double[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sliceInds, (Object)sliceVals);
        Tuple2 tuple23 = tuple22;
        int[] sliceInds2 = (int[])tuple23._1();
        double[] sliceVals2 = (double[])tuple23._2();
        return new SparseVector(selectedIndices.length, sliceInds2, sliceVals2);
    }

    @Override
    public String toJson() {
        JsonAST.JObject jValue;
        JsonAST.JObject x$1 = jValue = JsonListAssoc$.MODULE$.$tilde$extension(JsonDSL$.MODULE$.jobject2assoc(JsonListAssoc$.MODULE$.$tilde$extension(JsonDSL$.MODULE$.jobject2assoc(JsonAssoc$.MODULE$.$tilde$extension(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)BoxesRunTime.boxToInteger((int)0)), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)BoxesRunTime.boxToInteger((int)this.size())), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))), JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"indices"), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps(this.indices()))), (Function1 & Serializable)s -> JsonDSL$.MODULE$.seq2jvalue(s, (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))))), JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"values"), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.doubleArrayOps(this.values()))), (Function1 & Serializable)s -> JsonDSL$.MODULE$.seq2jvalue(s, (Function1 & Serializable)x -> JsonDSL$.MODULE$.double2jvalue(BoxesRunTime.unboxToDouble((Object)x)))));
        Formats x$2 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$1);
        return JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$1, x$2));
    }

    public org.apache.spark.ml.linalg.SparseVector asML() {
        return new org.apache.spark.ml.linalg.SparseVector(this.size(), this.indices(), this.values());
    }

    @Override
    public Iterator<Tuple2<Object, Object>> iterator() {
        int localSize = this.size();
        int localNumActives = this.numActives();
        int[] localIndices = this.indices();
        double[] localValues = this.values();
        return new Iterator<Tuple2<Object, Object>>(null, localIndices, localSize, localNumActives, localValues){
            private int i;
            private int j;
            private int k;
            private final int[] localIndices$1;
            private final int localSize$1;
            private final int localNumActives$1;
            private final double[] localValues$2;

            public final boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public final Iterator<Tuple2<Object, Object>> iterator() {
                return Iterator.iterator$((Iterator)this);
            }

            public Option<Tuple2<Object, Object>> nextOption() {
                return Iterator.nextOption$((Iterator)this);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public BufferedIterator<Tuple2<Object, Object>> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator<B> padTo(int len, B elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Tuple2<Iterator<Tuple2<Object, Object>>, Iterator<Tuple2<Object, Object>>> partition(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple2<Object, Object>, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Tuple2<Object, Object>, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public int indexWhere(Function1<Tuple2<Object, Object>, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public int indexWhere$default$2() {
                return Iterator.indexWhere$default$2$((Iterator)this);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public final int length() {
                return Iterator.length$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public Iterator<Tuple2<Object, Object>> filter(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public Iterator<Tuple2<Object, Object>> filterNot(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public Iterator<Tuple2<Object, Object>> filterImpl(Function1<Tuple2<Object, Object>, Object> p, boolean isFlipped) {
                return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
            }

            public Iterator<Tuple2<Object, Object>> withFilter(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Tuple2<Object, Object>, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public Iterator<Tuple2<Object, Object>> distinct() {
                return Iterator.distinct$((Iterator)this);
            }

            public <B> Iterator<Tuple2<Object, Object>> distinctBy(Function1<Tuple2<Object, Object>, B> f) {
                return Iterator.distinctBy$((Iterator)this, f);
            }

            public <B> Iterator<B> map(Function1<Tuple2<Object, Object>, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> flatMap(Function1<Tuple2<Object, Object>, IterableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public <B> Iterator<B> flatten(Function1<Tuple2<Object, Object>, IterableOnce<B>> ev) {
                return Iterator.flatten$((Iterator)this, ev);
            }

            public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                return Iterator.concat$((Iterator)this, xs);
            }

            public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                return Iterator.$plus$plus$((Iterator)this, xs);
            }

            public Iterator<Tuple2<Object, Object>> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<Object, Object>> takeWhile(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Iterator<Tuple2<Object, Object>> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<Object, Object>> dropWhile(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<Object, Object>>, Iterator<Tuple2<Object, Object>>> span(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<Tuple2<Object, Object>> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<Tuple2<Object, Object>> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<Tuple2<Tuple2<Object, Object>, B>> zip(IterableOnce<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public Iterator<Tuple2<Tuple2<Object, Object>, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B> boolean sameElements(IterableOnce<B> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Tuple2<Iterator<Tuple2<Object, Object>>, Iterator<Tuple2<Object, Object>>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <U> Iterator<Tuple2<Object, Object>> tapEach(Function1<Tuple2<Object, Object>, U> f) {
                return Iterator.tapEach$((Iterator)this, f);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public Iterator<Tuple2<Object, Object>> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public Tuple2<Iterator<Tuple2<Object, Object>>, Iterator<Tuple2<Object, Object>>> splitAt(int n) {
                return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
            }

            public boolean isTraversableAgain() {
                return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
            }

            public <U> void foreach(Function1<Tuple2<Object, Object>, U> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<Tuple2<Object, Object>, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<Tuple2<Object, Object>, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<Tuple2<Object, Object>, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<Tuple2<Object, Object>> find(Function1<Tuple2<Object, Object>, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, Tuple2<Object, Object>, B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Tuple2<Object, Object>, B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, Tuple2<Object, Object>, B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<Tuple2<Object, Object>, B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, Tuple2<Object, Object>, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<Tuple2<Object, Object>, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Tuple2<Object, Object>, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Tuple2<Object, Object>, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object xs) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
            }

            public <B> int copyToArray(Object xs, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
            }

            public <B> int copyToArray(Object xs, int start, int len) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<Tuple2<Object, Object>> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<Tuple2<Object, Object>> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<Tuple2<Object, Object>> maxByOption(Function1<Tuple2<Object, Object>, B> f, Ordering<B> cmp) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<Tuple2<Object, Object>> minByOption(Function1<Tuple2<Object, Object>, B> f, Ordering<B> cmp) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
            }

            public <B> Option<B> collectFirst(PartialFunction<Tuple2<Object, Object>, B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Tuple2<Object, Object>, B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<Tuple2<Object, Object>, B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<Tuple2<Object, Object>, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<Tuple2<Object, Object>> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<Tuple2<Object, Object>> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public scala.collection.immutable.Vector<Tuple2<Object, Object>> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K, V> Map<K, V> toMap(.less.colon.less<Tuple2<Object, Object>, Tuple2<K, V>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<Tuple2<Object, Object>> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<Tuple2<Object, Object>> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<Tuple2<Object, Object>> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<Tuple2<Object, Object>> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S extends Stepper<?>> S stepper(StepperShape<Tuple2<Object, Object>, S> shape) {
                return (S)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            private int i() {
                return this.i;
            }

            private void i_$eq(int x$1) {
                this.i = x$1;
            }

            private int j() {
                return this.j;
            }

            private void j_$eq(int x$1) {
                this.j = x$1;
            }

            private int k() {
                return this.k;
            }

            private void k_$eq(int x$1) {
                this.k = x$1;
            }

            public boolean hasNext() {
                return this.i() < this.localSize$1;
            }

            public Tuple2<Object, Object> next() {
                double d;
                if (this.i() == this.k()) {
                    this.j_$eq(this.j() + 1);
                    this.k_$eq(this.j() < this.localNumActives$1 ? this.localIndices$1[this.j()] : -1);
                    d = this.localValues$2[this.j() - 1];
                } else {
                    d = 0.0;
                }
                double v = d;
                this.i_$eq(this.i() + 1);
                return new Tuple2.mcID.sp(this.i() - 1, v);
            }
            {
                this.localIndices$1 = localIndices$1;
                this.localSize$1 = localSize$1;
                this.localNumActives$1 = localNumActives$1;
                this.localValues$2 = localValues$2;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.i = 0;
                this.j = 0;
                this.k = BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.intArrayOps(localIndices$1)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$k$1()}, serializedLambda);
            }
        };
    }

    @Override
    public Iterator<Tuple2<Object, Object>> activeIterator() {
        int[] localIndices = this.indices();
        double[] localValues = this.values();
        return package$.MODULE$.Iterator().tabulate(this.numActives(), (Function1 & Serializable)j -> SparseVector.$anonfun$activeIterator$1(localIndices, localValues, BoxesRunTime.unboxToInt((Object)j)));
    }

    public static final /* synthetic */ Iterator $anonfun$slice$1(SparseVector $this, IntRef currentIdx$1, int origIdx) {
        int iIdx = Arrays.binarySearch($this.indices(), origIdx);
        Iterator i_v = iIdx >= 0 ? package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(currentIdx$1.elem, $this.values()[iIdx])})) : package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
        ++currentIdx$1.elem;
        return i_v;
    }

    public static final /* synthetic */ Tuple2 $anonfun$activeIterator$1(int[] localIndices$2, double[] localValues$3, int j) {
        return new Tuple2.mcID.sp(localIndices$2[j], localValues$3[j]);
    }

    public SparseVector(int size, int[] indices, double[] values) {
        this.size = size;
        this.indices = indices;
        this.values = values;
        Vector.$init$(this);
        Predef$.MODULE$.require(size >= 0, (Function0 & Serializable)() -> "The size of the requested sparse vector must be no less than 0.");
        Predef$.MODULE$.require(indices.length == values.length, (Function0 & Serializable)() -> new java.lang.StringBuilder(48).append("Sparse vectors require that the dimension of the").append(new java.lang.StringBuilder(70).append(" indices match the dimension of the values. You provided ").append(this.indices().length).append(" indices and ").toString()).append(new java.lang.StringBuilder(9).append(" ").append(this.values().length).append(" values.").toString()).toString());
        Predef$.MODULE$.require(indices.length <= size, (Function0 & Serializable)() -> new java.lang.StringBuilder(0).append(new java.lang.StringBuilder(34).append("You provided ").append(this.indices().length).append(" indices and values, ").toString()).append(new java.lang.StringBuilder(41).append("which exceeds the specified vector size ").append(this.size()).append(".").toString()).toString());
    }
}

