/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.regression.RandomForestRegressionModel$;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$;
import org.apache.spark.ml.tree.HasVarianceImpurity;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.RandomForestParams;
import org.apache.spark.ml.tree.RandomForestRegressorParams;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.tree.TreeEnsembleParams;
import org.apache.spark.ml.tree.TreeEnsembleRegressorParams;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t-e\u0001B\u0014)\u0001MB\u0001b\u0018\u0001\u0003\u0006\u0004%\t\u0005\u0019\u0005\tS\u0002\u0011\t\u0011)A\u0005C\"A!\u000e\u0001BC\u0002\u0013%1\u000e\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003m\u0011!\t\bA!b\u0001\n\u0003\u0012\b\u0002\u0003<\u0001\u0005\u0003\u0005\u000b\u0011B:\t\r]\u0004A\u0011\u0001\u0016y\u0011\u00199\b\u0001\"\u0001+y\")a\u0010\u0001C!W\"Q\u00111\u0003\u0001\t\u0006\u0004%I!!\u0006\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\u0016!9\u00111\u0005\u0001\u0005B\u0005\u0015\u0002bBA\u001f\u0001\u0011\u0005\u0013q\b\u0005\b\u0003\u0003\u0003A\u0011IAB\u0011\u001d\tI\t\u0001C!\u0003\u0017Cq!a(\u0001\t\u0003\n\t\u000b\u0003\u0006\u0002&\u0002A)\u0019!C\u0001\u0003OC\u0001\"a,\u0001\t\u0003Q\u0013\u0011\u0017\u0005\b\u0003\u000b\u0004A\u0011IAd\u000f\u001d\t9\u000e\u000bE\u0001\u000334aa\n\u0015\t\u0002\u0005m\u0007BB<\u0016\t\u0003\t9\u0010C\u0004\u0002zV!\t%a?\t\u000f\t\u0015Q\u0003\"\u0011\u0003\b\u00199!qB\u000b\u0001+\tE\u0001\"\u0003B\n3\t\u0005\t\u0015!\u0003?\u0011\u00199\u0018\u0004\"\u0001\u0003\u0016!9!QD\r\u0005R\t}aA\u0002B\u0015+\u0011\u0011Y\u0003\u0003\u0004x;\u0011\u0005!Q\u0006\u0005\n\u0005ci\"\u0019!C\u0005\u0005gA\u0001Ba\u0010\u001eA\u0003%!Q\u0007\u0005\n\u0005\u0003j\"\u0019!C\u0005\u0005gA\u0001Ba\u0011\u001eA\u0003%!Q\u0007\u0005\b\u0005\u000biB\u0011\tB#\u0011!\u0011I%\u0006C\u0001U\t-\u0003B\u0003B4+E\u0005I\u0011\u0001\u0016\u0003j!I!QP\u000b\u0002\u0002\u0013%!q\u0010\u0002\u001c%\u0006tGm\\7G_J,7\u000f\u001e*fOJ,7o]5p]6{G-\u001a7\u000b\u0005%R\u0013A\u0003:fOJ,7o]5p]*\u00111\u0006L\u0001\u0003[2T!!\f\u0018\u0002\u000bM\u0004\u0018M]6\u000b\u0005=\u0002\u0014AB1qC\u000eDWMC\u00012\u0003\ry'oZ\u0002\u0001'\u0019\u0001AgP#L#B!QG\u000e\u001d?\u001b\u0005A\u0013BA\u001c)\u0005=\u0011Vm\u001a:fgNLwN\\'pI\u0016d\u0007CA\u001d=\u001b\u0005Q$BA\u001e+\u0003\u0019a\u0017N\\1mO&\u0011QH\u000f\u0002\u0007-\u0016\u001cGo\u001c:\u0011\u0005U\u0002\u0001C\u0001!D\u001b\u0005\t%B\u0001\"+\u0003\u0011!(/Z3\n\u0005\u0011\u000b%a\u0007*b]\u0012|WNR8sKN$(+Z4sKN\u001cxN\u001d)be\u0006l7\u000fE\u0002A\r\"K!aR!\u0003#Q\u0013X-Z#og\u0016l'\r\\3N_\u0012,G\u000e\u0005\u00026\u0013&\u0011!\n\u000b\u0002\u001c\t\u0016\u001c\u0017n]5p]R\u0013X-\u001a*fOJ,7o]5p]6{G-\u001a7\u0011\u00051{U\"A'\u000b\u00059S\u0013\u0001B;uS2L!\u0001U'\u0003\u00155cuK]5uC\ndW\r\u0005\u0002S9:\u00111+\u0017\b\u0003)^k\u0011!\u0016\u0006\u0003-J\na\u0001\u0010:p_Rt\u0014\"\u0001-\u0002\u000bM\u001c\u0017\r\\1\n\u0005i[\u0016a\u00029bG.\fw-\u001a\u0006\u00021&\u0011QL\u0018\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u00035n\u000b1!^5e+\u0005\t\u0007C\u00012g\u001d\t\u0019G\r\u0005\u0002U7&\u0011QmW\u0001\u0007!J,G-\u001a4\n\u0005\u001dD'AB*ue&twM\u0003\u0002f7\u0006!Q/\u001b3!\u0003\u0019yFO]3fgV\tA\u000eE\u0002n]\"k\u0011aW\u0005\u0003_n\u0013Q!\u0011:sCf\fqa\u0018;sK\u0016\u001c\b%A\u0006ok64U-\u0019;ve\u0016\u001cX#A:\u0011\u00055$\u0018BA;\\\u0005\rIe\u000e^\u0001\r]Vlg)Z1ukJ,7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\tyJ(p\u001f\u0005\u0006?\u001e\u0001\r!\u0019\u0005\u0006U\u001e\u0001\r\u0001\u001c\u0005\u0006c\u001e\u0001\ra\u001d\u000b\u0004}u|\b\"\u0002@\t\u0001\u0004a\u0017!\u0002;sK\u0016\u001c\b\"B9\t\u0001\u0004\u0019\b&B\u0005\u0002\u0004\u0005=\u0001\u0003BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%A&\u0001\u0006b]:|G/\u0019;j_:LA!!\u0004\u0002\b\t)1+\u001b8dK\u0006\u0012\u0011\u0011C\u0001\u0006c9\"d\u0006M\u0001\r?R\u0014X-Z,fS\u001eDGo]\u000b\u0003\u0003/\u0001B!\u001c8\u0002\u001aA\u0019Q.a\u0007\n\u0007\u0005u1L\u0001\u0004E_V\u0014G.Z\u0001\fiJ,WmV3jO\"$8\u000fK\u0003\f\u0003\u0007\ty!A\bue\u0006t7OZ8s[N\u001b\u0007.Z7b)\u0011\t9#a\u000e\u0011\t\u0005%\u00121G\u0007\u0003\u0003WQA!!\f\u00020\u0005)A/\u001f9fg*\u0019\u0011\u0011\u0007\u0017\u0002\u0007M\fH.\u0003\u0003\u00026\u0005-\"AC*ueV\u001cG\u000fV=qK\"9\u0011\u0011\b\u0007A\u0002\u0005\u001d\u0012AB:dQ\u0016l\u0017\rK\u0003\r\u0003\u0007\ty!A\u0005ue\u0006t7OZ8s[R!\u0011\u0011IA/!\u0011\t\u0019%a\u0016\u000f\t\u0005\u0015\u0013Q\u000b\b\u0005\u0003\u000f\n\u0019F\u0004\u0003\u0002J\u0005Ec\u0002BA&\u0003\u001fr1\u0001VA'\u0013\u0005\t\u0014BA\u00181\u0013\tic&C\u0002\u000221J1AWA\u0018\u0013\u0011\tI&a\u0017\u0003\u0013\u0011\u000bG/\u0019$sC6,'b\u0001.\u00020!9\u0011qL\u0007A\u0002\u0005\u0005\u0014a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u0003G\ny\u0007\u0005\u0004\u0002f\u0005\u001d\u00141N\u0007\u0003\u0003_IA!!\u001b\u00020\t9A)\u0019;bg\u0016$\b\u0003BA7\u0003_b\u0001\u0001\u0002\u0007\u0002r\u0005u\u0013\u0011!A\u0001\u0006\u0003\t\u0019HA\u0002`II\nB!!\u001e\u0002|A\u0019Q.a\u001e\n\u0007\u0005e4LA\u0004O_RD\u0017N\\4\u0011\u00075\fi(C\u0002\u0002\u0000m\u00131!\u00118z\u0003\u001d\u0001(/\u001a3jGR$B!!\u0007\u0002\u0006\"1\u0011q\u0011\bA\u0002a\n\u0001BZ3biV\u0014Xm]\u0001\u0005G>\u0004\u0018\u0010F\u0002?\u0003\u001bCq!a$\u0010\u0001\u0004\t\t*A\u0003fqR\u0014\u0018\r\u0005\u0003\u0002\u0014\u0006eUBAAK\u0015\r\t9JK\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u00037\u000b)J\u0001\u0005QCJ\fW.T1qQ\u0015y\u00111AA\b\u0003!!xn\u0015;sS:<G#A1)\u000bA\t\u0019!a\u0004\u0002%\u0019,\u0017\r^;sK&k\u0007o\u001c:uC:\u001cWm]\u000b\u0002q!*\u0011#a\u0001\u0002,\u0006\u0012\u0011QV\u0001\u0006c9*d\u0006M\u0001\u0006i>|E\u000eZ\u000b\u0003\u0003g\u0003B!!.\u0002B6\u0011\u0011q\u0017\u0006\u0005\u0003s\u000bY,A\u0003n_\u0012,GNC\u0002C\u0003{S1!a0-\u0003\u0015iG\u000e\\5c\u0013\u0011\t\u0019-a.\u0003#I\u000bg\u000eZ8n\r>\u0014Xm\u001d;N_\u0012,G.A\u0003xe&$X-\u0006\u0002\u0002JB\u0019A*a3\n\u0007\u00055WJ\u0001\u0005N\u0019^\u0013\u0018\u000e^3sQ\u0015\u0019\u00121AAiC\t\t\u0019.A\u00033]Ar\u0003\u0007K\u0003\u0001\u0003\u0007\ty!A\u000eSC:$w.\u001c$pe\u0016\u001cHOU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\t\u0003kU\u0019r!FAo\u0003G\fI\u000fE\u0002n\u0003?L1!!9\\\u0005\u0019\te.\u001f*fMB!A*!:?\u0013\r\t9/\u0014\u0002\u000b\u001b2\u0013V-\u00193bE2,\u0007\u0003BAv\u0003kl!!!<\u000b\t\u0005=\u0018\u0011_\u0001\u0003S>T!!a=\u0002\t)\fg/Y\u0005\u0004;\u00065HCAAm\u0003\u0011\u0011X-\u00193\u0016\u0005\u0005u\b\u0003\u0002'\u0002\u0000zJ1A!\u0001N\u0005!iEJU3bI\u0016\u0014\b&B\f\u0002\u0004\u0005E\u0017\u0001\u00027pC\u0012$2A\u0010B\u0005\u0011\u0019\u0011Y\u0001\u0007a\u0001C\u0006!\u0001/\u0019;iQ\u0015A\u00121AAi\u0005\u0005\u0012\u0016M\u001c3p[\u001a{'/Z:u%\u0016<'/Z:tS>tWj\u001c3fY^\u0013\u0018\u000e^3s'\rI\u0012\u0011Z\u0001\tS:\u001cH/\u00198dKR!!q\u0003B\u000e!\r\u0011I\"G\u0007\u0002+!1!1C\u000eA\u0002y\n\u0001b]1wK&k\u0007\u000f\u001c\u000b\u0005\u0005C\u00119\u0003E\u0002n\u0005GI1A!\n\\\u0005\u0011)f.\u001b;\t\r\t-A\u00041\u0001b\u0005\u0005\u0012\u0016M\u001c3p[\u001a{'/Z:u%\u0016<'/Z:tS>tWj\u001c3fYJ+\u0017\rZ3s'\ri\u0012Q \u000b\u0003\u0005_\u00012A!\u0007\u001e\u0003%\u0019G.Y:t\u001d\u0006lW-\u0006\u0002\u00036A!!q\u0007B\u001f\u001b\t\u0011ID\u0003\u0003\u0003<\u0005E\u0018\u0001\u00027b]\u001eL1a\u001aB\u001d\u0003)\u0019G.Y:t\u001d\u0006lW\rI\u0001\u000eiJ,Wm\u00117bgNt\u0015-\\3\u0002\u001dQ\u0014X-Z\"mCN\u001ch*Y7fAQ\u0019aHa\u0012\t\r\t-1\u00051\u0001b\u0003\u001d1'o\\7PY\u0012$\u0012B\u0010B'\u0005#\u0012YF!\u001a\t\u000f\t=C\u00051\u0001\u00024\u0006Aq\u000e\u001c3N_\u0012,G\u000eC\u0004\u0003T\u0011\u0002\rA!\u0016\u0002\rA\f'/\u001a8u!\r)$qK\u0005\u0004\u00053B#!\u0006*b]\u0012|WNR8sKN$(+Z4sKN\u001cxN\u001d\u0005\b\u0005;\"\u0003\u0019\u0001B0\u0003M\u0019\u0017\r^3h_JL7-\u00197GK\u0006$XO]3t!\u0015\u0011'\u0011M:t\u0013\r\u0011\u0019\u0007\u001b\u0002\u0004\u001b\u0006\u0004\bbB9%!\u0003\u0005\ra]\u0001\u0012MJ|Wn\u00147eI\u0011,g-Y;mi\u0012\"TC\u0001B6U\r\u0019(QN\u0016\u0003\u0005_\u0002BA!\u001d\u0003z5\u0011!1\u000f\u0006\u0005\u0005k\u00129(A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011B.\n\t\tm$1\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001BA!\u0011\u00119Da!\n\t\t\u0015%\u0011\b\u0002\u0007\u001f\nTWm\u0019;)\u000bU\t\u0019!!5)\u000bQ\t\u0019!!5")
public class RandomForestRegressionModel
extends RegressionModel<Vector, RandomForestRegressionModel>
implements RandomForestRegressorParams,
TreeEnsembleModel<DecisionTreeRegressionModel>,
MLWritable {
    private double[] _treeWeights;
    private Vector featureImportances;
    private final String uid;
    private final DecisionTreeRegressionModel[] _trees;
    private final int numFeatures;
    private int totalNumNodes;
    private Param<String> impurity;
    private IntParam numTrees;
    private BooleanParam bootstrap;
    private DoubleParam subsamplingRate;
    private Param<String> featureSubsetStrategy;
    private Param<String> leafCol;
    private IntParam maxDepth;
    private IntParam maxBins;
    private IntParam minInstancesPerNode;
    private DoubleParam minWeightFractionPerNode;
    private DoubleParam minInfoGain;
    private IntParam maxMemoryInMB;
    private BooleanParam cacheNodeIds;
    private Param<String> weightCol;
    private LongParam seed;
    private IntParam checkpointInterval;
    private volatile byte bitmap$0;

    public static RandomForestRegressionModel load(String string) {
        return RandomForestRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<RandomForestRegressionModel> read() {
        return RandomForestRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public Vector javaTreeWeights() {
        return TreeEnsembleModel.javaTreeWeights$(this);
    }

    @Override
    public String toDebugString() {
        return TreeEnsembleModel.toDebugString$(this);
    }

    @Override
    public Vector predictLeaf(Vector features) {
        return TreeEnsembleModel.predictLeaf$(this, features);
    }

    @Override
    public StructField getLeafField(String leafCol) {
        return TreeEnsembleModel.getLeafField$(this, leafCol);
    }

    @Override
    public final String getImpurity() {
        return HasVarianceImpurity.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return HasVarianceImpurity.getOldImpurity$(this);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$tree$TreeEnsembleRegressorParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return TreeEnsembleRegressorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final int getNumTrees() {
        return RandomForestParams.getNumTrees$(this);
    }

    @Override
    public final boolean getBootstrap() {
        return RandomForestParams.getBootstrap$(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams.getSubsamplingRate$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return TreeEnsembleParams.getFeatureSubsetStrategy$(this);
    }

    @Override
    public final DecisionTreeParams setLeafCol(String value) {
        return DecisionTreeParams.setLeafCol$(this, value);
    }

    @Override
    public final String getLeafCol() {
        return DecisionTreeParams.getLeafCol$(this);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public final double getMinWeightFractionPerNode() {
        return DecisionTreeParams.getMinWeightFractionPerNode$(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    private int totalNumNodes$lzycompute() {
        RandomForestRegressionModel randomForestRegressionModel = this;
        synchronized (randomForestRegressionModel) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.totalNumNodes = TreeEnsembleModel.totalNumNodes$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.totalNumNodes;
    }

    @Override
    public int totalNumNodes() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.totalNumNodes$lzycompute() : this.totalNumNodes;
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$HasVarianceImpurity$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final IntParam numTrees() {
        return this.numTrees;
    }

    @Override
    public final BooleanParam bootstrap() {
        return this.bootstrap;
    }

    @Override
    public final void org$apache$spark$ml$tree$RandomForestParams$_setter_$numTrees_$eq(IntParam x$1) {
        this.numTrees = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$RandomForestParams$_setter_$bootstrap_$eq(BooleanParam x$1) {
        this.bootstrap = x$1;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$featureSubsetStrategy_$eq(Param<String> x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public final Param<String> leafCol() {
        return this.leafCol;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minWeightFractionPerNode() {
        return this.minWeightFractionPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$leafCol_$eq(Param<String> x$1) {
        this.leafCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minWeightFractionPerNode_$eq(DoubleParam x$1) {
        this.minWeightFractionPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    private DecisionTreeRegressionModel[] _trees() {
        return this._trees;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    public DecisionTreeRegressionModel[] trees() {
        return this._trees();
    }

    private double[] _treeWeights$lzycompute() {
        RandomForestRegressionModel randomForestRegressionModel = this;
        synchronized (randomForestRegressionModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this._treeWeights = (double[])Array$.MODULE$.fill(this._trees().length, (Function0)(JFunction0.mcD.sp & Serializable)() -> 1.0, (ClassTag)ClassTag$.MODULE$.Double());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this._treeWeights;
    }

    private double[] _treeWeights() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this._treeWeights$lzycompute() : this._treeWeights;
    }

    @Override
    public double[] treeWeights() {
        return this._treeWeights();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StructType transformSchema(StructType schema) {
        void var2_2;
        block0: {
            StructType outputSchema = super.transformSchema(schema);
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.leafCol())))) break block0;
            outputSchema = SchemaUtils$.MODULE$.updateField(outputSchema, this.getLeafField(this.$(this.leafCol())), SchemaUtils$.MODULE$.updateField$default$3());
        }
        return var2_2;
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset dataset2;
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Seq predictionColNames = (Seq)package$.MODULE$.Seq().empty();
        Seq predictionColumns = (Seq)package$.MODULE$.Seq().empty();
        Broadcast bcastModel = dataset.sparkSession().sparkContext().broadcast((Object)this, ClassTag$.MODULE$.apply(RandomForestRegressionModel.class));
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.predictionCol())))) {
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(RandomForestRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_RandomForestRegressionModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_RandomForestRegressionModel$$typecreator1$1(RandomForestRegressionModel $outer) {
                }
            }
            UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1 & Serializable)features -> BoxesRunTime.boxToDouble((double)RandomForestRegressionModel.$anonfun$transform$1(bcastModel, features)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_RandomForestRegressionModel$$typecreator1$1(null)));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.predictionCol()));
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)predictUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).as(this.$(this.predictionCol()), outputSchema.apply(this.$(this.predictionCol())).metadata()));
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.leafCol())))) {
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(RandomForestRegressionModel.class.getClassLoader());
            JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(RandomForestRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_RandomForestRegressionModel$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_RandomForestRegressionModel$$typecreator2$1(RandomForestRegressionModel $outer) {
                }
            }
            public final class Org_apache_spark_ml_regression_RandomForestRegressionModel$$typecreator3$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_RandomForestRegressionModel$$typecreator3$1(RandomForestRegressionModel $outer) {
                }
            }
            UserDefinedFunction leafUDF = functions$.MODULE$.udf((Function1 & Serializable)features -> ((TreeEnsembleModel)bcastModel.value()).predictLeaf((Vector)features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_RandomForestRegressionModel$$typecreator2$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_regression_RandomForestRegressionModel$$typecreator3$1(null)));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.leafCol()));
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)leafUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).as(this.$(this.leafCol()), outputSchema.apply(this.$(this.leafCol())).metadata()));
        }
        if (predictionColNames.nonEmpty()) {
            dataset2 = dataset.withColumns(predictionColNames, predictionColumns);
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append(new StringBuilder(54).append(this.uid()).append(": RandomForestRegressionModel.transform() does nothing").toString()).append(" because no output columns were set.").toString());
            dataset2 = dataset.toDF();
        }
        return dataset2;
    }

    @Override
    public double predict(Vector features) {
        return BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this._trees()), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToDouble((double)RandomForestRegressionModel.$anonfun$predict$1(features, x$3)), (ClassTag)ClassTag$.MODULE$.Double())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)this.getNumTrees();
    }

    @Override
    public RandomForestRegressionModel copy(ParamMap extra) {
        return (RandomForestRegressionModel)((Model)this.copyValues(new RandomForestRegressionModel(this.uid(), this._trees(), this.numFeatures()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return new StringBuilder(58).append("RandomForestRegressionModel: uid=").append(this.uid()).append(", numTrees=").append(this.getNumTrees()).append(", numFeatures=").append(this.numFeatures()).toString();
    }

    private Vector featureImportances$lzycompute() {
        RandomForestRegressionModel randomForestRegressionModel = this;
        synchronized (randomForestRegressionModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this.trees(), this.numFeatures(), TreeEnsembleModel$.MODULE$.featureImportances$default$3());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.featureImportances;
    }

    public Vector featureImportances() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.featureImportances$lzycompute() : this.featureImportances;
    }

    public RandomForestModel toOld() {
        return new RandomForestModel(Algo$.MODULE$.Regression(), (DecisionTreeModel[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this._trees()), (Function1 & Serializable)x$4 -> x$4.toOld(), ClassTag$.MODULE$.apply(DecisionTreeModel.class)));
    }

    @Override
    public MLWriter write() {
        return new RandomForestRegressionModelWriter(this);
    }

    public static final /* synthetic */ double $anonfun$transform$1(Broadcast bcastModel$1, Vector features) {
        return ((RandomForestRegressionModel)bcastModel$1.value()).predict(features);
    }

    public static final /* synthetic */ double $anonfun$predict$1(Vector features$1, DecisionTreeRegressionModel x$3) {
        return x$3.rootNode().predictImpl(features$1).prediction();
    }

    public RandomForestRegressionModel(String uid, DecisionTreeRegressionModel[] _trees, int numFeatures) {
        this.uid = uid;
        this._trees = _trees;
        this.numFeatures = numFeatures;
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        HasWeightCol.$init$(this);
        DecisionTreeParams.$init$(this);
        TreeEnsembleParams.$init$(this);
        RandomForestParams.$init$(this);
        TreeEnsembleRegressorParams.$init$(this);
        HasVarianceImpurity.$init$(this);
        TreeEnsembleModel.$init$(this);
        MLWritable.$init$(this);
        Predef$.MODULE$.require(ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])_trees)), (Function0 & Serializable)() -> "RandomForestRegressionModel requires at least 1 tree.");
        Statics.releaseFence();
    }

    public RandomForestRegressionModel(DecisionTreeRegressionModel[] trees, int numFeatures) {
        this(Identifiable$.MODULE$.randomUID("rfr"), trees, numFeatures);
    }

    private static class RandomForestRegressionModelReader
    extends MLReader<RandomForestRegressionModel> {
        private final String className = RandomForestRegressionModel.class.getName();
        private final String treeClassName = DecisionTreeRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        private String treeClassName() {
            return this.treeClassName;
        }

        @Override
        public RandomForestRegressionModel load(String path) {
            Tuple2[] tuple2Array;
            DefaultParamsReader.Metadata metadata;
            double[] treeWeights;
            DefaultFormats$ format;
            block3: {
                Tuple3<DefaultParamsReader.Metadata, Tuple2<DefaultParamsReader.Metadata, Node>[], double[]> tuple3;
                block2: {
                    format = DefaultFormats$.MODULE$;
                    tuple3 = EnsembleModelReadWrite$.MODULE$.loadImpl(path, this.sparkSession(), this.className(), this.treeClassName());
                    if (tuple3 == null) break block2;
                    DefaultParamsReader.Metadata metadata2 = (DefaultParamsReader.Metadata)tuple3._1();
                    Tuple2[] treesData = (Tuple2[])tuple3._2();
                    treeWeights = (double[])tuple3._3();
                    if (metadata2 == null) break block2;
                    metadata = metadata2;
                    if (treesData == null) break block2;
                    tuple2Array = treesData;
                    if (treeWeights != null) break block3;
                }
                throw new MatchError(tuple3);
            }
            double[] dArray = treeWeights;
            Tuple3 tuple3 = new Tuple3((Object)metadata, (Object)tuple2Array, (Object)dArray);
            Tuple3 tuple32 = tuple3;
            DefaultParamsReader.Metadata metadata3 = (DefaultParamsReader.Metadata)tuple32._1();
            Tuple2[] treesData = (Tuple2[])tuple32._2();
            double[] treeWeights2 = (double[])tuple32._3();
            int numFeatures = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numFeatures")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            int numTrees = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numTrees")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            DecisionTreeRegressionModel[] trees = (DecisionTreeRegressionModel[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])treesData), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DefaultParamsReader.Metadata treeMetadata = (DefaultParamsReader.Metadata)tuple2._1();
                Node root = (Node)tuple2._2();
                DecisionTreeRegressionModel tree = new DecisionTreeRegressionModel(treeMetadata.uid(), root, numFeatures);
                treeMetadata.getAndSetParams(tree, treeMetadata.getAndSetParams$default$2());
                DecisionTreeRegressionModel decisionTreeRegressionModel = tree;
                return decisionTreeRegressionModel;
            }, ClassTag$.MODULE$.apply(DecisionTreeRegressionModel.class));
            Predef$.MODULE$.require(numTrees == trees.length, (Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(42).append("RandomForestRegressionModel.load expected ").append(numTrees).toString()).append(new StringBuilder(42).append(" trees based on metadata but found ").append(trees.length).append(" trees.").toString()).toString());
            RandomForestRegressionModel model = new RandomForestRegressionModel(metadata3.uid(), trees, numFeatures);
            metadata3.getAndSetParams(model, metadata3.getAndSetParams$default$2());
            return model;
        }
    }

    public static class RandomForestRegressionModelWriter
    extends MLWriter {
        private final RandomForestRegressionModel instance;

        @Override
        public void saveImpl(String path) {
            JsonAST.JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFeatures"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numTrees"), (Object)BoxesRunTime.boxToInteger((int)this.instance.getNumTrees()))})), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
            EnsembleModelReadWrite$.MODULE$.saveImpl(this.instance, path, this.sparkSession(), extraMetadata);
        }

        public RandomForestRegressionModelWriter(RandomForestRegressionModel instance) {
            this.instance = instance;
        }
    }
}

