/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.MutableEnumeratedCoordinateField;
import breeze.math.MutableInnerProductModule;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.LBFGSB;
import breeze.optimize.LBFGSB$;
import breeze.optimize.OWLQN;
import breeze.optimize.StochasticDiffFunction;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.InstanceBlock;
import org.apache.spark.ml.feature.InstanceBlock$;
import org.apache.spark.ml.feature.StandardScalerModel$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.WeightedLeastSquares;
import org.apache.spark.ml.optim.WeightedLeastSquares$;
import org.apache.spark.ml.optim.WeightedLeastSquares$Auto$;
import org.apache.spark.ml.optim.WeightedLeastSquaresModel;
import org.apache.spark.ml.optim.aggregator.HuberBlockAggregator;
import org.apache.spark.ml.optim.aggregator.LeastSquaresBlockAggregator;
import org.apache.spark.ml.optim.loss.L2Regularization;
import org.apache.spark.ml.optim.loss.RDDLossFunction;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasElasticNetParam;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasLoss;
import org.apache.spark.ml.param.shared.HasMaxBlockSizeInMB;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasSolver;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.LinearRegression$;
import org.apache.spark.ml.regression.LinearRegressionModel;
import org.apache.spark.ml.regression.LinearRegressionParams;
import org.apache.spark.ml.regression.LinearRegressionTrainingSummary;
import org.apache.spark.ml.regression.Regressor;
import org.apache.spark.ml.stat.Summarizer$;
import org.apache.spark.ml.stat.SummarizerBuffer;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.Instrumentation$loggerTags$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.ml.util.OptionalInstrumentation$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Double$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r-a\u0001B\u0017/\u0001eB\u0001b\u0016\u0001\u0003\u0006\u0004%\t\u0005\u0017\u0005\t_\u0002\u0011\t\u0011)A\u00053\")\u0011\u000f\u0001C\u0001e\")\u0011\u000f\u0001C\u0001m\")!\u0010\u0001C\u0001w\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0001bBA\u000e\u0001\u0011\u0005\u0011Q\u0004\u0005\b\u0003G\u0001A\u0011AA\u0013\u0011\u001d\tY\u0003\u0001C\u0001\u0003[Aq!!\u000f\u0001\t\u0003\tY\u0004C\u0004\u0002B\u0001!\t!a\u0011\t\u000f\u00055\u0003\u0001\"\u0001\u0002P!9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0003bBA1\u0001\u0011\u0005\u00111\r\u0005\b\u0003[\u0002A\u0011AA8\u0011\u001d\t)\b\u0001C\u0001\u0003oBq!!!\u0001\t#\n\u0019\tC\u0004\u0002.\u0002!I!a,\t\u000f\u0005\u001d\u0007\u0001\"\u0003\u0002J\"9\u0011\u0011\u001d\u0001\u0005\n\u0005\r\bb\u0002B\r\u0001\u0011%!1\u0004\u0005\b\u0005c\u0002A\u0011\u0002B:\u0011\u001d\u0011\t\t\u0001C!\u0005\u0007;qA!'/\u0011\u0003\u0011YJ\u0002\u0004.]!\u0005!Q\u0014\u0005\u0007cf!\tAa/\t\u000f\tu\u0016\u0004\"\u0011\u0003@\"I!qY\rC\u0002\u0013\u0005!\u0011\u001a\u0005\t\u0005\u001bL\u0002\u0015!\u0003\u00022!Q!\u0011[\rC\u0002\u0013\u0005aFa5\t\u0011\t}\u0017\u0004)A\u0005\u0005+D!B!9\u001a\u0005\u0004%\tA\fBj\u0011!\u0011\u0019/\u0007Q\u0001\n\tU\u0007B\u0003Bs3\t\u0007I\u0011\u0001\u0018\u0003T\"A!q]\r!\u0002\u0013\u0011)\u000e\u0003\u0006\u0003jf\u0011\r\u0011\"\u0001/\u0005WD\u0001Ba<\u001aA\u0003%!Q\u001e\u0005\u000b\u0005cL\"\u0019!C\u0001]\tM\u0007\u0002\u0003Bz3\u0001\u0006IA!6\t\u0015\tU\u0018D1A\u0005\u00029\u0012\u0019\u000e\u0003\u0005\u0003xf\u0001\u000b\u0011\u0002Bk\u0011)\u0011I0\u0007b\u0001\n\u0003q#1\u001e\u0005\t\u0005wL\u0002\u0015!\u0003\u0003n\"I!Q`\r\u0002\u0002\u0013%!q \u0002\u0011\u0019&tW-\u0019:SK\u001e\u0014Xm]:j_:T!a\f\u0019\u0002\u0015I,wM]3tg&|gN\u0003\u00022e\u0005\u0011Q\u000e\u001c\u0006\u0003gQ\nQa\u001d9be.T!!\u000e\u001c\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0014aA8sO\u000e\u00011#\u0002\u0001;\u0011.\u000b\u0006#B\u001e=}\u0011+U\"\u0001\u0018\n\u0005ur#!\u0003*fOJ,7o]8s!\ty$)D\u0001A\u0015\t\t\u0005'\u0001\u0004mS:\fGnZ\u0005\u0003\u0007\u0002\u0013aAV3di>\u0014\bCA\u001e\u0001!\tYd)\u0003\u0002H]\t)B*\u001b8fCJ\u0014Vm\u001a:fgNLwN\\'pI\u0016d\u0007CA\u001eJ\u0013\tQeF\u0001\fMS:,\u0017M\u001d*fOJ,7o]5p]B\u000b'/Y7t!\tau*D\u0001N\u0015\tq\u0005'\u0001\u0003vi&d\u0017B\u0001)N\u0005U!UMZ1vYR\u0004\u0016M]1ng^\u0013\u0018\u000e^1cY\u0016\u0004\"AU+\u000e\u0003MS!\u0001\u0016\u001a\u0002\u0011%tG/\u001a:oC2L!AV*\u0003\u000f1{wmZ5oO\u0006\u0019Q/\u001b3\u0016\u0003e\u0003\"AW2\u000f\u0005m\u000b\u0007C\u0001/`\u001b\u0005i&B\u000109\u0003\u0019a$o\\8u})\t\u0001-A\u0003tG\u0006d\u0017-\u0003\u0002c?\u00061\u0001K]3eK\u001aL!\u0001Z3\u0003\rM#(/\u001b8h\u0015\t\u0011w\fK\u0002\u0002O6\u0004\"\u0001[6\u000e\u0003%T!A\u001b\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002mS\n)1+\u001b8dK\u0006\na.A\u00032]Mr\u0003'\u0001\u0003vS\u0012\u0004\u0003f\u0001\u0002h[\u00061A(\u001b8jiz\"\"\u0001R:\t\u000b]\u001b\u0001\u0019A-)\u0007M<W\u000eK\u0002\u0004O6$\u0012\u0001\u0012\u0015\u0004\t\u001dD\u0018%A=\u0002\u000bErCG\f\u0019\u0002\u0017M,GOU3h!\u0006\u0014\u0018-\u001c\u000b\u0003yvl\u0011\u0001\u0001\u0005\u0006}\u0016\u0001\ra`\u0001\u0006m\u0006dW/\u001a\t\u0005\u0003\u0003\t\u0019!D\u0001`\u0013\r\t)a\u0018\u0002\u0007\t>,(\r\\3)\u0007\u00159W.A\btKR4\u0015\u000e^%oi\u0016\u00148-\u001a9u)\ra\u0018Q\u0002\u0005\u0007}\u001a\u0001\r!a\u0004\u0011\t\u0005\u0005\u0011\u0011C\u0005\u0004\u0003'y&a\u0002\"p_2,\u0017M\u001c\u0015\u0005\r\u001d\f9\"\t\u0002\u0002\u001a\u0005)\u0011GL\u001b/a\u0005\u00112/\u001a;Ti\u0006tG-\u0019:eSj\fG/[8o)\ra\u0018q\u0004\u0005\u0007}\u001e\u0001\r!a\u0004)\t\u001d9\u0017qC\u0001\u0013g\u0016$X\t\\1ti&\u001cg*\u001a;QCJ\fW\u000eF\u0002}\u0003OAQA \u0005A\u0002}D3\u0001C4y\u0003)\u0019X\r^'bq&#XM\u001d\u000b\u0004y\u0006=\u0002B\u0002@\n\u0001\u0004\t\t\u0004\u0005\u0003\u0002\u0002\u0005M\u0012bAA\u001b?\n\u0019\u0011J\u001c;)\u0007%9W.\u0001\u0004tKR$v\u000e\u001c\u000b\u0004y\u0006u\u0002\"\u0002@\u000b\u0001\u0004y\bf\u0001\u0006hq\u0006a1/\u001a;XK&<\u0007\u000e^\"pYR\u0019A0!\u0012\t\u000by\\\u0001\u0019A-)\t-9\u0017\u0011J\u0011\u0003\u0003\u0017\nQ!\r\u00187]A\n\u0011b]3u'>dg/\u001a:\u0015\u0007q\f\t\u0006C\u0003\u007f\u0019\u0001\u0007\u0011\f\u000b\u0003\rO\u0006%\u0013aE:fi\u0006;wM]3hCRLwN\u001c#faRDGc\u0001?\u0002Z!1a0\u0004a\u0001\u0003cAC!D4\u0002^\u0005\u0012\u0011qL\u0001\u0006e9\nd\u0006M\u0001\bg\u0016$Hj\\:t)\ra\u0018Q\r\u0005\u0006}:\u0001\r!\u0017\u0015\u0005\u001d\u001d\fI'\t\u0002\u0002l\u0005)!GL\u001a/a\u0005Q1/\u001a;FaNLGn\u001c8\u0015\u0007q\f\t\bC\u0003\u007f\u001f\u0001\u0007q\u0010\u000b\u0003\u0010O\u0006%\u0014aE:fi6\u000b\u0007P\u00117pG.\u001c\u0016N_3J]6\u0013Ec\u0001?\u0002z!)a\u0010\u0005a\u0001\u007f\"\"\u0001cZA?C\t\ty(A\u00034]Er\u0003'A\u0003ue\u0006Lg\u000eF\u0002F\u0003\u000bCq!a\"\u0012\u0001\u0004\tI)A\u0004eCR\f7/\u001a;1\t\u0005-\u00151\u0014\t\u0007\u0003\u001b\u000b\u0019*a&\u000e\u0005\u0005=%bAAIe\u0005\u00191/\u001d7\n\t\u0005U\u0015q\u0012\u0002\b\t\u0006$\u0018m]3u!\u0011\tI*a'\r\u0001\u0011a\u0011QTAC\u0003\u0003\u0005\tQ!\u0001\u0002 \n\u0019q\fJ\u0019\u0012\t\u0005\u0005\u0016q\u0015\t\u0005\u0003\u0003\t\u0019+C\u0002\u0002&~\u0013qAT8uQ&tw\r\u0005\u0003\u0002\u0002\u0005%\u0016bAAV?\n\u0019\u0011I\\=\u0002\u001fQ\u0014\u0018-\u001b8XSRDgj\u001c:nC2$R!RAY\u0003{Cq!a\"\u0013\u0001\u0004\t\u0019\f\r\u0003\u00026\u0006e\u0006CBAG\u0003'\u000b9\f\u0005\u0003\u0002\u001a\u0006eF\u0001DA^\u0003c\u000b\t\u0011!A\u0003\u0002\u0005}%aA0%e!9\u0011q\u0018\nA\u0002\u0005\u0005\u0017!B5ogR\u0014\bc\u0001'\u0002D&\u0019\u0011QY'\u0003\u001f%s7\u000f\u001e:v[\u0016tG/\u0019;j_:\fa\u0003\u001e:bS:<\u0016\u000e\u001e5D_:\u001cH/\u00198u\u0019\u0006\u0014W\r\u001c\u000b\n\u000b\u0006-\u0017q[Am\u0003;Dq!a\"\u0014\u0001\u0004\ti\r\r\u0003\u0002P\u0006M\u0007CBAG\u0003'\u000b\t\u000e\u0005\u0003\u0002\u001a\u0006MG\u0001DAk\u0003\u0017\f\t\u0011!A\u0003\u0002\u0005}%aA0%g!9\u0011qX\nA\u0002\u0005\u0005\u0007bBAn'\u0001\u0007\u0011\u0011G\u0001\f]Vlg)Z1ukJ,7\u000f\u0003\u0004\u0002`N\u0001\ra`\u0001\u0006s6+\u0017M\\\u0001\u0010GJ,\u0017\r^3PaRLW.\u001b>feRQ\u0011Q\u001dB\u0003\u0005\u0013\u0011iAa\u0004\u0011\u0011\u0005\u001d\u0018\u0011_A{\u0003\u007fl!!!;\u000b\t\u0005-\u0018Q^\u0001\t_B$\u0018.\\5{K*\u0011\u0011q^\u0001\u0007EJ,WM_3\n\t\u0005M\u0018\u0011\u001e\u0002\u0014\r&\u00148\u000f^(sI\u0016\u0014X*\u001b8j[&TXM\u001d\t\u0006\u0003o\fYp`\u0007\u0003\u0003sT1!QAw\u0013\u0011\ti0!?\u0003\u0017\u0011+gn]3WK\u000e$xN\u001d\t\u0007\u0003O\u0014\t!!>\n\t\t\r\u0011\u0011\u001e\u0002\r\t&4gMR;oGRLwN\u001c\u0005\u0007\u0005\u000f!\u0002\u0019A@\u0002#\u00154g-Z2uSZ,'+Z4QCJ\fW\u000e\u0003\u0004\u0003\fQ\u0001\ra`\u0001\u0014K\u001a4Wm\u0019;jm\u0016d\u0015GU3h!\u0006\u0014\u0018-\u001c\u0005\b\u00037$\u0002\u0019AA\u0019\u0011\u001d\u0011\t\u0002\u0006a\u0001\u0005'\t1BZ3biV\u0014Xm]*uIB)\u0011\u0011\u0001B\u000b\u007f&\u0019!qC0\u0003\u000b\u0005\u0013(/Y=\u0002\u0013Q\u0014\u0018-\u001b8J[BdG\u0003\u0006B\u000f\u0005G\u0011yDa\u0011\u0003F\t%#Q\nB(\u0005'\u0012i\u0007\u0005\u0005\u0002\u0002\t}!1\u0003B\n\u0013\r\u0011\tc\u0018\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\t\u0015R\u00031\u0001\u0003(\u0005I\u0011N\\:uC:\u001cWm\u001d\t\u0007\u0005S\u0011yCa\r\u000e\u0005\t-\"b\u0001B\u0017e\u0005\u0019!\u000f\u001a3\n\t\tE\"1\u0006\u0002\u0004%\u0012#\u0005\u0003\u0002B\u001b\u0005wi!Aa\u000e\u000b\u0007\te\u0002'A\u0004gK\u0006$XO]3\n\t\tu\"q\u0007\u0002\t\u0013:\u001cH/\u00198dK\"1!\u0011I\u000bA\u0002}\f1#Y2uk\u0006d'\t\\8dWNK'0Z%o\u001b\nCa!a8\u0016\u0001\u0004y\bB\u0002B$+\u0001\u0007q0\u0001\u0003z'R$\u0007b\u0002B&+\u0001\u0007!1C\u0001\rM\u0016\fG/\u001e:fg6+\u0017M\u001c\u0005\b\u0005#)\u0002\u0019\u0001B\n\u0011\u001d\u0011\t&\u0006a\u0001\u0005'\tq\"\u001b8ji&\fGnU8mkRLwN\u001c\u0005\b\u0005+*\u0002\u0019\u0001B,\u00039\u0011XmZ;mCJL'0\u0019;j_:\u0004b!!\u0001\u0003Z\tu\u0013b\u0001B.?\n1q\n\u001d;j_:\u0004BAa\u0018\u0003j5\u0011!\u0011\r\u0006\u0005\u0005G\u0012)'\u0001\u0003m_N\u001c(b\u0001B4a\u0005)q\u000e\u001d;j[&!!1\u000eB1\u0005Aa%GU3hk2\f'/\u001b>bi&|g\u000eC\u0004\u0003pU\u0001\r!!:\u0002\u0013=\u0004H/[7ju\u0016\u0014\u0018aC2sK\u0006$X-T8eK2$2\"\u0012B;\u0005s\u0012YH! \u0003\u0000!9!q\u000f\fA\u0002\tM\u0011\u0001C:pYV$\u0018n\u001c8\t\r\u0005}g\u00031\u0001\u0000\u0011\u0019\u00119E\u0006a\u0001\u007f\"9!1\n\fA\u0002\tM\u0001b\u0002B\t-\u0001\u0007!1C\u0001\u0005G>\u0004\u0018\u0010F\u0002E\u0005\u000bCqAa\"\u0018\u0001\u0004\u0011I)A\u0003fqR\u0014\u0018\r\u0005\u0003\u0003\f\nEUB\u0001BG\u0015\r\u0011y\tM\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u0005'\u0013iI\u0001\u0005QCJ\fW.T1qQ\r9r\r\u001f\u0015\u0004\u0001\u001dl\u0017\u0001\u0005'j]\u0016\f'OU3he\u0016\u001c8/[8o!\tY\u0014dE\u0004\u001a\u0005?\u0013)Ka+\u0011\t\u0005\u0005!\u0011U\u0005\u0004\u0005G{&AB!osJ+g\r\u0005\u0003M\u0005O#\u0015b\u0001BU\u001b\n)B)\u001a4bk2$\b+\u0019:b[N\u0014V-\u00193bE2,\u0007\u0003\u0002BW\u0005ok!Aa,\u000b\t\tE&1W\u0001\u0003S>T!A!.\u0002\t)\fg/Y\u0005\u0005\u0005s\u0013yK\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0003\u001c\u0006!An\\1e)\r!%\u0011\u0019\u0005\u0007\u0005\u0007\\\u0002\u0019A-\u0002\tA\fG\u000f\u001b\u0015\u00057\u001d\fI%\u0001\u0010N\u0003b{f)R!U+J+5k\u0018$P%~suJU'B\u0019~\u001bv\n\u0014,F%V\u0011\u0011\u0011\u0007\u0015\u00059\u001d\fi&A\u0010N\u0003b{f)R!U+J+5k\u0018$P%~suJU'B\u0019~\u001bv\n\u0014,F%\u0002BC!H4\u0002^\u0005!\u0011)\u001e;p+\t\u0011)\u000e\u0005\u0003\u0003X\nuWB\u0001Bm\u0015\u0011\u0011YNa-\u0002\t1\fgnZ\u0005\u0004I\ne\u0017!B!vi>\u0004\u0013A\u0002(pe6\fG.A\u0004O_Jl\u0017\r\u001c\u0011\u0002\u000b1\u0013eiR*\u0002\r1\u0013eiR*!\u0003A\u0019X\u000f\u001d9peR,GmU8mm\u0016\u00148/\u0006\u0002\u0003nB1\u0011\u0011\u0001B\u000b\u0005+\f\u0011c];qa>\u0014H/\u001a3T_24XM]:!\u00031\u0019\u0016/^1sK\u0012,%O]8s\u00035\u0019\u0016/^1sK\u0012,%O]8sA\u0005)\u0001*\u001e2fe\u00061\u0001*\u001e2fe\u0002\nqb];qa>\u0014H/\u001a3M_N\u001cXm]\u0001\u0011gV\u0004\bo\u001c:uK\u0012dun]:fg\u0002\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"a!\u0001\u0011\t\t]71A\u0005\u0005\u0007\u000b\u0011IN\u0001\u0004PE*,7\r\u001e\u0015\u00053\u001d\fI\u0005\u000b\u0003\u0019O\u0006%\u0003")
public class LinearRegression
extends Regressor<Vector, LinearRegression, LinearRegressionModel>
implements LinearRegressionParams,
DefaultParamsWritable {
    private final String uid;
    private Param<String> solver;
    private Param<String> loss;
    private DoubleParam epsilon;
    private DoubleParam maxBlockSizeInMB;
    private IntParam aggregationDepth;
    private Param<String> weightCol;
    private BooleanParam standardization;
    private BooleanParam fitIntercept;
    private DoubleParam tol;
    private IntParam maxIter;
    private DoubleParam elasticNetParam;
    private DoubleParam regParam;

    public static int MAX_FEATURES_FOR_NORMAL_SOLVER() {
        return LinearRegression$.MODULE$.MAX_FEATURES_FOR_NORMAL_SOLVER();
    }

    public static LinearRegression load(String string) {
        return LinearRegression$.MODULE$.load(string);
    }

    public static MLReader<LinearRegression> read() {
        return LinearRegression$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$regression$LinearRegressionParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public double getEpsilon() {
        return LinearRegressionParams.getEpsilon$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return LinearRegressionParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final double getMaxBlockSizeInMB() {
        return HasMaxBlockSizeInMB.getMaxBlockSizeInMB$(this);
    }

    @Override
    public final String getLoss() {
        return HasLoss.getLoss$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getSolver() {
        return HasSolver.getSolver$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization.getStandardization$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam.getElasticNetParam$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final Param<String> loss() {
        return this.loss;
    }

    @Override
    public final DoubleParam epsilon() {
        return this.epsilon;
    }

    @Override
    public final void org$apache$spark$ml$regression$LinearRegressionParams$_setter_$solver_$eq(Param<String> x$1) {
        this.solver = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$LinearRegressionParams$_setter_$loss_$eq(Param<String> x$1) {
        this.loss = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$LinearRegressionParams$_setter_$epsilon_$eq(DoubleParam x$1) {
        this.epsilon = x$1;
    }

    @Override
    public final DoubleParam maxBlockSizeInMB() {
        return this.maxBlockSizeInMB;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxBlockSizeInMB$_setter_$maxBlockSizeInMB_$eq(DoubleParam x$1) {
        this.maxBlockSizeInMB = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasLoss$_setter_$loss_$eq(Param<String> x$1) {
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param<String> x$1) {
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public LinearRegression setRegParam(double value) {
        return (LinearRegression)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearRegression setFitIntercept(boolean value) {
        return (LinearRegression)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LinearRegression setStandardization(boolean value) {
        return (LinearRegression)this.set(this.standardization(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LinearRegression setElasticNetParam(double value) {
        return (LinearRegression)this.set(this.elasticNetParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearRegression setMaxIter(int value) {
        return (LinearRegression)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public LinearRegression setTol(double value) {
        return (LinearRegression)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearRegression setWeightCol(String value) {
        return (LinearRegression)this.set(this.weightCol(), value);
    }

    public LinearRegression setSolver(String value) {
        return (LinearRegression)this.set(this.solver(), value);
    }

    public LinearRegression setAggregationDepth(int value) {
        return (LinearRegression)this.set(this.aggregationDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    public LinearRegression setLoss(String value) {
        return (LinearRegression)this.set(this.loss(), value);
    }

    public LinearRegression setEpsilon(double value) {
        return (LinearRegression)this.set(this.epsilon(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearRegression setMaxBlockSizeInMB(double value) {
        return (LinearRegression)this.set(this.maxBlockSizeInMB(), BoxesRunTime.boxToDouble((double)value));
    }

    @Override
    public LinearRegressionModel train(Dataset<?> dataset) {
        LinearRegressionModel linearRegressionModel;
        Object object = new Object();
        try {
            linearRegressionModel = (LinearRegressionModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable)instr -> {
                double[] dArray;
                None$ none$;
                double d;
                RDD instances;
                Tuple2<SummarizerBuffer, SummarizerBuffer> tuple2;
                int numFeatures;
                block22: {
                    block23: {
                        instr.logPipelineStage(this);
                        instr.logDataset(dataset);
                        instr.logParams(this, (Seq<Param<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Param[]{this.labelCol(), this.featuresCol(), this.weightCol(), this.predictionCol(), this.solver(), this.tol(), this.elasticNetParam(), this.fitIntercept(), this.maxIter(), this.regParam(), this.standardization(), this.aggregationDepth(), this.loss(), this.epsilon(), this.maxBlockSizeInMB()}));
                        StorageLevel storageLevel = dataset.storageLevel();
                        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
                        if (storageLevel == null ? storageLevel2 != null : !storageLevel.equals(storageLevel2)) {
                            instr.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Input instances will be standardized, blockified to blocks, and ").append("then cached during training. Be careful of double caching!").toString());
                        }
                        numFeatures = MetadataUtils$.MODULE$.getNumFeatures(dataset, this.$(this.featuresCol()));
                        instr.logNumFeatures(numFeatures);
                        String string = this.$(this.loss());
                        String string2 = LinearRegression$.MODULE$.SquaredError();
                        if (string != null ? !string.equals(string2) : string2 != null) break block22;
                        String string3 = this.$(this.solver());
                        String string4 = LinearRegression$.MODULE$.Auto();
                        if (!(string3 != null ? !string3.equals(string4) : string4 != null) && numFeatures <= WeightedLeastSquares$.MODULE$.MAX_NUM_FEATURES()) break block23;
                        String string5 = this.$(this.solver());
                        String string6 = LinearRegression$.MODULE$.Normal();
                        if (string5 != null ? !string5.equals(string6) : string6 != null) break block22;
                    }
                    throw new NonLocalReturnControl(object, (Object)this.trainWithNormal(dataset, (Instrumentation)instr));
                }
                if ((tuple2 = Summarizer$.MODULE$.getRegressionSummarizers((RDD<Instance>)(instances = this.extractInstances(dataset).setName("training instances")), BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), (Seq<String>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mean", "std", "count"}))))) == null) {
                    throw new MatchError(tuple2);
                }
                SummarizerBuffer summarizer = (SummarizerBuffer)tuple2._1();
                SummarizerBuffer labelSummarizer = (SummarizerBuffer)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)summarizer, (Object)labelSummarizer);
                Tuple2 tuple23 = tuple22;
                SummarizerBuffer summarizer2 = (SummarizerBuffer)tuple23._1();
                SummarizerBuffer labelSummarizer2 = (SummarizerBuffer)tuple23._2();
                double yMean = labelSummarizer2.mean().apply(0);
                double rawYStd = labelSummarizer2.std().apply(0);
                instr.logNumExamples(labelSummarizer2.count());
                instr.logNamedValue(Instrumentation$loggerTags$.MODULE$.meanOfLabels(), yMean);
                instr.logNamedValue(Instrumentation$loggerTags$.MODULE$.varianceOfLabels(), rawYStd);
                instr.logSumOfWeights(summarizer2.weightSum());
                double actualBlockSizeInMB = BoxesRunTime.unboxToDouble((Object)this.$(this.maxBlockSizeInMB()));
                if (actualBlockSizeInMB == 0.0) {
                    actualBlockSizeInMB = InstanceBlock$.MODULE$.DefaultBlockSizeInMB();
                    Predef$.MODULE$.require(actualBlockSizeInMB > 0.0, (Function0 & Serializable)() -> "inferred actual BlockSizeInMB must > 0");
                    instr.logNamedValue("actualBlockSizeInMB", Double.toString(actualBlockSizeInMB));
                }
                if (rawYStd == 0.0) {
                    if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) || yMean == 0.0) {
                        throw new NonLocalReturnControl(object, (Object)this.trainWithConstantLabel(dataset, (Instrumentation)instr, numFeatures, yMean));
                    }
                    Predef$.MODULE$.require(BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) == 0.0, (Function0 & Serializable)() -> "The standard deviation of the label is zero. Model cannot be regularized.");
                    instr.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("The standard deviation of the label is zero. ").append("Consider setting fitIntercept=true.").toString());
                }
                double yStd = rawYStd > 0.0 ? rawYStd : package$.MODULE$.abs(yMean);
                double[] featuresMean = summarizer2.mean().toArray();
                double[] featuresStd = summarizer2.std().toArray();
                if (!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numFeatures).exists((Function1)(JFunction1.mcZI.sp & Serializable)i -> featuresStd[i] == 0.0 && featuresMean[i] != 0.0)) {
                    instr.logWarning((Function0<String>)(Function0 & Serializable)() -> "Fitting LinearRegressionModel without intercept on dataset with constant nonzero column, Spark MLlib outputs zero coefficients for constant nonzero columns. This behavior is the same as R glmnet but different from LIBSVM.");
                }
                String string = this.$(this.loss());
                String string7 = LinearRegression$.MODULE$.SquaredError();
                String string8 = string;
                if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                    d = BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) / yStd;
                } else {
                    String string9 = LinearRegression$.MODULE$.Huber();
                    String string10 = string;
                    if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                        d = BoxesRunTime.unboxToDouble((Object)this.$(this.regParam()));
                    } else {
                        throw new MatchError((Object)string);
                    }
                }
                double effectiveRegParam = d;
                double effectiveL1RegParam = BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) * effectiveRegParam;
                double effectiveL2RegParam = (1.0 - BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam()))) * effectiveRegParam;
                JFunction1.mcDI.sp & Serializable getFeaturesStd = (JFunction1.mcDI.sp & Serializable)j -> j >= 0 && j < numFeatures ? featuresStd[j] : 0.0;
                if (effectiveL2RegParam != 0.0) {
                    JFunction1.mcZI.sp & Serializable shouldApply = (JFunction1.mcZI.sp & Serializable)idx -> idx >= 0 && idx < numFeatures;
                    none$ = new Some((Object)new L2Regularization(effectiveL2RegParam, (Function1<Object, Object>)shouldApply, (Option<Function1<Object, Object>>)(BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization())) ? None$.MODULE$ : new Some((Object)getFeaturesStd))));
                } else {
                    none$ = None$.MODULE$;
                }
                None$ regularization = none$;
                FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>> optimizer = this.createOptimizer(effectiveRegParam, effectiveL1RegParam, numFeatures, featuresStd);
                String string11 = this.$(this.loss());
                String string12 = LinearRegression$.MODULE$.SquaredError();
                String string13 = string11;
                if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                    dArray = (double[])Array$.MODULE$.ofDim(numFeatures, (ClassTag)ClassTag$.MODULE$.Double());
                } else {
                    String string14 = LinearRegression$.MODULE$.Huber();
                    String string15 = string11;
                    if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                        int dim = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? numFeatures + 2 : numFeatures + 1;
                        dArray = (double[])Array$.MODULE$.fill(dim, (Function0)(JFunction0.mcD.sp & Serializable)() -> 1.0, (ClassTag)ClassTag$.MODULE$.Double());
                    } else {
                        throw new MatchError((Object)string11);
                    }
                }
                double[] initialSolution = dArray;
                Tuple2<double[], double[]> tuple24 = this.trainImpl((RDD<Instance>)instances, actualBlockSizeInMB, yMean, yStd, featuresMean, featuresStd, initialSolution, (Option<L2Regularization>)regularization, optimizer);
                if (tuple24 == null) {
                    throw new MatchError(tuple24);
                }
                double[] parameters = (double[])tuple24._1();
                double[] objectiveHistory = (double[])tuple24._2();
                Tuple2 tuple25 = new Tuple2((Object)parameters, (Object)objectiveHistory);
                Tuple2 tuple26 = tuple25;
                double[] parameters2 = (double[])tuple26._1();
                double[] objectiveHistory2 = (double[])tuple26._2();
                if (parameters2 == null) {
                    String msg = new StringBuilder(8).append(optimizer.getClass().getName()).append(" failed.").toString();
                    instr.logError((Function0<String>)(Function0 & Serializable)() -> msg);
                    throw new SparkException(msg);
                }
                LinearRegressionModel model = this.createModel(parameters2, yMean, yStd, featuresMean, featuresStd);
                Tuple2<LinearRegressionModel, String> tuple27 = model.findSummaryModelAndPredictionCol();
                if (tuple27 == null) {
                    throw new MatchError(tuple27);
                }
                LinearRegressionModel summaryModel = (LinearRegressionModel)tuple27._1();
                String predictionColName = (String)tuple27._2();
                Tuple2 tuple28 = new Tuple2((Object)summaryModel, (Object)predictionColName);
                Tuple2 tuple29 = tuple28;
                LinearRegressionModel summaryModel2 = (LinearRegressionModel)tuple29._1();
                String predictionColName2 = (String)tuple29._2();
                LinearRegressionTrainingSummary trainingSummary = new LinearRegressionTrainingSummary(summaryModel2.transform(dataset), predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), model, new double[]{0.0}, objectiveHistory2);
                return (LinearRegressionModel)model.setSummary((Option<LinearRegressionTrainingSummary>)new Some((Object)trainingSummary));
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                linearRegressionModel = (LinearRegressionModel)ex.value();
            }
            throw ex;
        }
        return linearRegressionModel;
    }

    private LinearRegressionModel trainWithNormal(Dataset<?> dataset, Instrumentation instr) {
        WeightedLeastSquares optimizer = new WeightedLeastSquares(BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())), BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())), BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization())), true, WeightedLeastSquares$Auto$.MODULE$, BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), BoxesRunTime.unboxToDouble((Object)this.$(this.tol())));
        RDD instances = this.extractInstances(dataset).setName("training instances");
        WeightedLeastSquaresModel model = optimizer.fit((RDD<Instance>)instances, OptionalInstrumentation$.MODULE$.create(instr), optimizer.fit$default$3());
        LinearRegressionModel lrModel = this.copyValues(new LinearRegressionModel(this.uid(), (Vector)model.coefficients(), model.intercept()), this.copyValues$default$2());
        Tuple2<LinearRegressionModel, String> tuple2 = lrModel.findSummaryModelAndPredictionCol();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        LinearRegressionModel summaryModel = (LinearRegressionModel)tuple2._1();
        String predictionColName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)summaryModel, (Object)predictionColName);
        Tuple2 tuple23 = tuple22;
        LinearRegressionModel summaryModel2 = (LinearRegressionModel)tuple23._1();
        String predictionColName2 = (String)tuple23._2();
        LinearRegressionTrainingSummary trainingSummary = new LinearRegressionTrainingSummary(summaryModel2.transform(dataset), predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), summaryModel2, model.diagInvAtWA().toArray(), model.objectiveHistory());
        return (LinearRegressionModel)lrModel.setSummary((Option<LinearRegressionTrainingSummary>)new Some((Object)trainingSummary));
    }

    private LinearRegressionModel trainWithConstantLabel(Dataset<?> dataset, Instrumentation instr, int numFeatures, double yMean) {
        if (yMean == 0.0) {
            instr.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Mean and standard deviation of the label are zero, so the ").append("coefficients and the intercept will all be zero; as a result, training is not ").append("needed.").toString());
        } else {
            instr.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("The standard deviation of the label is zero, so the coefficients ").append("will be zeros and the intercept will be the mean of the label; as a result, ").append("training is not needed.").toString());
        }
        Vector coefficients = Vectors$.MODULE$.sparse(numFeatures, (Seq)scala.package$.MODULE$.Seq().empty());
        double intercept = yMean;
        LinearRegressionModel model = this.copyValues(new LinearRegressionModel(this.uid(), coefficients, intercept), this.copyValues$default$2());
        Tuple2<LinearRegressionModel, String> tuple2 = model.findSummaryModelAndPredictionCol();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        LinearRegressionModel summaryModel = (LinearRegressionModel)tuple2._1();
        String predictionColName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)summaryModel, (Object)predictionColName);
        Tuple2 tuple23 = tuple22;
        LinearRegressionModel summaryModel2 = (LinearRegressionModel)tuple23._1();
        String predictionColName2 = (String)tuple23._2();
        LinearRegressionTrainingSummary trainingSummary = new LinearRegressionTrainingSummary(summaryModel2.transform(dataset), predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), model, new double[]{0.0}, new double[]{0.0});
        return (LinearRegressionModel)model.setSummary((Option<LinearRegressionTrainingSummary>)new Some((Object)trainingSummary));
    }

    private FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>> createOptimizer(double effectiveRegParam, double effectiveL1RegParam, int numFeatures, double[] featuresStd) {
        LBFGS lBFGS;
        String string = this.$(this.loss());
        String string2 = LinearRegression$.MODULE$.SquaredError();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            LBFGS lBFGS2;
            if (BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) == 0.0 || effectiveRegParam == 0.0) {
                lBFGS2 = new LBFGS(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableInnerProductModule)DenseVector$.MODULE$.space_Double());
            } else {
                boolean standardizationParam = BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization()));
                lBFGS2 = new OWLQN(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, LinearRegression.effectiveL1RegFun$1(standardizationParam, effectiveL1RegParam, featuresStd), BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableEnumeratedCoordinateField)DenseVector$.MODULE$.space_Double());
            }
            lBFGS = lBFGS2;
        } else {
            String string4 = LinearRegression$.MODULE$.Huber();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                int dim = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? numFeatures + 2 : numFeatures + 1;
                DenseVector lowerBounds = DenseVector$.MODULE$.apply(Array$.MODULE$.fill(dim, (Function0)(JFunction0.mcD.sp & Serializable)() -> Double$.MODULE$.MinValue(), (ClassTag)ClassTag$.MODULE$.Double()));
                lowerBounds.update$mcD$sp(dim - 1, Double.MIN_VALUE);
                DenseVector upperBounds = DenseVector$.MODULE$.apply(Array$.MODULE$.fill(dim, (Function0)(JFunction0.mcD.sp & Serializable)() -> Double.MAX_VALUE, (ClassTag)ClassTag$.MODULE$.Double()));
                lBFGS = new LBFGSB(lowerBounds, upperBounds, BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), LBFGSB$.MODULE$.$lessinit$greater$default$6(), LBFGSB$.MODULE$.$lessinit$greater$default$7());
            } else {
                throw new MatchError((Object)string);
            }
        }
        return lBFGS;
    }

    private Tuple2<double[], double[]> trainImpl(RDD<Instance> instances, double actualBlockSizeInMB, double yMean, double yStd, double[] featuresMean, double[] featuresStd, double[] initialSolution, Option<L2Regularization> regularization, FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>> optimizer) {
        double[] solution;
        RDDLossFunction rDDLossFunction;
        int numFeatures = featuresStd.length;
        double[] inverseStd = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(featuresStd), (Function1)(JFunction1.mcDD.sp & Serializable)std -> std != 0.0 ? 1.0 / std : 0.0, (ClassTag)ClassTag$.MODULE$.Double());
        double[] scaledMean = (double[])Array$.MODULE$.tabulate(numFeatures, (Function1)(JFunction1.mcDI.sp & Serializable)i -> inverseStd[i] * featuresMean[i], (ClassTag)ClassTag$.MODULE$.Double());
        Broadcast bcInverseStd = instances.context().broadcast((Object)inverseStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast bcScaledMean = instances.context().broadcast((Object)scaledMean, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        RDD standardized = instances.mapPartitions((Function1 & Serializable)iter -> {
            Function1<Vector, Vector> func = StandardScalerModel$.MODULE$.getTransformFunc((double[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Double()), (double[])bcInverseStd.value(), false, true);
            return iter.map((Function1 & Serializable)x0$1 -> {
                Instance instance = x0$1;
                if (instance == null) {
                    throw new MatchError((Object)instance);
                }
                double label = instance.label();
                double weight = instance.weight();
                Vector vec = instance.features();
                Instance instance2 = new Instance(label, weight, (Vector)func.apply((Object)vec));
                return instance2;
            });
        }, instances.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Instance.class));
        long maxMemUsage = (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(actualBlockSizeInMB * (double)1024L * (double)1024L));
        RDD blocks = InstanceBlock$.MODULE$.blokifyWithMaxMemUsage((RDD<Instance>)standardized, maxMemUsage).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()).setName(new StringBuilder(34).append(this.uid()).append(": training blocks (blockSizeInMB=").append(actualBlockSizeInMB).append(")").toString());
        if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) {
            String string = this.$(this.loss());
            String string2 = LinearRegression$.MODULE$.Huber();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                double adapt = BLAS$.MODULE$.javaBLAS().ddot(numFeatures, initialSolution, 1, scaledMean, 1);
                initialSolution[numFeatures] = initialSolution[numFeatures] + adapt;
            }
        }
        String string = this.$(this.loss());
        String string3 = LinearRegression$.MODULE$.SquaredError();
        String string4 = string;
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            Function1 & Serializable getAggregatorFunc = (Function1 & Serializable)x$6 -> new LeastSquaresBlockAggregator((Broadcast<double[]>)bcInverseStd, (Broadcast<double[]>)bcScaledMean, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), yStd, yMean, (Broadcast<Vector>)x$6);
            rDDLossFunction = new RDDLossFunction(blocks, getAggregatorFunc, regularization, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(InstanceBlock.class), ClassTag$.MODULE$.apply(LeastSquaresBlockAggregator.class));
        } else {
            String string5 = LinearRegression$.MODULE$.Huber();
            String string6 = string;
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                Function1 & Serializable getAggregatorFunc = (Function1 & Serializable)x$7 -> new HuberBlockAggregator((Broadcast<double[]>)bcInverseStd, (Broadcast<double[]>)bcScaledMean, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), BoxesRunTime.unboxToDouble((Object)this.$(this.epsilon())), (Broadcast<Vector>)x$7);
                rDDLossFunction = new RDDLossFunction(blocks, getAggregatorFunc, regularization, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(InstanceBlock.class), ClassTag$.MODULE$.apply(HuberBlockAggregator.class));
            } else {
                throw new MatchError((Object)string);
            }
        }
        RDDLossFunction costFun = rDDLossFunction;
        Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction(costFun, DenseVector$.MODULE$.canCopyDenseVector((ClassTag)ClassTag$.MODULE$.Double())), (Object)new DenseVector.mcD.sp(initialSolution));
        ArrayBuilder arrayBuilder = ArrayBuilder$.MODULE$.make((ClassTag)ClassTag$.MODULE$.Double());
        FirstOrderMinimizer.State state = null;
        while (states.hasNext()) {
            state = (FirstOrderMinimizer.State)states.next();
            arrayBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)state.adjustedValue()));
        }
        blocks.unpersist(blocks.unpersist$default$1());
        bcInverseStd.destroy();
        bcScaledMean.destroy();
        double[] dArray = solution = state == null ? null : ((DenseVector)state.x()).toArray$mcD$sp((ClassTag)ClassTag$.MODULE$.Double());
        if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) {
            String string7 = this.$(this.loss());
            String string8 = LinearRegression$.MODULE$.Huber();
            if (!(string7 != null ? !string7.equals(string8) : string8 != null) && solution != null) {
                double adapt = BLAS$.MODULE$.javaBLAS().ddot(numFeatures, solution, 1, scaledMean, 1);
                solution[numFeatures] = solution[numFeatures] - adapt;
            }
        }
        return new Tuple2((Object)solution, arrayBuilder.result());
    }

    private LinearRegressionModel createModel(double[] solution, double yMean, double yStd, double[] featuresMean, double[] featuresStd) {
        double d;
        int numFeatures = featuresStd.length;
        String string = this.$(this.loss());
        String string2 = LinearRegression$.MODULE$.Huber();
        double multiplier = !(string != null ? !string.equals(string2) : string2 != null) ? 1.0 : yStd;
        double[] rawCoefficients = (double[])Array$.MODULE$.tabulate(numFeatures, (Function1)(JFunction1.mcDI.sp & Serializable)i -> featuresStd[i] != 0.0 ? solution[i] * multiplier / featuresStd[i] : 0.0, (ClassTag)ClassTag$.MODULE$.Double());
        if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) {
            double d2;
            String string3 = this.$(this.loss());
            String string4 = LinearRegression$.MODULE$.SquaredError();
            String string5 = string3;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                d2 = yMean - BLAS$.MODULE$.dot(Vectors$.MODULE$.dense(rawCoefficients), Vectors$.MODULE$.dense(featuresMean));
            } else {
                String string6 = LinearRegression$.MODULE$.Huber();
                String string7 = string3;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    d2 = solution[numFeatures];
                } else {
                    throw new MatchError((Object)string3);
                }
            }
            d = d2;
        } else {
            d = 0.0;
        }
        double intercept = d;
        Vector coefficients = Vectors$.MODULE$.dense(rawCoefficients).compressed();
        String string8 = this.$(this.loss());
        String string9 = LinearRegression$.MODULE$.Huber();
        double scale = !(string8 != null ? !string8.equals(string9) : string9 != null) ? BoxesRunTime.unboxToDouble((Object)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.doubleArrayOps(solution))) : 1.0;
        return this.copyValues(new LinearRegressionModel(this.uid(), coefficients, intercept, scale), this.copyValues$default$2());
    }

    @Override
    public LinearRegression copy(ParamMap extra) {
        return (LinearRegression)this.defaultCopy(extra);
    }

    private static final Function1 effectiveL1RegFun$1(boolean standardizationParam$1, double effectiveL1RegParam$1, double[] featuresStd$2) {
        return (JFunction1.mcDI.sp & Serializable)index -> standardizationParam$1 ? effectiveL1RegParam$1 : (featuresStd$2[index] != 0.0 ? effectiveL1RegParam$1 / featuresStd$2[index] : 0.0);
    }

    public LinearRegression(String uid) {
        this.uid = uid;
        HasRegParam.$init$(this);
        HasElasticNetParam.$init$(this);
        HasMaxIter.$init$(this);
        HasTol.$init$(this);
        HasFitIntercept.$init$(this);
        HasStandardization.$init$(this);
        HasWeightCol.$init$(this);
        HasSolver.$init$(this);
        HasAggregationDepth.$init$(this);
        HasLoss.$init$(this);
        HasMaxBlockSizeInMB.$init$(this);
        LinearRegressionParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        Statics.releaseFence();
    }

    public LinearRegression() {
        this(Identifiable$.MODULE$.randomUID("linReg"));
    }
}

