/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.feature.SelectorModel;
import org.apache.spark.ml.feature.SelectorParams;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\u0005\reA\u0002\t\u0012\u0003\u0003\u00192\u0004C\u0003;\u0001\u0011\u00051\bC\u0003>\u0001\u0011\u0005a\bC\u0003W\u0001\u0011\u0005q\u000bC\u0003[\u0001\u0011\u00051\fC\u0003b\u0001\u0011\u0005!\rC\u0003i\u0001\u0011\u0005\u0011\u000eC\u0003m\u0001\u0011\u0005Q\u000eC\u0003q\u0001\u0011\u0005\u0011\u000fC\u0003u\u0001\u0011\u0005Q\u000fC\u0003y\u0001\u0011\u0005\u0011\u0010\u0003\u0004}\u0001\u00016\t\" \u0005\t\u0003G\u0001\u0001U\"\u0005\u0002&!9\u0011Q\u0007\u0001\u0005B\u0005]\u0002bBA,\u0001\u0011\u0005\u0013\u0011\f\u0005\b\u0003[\u0002A\u0011IA8\u0005!\u0019V\r\\3di>\u0014(B\u0001\n\u0014\u0003\u001d1W-\u0019;ve\u0016T!\u0001F\u000b\u0002\u00055d'B\u0001\f\u0018\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0012$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00025\u0005\u0019qN]4\u0016\u0005q\u00193\u0003\u0002\u0001\u001ecQ\u00022AH\u0010\"\u001b\u0005\u0019\u0012B\u0001\u0011\u0014\u0005%)5\u000f^5nCR|'\u000f\u0005\u0002#G1\u0001A!\u0002\u0013\u0001\u0005\u00041#!\u0001+\u0004\u0001E\u0011q%\f\t\u0003Q-j\u0011!\u000b\u0006\u0002U\u0005)1oY1mC&\u0011A&\u000b\u0002\b\u001d>$\b.\u001b8h!\rqs&I\u0007\u0002#%\u0011\u0001'\u0005\u0002\u000e'\u0016dWm\u0019;pe6{G-\u001a7\u0011\u00059\u0012\u0014BA\u001a\u0012\u00059\u0019V\r\\3di>\u0014\b+\u0019:b[N\u0004\"!\u000e\u001d\u000e\u0003YR!aN\n\u0002\tU$\u0018\u000e\\\u0005\u0003sY\u0012Q\u0003R3gCVdG\u000fU1sC6\u001cxK]5uC\ndW-\u0001\u0004=S:LGO\u0010\u000b\u0002yA\u0019a\u0006A\u0011\u0002\u001dM,GOR3biV\u0014Xm]\"pYR\u0011q\bQ\u0007\u0002\u0001!)\u0011I\u0001a\u0001\u0005\u0006)a/\u00197vKB\u00111I\u0013\b\u0003\t\"\u0003\"!R\u0015\u000e\u0003\u0019S!aR\u0013\u0002\rq\u0012xn\u001c;?\u0013\tI\u0015&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u00172\u0013aa\u0015;sS:<'BA%*Q\r\u0011a\n\u0016\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#V\t!\"\u00198o_R\fG/[8o\u0013\t\u0019\u0006KA\u0003TS:\u001cW-I\u0001V\u0003\u0015\u0019d&\r\u00181\u00031\u0019X\r^(viB,HoQ8m)\ty\u0004\fC\u0003B\u0007\u0001\u0007!\tK\u0002\u0004\u001dR\u000b\u0011c]3u\u001dVlGk\u001c9GK\u0006$XO]3t)\tyD\fC\u0003B\t\u0001\u0007Q\f\u0005\u0002)=&\u0011q,\u000b\u0002\u0004\u0013:$\bf\u0001\u0003O)\u0006i1/\u001a;QKJ\u001cWM\u001c;jY\u0016$\"aP2\t\u000b\u0005+\u0001\u0019\u00013\u0011\u0005!*\u0017B\u00014*\u0005\u0019!u.\u001e2mK\"\u001aQA\u0014+\u0002\rM,GO\u00129s)\ty$\u000eC\u0003B\r\u0001\u0007A\rK\u0002\u0007\u001dR\u000baa]3u\r\u0012\u0014HCA o\u0011\u0015\tu\u00011\u0001eQ\r9a\nV\u0001\u0007g\u0016$hi^3\u0015\u0005}\u0012\b\"B!\t\u0001\u0004!\u0007f\u0001\u0005O)\u0006y1/\u001a;TK2,7\r^8s)f\u0004X\r\u0006\u0002@m\")\u0011)\u0003a\u0001\u0005\"\u001a\u0011B\u0014+\u0002\u0017M,G\u000fT1cK2\u001cu\u000e\u001c\u000b\u0003\u007fiDQ!\u0011\u0006A\u0002\tC3A\u0003(U\u0003Y9W\r^*fY\u0016\u001cG/[8o)\u0016\u001cHOU3tk2$Hc\u0001@\u0002 A\u0019q0!\u0007\u000f\t\u0005\u0005\u00111\u0003\b\u0005\u0003\u0007\tyA\u0004\u0003\u0002\u0006\u00055a\u0002BA\u0004\u0003\u0017q1!RA\u0005\u0013\u0005Q\u0012B\u0001\r\u001a\u0013\t1r#C\u0002\u0002\u0012U\t1a]9m\u0013\u0011\t)\"a\u0006\u0002\u000fA\f7m[1hK*\u0019\u0011\u0011C\u000b\n\t\u0005m\u0011Q\u0004\u0002\n\t\u0006$\u0018M\u0012:b[\u0016TA!!\u0006\u0002\u0018!1\u0011\u0011E\u0006A\u0002y\f!\u0001\u001a4\u0002'\r\u0014X-\u0019;f'\u0016dWm\u0019;pe6{G-\u001a7\u0015\u000b\u0005\n9#a\u000b\t\r\u0005%B\u00021\u0001C\u0003\r)\u0018\u000e\u001a\u0005\b\u0003[a\u0001\u0019AA\u0018\u0003\u001dIg\u000eZ5dKN\u0004B\u0001KA\u0019;&\u0019\u00111G\u0015\u0003\u000b\u0005\u0013(/Y=\u0002\u0007\u0019LG\u000fF\u0002\"\u0003sAq!a\u000f\u000e\u0001\u0004\ti$A\u0004eCR\f7/\u001a;1\t\u0005}\u0012\u0011\n\t\u0007\u0003\u0003\n\u0019%a\u0012\u000e\u0005\u0005]\u0011\u0002BA#\u0003/\u0011q\u0001R1uCN,G\u000fE\u0002#\u0003\u0013\"A\"a\u0013\u0002:\u0005\u0005\t\u0011!B\u0001\u0003\u001b\u00121a\u0018\u00132#\r9\u0013q\n\t\u0004Q\u0005E\u0013bAA*S\t\u0019\u0011I\\=)\u00075qE+A\bue\u0006t7OZ8s[N\u001b\u0007.Z7b)\u0011\tY&a\u001a\u0011\t\u0005u\u00131M\u0007\u0003\u0003?RA!!\u0019\u0002\u0018\u0005)A/\u001f9fg&!\u0011QMA0\u0005)\u0019FO];diRK\b/\u001a\u0005\b\u0003Sr\u0001\u0019AA.\u0003\u0019\u00198\r[3nC\"\u001aaB\u0014+\u0002\t\r|\u0007/\u001f\u000b\u0004y\u0005E\u0004bBA:\u001f\u0001\u0007\u0011QO\u0001\u0006Kb$(/\u0019\t\u0005\u0003o\ni(\u0004\u0002\u0002z)\u0019\u00111P\n\u0002\u000bA\f'/Y7\n\t\u0005}\u0014\u0011\u0010\u0002\t!\u0006\u0014\u0018-\\'ba\"\u001aqB\u0014+")
public abstract class Selector<T extends SelectorModel<T>>
extends Estimator<T>
implements SelectorParams,
DefaultParamsWritable {
    private IntParam numTopFeatures;
    private DoubleParam percentile;
    private DoubleParam fpr;
    private DoubleParam fdr;
    private DoubleParam fwe;
    private Param<String> selectorType;
    private Param<String> outputCol;
    private Param<String> labelCol;
    private Param<String> featuresCol;

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getNumTopFeatures() {
        return SelectorParams.getNumTopFeatures$(this);
    }

    @Override
    public double getPercentile() {
        return SelectorParams.getPercentile$(this);
    }

    @Override
    public double getFpr() {
        return SelectorParams.getFpr$(this);
    }

    @Override
    public double getFdr() {
        return SelectorParams.getFdr$(this);
    }

    @Override
    public double getFwe() {
        return SelectorParams.getFwe$(this);
    }

    @Override
    public String getSelectorType() {
        return SelectorParams.getSelectorType$(this);
    }

    @Override
    public final String getOutputCol() {
        return HasOutputCol.getOutputCol$(this);
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol.getLabelCol$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final IntParam numTopFeatures() {
        return this.numTopFeatures;
    }

    @Override
    public final DoubleParam percentile() {
        return this.percentile;
    }

    @Override
    public final DoubleParam fpr() {
        return this.fpr;
    }

    @Override
    public final DoubleParam fdr() {
        return this.fdr;
    }

    @Override
    public final DoubleParam fwe() {
        return this.fwe;
    }

    @Override
    public final Param<String> selectorType() {
        return this.selectorType;
    }

    @Override
    public final void org$apache$spark$ml$feature$SelectorParams$_setter_$numTopFeatures_$eq(IntParam x$1) {
        this.numTopFeatures = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$SelectorParams$_setter_$percentile_$eq(DoubleParam x$1) {
        this.percentile = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$SelectorParams$_setter_$fpr_$eq(DoubleParam x$1) {
        this.fpr = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$SelectorParams$_setter_$fdr_$eq(DoubleParam x$1) {
        this.fdr = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$SelectorParams$_setter_$fwe_$eq(DoubleParam x$1) {
        this.fwe = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$SelectorParams$_setter_$selectorType_$eq(Param<String> x$1) {
        this.selectorType = x$1;
    }

    @Override
    public final Param<String> outputCol() {
        return this.outputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param<String> x$1) {
        this.outputCol = x$1;
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param<String> x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    public Selector<T> setFeaturesCol(String value) {
        return (Selector)this.set(this.featuresCol(), value);
    }

    public Selector<T> setOutputCol(String value) {
        return (Selector)this.set(this.outputCol(), value);
    }

    public Selector<T> setNumTopFeatures(int value) {
        return (Selector)this.set(this.numTopFeatures(), BoxesRunTime.boxToInteger((int)value));
    }

    public Selector<T> setPercentile(double value) {
        return (Selector)this.set(this.percentile(), BoxesRunTime.boxToDouble((double)value));
    }

    public Selector<T> setFpr(double value) {
        return (Selector)this.set(this.fpr(), BoxesRunTime.boxToDouble((double)value));
    }

    public Selector<T> setFdr(double value) {
        return (Selector)this.set(this.fdr(), BoxesRunTime.boxToDouble((double)value));
    }

    public Selector<T> setFwe(double value) {
        return (Selector)this.set(this.fwe(), BoxesRunTime.boxToDouble((double)value));
    }

    public Selector<T> setSelectorType(String value) {
        return (Selector)this.set(this.selectorType(), value);
    }

    public Selector<T> setLabelCol(String value) {
        return (Selector)this.set(this.labelCol(), value);
    }

    public abstract Dataset<Row> getSelectionTestResult(Dataset<Row> var1);

    public abstract T createSelectorModel(String var1, int[] var2);

    @Override
    public T fit(Dataset<?> dataset) {
        int[] nArray;
        block13: {
            String string;
            block8: {
                Dataset<Row> resultDF;
                int numFeatures;
                SparkSession spark;
                block12: {
                    block10: {
                        block11: {
                            block9: {
                                this.transformSchema(dataset.schema(), true);
                                spark = dataset.sparkSession();
                                numFeatures = MetadataUtils$.MODULE$.getNumFeatures(dataset, this.$(this.featuresCol()));
                                resultDF = this.getSelectionTestResult((Dataset<Row>)dataset.toDF());
                                string = this.$(this.selectorType());
                                switch (string == null ? 0 : string.hashCode()) {
                                    case -921824963: {
                                        if (!"percentile".equals(string)) break block8;
                                        break block9;
                                    }
                                    case -315846324: {
                                        if ("numTopFeatures".equals(string)) {
                                            break;
                                        }
                                        break block8;
                                    }
                                    case 101236: {
                                        if (!"fdr".equals(string)) break block8;
                                        break block10;
                                    }
                                    case 101608: {
                                        if (!"fpr".equals(string)) break block8;
                                        break block11;
                                    }
                                    case 101812: {
                                        if (!"fwe".equals(string)) break block8;
                                        break block12;
                                    }
                                    default: {
                                        break block8;
                                    }
                                }
                                nArray = Selector.getTopIndices$1(BoxesRunTime.unboxToInt((Object)this.$(this.numTopFeatures())), resultDF, spark);
                                break block13;
                            }
                            nArray = Selector.getTopIndices$1((int)((double)numFeatures * this.getPercentile()), resultDF, spark);
                            break block13;
                        }
                        nArray = (int[])resultDF.select("featureIndex", (Seq)Nil$.MODULE$).where(functions$.MODULE$.col("pValue").$less(this.$(this.fpr()))).as(spark.implicits().newIntEncoder()).collect();
                        break block13;
                    }
                    double f = BoxesRunTime.unboxToDouble((Object)this.$(this.fdr())) / (double)numFeatures;
                    int maxIndex = BoxesRunTime.unboxToInt((Object)resultDF.sort("pValue", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"featureIndex"})).select("pValue", (Seq)Nil$.MODULE$).as(spark.implicits().newDoubleEncoder()).rdd().zipWithIndex().flatMap((Function1 & Serializable)x0$1 -> {
                        long index;
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        double pValue = tuple2._1$mcD$sp();
                        Iterator iterator = pValue <= f * (double)((index = tuple2._2$mcJ$sp()) + 1L) ? package$.MODULE$.Iterator().single((Object)BoxesRunTime.boxToInteger((int)((int)index))) : package$.MODULE$.Iterator().empty();
                        return iterator;
                    }, (ClassTag)ClassTag$.MODULE$.Int()).fold((Object)BoxesRunTime.boxToInteger((int)-1), (Function2)(JFunction2.mcIII.sp & Serializable)(x, y) -> scala.math.package$.MODULE$.max(x, y)));
                    nArray = maxIndex >= 0 ? Selector.getTopIndices$1(maxIndex + 1, resultDF, spark) : Array$.MODULE$.emptyIntArray();
                    break block13;
                }
                nArray = (int[])resultDF.select("featureIndex", (Seq)Nil$.MODULE$).where(functions$.MODULE$.col("pValue").$less((Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)this.$(this.fwe())) / (double)numFeatures)))).as(spark.implicits().newIntEncoder()).collect();
                break block13;
            }
            throw new IllegalArgumentException(new StringBuilder(23).append("Unknown Selector Type: ").append(string).toString());
        }
        int[] indices = nArray;
        return (T)((SelectorModel)this.copyValues(((Model)this.createSelectorModel(this.uid(), (int[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.intArrayOps(indices), (Ordering)Ordering.Int$.MODULE$))).setParent(this), this.copyValues$default$2()));
    }

    @Override
    public StructType transformSchema(StructType schema) {
        SchemaUtils$.MODULE$.checkColumnType(schema, this.$(this.featuresCol()), (DataType)new VectorUDT(), SchemaUtils$.MODULE$.checkColumnType$default$4());
        SchemaUtils$.MODULE$.checkNumericType(schema, this.$(this.labelCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
        return SchemaUtils$.MODULE$.appendColumn(schema, this.$(this.outputCol()), (DataType)new VectorUDT(), SchemaUtils$.MODULE$.appendColumn$default$4());
    }

    @Override
    public Selector<T> copy(ParamMap extra) {
        return (Selector)this.defaultCopy(extra);
    }

    private static final int[] getTopIndices$1(int k, Dataset resultDF$1, SparkSession spark$1) {
        return (int[])resultDF$1.sort("pValue", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"featureIndex"})).select("featureIndex", (Seq)Nil$.MODULE$).limit(k).as(spark$1.implicits().newIntEncoder()).collect();
    }

    public Selector() {
        HasFeaturesCol.$init$(this);
        HasLabelCol.$init$(this);
        HasOutputCol.$init$(this);
        SelectorParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        Statics.releaseFence();
    }
}

