/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.BinaryLogisticRegressionSummaryImpl;
import org.apache.spark.ml.classification.BinaryLogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.LogisticRegressionModel$;
import org.apache.spark.ml.classification.LogisticRegressionModel$LogisticRegressionModelWriter$;
import org.apache.spark.ml.classification.LogisticRegressionModel$LogisticRegressionModelWriter$Data$;
import org.apache.spark.ml.classification.LogisticRegressionParams;
import org.apache.spark.ml.classification.LogisticRegressionSummary;
import org.apache.spark.ml.classification.LogisticRegressionSummaryImpl;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.impl.Utils$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasElasticNetParam;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxBlockSizeInMB;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasThreshold;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.VersionUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0011\u001da\u0001B/_\u0001%D!\"!\u0003\u0001\u0005\u000b\u0007I\u0011IA\u0006\u0011)\tI\u0004\u0001B\u0001B\u0003%\u0011Q\u0002\u0005\u000b\u0003{\u0001!Q1A\u0005\u0002\u0005}\u0002BCA'\u0001\t\u0005\t\u0015!\u0003\u0002B!Q\u0011\u0011\u000b\u0001\u0003\u0006\u0004%\t!a\u0015\t\u0013\u0005]\u0003A!A!\u0002\u0013q\u0007BCA.\u0001\t\u0015\r\u0011\"\u0011\u0002^!Q\u0011Q\u000e\u0001\u0003\u0002\u0003\u0006I!a\u0018\t\u0015\u0005E\u0004A!b\u0001\n\u0013\t\u0019\b\u0003\u0006\u0002|\u0001\u0011\t\u0011)A\u0005\u0003kB\u0001\"! \u0001\t\u0003\u0011\u0017q\u0010\u0005\t\u0003{\u0002A\u0011\u00012\u0002\u0014\"9\u0011\u0011\u0014\u0001\u0005\u0002\u0005M\u0003BCAV\u0001!\u0015\r\u0011\"\u0003\u0002T!9\u0011Q\u0014\u0001\u0005\u0002\u00055\u0006BCAY\u0001!\u0015\r\u0011\"\u0003\u0002.\"Q\u00111\u0017\u0001\t\u0006\u0004%I!!.\t\u0015\u0005u\u0006\u0001#b\u0001\n\u0013\ty\fC\u0004\u0002H\u0002!I!!,\t\u000f\u0005%\u0007\u0001\"\u0003\u0002.\"9\u00111\u001a\u0001\u0005\n\u00055\u0007bBAm\u0001\u0011\u0005\u00131\u001c\u0005\b\u0003S\u0004A\u0011IAW\u0011\u001d\ti\u000f\u0001C!\u0003_Dq!!>\u0001\t\u0003\ny\fC\u0005\u0002z\u0002\u0011\r\u0011\"\u0003\u0002|\"A!1\u0001\u0001!\u0002\u0013\ti\u0010C\u0005\u0003\u0006\u0001\u0011\r\u0011\"\u0003\u0003\b!A!1\u0002\u0001!\u0002\u0013\u0011I\u0001C\u0005\u0003\u000e\u0001\u0011\r\u0011\"\u0003\u0002|\"A!q\u0002\u0001!\u0002\u0013\ti\u0010C\u0005\u0003\u0012\u0001\u0011\r\u0011\"\u0011\u0002^!A!\u0011\u0004\u0001!\u0002\u0013\ty\u0006C\u0004\u0003\u001e\u0001!\tEa\b\t\u000f\t\r\u0002\u0001\"\u0001\u0003&!9!1\u0007\u0001\u0005\u0002\tU\u0002b\u0002B4\u0001\u0011\u0005#\u0011\u000e\u0005\b\u0005_\u0002A\u0011\u000bB9\u0011\u001d\u00119\b\u0001C!\u0005sBqAa!\u0001\t\u0003\u0012)\tC\u0004\u0003\u001a\u0002!\tFa'\t\u000f\t}\u0005\u0001\"\u0015\u0003\"\"9!q\u0015\u0001\u0005B\t%\u0006b\u0002BZ\u0001\u0011\u0005#QW\u0004\b\u0005ss\u0006\u0012\u0001B^\r\u0019if\f#\u0001\u0003>\"9\u0011Q\u0010\u0018\u0005\u0002\tm\u0007b\u0002Bo]\u0011\u0005#q\u001c\u0005\b\u0005StC\u0011\tBv\r\u001d\u0011\u0019P\f\u0001/\u0005kD\u0011ba\u00013\u0005\u0003\u0005\u000b\u0011\u0002;\t\u000f\u0005u$\u0007\"\u0001\u0004\u0006\u001911Q\u0002\u001aE\u0007\u001fA!\"a\u00176\u0005+\u0007I\u0011AA/\u0011)\ti'\u000eB\tB\u0003%\u0011q\f\u0005\u000b\u0005#)$Q3A\u0005\u0002\u0005u\u0003B\u0003B\rk\tE\t\u0015!\u0003\u0002`!Q\u0011\u0011K\u001b\u0003\u0016\u0004%\t!a\u0015\t\u0013\u0005]SG!E!\u0002\u0013q\u0007BCA\u001fk\tU\r\u0011\"\u0001\u0002@!Q\u0011QJ\u001b\u0003\u0012\u0003\u0006I!!\u0011\t\u0015\u0005ETG!f\u0001\n\u0003\t\u0019\b\u0003\u0006\u0002|U\u0012\t\u0012)A\u0005\u0003kBq!! 6\t\u0003\u00199\u0003C\u0005\u0003\u0004V\n\t\u0011\"\u0001\u00048!I11I\u001b\u0012\u0002\u0013\u00051Q\t\u0005\n\u00073*\u0014\u0013!C\u0001\u0007\u000bB\u0011ba\u00176#\u0003%\ta!\u0018\t\u0013\r\u0005T'%A\u0005\u0002\r\r\u0004\"CB4kE\u0005I\u0011AB5\u0011%\u0019i'NA\u0001\n\u0003\u001ay\u0007C\u0005\u0004|U\n\t\u0011\"\u0001\u0002^!I1QP\u001b\u0002\u0002\u0013\u00051q\u0010\u0005\n\u0007\u000b+\u0014\u0011!C!\u0007\u000fC\u0011b!&6\u0003\u0003%\taa&\t\u0013\rmU'!A\u0005B\ru\u0005\"CBQk\u0005\u0005I\u0011IBR\u0011%\u0011\u0019,NA\u0001\n\u0003\u001a)\u000bC\u0005\u0004(V\n\t\u0011\"\u0011\u0004*\u001eI1Q\u0016\u001a\u0002\u0002#%1q\u0016\u0004\n\u0007\u001b\u0011\u0014\u0011!E\u0005\u0007cCq!! R\t\u0003\u0019y\fC\u0005\u00034F\u000b\t\u0011\"\u0012\u0004&\"I1\u0011Y)\u0002\u0002\u0013\u000551\u0019\u0005\n\u0007\u001f\f\u0016\u0011!CA\u0007#Dqaa93\t#\u001a)O\u0002\u0004\u0004j:\"11\u001e\u0005\b\u0003{:F\u0011ABw\u0011%\u0019\tp\u0016b\u0001\n\u0013\u0019y\u0007\u0003\u0005\u0004t^\u0003\u000b\u0011BB9\u0011\u001d\u0011Io\u0016C!\u0007kD\u0011b!?/\u0003\u0003%Iaa?\u0003/1{w-[:uS\u000e\u0014Vm\u001a:fgNLwN\\'pI\u0016d'BA0a\u00039\u0019G.Y:tS\u001aL7-\u0019;j_:T!!\u00192\u0002\u00055d'BA2e\u0003\u0015\u0019\b/\u0019:l\u0015\t)g-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0006\u0019qN]4\u0004\u0001M)\u0001A[;|}B!1\u000e\u001c8u\u001b\u0005q\u0016BA7_\u0005\u0001\u0002&o\u001c2bE&d\u0017n\u001d;jG\u000ec\u0017m]:jM&\u001c\u0017\r^5p]6{G-\u001a7\u0011\u0005=\u0014X\"\u00019\u000b\u0005E\u0004\u0017A\u00027j]\u0006dw-\u0003\u0002ta\n1a+Z2u_J\u0004\"a\u001b\u0001\u0011\u0005YLX\"A<\u000b\u0005a\u0004\u0017\u0001B;uS2L!A_<\u0003\u00155cuK]5uC\ndW\r\u0005\u0002ly&\u0011QP\u0018\u0002\u0019\u0019><\u0017n\u001d;jGJ+wM]3tg&|g\u000eU1sC6\u001c\b\u0003\u0002<\u0000\u0003\u0007I1!!\u0001x\u0005IA\u0015m\u001d+sC&t\u0017N\\4Tk6l\u0017M]=\u0011\u0007-\f)!C\u0002\u0002\by\u0013\u0011\u0005T8hSN$\u0018n\u0019*fOJ,7o]5p]R\u0013\u0018-\u001b8j]\u001e\u001cV/\\7bef\f1!^5e+\t\ti\u0001\u0005\u0003\u0002\u0010\u0005\u0005b\u0002BA\t\u0003;\u0001B!a\u0005\u0002\u001a5\u0011\u0011Q\u0003\u0006\u0004\u0003/A\u0017A\u0002\u001fs_>$hH\u0003\u0002\u0002\u001c\u0005)1oY1mC&!\u0011qDA\r\u0003\u0019\u0001&/\u001a3fM&!\u00111EA\u0013\u0005\u0019\u0019FO]5oO*!\u0011qDA\rQ\u0015\t\u0011\u0011FA\u001b!\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u0018E\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0012Q\u0006\u0002\u0006'&t7-Z\u0011\u0003\u0003o\tQ!\r\u00185]A\nA!^5eA!*!!!\u000b\u00026\u0005\t2m\\3gM&\u001c\u0017.\u001a8u\u001b\u0006$(/\u001b=\u0016\u0005\u0005\u0005\u0003cA8\u0002D%\u0019\u0011Q\t9\u0003\r5\u000bGO]5yQ\u0015\u0019\u0011\u0011FA%C\t\tY%A\u00033]Er\u0003'\u0001\nd_\u00164g-[2jK:$X*\u0019;sSb\u0004\u0003&\u0002\u0003\u0002*\u0005%\u0013aD5oi\u0016\u00148-\u001a9u-\u0016\u001cGo\u001c:\u0016\u00039DS!BA\u0015\u0003\u0013\n\u0001#\u001b8uKJ\u001cW\r\u001d;WK\u000e$xN\u001d\u0011)\u000b\u0019\tI#!\u0013\u0002\u00159,Xn\u00117bgN,7/\u0006\u0002\u0002`A!\u0011\u0011MA2\u001b\t\tI\"\u0003\u0003\u0002f\u0005e!aA%oi\"*q!!\u000b\u0002j\u0005\u0012\u00111N\u0001\u0006c9\u001ad\u0006M\u0001\f]Vl7\t\\1tg\u0016\u001c\b\u0005K\u0003\t\u0003S\tI'A\u0007jg6+H\u000e^5o_6L\u0017\r\\\u000b\u0003\u0003k\u0002B!!\u0019\u0002x%!\u0011\u0011PA\r\u0005\u001d\u0011un\u001c7fC:\fa\"[:Nk2$\u0018N\\8nS\u0006d\u0007%\u0001\u0004=S:LGO\u0010\u000b\fi\u0006\u0005\u0015QQAE\u0003\u001b\u000b\t\nC\u0004\u0002\n-\u0001\r!!\u0004)\r\u0005\u0005\u0015\u0011FA\u001b\u0011\u001d\tid\u0003a\u0001\u0003\u0003Bc!!\"\u0002*\u0005%\u0003BBA)\u0017\u0001\u0007a\u000e\u000b\u0004\u0002\n\u0006%\u0012\u0011\n\u0005\b\u00037Z\u0001\u0019AA0Q\u0019\ti)!\u000b\u0002j!9\u0011\u0011O\u0006A\u0002\u0005UDc\u0002;\u0002\u0016\u0006]\u00151\u0014\u0005\b\u0003\u0013a\u0001\u0019AA\u0007\u0011\u0019\tI\n\u0004a\u0001]\u0006a1m\\3gM&\u001c\u0017.\u001a8ug\"9\u0011Q\u0014\u0007A\u0002\u0005}\u0015!C5oi\u0016\u00148-\u001a9u!\u0011\t\t'!)\n\t\u0005\r\u0016\u0011\u0004\u0002\u0007\t>,(\r\\3)\u000b5\tI#a*\"\u0005\u0005%\u0016!\u0002\u001a/a9\u0002\u0014!D0d_\u00164g-[2jK:$8/\u0006\u0002\u0002 \"*q\"!\u000b\u0002j\u0005Qq,\u001b8uKJ\u001cW\r\u001d;\u0002!}Kg\u000e^3sG\u0016\u0004HOV3di>\u0014XCAA\\!\ry\u0017\u0011X\u0005\u0004\u0003w\u0003(a\u0003#f]N,g+Z2u_J\fQc\u00182j]\u0006\u0014\u0018\u0010\u00165sKNDw\u000e\u001c3BeJ\f\u00170\u0006\u0002\u0002BB1\u0011\u0011MAb\u0003?KA!!2\u0002\u001a\t)\u0011I\u001d:bs\u0006Qq\f\u001e5sKNDw\u000e\u001c3\u0002\u001b}\u0013\u0018m\u001e+ie\u0016\u001c\bn\u001c7e\u0003Y)\b\u000fZ1uK\nKg.\u0019:z)\"\u0014Xm\u001d5pY\u0012\u001cH\u0003BAh\u0003+\u0004B!!\u0019\u0002R&!\u00111[A\r\u0005\u0011)f.\u001b;\t\u000f\u0005]W\u00031\u0001\u0002B\u0006)\u0011M\u001d:bs\u0006a1/\u001a;UQJ,7\u000f[8mIR!\u0011Q\\Ap\u001b\u0005\u0001\u0001bBAq-\u0001\u0007\u0011qT\u0001\u0006m\u0006dW/\u001a\u0015\u0006-\u0005%\u0012Q]\u0011\u0003\u0003O\fQ!\r\u00186]A\nAbZ3u)\"\u0014Xm\u001d5pY\u0012DSaFA\u0015\u0003K\fQb]3u)\"\u0014Xm\u001d5pY\u0012\u001cH\u0003BAo\u0003cDq!!9\u0019\u0001\u0004\t\t\rK\u0003\u0019\u0003S\t)/A\u0007hKR$\u0006N]3tQ>dGm\u001d\u0015\u00063\u0005%\u0012Q]\u0001\u0007[\u0006\u0014x-\u001b8\u0016\u0005\u0005u\bcBA1\u0003\u007ft\u0017qT\u0005\u0005\u0005\u0003\tIBA\u0005Gk:\u001cG/[8oc\u00059Q.\u0019:hS:\u0004\u0013aB7be\u001eLgn]\u000b\u0003\u0005\u0013\u0001b!!\u0019\u0002\u0000:t\u0017\u0001C7be\u001eLgn\u001d\u0011\u0002\u000bM\u001cwN]3\u0002\rM\u001cwN]3!\u0003-qW/\u001c$fCR,(/Z:)\u000b\u0001\nIC!\u0006\"\u0005\t]\u0011!B\u0019/m9\u0002\u0014\u0001\u00048v[\u001a+\u0017\r^;sKN\u0004\u0003&B\u0011\u0002*\tU\u0011aB:v[6\f'/_\u000b\u0003\u0003\u0007ASAIA\u0015\u0003K\fQBY5oCJL8+^7nCJLXC\u0001B\u0014!\rY'\u0011F\u0005\u0004\u0005Wq&a\n\"j]\u0006\u0014\u0018\u0010T8hSN$\u0018n\u0019*fOJ,7o]5p]R\u0013\u0018-\u001b8j]\u001e\u001cV/\\7befDSaIA\u0015\u0005_\t#A!\r\u0002\u000bIr3G\f\u0019\u0002\u0011\u00154\u0018\r\\;bi\u0016$BAa\u000e\u0003>A\u00191N!\u000f\n\u0007\tmbLA\rM_\u001eL7\u000f^5d%\u0016<'/Z:tS>t7+^7nCJL\bb\u0002B I\u0001\u0007!\u0011I\u0001\bI\u0006$\u0018m]3ua\u0011\u0011\u0019Ea\u0015\u0011\r\t\u0015#1\nB(\u001b\t\u00119EC\u0002\u0003J\t\f1a]9m\u0013\u0011\u0011iEa\u0012\u0003\u000f\u0011\u000bG/Y:fiB!!\u0011\u000bB*\u0019\u0001!AB!\u0016\u0003>\u0005\u0005\t\u0011!B\u0001\u0005/\u00121a\u0018\u00134#\u0011\u0011IFa\u0018\u0011\t\u0005\u0005$1L\u0005\u0005\u0005;\nIBA\u0004O_RD\u0017N\\4\u0011\t\u0005\u0005$\u0011M\u0005\u0005\u0005G\nIBA\u0002B]fDS\u0001JA\u0015\u0003O\u000bq\u0001\u001d:fI&\u001cG\u000f\u0006\u0003\u0002 \n-\u0004B\u0002B7K\u0001\u0007a.\u0001\u0005gK\u0006$XO]3t\u0003Y\u0011\u0018m\u001e\u001aqe>\u0014\u0017MY5mSRL\u0018J\u001c)mC\u000e,Gc\u00018\u0003t!1!Q\u000f\u0014A\u00029\fQB]1x!J,G-[2uS>t\u0017A\u00039sK\u0012L7\r\u001e*boR\u0019aNa\u001f\t\r\t5t\u00051\u0001oQ\u00159\u0013\u0011\u0006B@C\t\u0011\t)A\u00034]Ar\u0003'\u0001\u0003d_BLHc\u0001;\u0003\b\"9!\u0011\u0012\u0015A\u0002\t-\u0015!B3yiJ\f\u0007\u0003\u0002BG\u0005'k!Aa$\u000b\u0007\tE\u0005-A\u0003qCJ\fW.\u0003\u0003\u0003\u0016\n=%\u0001\u0003)be\u0006lW*\u00199)\u000b!\nI#!\u000e\u0002\u001dI\fwO\r9sK\u0012L7\r^5p]R!\u0011q\u0014BO\u0011\u0019\u0011)(\u000ba\u0001]\u00061\u0002O]8cC\nLG.\u001b;zeA\u0014X\rZ5di&|g\u000e\u0006\u0003\u0002 \n\r\u0006B\u0002BSU\u0001\u0007a.A\u0006qe>\u0014\u0017MY5mSRL\u0018!B<sSR,WC\u0001BV!\r1(QV\u0005\u0004\u0005_;(\u0001C'M/JLG/\u001a:)\u000b-\nIC!\u0006\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0004)\u000b\u0001\tI#!\u000e\u0002/1{w-[:uS\u000e\u0014Vm\u001a:fgNLwN\\'pI\u0016d\u0007CA6/'\u001dq#q\u0018Bc\u0005\u0017\u0004B!!\u0019\u0003B&!!1YA\r\u0005\u0019\te.\u001f*fMB!aOa2u\u0013\r\u0011Im\u001e\u0002\u000b\u001b2\u0013V-\u00193bE2,\u0007\u0003\u0002Bg\u0005/l!Aa4\u000b\t\tE'1[\u0001\u0003S>T!A!6\u0002\t)\fg/Y\u0005\u0005\u00053\u0014yM\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0003<\u0006!!/Z1e+\t\u0011\t\u000f\u0005\u0003w\u0005G$\u0018b\u0001Bso\nAQ\n\u0014*fC\u0012,'\u000fK\u00031\u0003S\u0011)\"\u0001\u0003m_\u0006$Gc\u0001;\u0003n\"9!q^\u0019A\u0002\u00055\u0011\u0001\u00029bi\"DS!MA\u0015\u0005+\u0011Q\u0004T8hSN$\u0018n\u0019*fOJ,7o]5p]6{G-\u001a7Xe&$XM]\n\u0006e\t-&q\u001f\t\u0005\u0005s\u0014y0\u0004\u0002\u0003|*\u0019!Q 2\u0002\u0011%tG/\u001a:oC2LAa!\u0001\u0003|\n9Aj\\4hS:<\u0017\u0001C5ogR\fgnY3\u0015\t\r\u001d11\u0002\t\u0004\u0007\u0013\u0011T\"\u0001\u0018\t\r\r\rA\u00071\u0001u\u0005\u0011!\u0015\r^1\u0014\u000fU\u0012yl!\u0005\u0004\u0018A!\u0011\u0011MB\n\u0013\u0011\u0019)\"!\u0007\u0003\u000fA\u0013x\u000eZ;diB!1\u0011DB\u0012\u001d\u0011\u0019Yba\b\u000f\t\u0005M1QD\u0005\u0003\u00037IAa!\t\u0002\u001a\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002Bm\u0007KQAa!\t\u0002\u001aQa1\u0011FB\u0017\u0007_\u0019\tda\r\u00046A\u001911F\u001b\u000e\u0003IBq!a\u0017A\u0001\u0004\ty\u0006C\u0004\u0003\u0012\u0001\u0003\r!a\u0018\t\r\u0005E\u0003\t1\u0001o\u0011\u001d\ti\u0004\u0011a\u0001\u0003\u0003Bq!!\u001dA\u0001\u0004\t)\b\u0006\u0007\u0004*\re21HB\u001f\u0007\u007f\u0019\t\u0005C\u0005\u0002\\\u0005\u0003\n\u00111\u0001\u0002`!I!\u0011C!\u0011\u0002\u0003\u0007\u0011q\f\u0005\t\u0003#\n\u0005\u0013!a\u0001]\"I\u0011QH!\u0011\u0002\u0003\u0007\u0011\u0011\t\u0005\n\u0003c\n\u0005\u0013!a\u0001\u0003k\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004H)\"\u0011qLB%W\t\u0019Y\u0005\u0005\u0003\u0004N\rUSBAB(\u0015\u0011\u0019\tfa\u0015\u0002\u0013Ut7\r[3dW\u0016$'\u0002BA\u0018\u00033IAaa\u0016\u0004P\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAB0U\rq7\u0011J\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019)G\u000b\u0003\u0002B\r%\u0013AD2paf$C-\u001a4bk2$H%N\u000b\u0003\u0007WRC!!\u001e\u0004J\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"a!\u001d\u0011\t\rM4\u0011P\u0007\u0003\u0007kRAaa\u001e\u0003T\u0006!A.\u00198h\u0013\u0011\t\u0019c!\u001e\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!qLBA\u0011%\u0019\u0019)SA\u0001\u0002\u0004\ty&A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0007\u0013\u0003baa#\u0004\u0012\n}SBABG\u0015\u0011\u0019y)!\u0007\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0004\u0014\u000e5%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u001e\u0004\u001a\"I11Q&\u0002\u0002\u0003\u0007!qL\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0004r\r}\u0005\"CBB\u0019\u0006\u0005\t\u0019AA0\u0003!A\u0017m\u001d5D_\u0012,GCAA0)\t\u0019\t(\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003k\u001aY\u000bC\u0005\u0004\u0004>\u000b\t\u00111\u0001\u0003`\u0005!A)\u0019;b!\r\u0019Y#U\n\u0006#\u000eM&1\u001a\t\u0010\u0007k\u001bY,a\u0018\u0002`9\f\t%!\u001e\u0004*5\u00111q\u0017\u0006\u0005\u0007s\u000bI\"A\u0004sk:$\u0018.\\3\n\t\ru6q\u0017\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:,DCABX\u0003\u0015\t\u0007\u000f\u001d7z)1\u0019Ic!2\u0004H\u000e%71ZBg\u0011\u001d\tY\u0006\u0016a\u0001\u0003?BqA!\u0005U\u0001\u0004\ty\u0006\u0003\u0004\u0002RQ\u0003\rA\u001c\u0005\b\u0003{!\u0006\u0019AA!\u0011\u001d\t\t\b\u0016a\u0001\u0003k\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004T\u000e}\u0007CBA1\u0007+\u001cI.\u0003\u0003\u0004X\u0006e!AB(qi&|g\u000eE\u0007\u0002b\rm\u0017qLA0]\u0006\u0005\u0013QO\u0005\u0005\u0007;\fIB\u0001\u0004UkBdW-\u000e\u0005\n\u0007C,\u0016\u0011!a\u0001\u0007S\t1\u0001\u001f\u00131\u0003!\u0019\u0018M^3J[BdG\u0003BAh\u0007ODqAa<W\u0001\u0004\tiAA\u000fM_\u001eL7\u000f^5d%\u0016<'/Z:tS>tWj\u001c3fYJ+\u0017\rZ3s'\r9&\u0011\u001d\u000b\u0003\u0007_\u00042a!\u0003X\u0003%\u0019G.Y:t\u001d\u0006lW-\u0001\u0006dY\u0006\u001c8OT1nK\u0002\"2\u0001^B|\u0011\u001d\u0011yo\u0017a\u0001\u0003\u001b\tAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"a!@\u0011\t\rM4q`\u0005\u0005\t\u0003\u0019)H\u0001\u0004PE*,7\r\u001e\u0015\u0006]\u0005%\"Q\u0003\u0015\u0006[\u0005%\"Q\u0003")
public class LogisticRegressionModel
extends ProbabilisticClassificationModel<Vector, LogisticRegressionModel>
implements MLWritable,
LogisticRegressionParams,
HasTrainingSummary<LogisticRegressionTrainingSummary> {
    private Vector _coefficients;
    private double _intercept;
    private DenseVector _interceptVector;
    private double[] _binaryThresholdArray;
    private final String uid;
    private final Matrix coefficientMatrix;
    private final Vector interceptVector;
    private final int numClasses;
    private final boolean org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial;
    private final Function1<Vector, Object> margin;
    private final Function1<Vector, Vector> margins;
    private final Function1<Vector, Object> score;
    private final int numFeatures;
    private Option<LogisticRegressionTrainingSummary> trainingSummary;
    private Param<String> family;
    private Param<Matrix> lowerBoundsOnCoefficients;
    private Param<Matrix> upperBoundsOnCoefficients;
    private Param<Vector> lowerBoundsOnIntercepts;
    private Param<Vector> upperBoundsOnIntercepts;
    private DoubleParam maxBlockSizeInMB;
    private IntParam aggregationDepth;
    private DoubleParam threshold;
    private Param<String> weightCol;
    private BooleanParam standardization;
    private DoubleParam tol;
    private BooleanParam fitIntercept;
    private IntParam maxIter;
    private DoubleParam elasticNetParam;
    private DoubleParam regParam;
    private volatile byte bitmap$0;

    public static LogisticRegressionModel load(String string) {
        return LogisticRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<LogisticRegressionModel> read() {
        return LogisticRegressionModel$.MODULE$.read();
    }

    @Override
    public boolean hasSummary() {
        return HasTrainingSummary.hasSummary$(this);
    }

    @Override
    public HasTrainingSummary<LogisticRegressionTrainingSummary> setSummary(Option<LogisticRegressionTrainingSummary> summary) {
        return HasTrainingSummary.setSummary$(this, summary);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$classification$LogisticRegressionParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public String getFamily() {
        return LogisticRegressionParams.getFamily$(this);
    }

    @Override
    public void checkThresholdConsistency() {
        LogisticRegressionParams.checkThresholdConsistency$(this);
    }

    @Override
    public Matrix getLowerBoundsOnCoefficients() {
        return LogisticRegressionParams.getLowerBoundsOnCoefficients$(this);
    }

    @Override
    public Matrix getUpperBoundsOnCoefficients() {
        return LogisticRegressionParams.getUpperBoundsOnCoefficients$(this);
    }

    @Override
    public Vector getLowerBoundsOnIntercepts() {
        return LogisticRegressionParams.getLowerBoundsOnIntercepts$(this);
    }

    @Override
    public Vector getUpperBoundsOnIntercepts() {
        return LogisticRegressionParams.getUpperBoundsOnIntercepts$(this);
    }

    @Override
    public boolean usingBoundConstrainedOptimization() {
        return LogisticRegressionParams.usingBoundConstrainedOptimization$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return LogisticRegressionParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final double getMaxBlockSizeInMB() {
        return HasMaxBlockSizeInMB.getMaxBlockSizeInMB$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization.getStandardization$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam.getElasticNetParam$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final Option<LogisticRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    @Override
    public final void trainingSummary_$eq(Option<LogisticRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    @Override
    public final Param<String> family() {
        return this.family;
    }

    @Override
    public Param<Matrix> lowerBoundsOnCoefficients() {
        return this.lowerBoundsOnCoefficients;
    }

    @Override
    public Param<Matrix> upperBoundsOnCoefficients() {
        return this.upperBoundsOnCoefficients;
    }

    @Override
    public Param<Vector> lowerBoundsOnIntercepts() {
        return this.lowerBoundsOnIntercepts;
    }

    @Override
    public Param<Vector> upperBoundsOnIntercepts() {
        return this.upperBoundsOnIntercepts;
    }

    @Override
    public final void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$family_$eq(Param<String> x$1) {
        this.family = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnCoefficients_$eq(Param<Matrix> x$1) {
        this.lowerBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnCoefficients_$eq(Param<Matrix> x$1) {
        this.upperBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnIntercepts_$eq(Param<Vector> x$1) {
        this.lowerBoundsOnIntercepts = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnIntercepts_$eq(Param<Vector> x$1) {
        this.upperBoundsOnIntercepts = x$1;
    }

    @Override
    public final DoubleParam maxBlockSizeInMB() {
        return this.maxBlockSizeInMB;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxBlockSizeInMB$_setter_$maxBlockSizeInMB_$eq(DoubleParam x$1) {
        this.maxBlockSizeInMB = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Matrix coefficientMatrix() {
        return this.coefficientMatrix;
    }

    public Vector interceptVector() {
        return this.interceptVector;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    public boolean org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial;
    }

    public Vector coefficients() {
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            throw new SparkException("Multinomial models contain a matrix of coefficients, use coefficientMatrix instead.");
        }
        return this._coefficients();
    }

    private Vector _coefficients$lzycompute() {
        LogisticRegressionModel logisticRegressionModel = this;
        synchronized (logisticRegressionModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Vector vector;
                Predef$.MODULE$.require(this.coefficientMatrix().isTransposed(), (Function0 & Serializable)() -> "LogisticRegressionModel coefficients should be row major for binomial model.");
                Matrix matrix = this.coefficientMatrix();
                if (matrix instanceof DenseMatrix) {
                    DenseMatrix denseMatrix = (DenseMatrix)matrix;
                    vector = Vectors$.MODULE$.dense(denseMatrix.values());
                } else if (matrix instanceof SparseMatrix) {
                    SparseMatrix sparseMatrix = (SparseMatrix)matrix;
                    vector = Vectors$.MODULE$.sparse(this.coefficientMatrix().numCols(), sparseMatrix.rowIndices(), sparseMatrix.values());
                } else {
                    throw new MatchError((Object)matrix);
                }
                this._coefficients = vector;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this._coefficients;
    }

    private Vector _coefficients() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this._coefficients$lzycompute() : this._coefficients;
    }

    public double intercept() {
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            throw new SparkException("Multinomial models contain a vector of intercepts, use interceptVector instead.");
        }
        return this._intercept();
    }

    private double _intercept$lzycompute() {
        LogisticRegressionModel logisticRegressionModel = this;
        synchronized (logisticRegressionModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this._intercept = this.interceptVector().apply(0);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this._intercept;
    }

    private double _intercept() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this._intercept$lzycompute() : this._intercept;
    }

    private DenseVector _interceptVector$lzycompute() {
        LogisticRegressionModel logisticRegressionModel = this;
        synchronized (logisticRegressionModel) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this._interceptVector = this.interceptVector().toDense();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this._interceptVector;
    }

    private DenseVector _interceptVector() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this._interceptVector$lzycompute() : this._interceptVector;
    }

    /*
     * WARNING - void declaration
     */
    private double[] _binaryThresholdArray$lzycompute() {
        LogisticRegressionModel logisticRegressionModel = this;
        synchronized (logisticRegressionModel) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                void var2_2;
                double[] array = new double[]{Double.NaN, Double.NaN};
                this.updateBinaryThresholds(array);
                this._binaryThresholdArray = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this._binaryThresholdArray;
    }

    private double[] _binaryThresholdArray() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this._binaryThresholdArray$lzycompute() : this._binaryThresholdArray;
    }

    private double _threshold() {
        return this._binaryThresholdArray()[0];
    }

    private double _rawThreshold() {
        return this._binaryThresholdArray()[1];
    }

    private void updateBinaryThresholds(double[] array) {
        block0: {
            double _threshold;
            if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) break block0;
            array[0] = _threshold = this.getThreshold();
            array[1] = _threshold == 0.0 ? Double.NEGATIVE_INFINITY : (_threshold == 1.0 ? Double.POSITIVE_INFINITY : scala.math.package$.MODULE$.log(_threshold / (1.0 - _threshold)));
        }
    }

    @Override
    public LogisticRegressionModel setThreshold(double value) {
        LogisticRegressionParams.setThreshold$(this, value);
        this.updateBinaryThresholds(this._binaryThresholdArray());
        return this;
    }

    @Override
    public double getThreshold() {
        return LogisticRegressionParams.getThreshold$(this);
    }

    @Override
    public LogisticRegressionModel setThresholds(double[] value) {
        LogisticRegressionParams.setThresholds$(this, value);
        this.updateBinaryThresholds(this._binaryThresholdArray());
        return this;
    }

    @Override
    public double[] getThresholds() {
        return LogisticRegressionParams.getThresholds$(this);
    }

    private Function1<Vector, Object> margin() {
        return this.margin;
    }

    private Function1<Vector, Vector> margins() {
        return this.margins;
    }

    private Function1<Vector, Object> score() {
        return this.score;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public LogisticRegressionTrainingSummary summary() {
        return (LogisticRegressionTrainingSummary)HasTrainingSummary.summary$(this);
    }

    public BinaryLogisticRegressionTrainingSummary binarySummary() {
        BinaryLogisticRegressionTrainingSummary binaryLogisticRegressionTrainingSummary;
        LogisticRegressionTrainingSummary logisticRegressionTrainingSummary = this.summary();
        if (!(logisticRegressionTrainingSummary instanceof BinaryLogisticRegressionTrainingSummary)) {
            throw new RuntimeException(new StringBuilder(53).append("Cannot create a binary summary for a non-binary model").append(new StringBuilder(35).append("(numClasses=").append(this.numClasses()).append("), use summary instead.").toString()).toString());
        }
        BinaryLogisticRegressionTrainingSummary binaryLogisticRegressionTrainingSummary2 = binaryLogisticRegressionTrainingSummary = (BinaryLogisticRegressionTrainingSummary)logisticRegressionTrainingSummary;
        return binaryLogisticRegressionTrainingSummary2;
    }

    public LogisticRegressionSummary evaluate(Dataset<?> dataset) {
        String weightColName = !this.isDefined(this.weightCol()) ? "weightCol" : this.$(this.weightCol());
        Tuple3 tuple3 = this.findSummaryModel();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        ProbabilisticClassificationModel summaryModel = (ProbabilisticClassificationModel)tuple3._1();
        String probabilityColName = (String)tuple3._2();
        String predictionColName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)summaryModel, (Object)probabilityColName, (Object)predictionColName);
        Tuple3 tuple33 = tuple32;
        ProbabilisticClassificationModel summaryModel2 = (ProbabilisticClassificationModel)tuple33._1();
        String probabilityColName2 = (String)tuple33._2();
        String predictionColName2 = (String)tuple33._3();
        return this.numClasses() > 2 ? new LogisticRegressionSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), weightColName) : new BinaryLogisticRegressionSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), weightColName);
    }

    @Override
    public double predict(Vector features) {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() ? super.predict(features) : (BoxesRunTime.unboxToDouble((Object)this.score().apply((Object)features)) > this._threshold() ? 1.0 : 0.0);
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        DenseVector denseVector;
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            denseVector = (DenseVector)vector;
            double[] values = denseVector.values();
            if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
                Utils$.MODULE$.softmax(values);
            } else {
                values[0] = 1.0 / (1.0 + scala.math.package$.MODULE$.exp(-values[0]));
                values[1] = 1.0 - values[0];
            }
        } else {
            if (vector instanceof SparseVector) {
                throw new RuntimeException("Unexpected error in LogisticRegressionModel: raw2probabilitiesInPlace encountered SparseVector");
            }
            throw new MatchError((Object)vector);
        }
        DenseVector denseVector2 = denseVector;
        return denseVector2;
    }

    @Override
    public Vector predictRaw(Vector features) {
        Vector vector;
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            vector = (Vector)this.margins().apply((Object)features);
        } else {
            double m = BoxesRunTime.unboxToDouble((Object)this.margin().apply((Object)features));
            vector = Vectors$.MODULE$.dense(-m, (Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{m}));
        }
        return vector;
    }

    @Override
    public LogisticRegressionModel copy(ParamMap extra) {
        LogisticRegressionModel newModel = this.copyValues(new LogisticRegressionModel(this.uid(), this.coefficientMatrix(), this.interceptVector(), this.numClasses(), this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()), extra);
        return (LogisticRegressionModel)((Model)((Object)newModel.setSummary(this.trainingSummary()))).setParent(this.parent());
    }

    @Override
    public double raw2prediction(Vector rawPrediction) {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() ? super.raw2prediction(rawPrediction) : (rawPrediction.apply(1) > this._rawThreshold() ? 1.0 : 0.0);
    }

    @Override
    public double probability2prediction(Vector probability) {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() ? super.probability2prediction(probability) : (probability.apply(1) > this._threshold() ? 1.0 : 0.0);
    }

    @Override
    public MLWriter write() {
        return new LogisticRegressionModelWriter(this);
    }

    @Override
    public String toString() {
        return new StringBuilder(56).append("LogisticRegressionModel: uid=").append(this.uid()).append(", numClasses=").append(this.numClasses()).append(", numFeatures=").append(this.numFeatures()).toString();
    }

    public static final /* synthetic */ double $anonfun$margin$1(LogisticRegressionModel $this, Vector features) {
        return BLAS$.MODULE$.dot(features, $this._coefficients()) + $this._intercept();
    }

    public static final /* synthetic */ double $anonfun$score$1(LogisticRegressionModel $this, Vector features) {
        double m = BoxesRunTime.unboxToDouble((Object)$this.margin().apply((Object)features));
        return 1.0 / (1.0 + scala.math.package$.MODULE$.exp(-m));
    }

    public LogisticRegressionModel(String uid, Matrix coefficientMatrix, Vector interceptVector, int numClasses, boolean isMultinomial) {
        this.uid = uid;
        this.coefficientMatrix = coefficientMatrix;
        this.interceptVector = interceptVector;
        this.numClasses = numClasses;
        this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial = isMultinomial;
        MLWritable.$init$(this);
        HasRegParam.$init$(this);
        HasElasticNetParam.$init$(this);
        HasMaxIter.$init$(this);
        HasFitIntercept.$init$(this);
        HasTol.$init$(this);
        HasStandardization.$init$(this);
        HasWeightCol.$init$(this);
        HasThreshold.$init$(this);
        HasAggregationDepth.$init$(this);
        HasMaxBlockSizeInMB.$init$(this);
        LogisticRegressionParams.$init$(this);
        HasTrainingSummary.$init$(this);
        Predef$.MODULE$.require(coefficientMatrix.numRows() == interceptVector.size(), (Function0 & Serializable)() -> new StringBuilder(0).append("Dimension mismatch! Expected ").append(new StringBuilder(59).append("coefficientMatrix.numRows == interceptVector.size, but ").append(this.coefficientMatrix().numRows()).append(" != ").toString()).append(String.valueOf(BoxesRunTime.boxToInteger((int)this.interceptVector().size()))).toString());
        this.margin = (Function1 & Serializable)features -> BoxesRunTime.boxToDouble((double)LogisticRegressionModel.$anonfun$margin$1(this, features));
        this.margins = (Function1 & Serializable)features -> {
            void var2_2;
            DenseVector m = this._interceptVector().copy();
            BLAS$.MODULE$.gemv(1.0, this.coefficientMatrix(), features, 1.0, m);
            return var2_2;
        };
        this.score = (Function1 & Serializable)features -> BoxesRunTime.boxToDouble((double)LogisticRegressionModel.$anonfun$score$1(this, features));
        this.numFeatures = coefficientMatrix.numCols();
        Statics.releaseFence();
    }

    public LogisticRegressionModel(String uid, Vector coefficients, double intercept) {
        this(uid, (Matrix)new DenseMatrix(1, coefficients.size(), coefficients.toArray(), true), Vectors$.MODULE$.dense(intercept, (Seq)Nil$.MODULE$), 2, false);
    }

    private static class LogisticRegressionModelReader
    extends MLReader<LogisticRegressionModel> {
        private final String className = LogisticRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public LogisticRegressionModel load(String path) {
            LogisticRegressionModel logisticRegressionModel;
            DefaultParamsReader.Metadata metadata;
            block10: {
                Matrix matrix;
                Vector vector;
                int n;
                int n2;
                Object isMultinomial;
                block12: {
                    Row row;
                    block11: {
                        Some some;
                        Dataset data;
                        block7: {
                            double d;
                            int n3;
                            int n4;
                            Object coefficients;
                            block9: {
                                Row row2;
                                block8: {
                                    Some some2;
                                    metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
                                    Tuple2 tuple2 = VersionUtils$.MODULE$.majorMinorVersion(metadata.sparkVersion());
                                    if (tuple2 == null) {
                                        throw new MatchError((Object)tuple2);
                                    }
                                    int major = tuple2._1$mcI$sp();
                                    int minor = tuple2._2$mcI$sp();
                                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(major, minor);
                                    Tuple2.mcII.sp sp3 = sp2;
                                    int major2 = sp3._1$mcI$sp();
                                    int minor2 = sp3._2$mcI$sp();
                                    String dataPath = new Path(path, "data").toString();
                                    data = this.sparkSession().read().format("parquet").load(dataPath);
                                    if (major2 >= 2 && (major2 != 2 || minor2 != 0)) break block7;
                                    row2 = (Row)MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).select("numClasses", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"numFeatures", "intercept", "coefficients"})).head();
                                    if (row2 == null || (some2 = Row$.MODULE$.unapplySeq(row2)).isEmpty() || some2.get() == null || ((SeqOps)some2.get()).lengthCompare(4) != 0) break block8;
                                    Object numClasses = ((SeqOps)some2.get()).apply(0);
                                    Object numFeatures = ((SeqOps)some2.get()).apply(1);
                                    Object intercept = ((SeqOps)some2.get()).apply(2);
                                    coefficients = ((SeqOps)some2.get()).apply(3);
                                    if (!(numClasses instanceof Integer)) break block8;
                                    n4 = BoxesRunTime.unboxToInt((Object)numClasses);
                                    if (!(numFeatures instanceof Integer)) break block8;
                                    n3 = BoxesRunTime.unboxToInt((Object)numFeatures);
                                    if (!(intercept instanceof Double)) break block8;
                                    d = BoxesRunTime.unboxToDouble((Object)intercept);
                                    if (coefficients instanceof Vector) break block9;
                                }
                                throw new MatchError((Object)row2);
                            }
                            Vector vector2 = (Vector)coefficients;
                            Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)n4), (Object)BoxesRunTime.boxToInteger((int)n3), (Object)BoxesRunTime.boxToDouble((double)d), (Object)vector2);
                            Tuple4 tuple42 = tuple4;
                            int numClasses = BoxesRunTime.unboxToInt((Object)tuple42._1());
                            int numFeatures = BoxesRunTime.unboxToInt((Object)tuple42._2());
                            double intercept = BoxesRunTime.unboxToDouble((Object)tuple42._3());
                            Vector coefficients2 = (Vector)tuple42._4();
                            DenseMatrix coefficientMatrix = new DenseMatrix(1, coefficients2.size(), coefficients2.toArray(), true);
                            Vector interceptVector = Vectors$.MODULE$.dense(intercept, (Seq)Nil$.MODULE$);
                            logisticRegressionModel = new LogisticRegressionModel(metadata.uid(), (Matrix)coefficientMatrix, interceptVector, numClasses, false);
                            break block10;
                        }
                        row = (Row)data.select("numClasses", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"numFeatures", "interceptVector", "coefficientMatrix", "isMultinomial"})).head();
                        if (row == null || (some = Row$.MODULE$.unapplySeq(row)).isEmpty() || some.get() == null || ((SeqOps)some.get()).lengthCompare(5) != 0) break block11;
                        Object numClasses = ((SeqOps)some.get()).apply(0);
                        Object numFeatures = ((SeqOps)some.get()).apply(1);
                        Object interceptVector = ((SeqOps)some.get()).apply(2);
                        Object coefficientMatrix = ((SeqOps)some.get()).apply(3);
                        isMultinomial = ((SeqOps)some.get()).apply(4);
                        if (!(numClasses instanceof Integer)) break block11;
                        n2 = BoxesRunTime.unboxToInt((Object)numClasses);
                        if (!(numFeatures instanceof Integer)) break block11;
                        n = BoxesRunTime.unboxToInt((Object)numFeatures);
                        if (!(interceptVector instanceof Vector)) break block11;
                        vector = (Vector)interceptVector;
                        if (!(coefficientMatrix instanceof Matrix)) break block11;
                        matrix = (Matrix)coefficientMatrix;
                        if (isMultinomial instanceof Boolean) break block12;
                    }
                    throw new MatchError((Object)row);
                }
                boolean bl = BoxesRunTime.unboxToBoolean((Object)isMultinomial);
                Tuple5 tuple5 = new Tuple5((Object)BoxesRunTime.boxToInteger((int)n2), (Object)BoxesRunTime.boxToInteger((int)n), (Object)vector, (Object)matrix, (Object)BoxesRunTime.boxToBoolean((boolean)bl));
                Tuple5 tuple52 = tuple5;
                int numClasses = BoxesRunTime.unboxToInt((Object)tuple52._1());
                int numFeatures = BoxesRunTime.unboxToInt((Object)tuple52._2());
                Vector interceptVector = (Vector)tuple52._3();
                Matrix coefficientMatrix = (Matrix)tuple52._4();
                boolean isMultinomial2 = BoxesRunTime.unboxToBoolean((Object)tuple52._5());
                logisticRegressionModel = new LogisticRegressionModel(metadata.uid(), coefficientMatrix, interceptVector, numClasses, isMultinomial2);
            }
            LogisticRegressionModel model = logisticRegressionModel;
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class LogisticRegressionModelWriter
    extends MLWriter {
        private volatile LogisticRegressionModel$LogisticRegressionModelWriter$Data$ Data$module;
        private final LogisticRegressionModel instance;

        private LogisticRegressionModel$LogisticRegressionModelWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = new Data(this, this.instance.numClasses(), this.instance.numFeatures(), this.instance.interceptVector(), this.instance.coefficientMatrix(), this.instance.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LogisticRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.LogisticRegressionModel.LogisticRegressionModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.LogisticRegressionModel.LogisticRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1(LogisticRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1(null))).repartition(1).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            LogisticRegressionModelWriter logisticRegressionModelWriter = this;
            synchronized (logisticRegressionModelWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new LogisticRegressionModel$LogisticRegressionModelWriter$Data$(this);
                }
            }
        }

        public LogisticRegressionModelWriter(LogisticRegressionModel instance) {
            this.instance = instance;
        }

        private class Data
        implements Product,
        Serializable {
            private final int numClasses;
            private final int numFeatures;
            private final Vector interceptVector;
            private final Matrix coefficientMatrix;
            private final boolean isMultinomial;
            public final /* synthetic */ LogisticRegressionModelWriter $outer;

            public Iterator<String> productElementNames() {
                return Product.productElementNames$((Product)this);
            }

            public int numClasses() {
                return this.numClasses;
            }

            public int numFeatures() {
                return this.numFeatures;
            }

            public Vector interceptVector() {
                return this.interceptVector;
            }

            public Matrix coefficientMatrix() {
                return this.coefficientMatrix;
            }

            public boolean isMultinomial() {
                return this.isMultinomial;
            }

            public Data copy(int numClasses, int numFeatures, Vector interceptVector, Matrix coefficientMatrix, boolean isMultinomial) {
                return new Data(this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer(), numClasses, numFeatures, interceptVector, coefficientMatrix, isMultinomial);
            }

            public int copy$default$1() {
                return this.numClasses();
            }

            public int copy$default$2() {
                return this.numFeatures();
            }

            public Vector copy$default$3() {
                return this.interceptVector();
            }

            public Matrix copy$default$4() {
                return this.coefficientMatrix();
            }

            public boolean copy$default$5() {
                return this.isMultinomial();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 5;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    case 0: {
                        object = BoxesRunTime.boxToInteger((int)this.numClasses());
                        break;
                    }
                    case 1: {
                        object = BoxesRunTime.boxToInteger((int)this.numFeatures());
                        break;
                    }
                    case 2: {
                        object = this.interceptVector();
                        break;
                    }
                    case 3: {
                        object = this.coefficientMatrix();
                        break;
                    }
                    case 4: {
                        object = BoxesRunTime.boxToBoolean((boolean)this.isMultinomial());
                        break;
                    }
                    default: {
                        object = Statics.ioobe((int)x$1);
                        break;
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public String productElementName(int x$1) {
                String string;
                int n = x$1;
                switch (n) {
                    case 0: {
                        string = "numClasses";
                        break;
                    }
                    case 1: {
                        string = "numFeatures";
                        break;
                    }
                    case 2: {
                        string = "interceptVector";
                        break;
                    }
                    case 3: {
                        string = "coefficientMatrix";
                        break;
                    }
                    case 4: {
                        string = "isMultinomial";
                        break;
                    }
                    default: {
                        string = (String)Statics.ioobe((int)x$1);
                        break;
                    }
                }
                return string;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                n = Statics.mix((int)n, (int)this.numClasses());
                n = Statics.mix((int)n, (int)this.numFeatures());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.interceptVector()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficientMatrix()));
                n = Statics.mix((int)n, (int)(this.isMultinomial() ? 1231 : 1237));
                return Statics.finalizeHash((int)n, (int)5);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer() != this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.numClasses() != data.numClasses()) return false;
                if (this.numFeatures() != data.numFeatures()) return false;
                if (this.isMultinomial() != data.isMultinomial()) return false;
                Vector vector = this.interceptVector();
                Vector vector2 = data.interceptVector();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                Matrix matrix = this.coefficientMatrix();
                Matrix matrix2 = data.coefficientMatrix();
                if (matrix == null) {
                    if (matrix2 != null) {
                        return false;
                    }
                } else if (!matrix.equals(matrix2)) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ LogisticRegressionModelWriter org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(LogisticRegressionModelWriter $outer, int numClasses, int numFeatures, Vector interceptVector, Matrix coefficientMatrix, boolean isMultinomial) {
                this.numClasses = numClasses;
                this.numFeatures = numFeatures;
                this.interceptVector = interceptVector;
                this.coefficientMatrix = coefficientMatrix;
                this.isMultinomial = isMultinomial;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

