/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.transports.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueSocketChannel;
import java.util.concurrent.ThreadFactory;
import org.apache.qpid.jms.transports.TransportOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KQueueSupport {
    private static final Logger LOG = LoggerFactory.getLogger(KQueueSupport.class);

    public static boolean isAvailable(TransportOptions transportOptions) {
        try {
            return transportOptions.isUseKQueue() && KQueue.isAvailable();
        }
        catch (NoClassDefFoundError ncdfe) {
            LOG.debug("Unable to check for KQueue support due to missing class definition", (Throwable)ncdfe);
            return false;
        }
    }

    public static EventLoopGroup createGroup(int nThreads, ThreadFactory ioThreadfactory) {
        return new KQueueEventLoopGroup(nThreads, ioThreadfactory);
    }

    public static void createChannel(Bootstrap bootstrap) {
        bootstrap.channel(KQueueSocketChannel.class);
    }
}

