/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.awt.RenderingHints;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import javax.print.PrintService;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.printing.Orientation;
import org.apache.pdfbox.printing.PDFPageable;
import org.apache.pdfbox.tools.Version;
import picocli.CommandLine;

@CommandLine.Command(name="printpdf", header={"Prints a PDF document"}, versionProvider=Version.class, mixinStandardHelpOptions=true)
public final class PrintPDF
implements Callable<Integer> {
    private static final PrintStream SYSERR = System.err;
    @CommandLine.Option(names={"-password"}, description={"the password to decrypt the document."}, arity="0..1", interactive=true)
    private String password;
    @CommandLine.Option(names={"-silentPrint"}, description={"print without printer dialog box."})
    private boolean silentPrint;
    @CommandLine.Option(names={"-printerName"}, description={"print to specific printer."})
    private String printerName;
    @CommandLine.Option(names={"-orientation"}, description={"print using orientation [${COMPLETION-CANDIDATES}] (default: ${DEFAULT-VALUE})."})
    private Orientation orientation = Orientation.AUTO;
    @CommandLine.Option(names={"-border"}, description={"print with border."})
    private boolean border;
    @CommandLine.Option(names={"-dpi"}, description={"render into intermediate image with specific dpi and then print"})
    private int dpi;
    @CommandLine.Option(names={"-noColorOpt"}, description={"disable color optimizations (useful when printing barcodes)"})
    private boolean noColorOpt;
    @CommandLine.Option(names={"-i", "--input"}, description={"the PDF files to print."}, required=true)
    private File infile;

    public static void main(String[] args) {
        System.setProperty("apple.awt.UIElement", "true");
        int exitCode = new CommandLine(new PrintPDF()).execute(args);
        System.exit(exitCode);
    }

    @Override
    public Integer call() {
        RenderingHints renderingHints = null;
        if (this.noColorOpt) {
            renderingHints = new RenderingHints(null);
            renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        try (PDDocument document = Loader.loadPDF(this.infile, this.password);){
            AccessPermission ap = document.getCurrentAccessPermission();
            if (!ap.canPrint()) {
                throw new IOException("You do not have permission to print");
            }
            PrinterJob printJob = PrinterJob.getPrinterJob();
            printJob.setJobName(this.infile.getName());
            if (this.printerName != null) {
                PrintService[] printServices = PrinterJob.lookupPrintServices();
                boolean printerFound = false;
                for (int i = 0; i < printServices.length; ++i) {
                    if (!printServices[i].getName().equals(this.printerName)) continue;
                    printJob.setPrintService(printServices[i]);
                    printerFound = true;
                    break;
                }
                if (!printerFound) {
                    SYSERR.println("printer '" + this.printerName + "' not found, using default");
                    PrintPDF.showAvailablePrinters();
                }
            }
            PDFPageable pageable = new PDFPageable(document, this.orientation, this.border, this.dpi);
            pageable.setRenderingHints(renderingHints);
            printJob.setPageable(pageable);
            if (this.silentPrint || printJob.printDialog()) {
                printJob.print();
            }
        }
        catch (PrinterException | IOException ex) {
            SYSERR.println("Error printing document [" + ex.getClass().getSimpleName() + "]: " + ex.getMessage());
            return 4;
        }
        return 0;
    }

    @CommandLine.Command(name="listPrinters", description={"list available printers"}, helpCommand=true)
    private static void showAvailablePrinters() {
        PrintService[] printServices;
        SYSERR.println("Available printer names:");
        for (PrintService printService : printServices = PrinterJob.lookupPrintServices()) {
            SYSERR.println("    " + printService.getName());
        }
    }
}

