/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.treestatus;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.apache.pdfbox.debugger.treestatus.TreeStatus;

public class TreeStatusPane
implements TreeSelectionListener {
    private TreeStatus statusObj;
    private final JTree tree;
    private JTextField statusField;
    private JPanel panel;
    private Border defaultBorder;
    private Border errorBorder;
    private final Action textInputAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreePath path = TreeStatusPane.this.statusObj.getPathForString(TreeStatusPane.this.statusField.getText());
            if (path != null) {
                TreeStatusPane.this.tree.setSelectionPath(path);
                TreeStatusPane.this.tree.scrollPathToVisible(path);
                TreeStatusPane.this.tree.requestFocusInWindow();
            } else {
                TreeStatusPane.this.statusField.setBorder(TreeStatusPane.this.errorBorder);
            }
        }
    };

    public TreeStatusPane(JTree targetTree) {
        this.tree = targetTree;
        this.init();
    }

    private void init() {
        this.panel = new JPanel(new BorderLayout());
        this.statusField = new JTextField();
        this.statusField.setEditable(false);
        this.panel.add(this.statusField);
        this.defaultBorder = new BevelBorder(1);
        this.errorBorder = new BevelBorder(1, Color.RED, Color.RED);
        this.statusField.setAction(this.textInputAction);
        this.tree.addTreeSelectionListener(this);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void updateTreeStatus(TreeStatus statusObj) {
        this.statusField.setEditable(true);
        this.statusObj = statusObj;
        this.updateText(null);
    }

    private void updateText(String statusString) {
        this.statusField.setText(statusString);
        if (!this.statusField.getBorder().equals(this.defaultBorder)) {
            this.statusField.setBorder(this.defaultBorder);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath path = treeSelectionEvent.getPath();
        this.updateText(this.statusObj.getStringForPath(path));
    }
}

