/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.bitpacking;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.parquet.column.values.bitpacking.BitPacking;
import org.apache.parquet.column.values.bitpacking.BytePacker;
import org.apache.parquet.column.values.bitpacking.BytePackerForLong;
import org.apache.parquet.column.values.bitpacking.IntPacker;
import org.apache.parquet.column.values.bitpacking.Packer;
import org.apache.parquet.column.values.bitpacking.TestBitPacking;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestByteBitPacking {
    private static final Logger LOG = LoggerFactory.getLogger(TestByteBitPacking.class);

    @Test
    public void testPackUnPack() {
        LOG.debug("");
        LOG.debug("testPackUnPack");
        for (int i = 1; i < 32; ++i) {
            LOG.debug("Width: {}", (Object)i);
            int[] unpacked = new int[32];
            int[] values = this.generateValues(i);
            this.packUnpack(Packer.BIG_ENDIAN.newBytePacker(i), values, unpacked);
            LOG.debug("Output: {}", (Object)TestBitPacking.toString(unpacked));
            Assert.assertArrayEquals((String)("width " + i), (int[])values, (int[])unpacked);
        }
    }

    @Test
    public void testPackUnPackLong() {
        LOG.debug("");
        LOG.debug("testPackUnPackLong");
        for (int i = 1; i < 64; ++i) {
            LOG.debug("Width: {}", (Object)i);
            long[] unpacked32 = new long[32];
            long[] unpacked8 = new long[32];
            long[] values = this.generateValuesLong(i);
            this.packUnpack32(Packer.BIG_ENDIAN.newBytePackerForLong(i), values, unpacked32);
            LOG.debug("Output 32: {}", (Object)TestBitPacking.toString(unpacked32));
            Assert.assertArrayEquals((String)("width " + i), (long[])values, (long[])unpacked32);
            this.packUnpack8(Packer.BIG_ENDIAN.newBytePackerForLong(i), values, unpacked8);
            LOG.debug("Output 8: {}", (Object)TestBitPacking.toString(unpacked8));
            Assert.assertArrayEquals((String)("width " + i), (long[])values, (long[])unpacked8);
        }
    }

    private void packUnpack(BytePacker packer, int[] values, int[] unpacked) {
        byte[] packed = new byte[packer.getBitWidth() * 4];
        packer.pack32Values(values, 0, packed, 0);
        LOG.debug("packed: {}", (Object)TestBitPacking.toString(packed));
        packer.unpack32Values(ByteBuffer.wrap(packed), 0, unpacked, 0);
    }

    private void packUnpack32(BytePackerForLong packer, long[] values, long[] unpacked) {
        byte[] packed = new byte[packer.getBitWidth() * 4];
        packer.pack32Values(values, 0, packed, 0);
        LOG.debug("packed: {}", (Object)TestBitPacking.toString(packed));
        packer.unpack32Values(packed, 0, unpacked, 0);
    }

    private void packUnpack8(BytePackerForLong packer, long[] values, long[] unpacked) {
        int i;
        byte[] packed = new byte[packer.getBitWidth() * 4];
        for (i = 0; i < 4; ++i) {
            packer.pack8Values(values, 8 * i, packed, packer.getBitWidth() * i);
        }
        LOG.debug("packed: {}", (Object)TestBitPacking.toString(packed));
        for (i = 0; i < 4; ++i) {
            packer.unpack8Values(packed, packer.getBitWidth() * i, unpacked, 8 * i);
        }
    }

    private int[] generateValues(int bitWidth) {
        int[] values = new int[32];
        for (int j = 0; j < values.length; ++j) {
            values[j] = (int)(Math.random() * 100000.0) % (int)Math.pow(2.0, bitWidth);
        }
        LOG.debug("Input:  {}", (Object)TestBitPacking.toString(values));
        return values;
    }

    private long[] generateValuesLong(int bitWidth) {
        long[] values = new long[32];
        Random random = new Random(0L);
        for (int j = 0; j < values.length; ++j) {
            values[j] = random.nextLong() & (1L << bitWidth) - 1L;
        }
        LOG.debug("Input:  {}", (Object)TestBitPacking.toString(values));
        return values;
    }

    @Test
    public void testPackUnPackAgainstHandWritten() throws IOException {
        LOG.debug("");
        LOG.debug("testPackUnPackAgainstHandWritten");
        for (int i = 1; i < 8; ++i) {
            LOG.debug("Width: {}", (Object)i);
            byte[] packed = new byte[i * 4];
            int[] unpacked = new int[32];
            int[] values = this.generateValues(i);
            BytePacker packer = Packer.BIG_ENDIAN.newBytePacker(i);
            packer.pack32Values(values, 0, packed, 0);
            LOG.debug("Generated: {}", (Object)TestBitPacking.toString(packed));
            ByteArrayOutputStream manualOut = new ByteArrayOutputStream();
            BitPacking.BitPackingWriter writer = BitPacking.getBitPackingWriter((int)i, (OutputStream)manualOut);
            for (int j = 0; j < values.length; ++j) {
                writer.write(values[j]);
            }
            byte[] packedManualAsBytes = manualOut.toByteArray();
            LOG.debug("Manual: {}", (Object)TestBitPacking.toString(packedManualAsBytes));
            BitPacking.BitPackingReader reader = BitPacking.createBitPackingReader((int)i, (InputStream)new ByteArrayInputStream(packed), (long)32L);
            for (int j = 0; j < unpacked.length; ++j) {
                unpacked[j] = reader.read();
            }
            LOG.debug("Output: {}", (Object)TestBitPacking.toString(unpacked));
            Assert.assertArrayEquals((String)("width " + i), (int[])values, (int[])unpacked);
        }
    }

    @Test
    public void testPackUnPackAgainstLemire() throws IOException {
        for (Packer pack : Packer.values()) {
            LOG.debug("");
            LOG.debug("testPackUnPackAgainstLemire {}", (Object)pack.name());
            for (int i = 1; i < 32; ++i) {
                LOG.debug("Width: {}", (Object)i);
                int[] packed = new int[i];
                int[] unpacked = new int[32];
                int[] values = this.generateValues(i);
                IntPacker packer = pack.newIntPacker(i);
                packer.pack32Values(values, 0, packed, 0);
                ByteArrayOutputStream lemireOut = new ByteArrayOutputStream();
                block6: for (int v : packed) {
                    switch (pack) {
                        case LITTLE_ENDIAN: {
                            lemireOut.write(v >>> 0 & 0xFF);
                            lemireOut.write(v >>> 8 & 0xFF);
                            lemireOut.write(v >>> 16 & 0xFF);
                            lemireOut.write(v >>> 24 & 0xFF);
                            continue block6;
                        }
                        case BIG_ENDIAN: {
                            lemireOut.write(v >>> 24 & 0xFF);
                            lemireOut.write(v >>> 16 & 0xFF);
                            lemireOut.write(v >>> 8 & 0xFF);
                            lemireOut.write(v >>> 0 & 0xFF);
                        }
                    }
                }
                byte[] packedByLemireAsBytes = lemireOut.toByteArray();
                LOG.debug("Lemire out: {}", (Object)TestBitPacking.toString(packedByLemireAsBytes));
                BytePacker bytePacker = pack.newBytePacker(i);
                byte[] packedGenerated = new byte[i * 4];
                bytePacker.pack32Values(values, 0, packedGenerated, 0);
                LOG.debug("Gener. out: {}", (Object)TestBitPacking.toString(packedGenerated));
                Assert.assertEquals((String)(pack.name() + " width " + i), (Object)TestBitPacking.toString(packedByLemireAsBytes), (Object)TestBitPacking.toString(packedGenerated));
                bytePacker.unpack32Values(ByteBuffer.wrap(packedByLemireAsBytes), 0, unpacked, 0);
                LOG.debug("Output: {}", (Object)TestBitPacking.toString(unpacked));
                Assert.assertArrayEquals((String)("width " + i), (int[])values, (int[])unpacked);
            }
        }
    }
}

