/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.components.ClassloaderIsolationKeyProvider;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

@RequiresInstanceClassLoading(cloneAncestorResources=true)
public class WriteFlowFileCountToFile
extends AbstractProcessor
implements ClassloaderIsolationKeyProvider {
    private static final AtomicLong counter = new AtomicLong(0L);
    static final PropertyDescriptor ISOLATION_KEY = new PropertyDescriptor.Builder().name("Isolation Key").displayName("Isolation Key").description("The key to use as the ClassLoader Isolation Key").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    static final PropertyDescriptor FILE_TO_WRITE = new PropertyDescriptor.Builder().name("File to Write").displayName("File to Write").description("File to write the counts to").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("counts.txt").build();
    static final PropertyDescriptor CLASS_TO_CREATE = new PropertyDescriptor.Builder().name("Class to Create").displayName("Class to Create").description("If specified, each iteration of #onTrigger will create an instance of this class in order to test ClassLoader behavior. If unable to create the object, the FlowFile will be routed to failure").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    private final Relationship REL_SUCCESS = new Relationship.Builder().name("success").build();
    private final Relationship REL_FAILURE = new Relationship.Builder().name("failure").autoTerminateDefault(true).build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Arrays.asList(ISOLATION_KEY, FILE_TO_WRITE, CLASS_TO_CREATE);
    }

    public Set<Relationship> getRelationships() {
        return new HashSet<Relationship>(Arrays.asList(this.REL_SUCCESS, this.REL_FAILURE));
    }

    public String getClassloaderIsolationKey(PropertyContext context) {
        return context.getProperty(ISOLATION_KEY).getValue();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String className = context.getProperty(CLASS_TO_CREATE).getValue();
        if (className != null) {
            try {
                Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                this.getLogger().error("Failed to load class {} for {}; routing to failure", new Object[]{className, flowFile});
                session.transfer(flowFile, this.REL_FAILURE);
                return;
            }
        }
        long counterValue = counter.incrementAndGet();
        byte[] fileContents = String.valueOf(counterValue).getBytes(StandardCharsets.UTF_8);
        File file = new File(context.getProperty(FILE_TO_WRITE).getValue());
        try (FileOutputStream fos = new FileOutputStream(file);){
            ((OutputStream)fos).write(fileContents);
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
        session.transfer(flowFile, this.REL_SUCCESS);
    }
}

