/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

@CapabilityDescription(value="Ensures that all FlowFiles that are in the Processor's incoming queue are ordered such that the value of the key attribute is even for all FlowFiles before the first FlowFile with an odd value. If the FlowFiles are ordered correctly, they are transferred to the 'success' relationship; otherwise, they are transferred to the 'failure' relationship. The name of the key attribute is configurable. This is used to ensure that data is properly ordered while running within a Stateless flow.")
public class VerifyEvenThenOdd
extends AbstractProcessor {
    protected static final PropertyDescriptor ATTRIBUTE_NAME = new PropertyDescriptor.Builder().name("Attribute Name").description("The name of the attribute to check for even or odd values").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    private static final List<PropertyDescriptor> properties = List.of(ATTRIBUTE_NAME);
    protected static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles are transferred to this relationship in the event that all queued FlowFiles are ordered correctly.").build();
    protected static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("All FlowFiles are transferred to this relationship in the event that any queued FlowFiles are not ordered correctly.").build();
    private static final Set<Relationship> relationships = Set.of(REL_SUCCESS, REL_FAILURE);

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        List batch;
        ArrayList allFlowFiles = new ArrayList();
        while (!(batch = session.get(1000)).isEmpty()) {
            allFlowFiles.addAll(batch);
        }
        boolean oddSeen = false;
        boolean ordered = true;
        for (FlowFile flowFile : allFlowFiles) {
            boolean even;
            String value = flowFile.getAttribute(context.getProperty(ATTRIBUTE_NAME).getValue());
            int intValue = Integer.parseInt(value);
            boolean bl = even = intValue % 2 == 0;
            if (even && oddSeen) {
                ordered = false;
                break;
            }
            if (even) continue;
            oddSeen = true;
        }
        if (ordered) {
            session.transfer(allFlowFiles, REL_SUCCESS);
        } else {
            session.transfer(allFlowFiles, REL_FAILURE);
        }
    }
}

