/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;

public class UpdateContent
extends AbstractProcessor {
    static final PropertyDescriptor CONTENT = new PropertyDescriptor.Builder().name("Content").displayName("Content").description("Content to set").required(true).addValidator(Validator.VALID).defaultValue("Default Content").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    static final PropertyDescriptor UPDATE_STRATEGY = new PropertyDescriptor.Builder().name("Update Strategy").displayName("Update Strategy").description("How to update the contents").required(true).allowableValues(new String[]{"Replace", "Append"}).defaultValue("Replace").build();
    private final Relationship REL_SUCCESS = new Relationship.Builder().name("success").build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Arrays.asList(CONTENT, UPDATE_STRATEGY);
    }

    public Set<Relationship> getRelationships() {
        return Collections.singleton(this.REL_SUCCESS);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String content = context.getProperty(CONTENT).evaluateAttributeExpressions(flowFile).getValue();
        byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
        String strategy = context.getProperty(UPDATE_STRATEGY).getValue();
        if (strategy.equalsIgnoreCase("Replace")) {
            session.write(flowFile, out -> out.write(contentBytes));
        } else {
            session.append(flowFile, out -> out.write(contentBytes));
        }
        session.transfer(flowFile, this.REL_SUCCESS);
    }
}

