/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

public class LoopFlowFile
extends AbstractProcessor {
    private static final String ATTRIBUTE_NAME = "loop.count";
    static final PropertyDescriptor COUNT = new PropertyDescriptor.Builder().name("Count").displayName("Count").description("The number of times to loop").required(true).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).defaultValue("1").build();
    protected static Relationship REL_LOOP = new Relationship.Builder().name("loop").build();
    protected static Relationship REL_FINISHED = new Relationship.Builder().name("finished").build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Collections.singletonList(COUNT);
    }

    public Set<Relationship> getRelationships() {
        return new HashSet<Relationship>(Arrays.asList(REL_LOOP, REL_FINISHED));
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        int desiredCount;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String attributeValue = flowFile.getAttribute(ATTRIBUTE_NAME);
        int iterations = attributeValue == null ? 0 : Integer.parseInt(attributeValue);
        if (iterations >= (desiredCount = context.getProperty(COUNT).asInteger().intValue())) {
            session.transfer(flowFile, REL_FINISHED);
        } else {
            flowFile = session.putAttribute(flowFile, ATTRIBUTE_NAME, String.valueOf(iterations + 1));
            session.transfer(flowFile, REL_LOOP);
        }
    }
}

