/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.util.Arrays;
import java.util.List;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

public class DependOnProperties
extends AbstractProcessor {
    static final AllowableValue FOO = new AllowableValue("foo");
    static final AllowableValue BAR = new AllowableValue("bar");
    static final AllowableValue BAZ = new AllowableValue("baz");
    static final PropertyDescriptor ALWAYS_REQUIRED = new PropertyDescriptor.Builder().name("Always Required").displayName("Always Required").description("This property is always required").required(true).allowableValues(new DescribedValue[]{FOO, BAR, BAZ}).build();
    static final PropertyDescriptor ALWAYS_OPTIONAL = new PropertyDescriptor.Builder().name("Always Optional").displayName("Always Optional").description("This property is always optional").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor REQUIRED_IF_OPTIONAL_PROPERTY_SET = new PropertyDescriptor.Builder().name("Required If Optional Property Set").displayName("Required If Optional Property Set").description("This property is required if and only if the 'Always Optional' property is set (to anything)").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dependsOn(ALWAYS_OPTIONAL, new AllowableValue[0]).build();
    static final PropertyDescriptor REQUIRED_IF_OPTIONAL_IS_FOO = new PropertyDescriptor.Builder().name("Required If Optional Property Set To Foo").displayName("Required If Optional Property Set To Foo").description("This property is required if and only if the 'Always Optional' property is set to the value 'foo'").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dependsOn(ALWAYS_OPTIONAL, "foo", new String[0]).build();
    static final PropertyDescriptor REQUIRED_IF_ALWAYS_REQUIRED_IS_BAR_OR_BAZ = new PropertyDescriptor.Builder().name("Required If Always Required Is Bar Or Baz").displayName("Required If Always Required Is Bar Or Baz").description("This property is required if and only if the 'Always Required' property is set to the value 'bar' or the value 'baz'").required(true).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).dependsOn(ALWAYS_REQUIRED, new AllowableValue[]{BAR, BAZ}).build();
    static final PropertyDescriptor SECOND_LEVEL_DEPENDENCY = new PropertyDescriptor.Builder().name("Second Level Dependency").displayName("Second Level Dependency").description("Depends on 'Required If Optional Property Set To Foo'").required(false).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).dependsOn(REQUIRED_IF_OPTIONAL_IS_FOO, new AllowableValue[0]).build();
    static final PropertyDescriptor MULTIPLE_DEPENDENCIES = new PropertyDescriptor.Builder().name("Multiple Dependencies").displayName("Multiple Dependencies").description("Depends on Always Required = foo AND Always Optional = bar").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dependsOn(ALWAYS_REQUIRED, new AllowableValue[]{FOO}).dependsOn(ALWAYS_OPTIONAL, "bar", new String[0]).build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Arrays.asList(ALWAYS_REQUIRED, ALWAYS_OPTIONAL, REQUIRED_IF_OPTIONAL_PROPERTY_SET, REQUIRED_IF_OPTIONAL_IS_FOO, REQUIRED_IF_ALWAYS_REQUIRED_IS_BAR_OR_BAZ, SECOND_LEVEL_DEPENDENCY, MULTIPLE_DEPENDENCIES);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
    }
}

