/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flowanalysis;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.HashMap;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flowanalysis.AbstractFlowAnalysisRule;
import org.apache.nifi.flowanalysis.ComponentAnalysisResult;
import org.apache.nifi.flowanalysis.FlowAnalysisRuleContext;
import org.apache.nifi.flowanalysis.GroupAnalysisResult;
import org.apache.nifi.processor.exception.ProcessException;

@Stateful(scopes={Scope.LOCAL}, description="Stores the timestamp of the last initialization")
public class StatefulFlowAnalysisRule
extends AbstractFlowAnalysisRule {
    private final String LAST_ANALYIZE_COMPONENT_TIMESTAMP = "last.analyze.component.timestamp";
    private final String LAST_ANALYIZE_PROCESS_GROUP_TIMESTAMP = "last.analyze.component.timestamp";

    public Collection<ComponentAnalysisResult> analyzeComponent(VersionedComponent component, FlowAnalysisRuleContext context) {
        String lastAnalyizeTimestampKey = "last.analyze.component.timestamp";
        this.updateState(context, "last.analyze.component.timestamp");
        return super.analyzeComponent(component, context);
    }

    public Collection<GroupAnalysisResult> analyzeProcessGroup(VersionedProcessGroup processGroup, FlowAnalysisRuleContext context) {
        this.updateState(context, "last.analyze.component.timestamp");
        return super.analyzeProcessGroup(processGroup, context);
    }

    private void updateState(FlowAnalysisRuleContext context, String lastAnalyizeTimestampKey) {
        StateManager stateManager = context.getStateManager();
        HashMap<String, CallSite> state = new HashMap<String, CallSite>();
        state.put(lastAnalyizeTimestampKey, (CallSite)((Object)("" + System.currentTimeMillis())));
        try {
            stateManager.setState(state, Scope.LOCAL);
        }
        catch (IOException e) {
            throw new ProcessException("Couldn't set state");
        }
    }
}

