/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cs.tests.system;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.RecordSet;

public class MockCSVWriter
extends AbstractControllerService
implements RecordSetWriterFactory {
    public RecordSchema getSchema(Map<String, String> variables, RecordSchema readSchema) {
        return readSchema;
    }

    public RecordSetWriter createWriter(ComponentLog logger, final RecordSchema schema, OutputStream out, Map<String, String> variables) {
        OutputStreamWriter streamWriter = new OutputStreamWriter(out);
        final BufferedWriter writer = new BufferedWriter(streamWriter);
        return new RecordSetWriter(){
            int recordCount = 0;

            public WriteResult write(RecordSet recordSet) throws IOException {
                Record record;
                this.beginRecordSet();
                while ((record = recordSet.next()) != null) {
                    this.write(record);
                }
                return this.finishRecordSet();
            }

            public void beginRecordSet() throws IOException {
                List fieldNames = schema.getFieldNames();
                int i = 0;
                for (String fieldName : fieldNames) {
                    writer.write(fieldName);
                    if (++i >= fieldNames.size()) continue;
                    writer.write(44);
                    writer.write(32);
                }
                writer.write("\n");
            }

            public WriteResult finishRecordSet() {
                return this.createWriteResult();
            }

            public WriteResult write(Record record) throws IOException {
                Object[] values = record.getValues();
                int i = 0;
                for (Object value : values) {
                    writer.write(value == null ? "" : value.toString());
                    if (++i >= values.length) continue;
                    writer.write(44);
                    writer.write(32);
                }
                writer.write("\n");
                ++this.recordCount;
                return this.createWriteResult();
            }

            private WriteResult createWriteResult() {
                return new WriteResult(){

                    public int getRecordCount() {
                        return recordCount;
                    }

                    public Map<String, String> getAttributes() {
                        return Collections.emptyMap();
                    }
                };
            }

            public String getMimeType() {
                return "text/csv";
            }

            public void flush() throws IOException {
                writer.flush();
            }

            public void close() throws IOException {
                writer.close();
            }
        };
    }
}

