/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cs.tests.system;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;

public class MockCSVReader
extends AbstractControllerService
implements RecordReaderFactory {
    public RecordReader createRecordReader(FlowFile flowFile, InputStream in, ComponentLog logger) throws IOException {
        return this.createRecordReader(flowFile.getAttributes(), in, flowFile.getSize(), logger);
    }

    public RecordReader createRecordReader(Map<String, String> variables, InputStream in, long inputLength, ComponentLog logger) throws IOException {
        String[] colNames;
        InputStreamReader inputStreamReader = new InputStreamReader(in);
        final BufferedReader reader = new BufferedReader(inputStreamReader);
        final ArrayList<String> fieldNames = new ArrayList<String>();
        String firstLine = reader.readLine();
        for (String colName : colNames = firstLine.split(",")) {
            fieldNames.add(colName.trim());
        }
        ArrayList<RecordField> fields = new ArrayList<RecordField>();
        for (String fieldName : fieldNames) {
            fields.add(new RecordField(fieldName, RecordFieldType.STRING.getDataType()));
        }
        SimpleRecordSchema schema = new SimpleRecordSchema(fields);
        return new RecordReader(){
            final /* synthetic */ RecordSchema val$schema;
            {
                this.val$schema = recordSchema;
            }

            public Record nextRecord(boolean coerceTypes, boolean dropUnknownFields) throws IOException, MalformedRecordException {
                String nextLine;
                HashMap<String, String> values = new HashMap<String, String>();
                while ((nextLine = reader.readLine()) != null) {
                    if ((nextLine = nextLine.trim()).isEmpty()) continue;
                    String[] colValues = nextLine.split(",");
                    int i = 0;
                    for (String colValue : colValues) {
                        String colName = (String)fieldNames.get(i++);
                        values.put(colName, colValue.trim());
                    }
                    return new MapRecord(this.val$schema, values);
                }
                return null;
            }

            public RecordSchema getSchema() {
                return this.val$schema;
            }

            public void close() throws IOException {
                reader.close();
            }
        };
    }
}

