/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cs.tests.system;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.VerifiableControllerService;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.util.StandardValidators;

public class EnsureControllerServiceConfigurationCorrect
extends AbstractControllerService
implements VerifiableControllerService {
    static final PropertyDescriptor SUCCESSFUL_VERIFICATION = new PropertyDescriptor.Builder().name("Successful Verification").displayName("Successful Verification").description("Whether or not Verification should succeed").required(true).allowableValues(new String[]{"true", "false"}).build();
    static final PropertyDescriptor VERIFICATION_STEPS = new PropertyDescriptor.Builder().name("Verification Steps").displayName("Verification Steps").description("The number of steps to use in the Verification").required(true).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue("1").build();
    static final PropertyDescriptor EXCEPTION_ON_VERIFICATION = new PropertyDescriptor.Builder().name("Exception on Verification").displayName("Exception on Verification").description("If true, attempting to perform verification will throw a RuntimeException").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    static final PropertyDescriptor FAILURE_NODE_NUMBER = new PropertyDescriptor.Builder().name("Failure Node Number").displayName("Failure Node Number").description("The Node Number to Fail On").required(false).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Arrays.asList(SUCCESSFUL_VERIFICATION, VERIFICATION_STEPS, EXCEPTION_ON_VERIFICATION, FAILURE_NODE_NUMBER);
    }

    public List<ConfigVerificationResult> verify(ConfigurationContext context, ComponentLog verificationLogger, Map<String, String> attributes) {
        int iterations;
        boolean exception = context.getProperty(EXCEPTION_ON_VERIFICATION).asBoolean();
        if (exception) {
            throw new RuntimeException("Intentional Exception - Processor was configured to throw an Exception when performing config verification");
        }
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>();
        try {
            iterations = context.getProperty(VERIFICATION_STEPS).evaluateAttributeExpressions(attributes).asInteger();
        }
        catch (NumberFormatException nfe) {
            results.add(new ConfigVerificationResult.Builder().verificationStepName("Determine Number of Verification Steps").outcome(ConfigVerificationResult.Outcome.FAILED).explanation("Invalid value for the number of Verification Steps").build());
            return results;
        }
        boolean success = context.getProperty(SUCCESSFUL_VERIFICATION).asBoolean();
        ConfigVerificationResult.Outcome outcome = success ? ConfigVerificationResult.Outcome.SUCCESSFUL : ConfigVerificationResult.Outcome.FAILED;
        for (int i = 0; i < iterations; ++i) {
            results.add(new ConfigVerificationResult.Builder().verificationStepName("Verification Step #" + i).outcome(outcome).explanation("Verification Step #" + i).build());
        }
        Integer failureNodeNum = context.getProperty(FAILURE_NODE_NUMBER).asInteger();
        if (failureNodeNum == null) {
            results.add(new ConfigVerificationResult.Builder().verificationStepName("Fail Based on Node Number").outcome(ConfigVerificationResult.Outcome.SKIPPED).explanation("Not configured to Fail based on node number").build());
        } else {
            String currentNodeNumberString = System.getProperty("nodeNumber");
            Integer currentNodeNumber = currentNodeNumberString == null ? null : Integer.valueOf(Integer.parseInt(currentNodeNumberString));
            boolean shouldFail = Objects.equals(failureNodeNum, currentNodeNumber);
            if (shouldFail) {
                results.add(new ConfigVerificationResult.Builder().verificationStepName("Fail Based on Node Number").outcome(ConfigVerificationResult.Outcome.FAILED).explanation("This node is Node Number " + currentNodeNumberString + " and configured to fail on this Node Number").build());
            } else {
                results.add(new ConfigVerificationResult.Builder().verificationStepName("Fail Based on Node Number").outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation("This node is Node Number " + currentNodeNumberString + " and configured not to fail on this Node Number").build());
            }
        }
        return results;
    }
}

