/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.repository;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.KeyManagementException;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.apache.nifi.security.kms.EncryptionException;
import org.apache.nifi.security.kms.KeyProvider;
import org.apache.nifi.security.kms.KeyProviderFactory;
import org.apache.nifi.security.repository.RepositoryObjectEncryptionMetadata;
import org.apache.nifi.security.repository.RepositoryType;
import org.apache.nifi.security.repository.config.RepositoryEncryptionConfiguration;
import org.apache.nifi.security.util.EncryptionMethod;
import org.apache.nifi.security.util.crypto.AESKeyedCipherProvider;
import org.apache.nifi.stream.io.NonCloseableInputStream;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryEncryptorUtils {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryEncryptorUtils.class);
    private static final int CONTENT_HEADER_SIZE = 2;
    private static final int IV_LENGTH = 16;
    private static final byte[] EMPTY_IV = new byte[16];
    private static final String VERSION = "v1";
    private static final List<String> SUPPORTED_VERSIONS = Arrays.asList("v1");
    private static final int MIN_METADATA_LENGTH = 22;
    private static final int METADATA_DEFAULT_LENGTH = (53 + "v1".length()) * 2;

    public static byte[] serializeEncryptionMetadata(RepositoryObjectEncryptionMetadata metadata) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream outputStream = new ObjectOutputStream(baos);
        outputStream.writeObject(metadata);
        outputStream.close();
        return baos.toByteArray();
    }

    public static Cipher initCipher(AESKeyedCipherProvider aesKeyedCipherProvider, EncryptionMethod method, int mode, SecretKey key, byte[] ivBytes) throws EncryptionException {
        try {
            if (method == null || key == null || ivBytes == null) {
                throw new IllegalArgumentException("Missing critical information");
            }
            return aesKeyedCipherProvider.getCipher(method, key, ivBytes, mode == 1);
        }
        catch (Exception e) {
            logger.error("Encountered an exception initializing the cipher", (Throwable)e);
            throw new EncryptionException(e);
        }
    }

    public static RepositoryObjectEncryptionMetadata extractEncryptionMetadata(byte[] encryptedRecord) throws EncryptionException, IOException, ClassNotFoundException {
        if (encryptedRecord == null || encryptedRecord.length < 22) {
            throw new EncryptionException("The encrypted record is too short to contain the metadata");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(encryptedRecord);
        try (ObjectInputStream ois = new ObjectInputStream(bais);){
            RepositoryObjectEncryptionMetadata repositoryObjectEncryptionMetadata = (RepositoryObjectEncryptionMetadata)ois.readObject();
            return repositoryObjectEncryptionMetadata;
        }
    }

    public static RepositoryObjectEncryptionMetadata extractEncryptionMetadata(InputStream encryptedRecord) throws EncryptionException, IOException, ClassNotFoundException {
        if (encryptedRecord == null) {
            throw new EncryptionException("The encrypted record is too short to contain the metadata");
        }
        encryptedRecord.read(new byte[2]);
        try (ObjectInputStream ois = new ObjectInputStream((InputStream)new NonCloseableInputStream(encryptedRecord));){
            RepositoryObjectEncryptionMetadata repositoryObjectEncryptionMetadata = (RepositoryObjectEncryptionMetadata)ois.readObject();
            return repositoryObjectEncryptionMetadata;
        }
    }

    public static byte[] extractCipherBytes(byte[] encryptedRecord, RepositoryObjectEncryptionMetadata metadata) {
        int cipherBytesStart = metadata.cipherByteLength > 0 ? encryptedRecord.length - metadata.cipherByteLength : metadata.length() + 2;
        return Arrays.copyOfRange(encryptedRecord, cipherBytesStart, encryptedRecord.length);
    }

    public static KeyProvider buildKeyProvider(NiFiProperties niFiProperties, SecretKey masterKey, RepositoryType repositoryType) throws KeyManagementException {
        RepositoryEncryptionConfiguration rec = RepositoryEncryptionConfiguration.fromNiFiProperties(niFiProperties, repositoryType);
        if (rec.getKeyProviderImplementation() == null) {
            throw new KeyManagementException("Cannot create key provider because the NiFi properties are missing the following property: nifi.content.repository.encryption.key.provider.implementation");
        }
        return KeyProviderFactory.buildKeyProvider(rec, masterKey);
    }
}

