/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.server.codec;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.Map;
import java.util.Objects;
import org.apache.nifi.distributed.cache.server.codec.CacheRequestDecoder;
import org.apache.nifi.distributed.cache.server.protocol.CacheVersionRequest;
import org.apache.nifi.distributed.cache.server.protocol.CacheVersionResponse;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.remote.VersionNegotiator;

public class CacheVersionRequestHandler
extends SimpleChannelInboundHandler<CacheVersionRequest> {
    private final ComponentLog log;
    private final VersionNegotiator versionNegotiator;

    public CacheVersionRequestHandler(ComponentLog log, VersionNegotiator versionNegotiator) {
        this.log = Objects.requireNonNull(log, "Component Log required");
        this.versionNegotiator = Objects.requireNonNull(versionNegotiator, "Version Negotiator required");
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, CacheVersionRequest cacheVersionRequest) {
        for (Map.Entry entry : channelHandlerContext.channel().pipeline()) {
            ChannelHandler channelHandler = (ChannelHandler)entry.getValue();
            if (!(channelHandler instanceof CacheRequestDecoder)) continue;
            CacheRequestDecoder cacheRequestDecoder = (CacheRequestDecoder)channelHandler;
            int requestedVersion = cacheVersionRequest.getVersion();
            CacheVersionResponse cacheVersionResponse = this.handleVersion(cacheRequestDecoder, requestedVersion);
            channelHandlerContext.writeAndFlush((Object)cacheVersionResponse);
        }
    }

    private CacheVersionResponse handleVersion(CacheRequestDecoder cacheRequestDecoder, int requestedVersion) {
        CacheVersionResponse cacheVersionResponse;
        if (this.versionNegotiator.isVersionSupported(requestedVersion)) {
            this.log.debug("Cache Version Supported [{}]", new Object[]{requestedVersion});
            cacheRequestDecoder.setProtocolVersion(requestedVersion);
            cacheVersionResponse = new CacheVersionResponse(20, requestedVersion);
        } else {
            Integer preferredVersion = this.versionNegotiator.getPreferredVersion(requestedVersion);
            if (preferredVersion == null) {
                this.log.debug("Cache Version Rejected [{}]", new Object[]{requestedVersion});
                cacheVersionResponse = new CacheVersionResponse(255, requestedVersion);
            } else {
                this.log.debug("Cache Version Rejected [{}] Preferred [{}]", new Object[]{requestedVersion, preferredVersion});
                cacheVersionResponse = new CacheVersionResponse(21, preferredVersion);
            }
        }
        return cacheVersionResponse;
    }
}

