/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbm;

import com.google.common.collect.Sets;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.netbeans.nbm.AbstractNbmMojo;
import org.apache.netbeans.nbm.utils.ExamineManifest;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.filters.StringInputStream;
import org.apache.tools.ant.taskdefs.Chmod;
import org.apache.tools.ant.types.FileSet;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.io.InputStreamFacade;
import org.netbeans.nbbuild.MakeListOfNBM;

@Mojo(name="cluster-app", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class CreateClusterAppMojo
extends AbstractNbmMojo {
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(required=true, readonly=true, property="project")
    private MavenProject project;
    @Parameter(property="netbeans.branding.token", required=true)
    protected String brandingToken;
    @Parameter(property="netbeans.conf.file")
    private File etcConfFile;
    @Parameter(property="netbeans.clusters.file")
    private File etcClustersFile;
    @Parameter(property="netbeans.bin.directory")
    private File binDirectory;
    @Parameter(defaultValue="extra")
    private String defaultCluster;
    @Parameter(defaultValue="true", property="netbeans.verify.integrity")
    private boolean verifyIntegrity;
    @Parameter(defaultValue="org.netbeans", property="groupIdPrefix")
    private String groupIdPrefix;
    private final Collection<String> defaultPlatformTokens = Arrays.asList("org.openide.modules.os.Windows", "org.openide.modules.os.Unix", "org.openide.modules.os.MacOSX", "org.openide.modules.os.OS2", "org.openide.modules.os.PlainUnix", "org.openide.modules.os.Linux", "org.openide.modules.os.Solaris", "org.openide.modules.ModuleFormat1", "org.openide.modules.ModuleFormat2", "org.openide.modules.jre.JavaFX");
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private ArtifactResolver artifactResolver;
    @Parameter(required=true, readonly=true, property="localRepository")
    protected ArtifactRepository localRepository;
    private static final Pattern PATT = Pattern.compile(".*targetcluster=\"([a-zA-Z0-9_\\.\\-]+)\".*", 32);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        File[] files;
        File nbmBuildDirFile = new File(this.outputDirectory, this.brandingToken);
        if (!nbmBuildDirFile.exists()) {
            nbmBuildDirFile.mkdirs();
        }
        if (!"nbm-application".equals(this.project.getPackaging())) throw new MojoExecutionException("This goal only makes sense on project with nbm-application packaging");
        Project antProject = this.registerNbmAntTasks();
        File[] wrappedBundleCNBs = new HashSet(100);
        HashMap<String, Set<String>> clusterDependencies = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> clusterModules = new HashMap<String, Set<String>>();
        HashSet<String> modulesCNBs = new HashSet<String>(200);
        HashSet dependencyCNBs = new HashSet(200);
        HashMap<String, Set<String>> dependencyCNBBacktraces = new HashMap<String, Set<String>>(50);
        HashSet requireTokens = new HashSet(50);
        HashMap<String, Set<String>> requireTokensBacktraces = new HashMap<String, Set<String>>(50);
        HashSet provideTokens = new HashSet(50);
        HashSet osgiImports = new HashSet(50);
        HashMap<String, Set<String>> osgiImportsBacktraces = new HashMap<String, Set<String>>(50);
        HashSet<String> osgiExports = new HashSet<String>(50);
        HashSet<String> osgiExportsSubs = new HashSet<String>(50);
        ArrayList<BundleTuple> bundles = new ArrayList<BundleTuple>();
        Set artifacts = this.project.getArtifacts();
        for (Artifact art : artifacts) {
            AbstractNbmMojo.ArtifactResult res;
            block68: {
                res = this.turnJarToNbmFile(art, this.artifactFactory, this.artifactResolver, this.project, this.localRepository);
                if (res.hasConvertedArtifact()) {
                    art = res.getConvertedArtifact();
                }
                if (art.getType().equals("nbm-file")) {
                    try (JarFile jf = new JarFile(art.getFile());){
                        ExamineManifest ex;
                        Iterator clusterName = this.findCluster(jf);
                        ClusterTuple cluster = this.processCluster((String)((Object)clusterName), nbmBuildDirFile, art);
                        this.getLog().debug((CharSequence)("Copying " + art.getId() + " to cluster " + (String)((Object)clusterName)));
                        Enumeration<JarEntry> enu = jf.entries();
                        MakeListOfNBM makeTask = (MakeListOfNBM)antProject.createTask("genlist");
                        antProject.setNewProperty("module.name", art.getFile().getName());
                        antProject.setProperty("cluster.dir", clusterName);
                        FileSet set = makeTask.createFileSet();
                        set.setDir(cluster.location);
                        makeTask.setOutputfiledir(cluster.location);
                        String[] executables = null;
                        File classpathRoot = null;
                        String classPath = null;
                        while (enu.hasMoreElements()) {
                            JarEntry ent = enu.nextElement();
                            String[] name = ent.getName();
                            if (name.equals("Info/executables.list")) {
                                if (!cluster.newer) continue;
                                InputStream is = jf.getInputStream(ent);
                                executables = StringUtils.split((String)IOUtil.toString((InputStream)is, (String)"UTF-8"), (String)"\n");
                                continue;
                            }
                            if (!name.startsWith("netbeans/")) continue;
                            String path = clusterName + name.substring("netbeans".length());
                            int ispack200 = path.endsWith(".jar.pack.gz") ? 1 : 0;
                            if (ispack200 != 0) {
                                path = path.replace(".jar.pack.gz", ".jar");
                            }
                            File fl = new File(nbmBuildDirFile, path.replace("/", File.separator));
                            String part = name.substring("netbeans/".length());
                            if (ispack200 != 0) {
                                part = part.replace(".jar.pack.gz", ".jar");
                            }
                            if (cluster.newer) {
                                if (ent.isDirectory()) {
                                    fl.mkdirs();
                                } else if (path.endsWith(".external")) {
                                    try (InputStream is = jf.getInputStream(ent);){
                                        this.externalDownload(new File(fl.getParentFile(), fl.getName().replaceFirst("[.]external$", "")), is);
                                    }
                                    set.appendIncludes(new String[]{name.substring("netbeans/".length(), name.length() - ".external".length())});
                                } else {
                                    BufferedOutputStream outstream;
                                    block67: {
                                        set.appendIncludes(new String[]{part});
                                        fl.getParentFile().mkdirs();
                                        fl.createNewFile();
                                        outstream = null;
                                        try {
                                            outstream = new BufferedOutputStream(new FileOutputStream(fl));
                                            Iterator instream = jf.getInputStream(ent);
                                            if (ispack200 != 0) {
                                                Pack200.Unpacker unp = Pack200.newUnpacker();
                                                GZIPInputStream gzip = new GZIPInputStream((InputStream)((Object)instream));
                                                try (JarOutputStream jos = new JarOutputStream(outstream);){
                                                    unp.unpack((InputStream)gzip, jos);
                                                    break block67;
                                                }
                                            }
                                            IOUtil.copy((InputStream)((Object)instream), (OutputStream)outstream);
                                        }
                                        catch (Throwable throwable) {
                                            IOUtil.close(outstream);
                                            throw throwable;
                                        }
                                    }
                                    IOUtil.close((OutputStream)outstream);
                                }
                            }
                            if (!part.matches("(modules|core|lib)/[^/]+[.]jar")) continue;
                            ex = new ExamineManifest(this.getLog());
                            ex.setJarFile(fl);
                            ex.setPopulateDependencies(true);
                            ex.checkFile();
                            if (ex.isNetBeansModule()) {
                                makeTask.setModule(part);
                                CreateClusterAppMojo.addToMap(clusterDependencies, clusterName, ex.getDependencyTokens());
                                CreateClusterAppMojo.addToMap(clusterModules, clusterName, Collections.singletonList(ex.getModule()));
                                if (ex.getClasspath().length() > 0) {
                                    classPath = ex.getClasspath();
                                    classpathRoot = fl.getParentFile();
                                }
                            }
                            if (!this.verifyIntegrity) continue;
                            dependencyCNBs.addAll(ex.getDependencyTokens());
                            modulesCNBs.add(ex.getModule());
                            for (String d : ex.getDependencyTokens()) {
                                CreateClusterAppMojo.addToMap(dependencyCNBBacktraces, d, Collections.singletonList(ex.getModule()));
                            }
                            if (!ex.isNetBeansModule()) continue;
                            requireTokens.addAll(ex.getNetBeansRequiresTokens());
                            for (String r : ex.getNetBeansRequiresTokens()) {
                                CreateClusterAppMojo.addToMap(requireTokensBacktraces, r, Collections.singletonList(ex.getModule()));
                            }
                            provideTokens.addAll(ex.getNetBeansProvidesTokens());
                            for (String pack : ex.getPackages()) {
                                if (pack.endsWith(".**")) {
                                    pack = pack.substring(0, pack.length() - ".**".length());
                                    osgiExportsSubs.add(pack);
                                    continue;
                                }
                                if (!pack.endsWith(".*")) continue;
                                pack = pack.substring(0, pack.length() - ".*".length());
                                osgiExports.add(pack);
                            }
                        }
                        if (classPath != null) {
                            String[] paths;
                            for (String path : paths = StringUtils.split(classPath, (String)" ")) {
                                File jdk7;
                                String jhm;
                                path = path.trim();
                                File classpathFile = new File(classpathRoot, path);
                                if (path.equals("${java.home}/lib/ext/jfxrt.jar") && !(classpathFile = new File(new File(new File(new File(jhm = System.getProperty("java.home")), "lib"), "ext"), "jfxrt.jar")).exists() && (jdk7 = new File(new File(new File(jhm), "lib"), "jfxrt.jar")).exists()) {
                                    classpathFile = jdk7;
                                }
                                if (!classpathFile.isFile()) {
                                    this.getLog().warn((CharSequence)("Could not resolve Class-Path item in " + art.getId() + ", path is:" + path + ", skipping"));
                                    continue;
                                }
                                ex = new ExamineManifest(this.getLog());
                                ex.setJarFile(classpathFile);
                                ex.checkFile();
                                if (!ex.isOsgiBundle() || art.getId().contains(this.groupIdPrefix + ".modules:org-netbeans-modules-maven-embedder")) continue;
                                this.getLog().info((CharSequence)(ex.getModule() + " added by " + art.getId() + "" + classpathFile));
                                wrappedBundleCNBs.add(ex.getModule());
                            }
                        }
                        if (!cluster.newer) break block68;
                        try {
                            makeTask.execute();
                        }
                        catch (BuildException e) {
                            this.getLog().error((CharSequence)("Cannot Generate update_tracking XML file from " + art.getFile()));
                            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
                        }
                        if (executables != null) {
                            for (String exec : executables) {
                                File execFile = new File(cluster.location, exec = exec.replace("/", File.separator));
                                if (!execFile.exists()) continue;
                                execFile.setExecutable(true, false);
                            }
                        }
                    }
                    catch (IOException ex) {
                        this.getLog().error((CharSequence)art.getFile().getAbsolutePath(), (Throwable)ex);
                    }
                }
            }
            if (!res.isOSGiBundle()) continue;
            ExamineManifest ex = res.getExaminedManifest();
            bundles.add(new BundleTuple(art, ex));
            if (!this.verifyIntegrity) continue;
            dependencyCNBs.addAll(ex.getDependencyTokens());
            for (String d : ex.getDependencyTokens()) {
                CreateClusterAppMojo.addToMap(dependencyCNBBacktraces, d, Collections.singletonList(ex.getModule()));
            }
            modulesCNBs.add(ex.getModule());
            osgiImports.addAll(ex.getOsgiImports());
            for (String d : ex.getOsgiImports()) {
                CreateClusterAppMojo.addToMap(osgiImportsBacktraces, d, Collections.singletonList(ex.getModule()));
            }
            osgiExports.addAll(ex.getOsgiExports());
        }
        if (this.verifyIntegrity) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("All found codenamebases:" + Arrays.toString(modulesCNBs.toArray())));
                this.getLog().debug((CharSequence)("All found OSGI exports:" + Arrays.toString(osgiExports.toArray())));
                this.getLog().debug((CharSequence)("All found provided tokens:" + Arrays.toString(provideTokens.toArray())));
            }
            dependencyCNBs.removeAll(modulesCNBs);
            if (modulesCNBs.contains("org.netbeans.modules.netbinox")) {
                dependencyCNBs.remove("org.eclipse.osgi");
            }
            osgiImports.removeAll(osgiExports);
            Iterator it = osgiImports.iterator();
            block30: while (it.hasNext()) {
                String s = (String)it.next();
                if (s.startsWith("java.") || s.startsWith("javax.") || s.startsWith("sun.") || s.startsWith("org.xml.sax") || s.startsWith("org.w3c.dom") || s.startsWith("org.ietf.jgss")) {
                    it.remove();
                    continue;
                }
                for (String sub : osgiExportsSubs) {
                    if (!s.startsWith(sub)) continue;
                    it.remove();
                    continue block30;
                }
            }
            requireTokens.removeAll(provideTokens);
            requireTokens.removeAll(this.defaultPlatformTokens);
            if (!(dependencyCNBs.isEmpty() && osgiImports.isEmpty() && requireTokens.isEmpty())) {
                Set back;
                if (!dependencyCNBs.isEmpty()) {
                    this.getLog().error((CharSequence)"Some included modules/bundles depend on these codenamebases but they are not included. The application will fail starting up. The missing codenamebases are:");
                    for (String s : dependencyCNBs) {
                        back = (Set)dependencyCNBBacktraces.get(s);
                        this.getLog().error((CharSequence)("   " + s + (back != null ? "          ref: " + Arrays.toString(back.toArray()) : "")));
                    }
                }
                if (!osgiImports.isEmpty()) {
                    this.getLog().error((CharSequence)"Some OSGi imports are not satisfied by included bundles' exports. The application will fail starting up. The missing imports are:");
                    for (String s : osgiImports) {
                        back = (Set)osgiImportsBacktraces.get(s);
                        this.getLog().error((CharSequence)("   " + s + (back != null ? "          ref: " + Arrays.toString(back.toArray()) : "")));
                    }
                }
                if (requireTokens.isEmpty()) throw new MojoFailureException("See above for consistency validation check failures. Either fix those by adding the relevant dependencies to the application or disable the check by setting the verifyIntegrity parameter to false or by running with -Dnetbeans.verify.integrity=false cmd line parameter.");
                this.getLog().error((CharSequence)"Some tokens required by included modules are not provided by included modules. The application will fail starting up. The missing tokens are:");
                Iterator iterator = requireTokens.iterator();
                while (iterator.hasNext()) {
                    String s;
                    s = (String)iterator.next();
                    back = (Set)requireTokensBacktraces.get(s);
                    this.getLog().error((CharSequence)("   " + s + (back != null ? "          ref: " + Arrays.toString(back.toArray()) : "")));
                }
                throw new MojoFailureException("See above for consistency validation check failures. Either fix those by adding the relevant dependencies to the application or disable the check by setting the verifyIntegrity parameter to false or by running with -Dnetbeans.verify.integrity=false cmd line parameter.");
            }
            this.getLog().info((CharSequence)"Integrity verification passed.");
        } else {
            this.getLog().info((CharSequence)"Integrity verification skipped.");
        }
        Map<String, Set<String>> cluster2depClusters = CreateClusterAppMojo.computeClusterOrdering(clusterDependencies, clusterModules);
        clusterModules.clear();
        CreateClusterAppMojo.assignClustersToBundles(bundles, wrappedBundleCNBs, clusterDependencies, cluster2depClusters, this.getLog());
        for (BundleTuple ent : bundles) {
            Artifact art = ent.artifact;
            final ExamineManifest ex = ent.manifest;
            String clstr = ent.cluster;
            if (clstr == null) {
                clstr = this.defaultCluster;
            }
            ClusterTuple cluster = this.processCluster(clstr, nbmBuildDirFile, art);
            if (!cluster.newer) continue;
            this.getLog().info((CharSequence)("Copying " + art.getId() + " to cluster " + clstr));
            File modules = new File(cluster.location, "modules");
            modules.mkdirs();
            File config = new File(cluster.location, "config");
            File confModules = new File(config, "Modules");
            confModules.mkdirs();
            File updateTracking = new File(cluster.location, "update_tracking");
            updateTracking.mkdirs();
            final String cnb = ex.getModule();
            String cnbDashed = cnb.replace(".", "-");
            final File moduleArt = new File(modules, cnbDashed + ".jar");
            final String specVer = ex.getSpecVersion();
            try {
                FileUtils.copyFile((File)art.getFile(), (File)moduleArt);
                final File moduleConf = new File(confModules, cnbDashed + ".xml");
                FileUtils.copyStreamToFile((InputStreamFacade)new InputStreamFacade(){

                    public InputStream getInputStream() throws IOException {
                        return new StringInputStream(CreateClusterAppMojo.createBundleConfigFile(cnb, ex.isBundleAutoload()), "UTF-8");
                    }
                }, (File)moduleConf);
                FileUtils.copyStreamToFile((InputStreamFacade)new InputStreamFacade(){

                    public InputStream getInputStream() throws IOException {
                        return new StringInputStream(CreateClusterAppMojo.createBundleUpdateTracking(cnb, moduleArt, moduleConf, specVer), "UTF-8");
                    }
                }, (File)new File(updateTracking, cnbDashed + ".xml"));
            }
            catch (IOException exc) {
                this.getLog().error((Throwable)exc);
            }
        }
        this.getLog().info((CharSequence)("Created NetBeans module cluster(s) at " + nbmBuildDirFile.getAbsoluteFile()));
        for (File file : files = nbmBuildDirFile.listFiles()) {
            if (!file.isDirectory()) continue;
            File stamp = new File(file, ".lastModified");
            if (!stamp.exists()) {
                try {
                    stamp.createNewFile();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            stamp.setLastModified(new Date().getTime());
        }
        try {
            this.createBinEtcDir(nbmBuildDirFile, this.brandingToken);
            return;
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Cannot process etc folder content creation.", (Exception)ex);
        }
    }

    private String findCluster(JarFile jf) throws MojoFailureException, IOException {
        ZipEntry entry = jf.getEntry("Info/info.xml");
        InputStream ins = jf.getInputStream(entry);
        String str = IOUtil.toString((InputStream)ins, (String)"UTF8");
        Matcher m = PATT.matcher(str);
        if (!m.matches()) {
            this.getLog().info((CharSequence)("Cannot find cluster for " + jf.getName() + " Falling back to default value - '" + this.defaultCluster + "'."));
            return this.defaultCluster;
        }
        return m.group(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createBinEtcDir(File buildDir, String brandingToken) throws IOException, MojoExecutionException {
        String str;
        File etcDir;
        block35: {
            File confFile;
            block34: {
                String clustersString;
                etcDir = new File(buildDir + File.separator + "etc");
                etcDir.mkdir();
                File clusterConf = new File(etcDir + File.separator + brandingToken + ".clusters");
                if (this.etcClustersFile != null) {
                    clustersString = FileUtils.fileRead((File)this.etcClustersFile, (String)"UTF-8");
                } else {
                    File[] clusters;
                    clusterConf.createNewFile();
                    StringBuilder buffer = new StringBuilder();
                    for (File cluster : clusters = buildDir.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return new File(pathname, ".lastModified").exists();
                        }
                    })) {
                        buffer.append(cluster.getName());
                        buffer.append("\n");
                    }
                    clustersString = buffer.toString();
                }
                FileUtils.fileWrite((String)clusterConf.getAbsolutePath(), (String)clustersString);
                confFile = this.etcConfFile;
                if (confFile != null) break block34;
                File harnessDir = new File(buildDir, "harness");
                confFile = new File(harnessDir.getAbsolutePath() + File.separator + "etc" + File.separator + "app.conf");
                if (confFile.exists()) {
                    str = FileUtils.fileRead((File)confFile, (String)"UTF-8");
                    break block35;
                } else {
                    this.getLog().debug((CharSequence)"Using fallback app.conf shipping with the nbm-maven-plugin.");
                    InputStream instream = null;
                    try {
                        instream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("harness/etc/app.conf");
                        str = IOUtil.toString((InputStream)instream, (String)"UTF-8");
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(instream);
                        throw throwable;
                    }
                    IOUtil.close((InputStream)instream);
                }
                break block35;
            }
            str = FileUtils.fileRead((File)confFile, (String)"UTF-8");
        }
        File confDestFile = new File(etcDir.getAbsolutePath() + File.separator + brandingToken + ".conf");
        str = str.replace("${branding.token}", brandingToken);
        FileUtils.fileWrite((String)confDestFile.getAbsolutePath(), (String)"UTF-8", (String)str);
        File destBinDir = new File(buildDir + File.separator + "bin");
        destBinDir.mkdir();
        File destExeW = new File(destBinDir, brandingToken + "_w.exe");
        File destExe = new File(destBinDir, brandingToken + ".exe");
        File destExe64 = new File(destBinDir, brandingToken + "64.exe");
        File destSh = new File(destBinDir, brandingToken);
        if (this.binDirectory != null) {
            File binDir = this.binDirectory;
            File[] fls = binDir.listFiles();
            if (fls == null) {
                throw new MojoExecutionException("Parameter 'binDirectory' has to point to an existing folder.");
            }
            for (File fl : fls) {
                String name = fl.getName();
                File dest = null;
                if (name.endsWith("_w.exe")) {
                    dest = destExeW;
                } else if (name.endsWith("64.exe")) {
                    dest = destExe64;
                } else if (name.endsWith(".exe")) {
                    dest = destExe;
                } else if (!name.contains(".") || name.endsWith(".sh")) {
                    dest = destSh;
                }
                if (dest == null || !fl.exists()) continue;
                FileUtils.copyFile((File)fl, (File)dest);
            }
        } else {
            File harnessDir = new File(buildDir, "harness");
            File binDir = new File(harnessDir.getAbsolutePath() + File.separator + "launchers");
            if (binDir.exists()) {
                File exew;
                File exe = new File(binDir, "app.exe");
                FileUtils.copyFile((File)exe, (File)destExe);
                File exe64 = new File(binDir, "app64.exe");
                if (exe64.isFile()) {
                    FileUtils.copyFile((File)exe64, (File)destExe64);
                }
                if ((exew = new File(binDir, "app_w.exe")).exists()) {
                    FileUtils.copyFile((File)exew, (File)destExeW);
                }
                File sh = new File(binDir, "app.sh");
                FileUtils.copyFile((File)sh, (File)destSh);
            } else {
                File nbm = this.getHarnessNbm();
                try (ZipFile zip = new ZipFile(nbm);){
                    this.getLog().debug((CharSequence)"Using fallback executables from downloaded org-netbeans-modules-apisupport-harness nbm file.");
                    this.writeFromZip(zip, "netbeans/launchers/app.sh", destSh, true);
                    this.writeFromZip(zip, "netbeans/launchers/app.exe", destExe, true);
                    this.writeFromZip(zip, "netbeans/launchers/app64.exe", destExe64, false);
                    this.writeFromZip(zip, "netbeans/launchers/app_w.exe", destExeW, false);
                }
            }
        }
        Project antProject = this.antProject();
        Chmod chmod = (Chmod)antProject.createTask("chmod");
        FileSet fs = new FileSet();
        fs.setDir(destBinDir);
        fs.setIncludes("*");
        chmod.addFileset(fs);
        chmod.setPerm("755");
        chmod.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String path, File destSh) throws IOException {
        InputStream instream = null;
        BufferedOutputStream output = null;
        try {
            instream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(path);
            if (instream == null) {
                throw new FileNotFoundException(path);
            }
            destSh.createNewFile();
            output = new BufferedOutputStream(new FileOutputStream(destSh));
            IOUtil.copy((InputStream)instream, (OutputStream)output);
        }
        catch (Throwable throwable) {
            IOUtil.close(instream);
            IOUtil.close(output);
            throw throwable;
        }
        IOUtil.close((InputStream)instream);
        IOUtil.close((OutputStream)output);
    }

    private ClusterTuple processCluster(String cluster, File nbmBuildDirFile, Artifact art) {
        File clusterFile = new File(nbmBuildDirFile, cluster);
        boolean newer = false;
        if (!clusterFile.exists()) {
            clusterFile.mkdir();
            newer = true;
        } else {
            File stamp = new File(clusterFile, ".lastModified");
            if (stamp.lastModified() < art.getFile().lastModified()) {
                newer = true;
            }
        }
        return new ClusterTuple(clusterFile, newer);
    }

    private void externalDownload(File f, InputStream is) throws IOException {
        String line;
        BufferedReader r = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        long crc = -1L;
        long size = -1L;
        boolean found = false;
        while ((line = r.readLine()) != null) {
            if (line.startsWith("CRC:")) {
                crc = Long.parseLong(line.substring(4).trim());
                continue;
            }
            if (line.startsWith("URL:")) {
                String rest = line.substring(4).trim();
                if (rest.startsWith("m2:/")) {
                    if (found) continue;
                    String[] coords = rest.substring(4).trim().split(":");
                    Artifact artifact = coords.length == 4 ? this.artifactFactory.createArtifact(coords[0], coords[1], coords[2], null, coords[3]) : this.artifactFactory.createArtifactWithClassifier(coords[0], coords[1], coords[2], coords[3], coords[4]);
                    try {
                        this.artifactResolver.resolve(artifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
                        FileUtils.copyFile((File)artifact.getFile(), (File)f);
                        found = true;
                    }
                    catch (AbstractArtifactResolutionException x) {
                        this.getLog().warn((CharSequence)("Cannot find " + line.substring(8)), (Throwable)x);
                    }
                    continue;
                }
                if (found) continue;
                String url = line.substring(4).trim();
                try {
                    FileUtils.copyURLToFile((URL)new URL(url), (File)f);
                    found = true;
                }
                catch (IOException x) {
                    this.getLog().warn((CharSequence)("Cannot download " + url), (Throwable)x);
                }
                continue;
            }
            if (line.startsWith("SIZE:")) {
                size = Long.parseLong(line.substring(5).trim());
                continue;
            }
            this.getLog().warn((CharSequence)("Unrecognized line: " + line));
        }
        if (!found) {
            throw new IOException("Could not download " + f);
        }
        if (crc != -1L && crc != CreateClusterAppMojo.crcForFile(f).getValue()) {
            throw new IOException("CRC-32 of " + f + " does not match declared " + crc);
        }
        if (size != -1L && size != f.length()) {
            throw new IOException("Size of " + f + " does not match declared " + size);
        }
    }

    private File getHarnessNbm() throws MojoExecutionException {
        Set artifacts = this.project.getArtifacts();
        String version = null;
        for (Artifact a : artifacts) {
            if (!(this.groupIdPrefix + ".modules").equals(a.getGroupId()) || !"org-netbeans-bootstrap".equals(a.getArtifactId())) continue;
            version = a.getBaseVersion();
            break;
        }
        if (version == null) {
            throw new MojoExecutionException("We could not find org-netbeans-bootstrap among the modules in the application. Launchers could not be found.");
        }
        Artifact nbmArt = this.artifactFactory.createArtifact(this.groupIdPrefix + ".modules", "org-netbeans-modules-apisupport-harness", version, "compile", "nbm-file");
        try {
            this.artifactResolver.resolve(nbmArt, this.project.getRemoteArtifactRepositories(), this.localRepository);
        }
        catch (ArtifactNotFoundException | ArtifactResolutionException ex) {
            throw new MojoExecutionException("Failed to retrieve the nbm file from repository", (Exception)ex);
        }
        return nbmArt.getFile();
    }

    private void writeFromZip(final ZipFile zip, String zipPath, File destFile, boolean mandatory) throws MojoExecutionException, IOException {
        final ZipEntry path = zip.getEntry(zipPath);
        if (path == null) {
            if (mandatory) {
                throw new MojoExecutionException(zipPath + " not found in " + zip.getName());
            }
            this.getLog().debug((CharSequence)(zipPath + " is not present in " + zip.getName()));
            return;
        }
        FileUtils.copyStreamToFile((InputStreamFacade)new InputStreamFacade(){

            public InputStream getInputStream() throws IOException {
                return zip.getInputStream(path);
            }
        }, (File)destFile);
    }

    private static void addToMap(Map<String, Set<String>> map, String clusterName, List<String> newValues) {
        Set<String> lst = map.get(clusterName);
        if (lst == null) {
            lst = new HashSet<String>();
            map.put(clusterName, lst);
        }
        if (newValues != null) {
            lst.addAll(newValues);
        }
    }

    private static List<String> findByDependencies(Map<String, Set<String>> clusterDependencies, String spec) {
        ArrayList<String> toRet = new ArrayList<String>();
        for (Map.Entry<String, Set<String>> entry : clusterDependencies.entrySet()) {
            if (!entry.getValue().contains(spec)) continue;
            toRet.add(entry.getKey());
        }
        return toRet;
    }

    static void assignClustersToBundles(List<BundleTuple> bundles, Set<String> wrappedBundleCNBs, Map<String, Set<String>> clusterDependencies, Map<String, Set<String>> cluster2depClusters, Log log) {
        ArrayList<BundleTuple> toProcess = new ArrayList<BundleTuple>();
        ArrayList<BundleTuple> known = new ArrayList<BundleTuple>();
        Iterator<BundleTuple> it = bundles.iterator();
        while (it.hasNext()) {
            BundleTuple ent = it.next();
            Artifact art = ent.artifact;
            ExamineManifest ex = ent.manifest;
            String spec = ex.getModule();
            if (art != null && art.getDependencyTrail().size() > 2 && wrappedBundleCNBs.contains(spec)) {
                log.debug((CharSequence)("Not including bundle " + art.getDependencyConflictId() + ". It is already included in a NetBeans module"));
                it.remove();
                continue;
            }
            List<String> depclusters = CreateClusterAppMojo.findByDependencies(clusterDependencies, spec);
            if (depclusters.size() == 1) {
                ent.cluster = depclusters.get(0);
                known.add(ent);
                continue;
            }
            if (depclusters.isEmpty()) {
                toProcess.add(ent);
                continue;
            }
            Iterator<String> it2 = depclusters.iterator();
            while (it2.hasNext()) {
                String s = it2.next();
                Set<String> depsCs = cluster2depClusters.get(s);
                boolean removeS = false;
                for (String sDep : depclusters) {
                    if (s.equals(sDep) || depsCs == null || !depsCs.contains(sDep)) continue;
                    removeS = true;
                }
                if (!removeS) continue;
                it2.remove();
            }
            ent.cluster = depclusters.get(0);
            known.add(ent);
        }
        if (!toProcess.isEmpty()) {
            CreateClusterAppMojo.walkKnownBundleDependenciesDown(known, toProcess);
        }
        if (!toProcess.isEmpty()) {
            CreateClusterAppMojo.walkKnownBundleDependenciesUp(known, toProcess);
        }
    }

    private static void walkKnownBundleDependenciesDown(List<BundleTuple> known, List<BundleTuple> toProcess) {
        boolean atLeastOneWasFound = false;
        Iterator<BundleTuple> it = toProcess.iterator();
        while (it.hasNext()) {
            BundleTuple bundleTuple = it.next();
            boolean found = false;
            for (BundleTuple knownBT : known) {
                Sets.SetView is = Sets.intersection((Set)bundleTuple.manifest.getOsgiExports(), (Set)knownBT.manifest.getOsgiImports());
                if (!is.isEmpty()) {
                    found = true;
                    bundleTuple.cluster = knownBT.cluster;
                    break;
                }
                is = Sets.intersection(Collections.singleton(bundleTuple.manifest.getModule()), new HashSet(knownBT.manifest.getDependencyTokens()));
                if (is.isEmpty()) continue;
                found = true;
                bundleTuple.cluster = knownBT.cluster;
                break;
            }
            if (!found) continue;
            atLeastOneWasFound = true;
            it.remove();
            known.add(bundleTuple);
        }
        if (!toProcess.isEmpty() && atLeastOneWasFound) {
            CreateClusterAppMojo.walkKnownBundleDependenciesDown(known, toProcess);
        }
    }

    private static void walkKnownBundleDependenciesUp(List<BundleTuple> known, List<BundleTuple> toProcess) {
        boolean atLeastOneWasFound = false;
        Iterator<BundleTuple> it = toProcess.iterator();
        while (it.hasNext()) {
            BundleTuple bundleTuple = it.next();
            boolean found = false;
            for (BundleTuple knownBT : known) {
                Sets.SetView is = Sets.intersection((Set)bundleTuple.manifest.getOsgiImports(), (Set)knownBT.manifest.getOsgiExports());
                if (!is.isEmpty()) {
                    found = true;
                    bundleTuple.cluster = knownBT.cluster;
                    break;
                }
                is = Sets.intersection(Collections.singleton(knownBT.manifest.getModule()), new HashSet(bundleTuple.manifest.getDependencyTokens()));
                if (is.isEmpty()) continue;
                found = true;
                bundleTuple.cluster = knownBT.cluster;
                break;
            }
            if (!found) continue;
            atLeastOneWasFound = true;
            it.remove();
            known.add(bundleTuple);
        }
        if (!toProcess.isEmpty() && atLeastOneWasFound) {
            CreateClusterAppMojo.walkKnownBundleDependenciesDown(known, toProcess);
        }
        if (!toProcess.isEmpty() && atLeastOneWasFound) {
            CreateClusterAppMojo.walkKnownBundleDependenciesUp(known, toProcess);
        }
    }

    static Map<String, Set<String>> computeClusterOrdering(Map<String, Set<String>> clusterDependencies, Map<String, Set<String>> clusterModules) {
        HashMap<String, Set<String>> cluster2depClusters = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> entry : clusterDependencies.entrySet()) {
            String cluster = entry.getKey();
            Set<String> deps = entry.getValue();
            for (Map.Entry<String, Set<String>> subEnt : clusterModules.entrySet()) {
                Sets.SetView is;
                if (subEnt.getKey().equals(cluster) || (is = Sets.intersection(subEnt.getValue(), deps)).isEmpty()) continue;
                CreateClusterAppMojo.addToMap(cluster2depClusters, cluster, Collections.singletonList(subEnt.getKey()));
            }
        }
        return cluster2depClusters;
    }

    static String createBundleConfigFile(String cnb, boolean autoload) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE module PUBLIC \"-//NetBeans//DTD Module Status 1.0//EN\"\n                        \"http://www.netbeans.org/dtds/module-status-1_0.dtd\">\n<module name=\"" + cnb + "\">\n    <param name=\"autoload\">" + autoload + "</param>\n    <param name=\"eager\">false</param>\n" + (autoload ? "" : "    <param name=\"enabled\">true</param>\n") + "    <param name=\"jar\">modules/" + cnb.replace(".", "-") + ".jar</param>\n    <param name=\"reloadable\">false</param>\n</module>\n";
    }

    static String createBundleUpdateTracking(String cnb, File moduleArt, File moduleConf, String specVersion) throws FileNotFoundException, IOException {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<module codename=\"" + cnb + "\">\n    <module_version install_time=\"" + System.currentTimeMillis() + "\" last=\"true\" origin=\"installer\" specification_version=\"" + specVersion + "\">\n        <file crc=\"" + CreateClusterAppMojo.crcForFile(moduleConf).getValue() + "\" name=\"config/Modules/" + cnb.replace(".", "-") + ".xml\"/>\n        <file crc=\"" + CreateClusterAppMojo.crcForFile(moduleArt).getValue() + "\" name=\"modules/" + cnb.replace(".", "-") + ".jar\"/>\n    </module_version>\n</module>";
    }

    static CRC32 crcForFile(File inFile) throws FileNotFoundException, IOException {
        CRC32 crc = new CRC32();
        try (FileInputStream inFileStream = new FileInputStream(inFile);){
            byte[] array = new byte[(int)inFile.length()];
            int len = ((InputStream)inFileStream).read(array);
            if (len != array.length) {
                throw new IOException("Cannot fully read " + inFile);
            }
            crc.update(array);
        }
        return crc;
    }

    private static class ClusterTuple {
        final File location;
        final boolean newer;

        private ClusterTuple(File clusterFile, boolean newer) {
            this.location = clusterFile;
            this.newer = newer;
        }
    }

    static class BundleTuple {
        final Artifact artifact;
        final ExamineManifest manifest;
        String cluster;

        BundleTuple(Artifact artifact, ExamineManifest manifest) {
            this.artifact = artifact;
            this.manifest = manifest;
        }
    }
}

