/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore.pc;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.surefire.api.util.internal.DaemonThreadFactory;
import org.apache.maven.surefire.junitcore.pc.InvokerStrategy;
import org.apache.maven.surefire.junitcore.pc.NonSharedThreadPoolStrategy;
import org.apache.maven.surefire.junitcore.pc.SchedulingStrategy;
import org.apache.maven.surefire.junitcore.pc.SharedThreadPoolStrategy;

public class SchedulingStrategies {
    private static final ThreadFactory DAEMON_THREAD_FACTORY = DaemonThreadFactory.newDaemonThreadFactory();

    public static SchedulingStrategy createInvokerStrategy(ConsoleLogger logger) {
        return new InvokerStrategy(logger);
    }

    public static SchedulingStrategy createParallelStrategy(ConsoleLogger logger, int nThreads) {
        return new NonSharedThreadPoolStrategy(logger, Executors.newFixedThreadPool(nThreads, DAEMON_THREAD_FACTORY));
    }

    public static SchedulingStrategy createParallelStrategyUnbounded(ConsoleLogger logger) {
        return new NonSharedThreadPoolStrategy(logger, Executors.newCachedThreadPool(DAEMON_THREAD_FACTORY));
    }

    public static SchedulingStrategy createParallelSharedStrategy(ConsoleLogger logger, ExecutorService threadPool) {
        if (threadPool == null) {
            throw new NullPointerException("null threadPool in #createParallelSharedStrategy");
        }
        return new SharedThreadPoolStrategy(logger, threadPool);
    }
}

