/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencyManagement;
import org.eclipse.aether.collection.DependencyManager;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.scope.ScopeManager;
import org.eclipse.aether.scope.SystemDependencyScope;
import org.eclipse.aether.util.graph.manager.MMap;

public abstract class AbstractDependencyManager
implements DependencyManager {
    protected final ArrayList<AbstractDependencyManager> path;
    protected final int depth;
    protected final int deriveUntil;
    protected final int applyFrom;
    protected final MMap<Key, String> managedVersions;
    protected final MMap<Key, String> managedScopes;
    protected final MMap<Key, Boolean> managedOptionals;
    protected final MMap<Key, String> managedLocalPaths;
    protected final MMap<Key, Holder<Collection<Exclusion>>> managedExclusions;
    protected final SystemDependencyScope systemDependencyScope;
    private final int hashCode;

    protected AbstractDependencyManager(int deriveUntil, int applyFrom, ScopeManager scopeManager) {
        this(new ArrayList<AbstractDependencyManager>(), 0, deriveUntil, applyFrom, null, null, null, null, null, scopeManager != null ? (SystemDependencyScope)scopeManager.getSystemDependencyScope().orElse(null) : SystemDependencyScope.LEGACY);
    }

    protected AbstractDependencyManager(ArrayList<AbstractDependencyManager> path, int depth, int deriveUntil, int applyFrom, MMap<Key, String> managedVersions, MMap<Key, String> managedScopes, MMap<Key, Boolean> managedOptionals, MMap<Key, String> managedLocalPaths, MMap<Key, Holder<Collection<Exclusion>>> managedExclusions, SystemDependencyScope systemDependencyScope) {
        this.path = path;
        this.depth = depth;
        this.deriveUntil = deriveUntil;
        this.applyFrom = applyFrom;
        this.managedVersions = managedVersions;
        this.managedScopes = managedScopes;
        this.managedOptionals = managedOptionals;
        this.managedLocalPaths = managedLocalPaths;
        this.managedExclusions = managedExclusions;
        this.systemDependencyScope = systemDependencyScope;
        this.hashCode = Objects.hash(path, depth, managedVersions, managedScopes, managedOptionals, managedExclusions);
    }

    protected abstract DependencyManager newInstance(MMap<Key, String> var1, MMap<Key, String> var2, MMap<Key, Boolean> var3, MMap<Key, String> var4, MMap<Key, Holder<Collection<Exclusion>>> var5);

    private boolean containsManagedVersion(Key key, MMap<Key, String> managedVersions) {
        for (AbstractDependencyManager ancestor : this.path) {
            if (ancestor.managedVersions == null || !ancestor.managedVersions.containsKey(key)) continue;
            return true;
        }
        return managedVersions != null && managedVersions.containsKey(key);
    }

    private String getManagedVersion(Key key) {
        for (AbstractDependencyManager ancestor : this.path) {
            if (ancestor.managedVersions == null || !ancestor.managedVersions.containsKey(key)) continue;
            return ancestor.managedVersions.get(key);
        }
        if (this.depth == 1 && this.managedVersions != null && this.managedVersions.containsKey(key)) {
            return this.managedVersions.get(key);
        }
        return null;
    }

    private boolean containsManagedScope(Key key, MMap<Key, String> managedScopes) {
        for (AbstractDependencyManager ancestor : this.path) {
            if (ancestor.managedScopes == null || !ancestor.managedScopes.containsKey(key)) continue;
            return true;
        }
        return managedScopes != null && managedScopes.containsKey(key);
    }

    private String getManagedScope(Key key) {
        for (AbstractDependencyManager ancestor : this.path) {
            if (ancestor.managedScopes == null || !ancestor.managedScopes.containsKey(key)) continue;
            return ancestor.managedScopes.get(key);
        }
        if (this.depth == 1 && this.managedScopes != null && this.managedScopes.containsKey(key)) {
            return this.managedScopes.get(key);
        }
        return null;
    }

    private boolean containsManagedOptional(Key key, MMap<Key, Boolean> managedOptionals) {
        for (AbstractDependencyManager ancestor : this.path) {
            if (ancestor.managedOptionals == null || !ancestor.managedOptionals.containsKey(key)) continue;
            return true;
        }
        return managedOptionals != null && managedOptionals.containsKey(key);
    }

    private Boolean getManagedOptional(Key key) {
        for (AbstractDependencyManager ancestor : this.path) {
            if (ancestor.managedOptionals == null || !ancestor.managedOptionals.containsKey(key)) continue;
            return ancestor.managedOptionals.get(key);
        }
        if (this.depth == 1 && this.managedOptionals != null && this.managedOptionals.containsKey(key)) {
            return this.managedOptionals.get(key);
        }
        return null;
    }

    private boolean containsManagedLocalPath(Key key, MMap<Key, String> managedLocalPaths) {
        for (AbstractDependencyManager ancestor : this.path) {
            if (ancestor.managedLocalPaths == null || !ancestor.managedLocalPaths.containsKey(key)) continue;
            return true;
        }
        return managedLocalPaths != null && managedLocalPaths.containsKey(key);
    }

    private String getManagedLocalPath(Key key) {
        for (AbstractDependencyManager ancestor : this.path) {
            if (ancestor.managedLocalPaths == null || !ancestor.managedLocalPaths.containsKey(key)) continue;
            return ancestor.managedLocalPaths.get(key);
        }
        if (this.managedLocalPaths != null && this.managedLocalPaths.containsKey(key)) {
            return this.managedLocalPaths.get(key);
        }
        return null;
    }

    private Collection<Exclusion> getManagedExclusions(Key key) {
        ArrayList<Exclusion> result = new ArrayList<Exclusion>();
        for (AbstractDependencyManager ancestor : this.path) {
            if (ancestor.managedExclusions == null || !ancestor.managedExclusions.containsKey(key)) continue;
            result.addAll((Collection)((Holder)ancestor.managedExclusions.get(key)).value);
        }
        if (this.managedExclusions != null && this.managedExclusions.containsKey(key)) {
            result.addAll((Collection)((Holder)this.managedExclusions.get(key)).value);
        }
        return result.isEmpty() ? null : result;
    }

    public DependencyManager deriveChildManager(DependencyCollectionContext context) {
        Objects.requireNonNull(context, "context cannot be null");
        if (!this.isDerived()) {
            return this;
        }
        MMap<Key, String> managedVersions = null;
        MMap<Key, String> managedScopes = null;
        MMap<Key, Boolean> managedOptionals = null;
        MMap<Key, String> managedLocalPaths = null;
        MMap managedExclusions = null;
        for (Dependency managedDependency : context.getManagedDependencies()) {
            Holder managed;
            Collection exclusions;
            String localPath;
            Artifact artifact = managedDependency.getArtifact();
            Key key = new Key(artifact);
            String version = artifact.getVersion();
            if (!version.isEmpty() && !this.containsManagedVersion(key, managedVersions)) {
                if (managedVersions == null) {
                    managedVersions = MMap.emptyNotDone();
                }
                managedVersions.put(key, version);
            }
            if (this.isInheritedDerived()) {
                Boolean optional;
                String scope = managedDependency.getScope();
                if (!scope.isEmpty() && !this.containsManagedScope(key, managedScopes)) {
                    if (managedScopes == null) {
                        managedScopes = MMap.emptyNotDone();
                    }
                    managedScopes.put(key, scope);
                }
                if ((optional = managedDependency.getOptional()) != null && !this.containsManagedOptional(key, managedOptionals)) {
                    if (managedOptionals == null) {
                        managedOptionals = MMap.emptyNotDone();
                    }
                    managedOptionals.put(key, optional);
                }
            }
            String string = localPath = this.systemDependencyScope == null ? null : this.systemDependencyScope.getSystemPath(managedDependency.getArtifact());
            if (localPath != null && !this.containsManagedLocalPath(key, managedLocalPaths)) {
                if (managedLocalPaths == null) {
                    managedLocalPaths = MMap.emptyNotDone();
                }
                managedLocalPaths.put(key, localPath);
            }
            if ((exclusions = managedDependency.getExclusions()).isEmpty()) continue;
            if (managedExclusions == null) {
                managedExclusions = MMap.emptyNotDone();
            }
            if ((managed = (Holder)managedExclusions.get(key)) != null) {
                ArrayList ex = new ArrayList((Collection)managed.getValue());
                ex.addAll(exclusions);
                managed = new Holder(ex);
                managedExclusions.put(key, managed);
                continue;
            }
            managedExclusions.put(key, new Holder<Collection>(exclusions));
        }
        return this.newInstance(managedVersions != null ? managedVersions.done() : null, managedScopes != null ? managedScopes.done() : null, managedOptionals != null ? managedOptionals.done() : null, managedLocalPaths != null ? managedLocalPaths.done() : null, managedExclusions != null ? managedExclusions.done() : null);
    }

    public DependencyManagement manageDependency(Dependency dependency) {
        Collection<Exclusion> exclusions;
        Objects.requireNonNull(dependency, "dependency cannot be null");
        DependencyManagement management = null;
        Key key = new Key(dependency.getArtifact());
        if (this.isApplied()) {
            Boolean optional;
            String localPath;
            String scope;
            String version = this.getManagedVersion(key);
            if (version != null) {
                management = new DependencyManagement();
                management.setVersion(version);
            }
            if ((scope = this.getManagedScope(key)) != null) {
                if (management == null) {
                    management = new DependencyManagement();
                }
                management.setScope(scope);
                if (this.systemDependencyScope != null && !this.systemDependencyScope.is(scope) && this.systemDependencyScope.getSystemPath(dependency.getArtifact()) != null) {
                    HashMap properties = new HashMap(dependency.getArtifact().getProperties());
                    this.systemDependencyScope.setSystemPath(properties, null);
                    management.setProperties(properties);
                }
            }
            if (this.systemDependencyScope != null && (scope != null && this.systemDependencyScope.is(scope) || scope == null && this.systemDependencyScope.is(dependency.getScope())) && (localPath = this.getManagedLocalPath(key)) != null) {
                if (management == null) {
                    management = new DependencyManagement();
                }
                HashMap properties = new HashMap(dependency.getArtifact().getProperties());
                this.systemDependencyScope.setSystemPath(properties, localPath);
                management.setProperties(properties);
            }
            if ((optional = this.getManagedOptional(key)) != null) {
                if (management == null) {
                    management = new DependencyManagement();
                }
                management.setOptional(optional);
            }
        }
        if ((exclusions = this.getManagedExclusions(key)) != null) {
            if (management == null) {
                management = new DependencyManagement();
            }
            LinkedHashSet<Exclusion> result = new LinkedHashSet<Exclusion>(dependency.getExclusions());
            result.addAll(exclusions);
            management.setExclusions(result);
        }
        return management;
    }

    protected boolean isDerived() {
        return this.depth < this.deriveUntil;
    }

    protected boolean isInheritedDerived() {
        return this.isDerived();
    }

    protected boolean isApplied() {
        return this.depth >= this.applyFrom;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        AbstractDependencyManager that = (AbstractDependencyManager)obj;
        return Objects.equals(this.path, that.path) && this.depth == that.depth && Objects.equals(this.managedVersions, that.managedVersions) && Objects.equals(this.managedScopes, that.managedScopes) && Objects.equals(this.managedOptionals, that.managedOptionals) && Objects.equals(this.managedExclusions, that.managedExclusions);
    }

    public int hashCode() {
        return this.hashCode;
    }

    protected static class Holder<T> {
        private final T value;
        private final int hashCode;

        Holder(T value) {
            this.value = Objects.requireNonNull(value);
            this.hashCode = Objects.hash(value);
        }

        public T getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Holder)) {
                return false;
            }
            Holder holder = (Holder)o;
            return Objects.equals(this.value, holder.value);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    protected static class Key {
        private final Artifact artifact;
        private final int hashCode;

        Key(Artifact artifact) {
            this.artifact = artifact;
            this.hashCode = Objects.hash(artifact.getArtifactId(), artifact.getGroupId(), artifact.getExtension(), artifact.getClassifier());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key that = (Key)obj;
            return this.artifact.getArtifactId().equals(that.artifact.getArtifactId()) && this.artifact.getGroupId().equals(that.artifact.getGroupId()) && this.artifact.getExtension().equals(that.artifact.getExtension()) && this.artifact.getClassifier().equals(that.artifact.getClassifier());
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return String.valueOf(this.artifact);
        }
    }
}

