/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.version;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.aether.util.version.GenericVersion;
import org.eclipse.aether.util.version.VersionSchemeSupport;
import org.eclipse.aether.version.InvalidVersionSpecificationException;

public class GenericVersionScheme
extends VersionSchemeSupport {
    private final Map<String, GenericVersion> versionCache = Collections.synchronizedMap(new WeakHashMap());
    private final AtomicLong cacheHits = new AtomicLong(0L);
    private final AtomicLong cacheMisses = new AtomicLong(0L);
    private final AtomicLong totalRequests = new AtomicLong(0L);
    private static final AtomicLong GLOBAL_CACHE_HITS = new AtomicLong(0L);
    private static final AtomicLong GLOBAL_CACHE_MISSES = new AtomicLong(0L);
    private static final AtomicLong GLOBAL_TOTAL_REQUESTS = new AtomicLong(0L);
    private static final AtomicLong INSTANCE_COUNT = new AtomicLong(0L);

    public GenericVersionScheme() {
        INSTANCE_COUNT.incrementAndGet();
    }

    private static boolean isStatisticsEnabled() {
        String sysProp = System.getProperty("aether.util.versionScheme.cacheDebug");
        if (sysProp != null) {
            return Boolean.parseBoolean(sysProp);
        }
        return false;
    }

    public GenericVersion parseVersion(String version) throws InvalidVersionSpecificationException {
        this.totalRequests.incrementAndGet();
        GLOBAL_TOTAL_REQUESTS.incrementAndGet();
        GenericVersion existing = this.versionCache.get(version);
        if (existing != null) {
            this.cacheHits.incrementAndGet();
            GLOBAL_CACHE_HITS.incrementAndGet();
            return existing;
        }
        this.cacheMisses.incrementAndGet();
        GLOBAL_CACHE_MISSES.incrementAndGet();
        return this.versionCache.computeIfAbsent(version, GenericVersion::new);
    }

    public String getCacheStatistics() {
        long hits = this.cacheHits.get();
        long misses = this.cacheMisses.get();
        long total = this.totalRequests.get();
        double hitRate = total > 0L ? (double)hits / (double)total * 100.0 : 0.0;
        return String.format("GenericVersionScheme Cache Stats: hits=%d, misses=%d, total=%d, hit-rate=%.2f%%, cache-size=%d", hits, misses, total, hitRate, this.versionCache.size());
    }

    private static void printGlobalStatistics() {
        long hits = GLOBAL_CACHE_HITS.get();
        long misses = GLOBAL_CACHE_MISSES.get();
        long total = GLOBAL_TOTAL_REQUESTS.get();
        long instances = INSTANCE_COUNT.get();
        double hitRate = total > 0L ? (double)hits / (double)total * 100.0 : 0.0;
        System.err.println("=== GenericVersionScheme Global Cache Statistics (WeakHashMap) ===");
        System.err.println(String.format("Total instances created: %d", instances));
        System.err.println(String.format("Total requests: %d", total));
        System.err.println(String.format("Cache hits: %d", hits));
        System.err.println(String.format("Cache misses: %d", misses));
        System.err.println(String.format("Hit rate: %.2f%%", hitRate));
        System.err.println(String.format("Average requests per instance: %.2f", instances > 0L ? (double)total / (double)instances : 0.0));
        System.err.println("=== End Cache Statistics ===");
    }

    public static void main(String ... args) {
        System.out.println("Display parameters as parsed by Maven Resolver 'generic' scheme (in canonical form and as a list of tokens) and comparison result:");
        if (args.length == 0) {
            return;
        }
        GenericVersionScheme scheme = new GenericVersionScheme();
        GenericVersion prev = null;
        int i = 1;
        for (String version : args) {
            try {
                GenericVersion c = scheme.parseVersion(version);
                if (prev != null) {
                    int compare = prev.compareTo(c);
                    System.out.println("   " + prev + ' ' + (compare == 0 ? "==" : (compare < 0 ? "<" : ">")) + ' ' + version);
                }
                System.out.println(i++ + ". " + version + " -> " + c.asString() + "; tokens: " + c.asItems());
                prev = c;
            }
            catch (InvalidVersionSpecificationException e) {
                System.err.println("Invalid version: " + version + " - " + e.getMessage());
            }
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (GenericVersionScheme.isStatisticsEnabled()) {
                GenericVersionScheme.printGlobalStatistics();
            }
        }));
    }
}

