/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.invoker;

import javax.inject.Inject;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.invoker.AbstractInvokerMojo;
import org.apache.maven.plugins.invoker.InterpolatorUtils;
import org.apache.maven.plugins.invoker.InvokerSession;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.toolchain.ToolchainManagerPrivate;

@Mojo(name="run", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class InvokerMojo
extends AbstractInvokerMojo {
    @Parameter(property="maven.test.failure.ignore", defaultValue="false")
    private boolean ignoreFailures;
    @Parameter(property="invoker.failIfNoProjects")
    private Boolean failIfNoProjects;
    @Parameter(property="invoker.streamLogsOnFailures", defaultValue="false")
    private boolean streamLogsOnFailures;

    @Inject
    public InvokerMojo(Invoker invoker, SettingsBuilder settingsBuilder, ToolchainManagerPrivate toolchainManagerPrivate, InterpolatorUtils interpolaterUtils) {
        super(invoker, settingsBuilder, toolchainManagerPrivate, interpolaterUtils);
    }

    @Override
    void processResults(InvokerSession invokerSession) throws MojoFailureException {
        if (this.streamLogsOnFailures) {
            invokerSession.logFailedBuildLog(this.getLog(), this.ignoreFailures);
        }
        if (!this.suppressSummaries) {
            invokerSession.logSummary(this.getLog(), this.ignoreFailures);
        }
        invokerSession.handleFailures(this.getLog(), this.ignoreFailures);
    }

    @Override
    protected void doFailIfNoProjects() throws MojoFailureException {
        if (Boolean.TRUE.equals(this.failIfNoProjects)) {
            throw new MojoFailureException("No projects to invoke!");
        }
    }
}

