/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.invoker;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;

@Named
class InterpolatorUtils {
    private final Interpolator atInterpolator = new RegexBasedInterpolator("[@\\$]\\{(.+?)", "}");

    @Inject
    InterpolatorUtils(MavenProject mavenProject) {
        this.atInterpolator.addValueSource((ValueSource)new MapBasedValueSource((Map)mavenProject.getProperties()));
    }

    public String interpolateAtPattern(String value) throws MojoExecutionException {
        if (value == null || !value.contains("@{") && !value.contains("${")) {
            return value;
        }
        try {
            return this.atInterpolator.interpolate(value);
        }
        catch (InterpolationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

