/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.fromDependencies;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.dependency.AbstractDependencyMojo;
import org.apache.maven.plugins.dependency.utils.DependencyStatusSets;
import org.apache.maven.plugins.dependency.utils.DependencyUtil;
import org.apache.maven.plugins.dependency.utils.ResolverUtil;
import org.apache.maven.plugins.dependency.utils.translators.ClassifierTypeTranslator;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.ClassifierFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.artifact.filter.collection.GroupIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ProjectTransitivityFilter;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.apache.maven.shared.artifact.filter.collection.TypeFilter;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractDependencyFilterMojo
extends AbstractDependencyMojo {
    @Parameter(property="overWriteReleases", defaultValue="false")
    protected boolean overWriteReleases;
    @Parameter(property="overWriteSnapshots", defaultValue="false")
    protected boolean overWriteSnapshots;
    @Parameter(property="overWriteIfNewer", defaultValue="true")
    protected boolean overWriteIfNewer;
    @Parameter(property="excludeTransitive", defaultValue="false")
    protected boolean excludeTransitive;
    @Parameter(property="includeTypes", defaultValue="")
    protected String includeTypes;
    @Parameter(property="excludeTypes", defaultValue="")
    protected String excludeTypes;
    @Parameter(property="includeScope", defaultValue="")
    protected String includeScope;
    @Parameter(property="excludeScope", defaultValue="")
    protected String excludeScope;
    @Parameter(property="includeClassifiers", defaultValue="")
    protected String includeClassifiers;
    @Parameter(property="excludeClassifiers", defaultValue="")
    protected String excludeClassifiers;
    @Parameter(property="classifier", defaultValue="")
    protected String classifier;
    @Parameter(property="type", defaultValue="")
    protected String type;
    @Parameter(property="excludeArtifactIds", defaultValue="")
    protected String excludeArtifactIds;
    @Parameter(property="includeArtifactIds", defaultValue="")
    protected String includeArtifactIds;
    @Parameter(property="excludeGroupIds", defaultValue="")
    protected String excludeGroupIds;
    @Parameter(property="includeGroupIds", defaultValue="")
    protected String includeGroupIds;
    @Parameter(property="markersDirectory", defaultValue="${project.build.directory}/dependency-maven-plugin-markers")
    protected File markersDirectory;
    @Parameter(property="mdep.prependGroupId", defaultValue="false")
    protected boolean prependGroupId = false;
    private final ResolverUtil resolverUtil;
    private final ProjectBuilder projectBuilder;
    private final ArtifactHandlerManager artifactHandlerManager;

    @Inject
    protected AbstractDependencyFilterMojo(MavenSession session, BuildContext buildContext, MavenProject project, ResolverUtil resolverUtil, ProjectBuilder projectBuilder, ArtifactHandlerManager artifactHandlerManager) {
        super(session, buildContext, project);
        this.resolverUtil = resolverUtil;
        this.projectBuilder = projectBuilder;
        this.artifactHandlerManager = artifactHandlerManager;
    }

    protected abstract ArtifactsFilter getMarkedArtifactFilter();

    protected Set<org.apache.maven.artifact.Artifact> getResolvedDependencies(boolean stopOnFailure) throws MojoExecutionException {
        DependencyStatusSets status = this.getDependencySets(stopOnFailure);
        return status.getResolvedDependencies();
    }

    protected DependencyStatusSets getDependencySets(boolean stopOnFailure) throws MojoExecutionException {
        return this.getDependencySets(stopOnFailure, false);
    }

    protected DependencyStatusSets getDependencySets(boolean stopOnFailure, boolean includeParents) throws MojoExecutionException {
        FilterArtifacts filter = new FilterArtifacts();
        filter.addFilter((ArtifactsFilter)new ProjectTransitivityFilter(this.getProject().getDependencyArtifacts(), this.excludeTransitive));
        if ("test".equals(this.excludeScope)) {
            throw new MojoExecutionException("Excluding every artifact inside 'test' resolution scope means excluding everything: you probably want includeScope='compile', read parameters documentation for detailed explanations");
        }
        filter.addFilter((ArtifactsFilter)new ScopeFilter(DependencyUtil.cleanToBeTokenizedString(this.includeScope), DependencyUtil.cleanToBeTokenizedString(this.excludeScope)));
        filter.addFilter((ArtifactsFilter)new TypeFilter(DependencyUtil.cleanToBeTokenizedString(this.includeTypes), DependencyUtil.cleanToBeTokenizedString(this.excludeTypes)));
        filter.addFilter((ArtifactsFilter)new ClassifierFilter(DependencyUtil.cleanToBeTokenizedString(this.includeClassifiers), DependencyUtil.cleanToBeTokenizedString(this.excludeClassifiers)));
        filter.addFilter((ArtifactsFilter)new GroupIdFilter(DependencyUtil.cleanToBeTokenizedString(this.includeGroupIds), DependencyUtil.cleanToBeTokenizedString(this.excludeGroupIds)));
        filter.addFilter((ArtifactsFilter)new ArtifactIdFilter(DependencyUtil.cleanToBeTokenizedString(this.includeArtifactIds), DependencyUtil.cleanToBeTokenizedString(this.excludeArtifactIds)));
        Set artifacts = this.getProject().getArtifacts();
        if (includeParents) {
            for (org.apache.maven.artifact.Artifact dep : new ArrayList(artifacts)) {
                this.addParentArtifacts(this.buildProjectFromArtifact(dep), artifacts);
            }
            this.addParentArtifacts(this.getProject(), artifacts);
        }
        try {
            artifacts = filter.filter(artifacts);
        }
        catch (ArtifactFilterException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        DependencyStatusSets status = this.classifier != null && !this.classifier.isEmpty() ? this.getClassifierTranslatedDependencies(artifacts, stopOnFailure) : this.filterMarkedDependencies(artifacts);
        return status;
    }

    private MavenProject buildProjectFromArtifact(org.apache.maven.artifact.Artifact artifact) throws MojoExecutionException {
        try {
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            buildingRequest.setProcessPlugins(false);
            return this.projectBuilder.build(artifact, (ProjectBuildingRequest)buildingRequest).getProject();
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("Coud not build project for " + artifact.getId(), (Exception)((Object)e));
        }
    }

    private void addParentArtifacts(MavenProject project, Set<org.apache.maven.artifact.Artifact> artifacts) throws MojoExecutionException {
        while (project.hasParent() && !artifacts.contains((project = project.getParent()).getArtifact())) {
            try {
                Artifact resolvedArtifact = this.resolverUtil.resolveArtifact(RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)project.getArtifact()), project.getRemoteProjectRepositories());
                artifacts.add(RepositoryUtils.toArtifact((Artifact)resolvedArtifact));
            }
            catch (ArtifactResolutionException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    private DependencyStatusSets getClassifierTranslatedDependencies(Set<org.apache.maven.artifact.Artifact> artifacts, boolean stopOnFailure) throws MojoExecutionException {
        LinkedHashSet<org.apache.maven.artifact.Artifact> unResolvedArtifacts = new LinkedHashSet<org.apache.maven.artifact.Artifact>();
        Set<org.apache.maven.artifact.Artifact> resolvedArtifacts = artifacts;
        DependencyStatusSets status = new DependencyStatusSets();
        if (this.classifier != null && !this.classifier.isEmpty()) {
            ClassifierTypeTranslator translator = new ClassifierTypeTranslator(this.artifactHandlerManager, this.classifier, this.type);
            Set<Artifact> coordinates = translator.translate(artifacts, this.getLog());
            status = this.filterMarkedDependencies(artifacts);
            artifacts = status.getResolvedDependencies();
            resolvedArtifacts = this.resolve(new LinkedHashSet<Artifact>(coordinates), stopOnFailure);
            unResolvedArtifacts.addAll(artifacts);
            unResolvedArtifacts.removeAll(resolvedArtifacts);
        }
        status.setResolvedDependencies(resolvedArtifacts);
        status.setUnResolvedDependencies(unResolvedArtifacts);
        return status;
    }

    protected DependencyStatusSets filterMarkedDependencies(Set<org.apache.maven.artifact.Artifact> artifacts) throws MojoExecutionException {
        Set unMarkedArtifacts;
        FilterArtifacts filter = new FilterArtifacts();
        filter.clearFilters();
        filter.addFilter(this.getMarkedArtifactFilter());
        try {
            unMarkedArtifacts = filter.filter(artifacts);
        }
        catch (ArtifactFilterException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        LinkedHashSet<org.apache.maven.artifact.Artifact> skippedArtifacts = new LinkedHashSet<org.apache.maven.artifact.Artifact>(artifacts);
        skippedArtifacts.removeAll(unMarkedArtifacts);
        return new DependencyStatusSets(unMarkedArtifacts, null, skippedArtifacts);
    }

    private Set<org.apache.maven.artifact.Artifact> resolve(Set<Artifact> artifacts, boolean stopOnFailure) throws MojoExecutionException {
        LinkedHashSet<org.apache.maven.artifact.Artifact> resolvedArtifacts = new LinkedHashSet<org.apache.maven.artifact.Artifact>();
        for (Artifact artifact : artifacts) {
            try {
                Artifact resolveArtifact = this.resolverUtil.resolveArtifact(artifact, this.getProject().getRemoteProjectRepositories());
                resolvedArtifacts.add(RepositoryUtils.toArtifact((Artifact)resolveArtifact));
            }
            catch (ArtifactResolutionException ex) {
                this.getLog().debug((CharSequence)("error resolving: " + artifact), (Throwable)ex);
                if (!stopOnFailure) continue;
                throw new MojoExecutionException("error resolving: " + artifact, (Exception)((Object)ex));
            }
        }
        return resolvedArtifacts;
    }

    public File getMarkersDirectory() {
        return this.markersDirectory;
    }

    public void setMarkersDirectory(File theMarkersDirectory) {
        this.markersDirectory = theMarkersDirectory;
    }

    public boolean isPrependGroupId() {
        return this.prependGroupId;
    }

    public void setPrependGroupId(boolean prependGroupId) {
        this.prependGroupId = prependGroupId;
    }

    protected final ResolverUtil getResolverUtil() {
        return this.resolverUtil;
    }
}

