/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.fromConfiguration;

import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.dependency.fromConfiguration.AbstractFromConfigurationMojo;
import org.apache.maven.plugins.dependency.fromConfiguration.ArtifactItem;
import org.apache.maven.plugins.dependency.fromConfiguration.ProcessArtifactItemsRequest;
import org.apache.maven.plugins.dependency.utils.UnpackUtil;
import org.apache.maven.plugins.dependency.utils.filters.ArtifactItemFilter;
import org.apache.maven.plugins.dependency.utils.filters.MarkerFileFilter;
import org.apache.maven.plugins.dependency.utils.markers.UnpackFileMarkerHandler;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.components.io.filemappers.FileMapper;
import org.eclipse.aether.RepositorySystem;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="unpack", defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresProject=false, threadSafe=true)
public class UnpackMojo
extends AbstractFromConfigurationMojo {
    private final UnpackUtil unpackUtil;
    @Parameter(property="markersDirectory", defaultValue="${project.build.directory}/dependency-maven-plugin-markers")
    private File markersDirectory;
    @Parameter(property="mdep.unpack.includes")
    private String includes;
    @Parameter(property="mdep.unpack.excludes")
    private String excludes;
    @Parameter(property="dependency.ignorePermissions", defaultValue="false")
    private boolean ignorePermissions;
    @Parameter(property="mdep.unpack.filemappers")
    private FileMapper[] fileMappers;
    @Parameter(property="artifact")
    private String artifact;

    @Inject
    public UnpackMojo(MavenSession session, BuildContext buildContext, MavenProject project, ArtifactHandlerManager artifactHandlerManager, UnpackUtil unpackUtil, RepositorySystem repositorySystem) {
        super(session, buildContext, project, artifactHandlerManager, repositorySystem);
        this.unpackUtil = unpackUtil;
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            return;
        }
        this.verifyRequirements();
        List<ArtifactItem> processedItems = this.getProcessedArtifactItems(false);
        for (ArtifactItem artifactItem : processedItems) {
            if (artifactItem.isNeedsProcessing()) {
                this.unpackArtifact(artifactItem);
                continue;
            }
            this.getLog().info((CharSequence)(artifactItem.getArtifact().getFile().getName() + " already unpacked."));
        }
    }

    private void unpackArtifact(ArtifactItem artifactItem) throws MojoExecutionException {
        UnpackFileMarkerHandler handler = new UnpackFileMarkerHandler(artifactItem, this.markersDirectory);
        this.unpackUtil.unpack(artifactItem.getArtifact().getFile(), artifactItem.getType(), artifactItem.getOutputDirectory(), artifactItem.getIncludes(), artifactItem.getExcludes(), artifactItem.getEncoding(), this.ignorePermissions, artifactItem.getFileMappers(), this.getLog());
        handler.setMarker();
    }

    @Override
    ArtifactItemFilter getMarkedArtifactFilter(ArtifactItem item) {
        UnpackFileMarkerHandler handler = new UnpackFileMarkerHandler(item, this.markersDirectory);
        return new MarkerFileFilter(this.isOverWriteReleases(), this.isOverWriteSnapshots(), this.isOverWriteIfNewer(), handler);
    }

    protected List<ArtifactItem> getProcessedArtifactItems(boolean removeVersion) throws MojoExecutionException {
        List<ArtifactItem> items = super.getProcessedArtifactItems(new ProcessArtifactItemsRequest(removeVersion, false, false, false));
        for (ArtifactItem artifactItem : items) {
            if (artifactItem.getIncludes().isEmpty()) {
                artifactItem.setIncludes(this.getIncludes());
            }
            if (!artifactItem.getExcludes().isEmpty()) continue;
            artifactItem.setExcludes(this.getExcludes());
        }
        return items;
    }

    public File getMarkersDirectory() {
        return this.markersDirectory;
    }

    public void setMarkersDirectory(File theMarkersDirectory) {
        this.markersDirectory = theMarkersDirectory;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public FileMapper[] getFileMappers() {
        return this.fileMappers;
    }

    public void setFileMappers(FileMapper[] fileMappers) {
        this.fileMappers = fileMappers;
    }
}

