/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.resolvers;

import java.util.List;
import java.util.function.Predicate;
import org.apache.maven.model.Plugin;

class PluginsIncludeExcludeFilter
implements Predicate<Plugin> {
    private final List<String> includesGroupId;
    private final List<String> excludesGroupId;
    private final List<String> includesArtifactId;
    private final List<String> excludesArtifactId;

    PluginsIncludeExcludeFilter(List<String> includeGroupIds, List<String> excludeGroupIds, List<String> includeArtifactIds, List<String> excludeArtifactIds) {
        this.includesGroupId = includeGroupIds;
        this.excludesGroupId = excludeGroupIds;
        this.includesArtifactId = includeArtifactIds;
        this.excludesArtifactId = excludeArtifactIds;
    }

    @Override
    public boolean test(Plugin plugin) {
        if (!this.includesGroupId.isEmpty() && !this.includesGroupId.contains(plugin.getGroupId())) {
            return false;
        }
        if (this.excludesGroupId.contains(plugin.getGroupId())) {
            return false;
        }
        if (!this.includesArtifactId.isEmpty() && !this.includesArtifactId.contains(plugin.getArtifactId())) {
            return false;
        }
        return !this.excludesArtifactId.contains(plugin.getArtifactId());
    }
}

