/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.analyze;

import java.util.Collection;
import java.util.Locale;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalysis;
import org.codehaus.plexus.i18n.I18N;

public class AnalyzeReportRenderer
extends AbstractMavenReportRenderer {
    private final I18N i18n;
    private final Locale locale;
    private final ProjectDependencyAnalysis analysis;

    public AnalyzeReportRenderer(Sink sink, I18N i18n, Locale locale, ProjectDependencyAnalysis analysis) {
        super(sink);
        this.i18n = i18n;
        this.locale = locale;
        this.analysis = analysis;
    }

    public String getTitle() {
        return this.getI18nString("title");
    }

    private String getI18nString(String key) {
        return this.i18n.getString("analyze-report", this.locale, "report.analyze." + key);
    }

    protected void renderBody() {
        this.startSection(this.getTitle());
        boolean reported = false;
        if (!this.analysis.getUsedDeclaredArtifacts().isEmpty()) {
            this.startSection(this.getI18nString("UsedDeclaredDependencies"));
            this.renderDependenciesTable(this.sink, this.analysis.getUsedDeclaredArtifacts());
            this.endSection();
            reported = true;
        }
        if (!this.analysis.getUsedUndeclaredArtifacts().isEmpty()) {
            this.startSection(this.getI18nString("UsedUndeclaredDependencies"));
            this.renderDependenciesTable(this.sink, this.analysis.getUsedUndeclaredArtifacts());
            this.endSection();
            reported = true;
        }
        if (!this.analysis.getUnusedDeclaredArtifacts().isEmpty()) {
            this.startSection(this.getI18nString("UnusedDeclaredDependencies"));
            this.renderDependenciesTable(this.sink, this.analysis.getUnusedDeclaredArtifacts());
            this.endSection();
            reported = true;
        }
        if (!this.analysis.getTestArtifactsWithNonTestScope().isEmpty()) {
            this.startSection(this.getI18nString("CompileScopeTestOnlyDependencies"));
            this.renderDependenciesTable(this.sink, this.analysis.getTestArtifactsWithNonTestScope());
            this.endSection();
            reported = true;
        }
        if (!reported) {
            this.text(this.getI18nString("noDependencyProblems"));
        }
        this.endSection();
    }

    private void renderDependenciesTable(Sink sink, Collection<Artifact> artifacts) {
        this.startTable();
        this.tableHeader(new String[]{"GroupId", "ArtifactId", "Version", "Scope", "Classifier", "Type", "Optional"});
        for (Artifact artifact : artifacts) {
            this.tableRow(new String[]{artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope(), artifact.getClassifier(), artifact.getType(), artifact.isOptional() ? "" : "false"});
        }
        this.endTable();
    }
}

