/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.apache.maven.api.JavaPathType;
import org.apache.maven.api.PathType;
import org.apache.maven.api.plugin.Log;
import org.apache.maven.api.services.DependencyResolverResult;
import org.apache.maven.plugin.compiler.AbstractCompilerMojo;
import org.apache.maven.plugin.compiler.CompilationFailureException;
import org.apache.maven.plugin.compiler.DiagnosticLogger;
import org.apache.maven.plugin.compiler.DirectoryHierarchy;
import org.apache.maven.plugin.compiler.ForkedTool;
import org.apache.maven.plugin.compiler.IncrementalBuild;
import org.apache.maven.plugin.compiler.Options;
import org.apache.maven.plugin.compiler.PathFilter;
import org.apache.maven.plugin.compiler.SourceDirectory;
import org.apache.maven.plugin.compiler.SourceFile;
import org.apache.maven.plugin.compiler.SourcesForRelease;
import org.apache.maven.plugin.compiler.WorkaroundForPatchModule;

public class ToolExecutor {
    private static final Locale LOCALE = null;
    protected final Charset encoding;
    final List<SourceDirectory> sourceDirectories;
    protected final Set<Path> generatedSourceDirectories;
    private List<SourceFile> sourceFiles;
    protected final boolean hasModuleDeclaration;
    private DirectoryHierarchy directoryHierarchy;
    final DependencyResolverResult dependencyResolution;
    private final Map<PathType, Collection<Path>> dependencies;
    protected final Path outputDirectory;
    private final EnumSet<IncrementalBuild.Aspect> incrementalBuildConfig;
    private IncrementalBuild incrementalBuild;
    private boolean isPartialBuild;
    protected final DiagnosticListener<? super JavaFileObject> listener;
    protected final Log logger;
    final List<SourcesForRelease> sourcesForDebugFile;

    protected ToolExecutor(AbstractCompilerMojo mojo, DiagnosticListener<? super JavaFileObject> listener) throws IOException {
        this.logger = mojo.logger;
        if (listener == null) {
            Path root = mojo.project.getRootDirectory();
            listener = new DiagnosticLogger(this.logger, mojo.messageBuilderFactory, LOCALE, root);
        }
        this.listener = listener;
        this.encoding = mojo.charset();
        this.incrementalBuildConfig = mojo.incrementalCompilationConfiguration();
        this.outputDirectory = Files.createDirectories(mojo.getOutputDirectory(), new FileAttribute[0]);
        this.sourceDirectories = mojo.getSourceDirectories(this.outputDirectory);
        this.dependencies = new LinkedHashMap<PathType, Collection<Path>>();
        this.sourcesForDebugFile = new ArrayList<SourcesForRelease>();
        if (this.incrementalBuildConfig.contains((Object)IncrementalBuild.Aspect.MODULES)) {
            boolean hasNoFileMatchers = mojo.hasNoFileMatchers();
            for (SourceDirectory root : this.sourceDirectories) {
                if (root.moduleName == null) {
                    throw new CompilationFailureException("The <incrementalCompilation> value can be \"modules\" only if all source directories are Java modules.");
                }
                hasNoFileMatchers &= root.includes.isEmpty() && root.excludes.isEmpty();
            }
            if (!hasNoFileMatchers) {
                throw new CompilationFailureException("Include and exclude filters cannot be specified when <incrementalCompilation> is set to \"modules\".");
            }
            this.hasModuleDeclaration = true;
            this.sourceFiles = List.of();
        } else {
            this.sourceFiles = new PathFilter(mojo).walkSourceFiles(this.sourceDirectories);
            this.hasModuleDeclaration = mojo.hasModuleDeclaration(this.sourceDirectories);
            if (this.sourceFiles.isEmpty()) {
                this.generatedSourceDirectories = Set.of();
                this.dependencyResolution = null;
                return;
            }
        }
        this.dependencyResolution = mojo.resolveDependencies(this.hasModuleDeclaration);
        if (this.dependencyResolution != null) {
            this.dependencies.putAll(this.dependencyResolution.getDispatchedPaths());
        }
        mojo.resolveProcessorPathEntries(this.dependencies);
        mojo.amendincrementalCompilation(this.incrementalBuildConfig, this.dependencies.keySet());
        this.generatedSourceDirectories = mojo.addGeneratedSourceDirectory(this.dependencies.keySet());
        this.copyDependencyValues();
    }

    private void copyDependencyValues() {
        this.dependencies.entrySet().forEach(entry -> entry.setValue(List.copyOf((Collection)entry.getValue())));
    }

    Path getOutputDirectoryOfPreviousPhase() {
        return null;
    }

    Path resolveModuleOutputDirectory(Path outputDirectory, String moduleName) {
        return outputDirectory.resolve(moduleName);
    }

    @Deprecated(since="4.0.0")
    String moduleNameFromPackageHierarchy() {
        return null;
    }

    final boolean isReleaseSpecifiedForAll() {
        for (SourceDirectory source : this.sourceDirectories) {
            if (source.release != null) continue;
            return false;
        }
        return true;
    }

    public boolean applyIncrementalBuild(AbstractCompilerMojo mojo, Options configuration) throws IOException {
        boolean checkOptions;
        boolean checkDepends;
        boolean checkClasses;
        boolean checkSources = this.incrementalBuildConfig.contains((Object)IncrementalBuild.Aspect.SOURCES);
        if (checkSources | (checkClasses = this.incrementalBuildConfig.contains((Object)IncrementalBuild.Aspect.CLASSES)) | (checkDepends = this.incrementalBuildConfig.contains((Object)IncrementalBuild.Aspect.DEPENDENCIES)) | (checkOptions = this.incrementalBuildConfig.contains((Object)IncrementalBuild.Aspect.OPTIONS))) {
            this.incrementalBuild = new IncrementalBuild(mojo, this.sourceFiles, checkSources, configuration, this.incrementalBuildConfig);
            String causeOfRebuild = null;
            if (checkSources) {
                causeOfRebuild = this.incrementalBuild.inputFileTreeChanges();
            }
            if (checkClasses && causeOfRebuild == null) {
                causeOfRebuild = this.incrementalBuild.markNewOrModifiedSources();
            }
            if (checkDepends && causeOfRebuild == null) {
                List<String> fileExtensions = mojo.fileExtensions;
                causeOfRebuild = this.incrementalBuild.dependencyChanges(this.dependencies.values(), fileExtensions);
            }
            if (checkOptions && causeOfRebuild == null) {
                causeOfRebuild = this.incrementalBuild.optionChanges();
            }
            if (causeOfRebuild != null) {
                if (!this.sourceFiles.isEmpty()) {
                    this.logger.info((CharSequence)causeOfRebuild);
                }
            } else {
                this.isPartialBuild = true;
                this.sourceFiles = this.incrementalBuild.getModifiedSources();
                if (IncrementalBuild.isEmptyOrIgnorable(this.sourceFiles)) {
                    this.incrementalBuildConfig.clear();
                    this.logger.info((CharSequence)"Nothing to compile - all classes are up to date.");
                    this.sourceFiles = List.of();
                    return false;
                }
                int n = this.sourceFiles.size();
                StringBuilder sb = new StringBuilder("Compiling ").append(n).append(" modified source file");
                if (n > 1) {
                    sb.append('s');
                }
                this.logger.info((CharSequence)sb.append('.'));
            }
            if (!(checkSources | checkDepends | checkOptions)) {
                this.incrementalBuild.deleteCache();
                this.incrementalBuild = null;
            }
        }
        this.incrementalBuildConfig.clear();
        return true;
    }

    private void saveIncrementalBuild() throws IOException {
        if (this.incrementalBuild != null) {
            this.incrementalBuild.writeCache();
            this.incrementalBuild = null;
        }
    }

    protected Deque<Path> dependencies(PathType pathType) {
        return (Deque)this.dependencies.compute(pathType, (key, paths) -> {
            if (paths == null) {
                return new ArrayDeque();
            }
            if (paths instanceof ArrayDeque) {
                ArrayDeque deque = (ArrayDeque)paths;
                return deque;
            }
            ArrayDeque copy = new ArrayDeque(paths.size() + 4);
            copy.addAll(paths);
            return copy;
        });
    }

    private void setDependencyPaths(StandardJavaFileManager fileManager) throws IOException {
        ArrayList<Path> unresolvedPaths = new ArrayList<Path>();
        for (Map.Entry<PathType, Collection<Path>> entry : this.dependencies.entrySet()) {
            JavaPathType.Modular type;
            Optional location;
            Collection<Path> paths = entry.getValue();
            PathType key = entry.getKey();
            if (key instanceof JavaPathType) {
                JavaPathType type2 = (JavaPathType)key;
                location = type2.location();
                if (location.isPresent()) {
                    JavaFileManager.Location value = (JavaFileManager.Location)location.get();
                    if (value == StandardLocation.CLASS_PATH && this.isPartialBuild && !this.hasModuleDeclaration) {
                        paths = new ArrayDeque<Path>(paths);
                        paths.add(this.outputDirectory);
                        entry.setValue(paths);
                    }
                    fileManager.setLocationFromPaths(value, paths);
                    continue;
                }
            } else if (key instanceof JavaPathType.Modular && (location = (type = (JavaPathType.Modular)key).rawType().location()).isPresent()) {
                fileManager.setLocationForModule((JavaFileManager.Location)location.get(), type.moduleName(), paths);
                continue;
            }
            unresolvedPaths.addAll(paths);
        }
        if (!unresolvedPaths.isEmpty()) {
            StringBuilder sb = new StringBuilder("Cannot determine where to place the following artifacts:");
            for (Path p : unresolvedPaths) {
                sb.append(System.lineSeparator()).append(" - ").append(p);
            }
            this.logger.warn((CharSequence)sb);
        }
    }

    protected Deque<Path> prependDependency(PathType pathType, Path first) {
        Deque<Path> paths = this.dependencies(pathType);
        paths.addFirst(first);
        return paths;
    }

    private static SourceVersion nonNullOrLatest(SourceVersion release) {
        return release != null ? release : SourceVersion.latest();
    }

    private Collection<SourcesForRelease> groupByReleaseAndModule() {
        EnumMap<SourceVersion, SourcesForRelease> result = new EnumMap<SourceVersion, SourcesForRelease>(SourceVersion.class);
        for (SourceDirectory directory : this.sourceDirectories) {
            SourcesForRelease unit = result.computeIfAbsent(ToolExecutor.nonNullOrLatest(directory.release), release -> new SourcesForRelease(directory.release));
            String moduleName = directory.moduleName;
            if (moduleName == null || moduleName.isBlank()) {
                moduleName = "";
            }
            unit.roots.computeIfAbsent(moduleName, key -> new LinkedHashSet());
        }
        for (SourceFile source : this.sourceFiles) {
            ((SourcesForRelease)result.get((Object)ToolExecutor.nonNullOrLatest(source.directory.release))).add(source);
        }
        return result.values();
    }

    private boolean noSourcesToCompile() throws IOException {
        this.sourcesForDebugFile.clear();
        if (this.sourceFiles.isEmpty()) {
            Object message = "No sources to compile.";
            try {
                Files.delete(this.outputDirectory);
            }
            catch (DirectoryNotEmptyException e) {
                message = (String)message + " However, the output directory is not empty.";
            }
            this.logger.info((CharSequence)message);
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            int n = this.sourceFiles.size();
            StringBuilder sb = new StringBuilder(n * 40).append("The source files to compile are:");
            for (SourceFile file : this.sourceFiles) {
                sb.append(System.lineSeparator()).append("    ").append(file);
            }
            this.logger.debug((CharSequence)sb);
        }
        return false;
    }

    private void determineDirectoryHierarchy(Collection<SourcesForRelease> units) {
        String moduleNameFromPackageHierarchy = this.moduleNameFromPackageHierarchy();
        for (SourcesForRelease unit : units) {
            for (String moduleName : unit.roots.keySet()) {
                DirectoryHierarchy detected;
                if (moduleName.isEmpty()) {
                    detected = moduleNameFromPackageHierarchy == null ? DirectoryHierarchy.PACKAGE : DirectoryHierarchy.PACKAGE_WITH_MODULE;
                } else if (moduleNameFromPackageHierarchy == null) {
                    detected = DirectoryHierarchy.MODULE_SOURCE;
                } else {
                    throw new CompilationFailureException("The \"%s\" module must be declared in a <module> element of <sources>.".formatted(moduleNameFromPackageHierarchy));
                }
                if (this.directoryHierarchy == null) {
                    this.directoryHierarchy = detected;
                    continue;
                }
                if (this.directoryHierarchy == detected) continue;
                throw new CompilationFailureException("Mix of %s and %s hierarchies.".formatted(new Object[]{this.directoryHierarchy, detected}));
            }
        }
        if (moduleNameFromPackageHierarchy != null) {
            for (SourcesForRelease unit : units) {
                Set<Path> paths = unit.roots.remove("");
                if (paths == null) continue;
                unit.roots.put(moduleNameFromPackageHierarchy, paths);
            }
        }
    }

    public boolean compile(JavaCompiler compiler, Options configuration, Writer otherOutput) throws IOException {
        if (this.noSourcesToCompile()) {
            return true;
        }
        Collection<SourcesForRelease> units = this.groupByReleaseAndModule();
        this.determineDirectoryHierarchy(units);
        if (this.hasModuleDeclaration && !(compiler instanceof ForkedTool)) {
            compiler = new WorkaroundForPatchModule(compiler);
        }
        boolean success = true;
        try (StandardJavaFileManager fileManager = compiler.getStandardFileManager(this.listener, LOCALE, this.encoding);){
            this.setDependencyPaths(fileManager);
            if (!this.generatedSourceDirectories.isEmpty()) {
                fileManager.setLocationFromPaths(StandardLocation.SOURCE_OUTPUT, this.generatedSourceDirectories);
            }
            PathManager pathManager = switch (this.directoryHierarchy) {
                default -> throw new IncompatibleClassChangeError();
                case DirectoryHierarchy.PACKAGE -> new PathManager(fileManager);
                case DirectoryHierarchy.PACKAGE_WITH_MODULE, DirectoryHierarchy.MODULE_SOURCE -> new ModulePathManager(fileManager);
            };
            for (SourcesForRelease unit : units) {
                Iterable<? extends JavaFileObject> sources;
                JavaCompiler.CompilationTask task;
                configuration.setRelease(unit.getReleaseString());
                pathManager.configureSourcePaths(unit.roots);
                this.copyDependencyValues();
                unit.dependencySnapshot = new LinkedHashMap<PathType, Collection<Path>>(this.dependencies);
                pathManager.setupOutputDirectory(unit);
                if (!unit.files.isEmpty() && !(success = (task = compiler.getTask(otherOutput, fileManager, this.listener, configuration.options, null, sources = fileManager.getJavaFileObjectsFromPaths((Collection<? extends Path>)unit.files))).call().booleanValue())) {
                    break;
                }
                pathManager.markVersioned();
            }
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
        DiagnosticListener<? super JavaFileObject> diagnosticListener = this.listener;
        if (diagnosticListener instanceof DiagnosticLogger) {
            DiagnosticLogger diagnostic = (DiagnosticLogger)diagnosticListener;
            diagnostic.logSummary();
        }
        if (success) {
            this.saveIncrementalBuild();
        }
        return success;
    }

    private class PathManager {
        protected final StandardJavaFileManager fileManager;
        protected Path latestOutputDirectory;
        private boolean isVersioned;

        protected PathManager(StandardJavaFileManager fileManager) {
            this.fileManager = fileManager;
            this.latestOutputDirectory = ToolExecutor.this.getOutputDirectoryOfPreviousPhase();
        }

        private static Set<Path> merge(Collection<Set<Path>> directories) {
            Set<Path> allSources = Set.of();
            for (Set<Path> more : directories) {
                if (allSources.isEmpty()) {
                    allSources = more;
                    continue;
                }
                allSources = new LinkedHashSet<Path>(allSources);
                allSources.addAll(more);
            }
            return allSources;
        }

        protected void configureSourcePaths(Map<String, Set<Path>> roots) throws IOException {
            this.fileManager.setLocationFromPaths(StandardLocation.SOURCE_PATH, PathManager.merge(roots.values()));
            if (this.latestOutputDirectory != null) {
                Deque<Path> paths = ToolExecutor.this.prependDependency((PathType)JavaPathType.CLASSES, this.latestOutputDirectory);
                this.fileManager.setLocationFromPaths(StandardLocation.CLASS_PATH, paths);
            }
        }

        final void setupOutputDirectory(SourcesForRelease unit) throws IOException {
            Path outputForRelease = ToolExecutor.this.outputDirectory;
            if (this.isVersioned) {
                outputForRelease = Files.createDirectories(ToolExecutor.this.directoryHierarchy.outputDirectoryForReleases(outputForRelease, unit.release), new FileAttribute[0]);
            }
            this.fileManager.setLocationFromPaths(StandardLocation.CLASS_OUTPUT, Set.of(outputForRelease));
            this.latestOutputDirectory = outputForRelease;
            unit.outputForRelease = outputForRelease;
            ToolExecutor.this.sourcesForDebugFile.add(unit);
        }

        final void markVersioned() {
            this.isVersioned = true;
        }
    }

    private final class ModulePathManager
    extends PathManager {
        private boolean canAddOutputToModulePath;
        private final Map<String, Boolean> modulesNotPresentInNewVersion;
        private final Map<String, Integer> modulesWithSourcesAsPatches;

        ModulePathManager(StandardJavaFileManager fileManager) {
            super(fileManager);
            this.canAddOutputToModulePath = true;
            this.modulesNotPresentInNewVersion = new LinkedHashMap<String, Boolean>();
            this.modulesWithSourcesAsPatches = new HashMap<String, Integer>();
        }

        @Override
        protected void configureSourcePaths(Map<String, Set<Path>> roots) throws IOException {
            for (Map.Entry<String, Set<Path>> entry : roots.entrySet()) {
                Deque<Path> paths;
                String moduleName = entry.getKey();
                Set<Path> sourcePaths = entry.getValue();
                this.fileManager.setLocationForModule(StandardLocation.MODULE_SOURCE_PATH, moduleName, sourcePaths);
                this.modulesNotPresentInNewVersion.put(moduleName, Boolean.FALSE);
                if (this.latestOutputDirectory == null) continue;
                if (this.canAddOutputToModulePath) {
                    this.canAddOutputToModulePath = false;
                    paths = ToolExecutor.this.prependDependency((PathType)JavaPathType.MODULES, this.latestOutputDirectory);
                    this.fileManager.setLocationFromPaths(StandardLocation.MODULE_PATH, paths);
                }
                paths = ToolExecutor.this.dependencies((PathType)JavaPathType.patchModule((String)moduleName));
                ModulePathManager.removeFirsts(paths, this.modulesWithSourcesAsPatches.put(moduleName, sourcePaths.size()));
                Path latestOutput = ToolExecutor.this.resolveModuleOutputDirectory(this.latestOutputDirectory, moduleName);
                if (Files.exists(latestOutput, new LinkOption[0])) {
                    paths.addFirst(latestOutput);
                }
                sourcePaths.forEach(paths::addFirst);
                this.fileManager.setLocationForModule(StandardLocation.PATCH_MODULE_PATH, moduleName, paths);
            }
            this.omitSourcelessModulesInNewVersion();
        }

        private void omitSourcelessModulesInNewVersion() throws IOException {
            Iterator<Map.Entry<String, Boolean>> iterator = this.modulesNotPresentInNewVersion.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Boolean> entry = iterator.next();
                if (entry.getValue().booleanValue()) {
                    String moduleName = entry.getKey();
                    Deque<Path> paths = ToolExecutor.this.dependencies((PathType)JavaPathType.patchModule((String)moduleName));
                    if (ModulePathManager.removeFirsts(paths, this.modulesWithSourcesAsPatches.remove(moduleName))) {
                        paths.addFirst(this.latestOutputDirectory.resolve(moduleName));
                    } else if (paths.isEmpty()) {
                        paths.add(ToolExecutor.this.outputDirectory.resolve(moduleName));
                    }
                    this.fileManager.setLocationForModule(StandardLocation.PATCH_MODULE_PATH, moduleName, paths);
                    this.fileManager.setLocationForModule(StandardLocation.MODULE_SOURCE_PATH, moduleName, Set.of());
                    iterator.remove();
                    continue;
                }
                entry.setValue(Boolean.TRUE);
            }
        }

        private static boolean removeFirsts(Deque<Path> paths, Integer count) {
            boolean changed = false;
            if (count != null) {
                int i = count;
                while (--i >= 0) {
                    changed |= paths.removeFirst() != null;
                }
            }
            return changed;
        }
    }
}

