/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.changes.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugins.changes.model.Action;
import org.apache.maven.plugins.changes.model.Component;
import org.apache.maven.plugins.changes.model.Release;

public abstract class AbstractRelease {
    private final List<Component> components = new ArrayList<Component>();

    public abstract List<Action> getActions();

    public List<Action> getActions(String type) {
        return this.getActions().stream().filter(a -> a.getType() != null).filter(a -> a.getType().equalsIgnoreCase(type)).collect(Collectors.toList());
    }

    public void addComponent(String name, Release release) {
        Component component = new Component();
        component.setName(name);
        component.setDescription(release.getDescription());
        component.setActions(release.getActions());
        this.components.add(component);
    }

    public List<Component> getComponents() {
        return this.components;
    }
}

